/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class HalfPrdStructureRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit headprdorg = (MulBasedataEdit)this.getControl("headprdorg");
        headprdorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit headinveorg = (MulBasedataEdit)this.getControl("headinveorg");
        headinveorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit startPeriod = (BasedataEdit)this.getControl("beginperiod");
        startPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulproduct = (MulBasedataEdit)this.getControl("mulproduct");
        mulproduct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulmaterialtype = (BasedataEdit)this.getControl("mulmaterialtype");
        mulmaterialtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulmaterial = (BasedataEdit)this.getControl("mulmaterial");
        mulmaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.init();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        Long orgId = this.getModel().getDataEntity().getLong("org.id");
        Long costAccountId = this.getModel().getDataEntity().getLong("costaccount.id");
        ArrayList<Long> createOrgIds = new ArrayList<Long>();
        createOrgIds.add(orgId);
        switch (name) {
            case "costaccount": {
                qFilters.add(this.getCostAccountF7QFilter(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())));
                break;
            }
            case "headprdorg": {
                if (CadEmptyUtils.isEmpty((Long)costAccountId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"HalfPrdStructureRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List prodOrglist = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)true);
                qFilters.add(new QFilter("id", "in", (Object)prodOrglist));
                break;
            }
            case "headinveorg": {
                if (CadEmptyUtils.isEmpty((Long)costAccountId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"HalfPrdStructureRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObjectCollection headprdorg = this.getModel().getDataEntity().getDynamicObjectCollection("headprdorg");
                Set pdorgSet = headprdorg.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                HashSet stOrgs = new HashSet();
                if (!CadEmptyUtils.isEmpty(pdorgSet)) {
                    for (Long pdorg : pdorgSet) {
                        List stOrglist = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)pdorg, (boolean)true);
                        stOrgs.addAll(stOrglist);
                    }
                } else {
                    List stOrglist = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)orgId, (boolean)true);
                    stOrgs.addAll(stOrglist);
                }
                qFilters.add(new QFilter("id", "in", stOrgs));
                break;
            }
            case "beginperiod": 
            case "endperiod": {
                if (CadEmptyUtils.isEmpty((Long)costAccountId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"HalfPrdStructureRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter periodfilter = new QFilter("entry.costaccount", "=", (Object)costAccountId);
                DynamicObject periodSet = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"org.id orgid,entry.costaccount.id acctid,entry.calpolicy.periodtype periodtype,entry.startperiod.id startperiod,entry.currentperiod.id currentperiod", (QFilter[])periodfilter.toArray());
                long periodtype = periodSet.getLong("periodtype");
                qFilters.add(new QFilter("periodtype", "=", (Object)periodtype));
                qFilters.add(new QFilter("id", ">=", (Object)periodSet.getLong("startperiod")));
                qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
                break;
            }
            case "materialgrpstd": {
                Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
                qFilters.add(new QFilter("id", "in", (Object)ids));
                break;
            }
            case "mulmaterialtype": {
                DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
                if (materialgrpstd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"HalfPrdStructureRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstd.getPkValue(), false});
                qFilters.add(serviceResponse);
                listShowParameter.setF7ClickByFilter(false);
                break;
            }
            case "mulmaterial": {
                DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
                if (materialgrpstd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"HalfPrdStructureRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObjectCollection mulmaterialtype = (DynamicObjectCollection)this.getModel().getValue("mulmaterialtype");
                if (!CollectionUtils.isEmpty((Collection)mulmaterialtype) || materialgrpstd.getLong("id") != 730148448254487552L) {
                    qFilters.add(MaterialGroupHelper.getClassifiedMaterialIdFilter((DynamicObjectCollection)mulmaterialtype, (boolean)false, (DynamicObject)materialgrpstd));
                }
                listShowParameter.setF7ClickByFilter(false);
            }
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        boolean onlymaterialtype = this.getModel().getDataEntity().getBoolean("onlymaterialtype");
        String needPrdorgCache = this.getPageCache().get("need_prdorg_cache");
        String needStorgCache = this.getPageCache().get("need_storg_cache");
        for (AbstractReportColumn col : columns) {
            if (!(col instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)col;
            String key = reportColumn.getFieldKey();
            if ("entrymaterial".equals(key) || "entrymaterialname".equals(key) || "materialbaseunit".equals(key)) {
                reportColumn.setHide(onlymaterialtype);
            }
            if ("prdorg".equals(key) || "prdorgname".equals(key)) {
                reportColumn.setHide("N".equals(needPrdorgCache));
            }
            if ("inveorg".equals(key) || "invorgname".equals(key)) {
                reportColumn.setHide("N".equals(needStorgCache));
            }
            if (!"level".equals(key)) continue;
            reportColumn.setHide("B".equals(this.getModel().getDataEntity().getString("query")));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "costaccount": {
                if (newValue == null) {
                    this.getModel().setValue("org", null);
                    this.getModel().setValue("headprdorg", null);
                    this.getModel().setValue("headinveorg", null);
                    this.getModel().setValue("currency", null);
                    this.getModel().setValue("beginperiod", null);
                    this.getModel().setValue("endperiod", null);
                }
                long costAccountId = newValue == null ? 0L : ((DynamicObject)newValue).getLong("id");
                this.setOrg(newValue, "org");
                this.setVisableProdOrgAndInveOrg(costAccountId);
                this.setCurrency();
                this.setStartAndEndPeriod();
                break;
            }
            case "beginperiod": {
                this.adjustEndPeriodByStartPeriod(newValue);
                break;
            }
            case "endperiod": {
                this.adjustStartPeriodByEndPeriod(newValue);
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialtype", null);
                this.getModel().setValue("mulmaterial", null);
                break;
            }
            case "mulmaterialtype": {
                this.getModel().setValue("mulmaterial", null);
                break;
            }
            case "headprdorg": {
                if ("Y".equals(this.getPageCache().get("need_storg_cache"))) {
                    List stOrglist;
                    DynamicObjectCollection headprdorg = this.getModel().getDataEntity().getDynamicObjectCollection("headprdorg");
                    List pdorgList = headprdorg.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                    if (headprdorg.size() == 1 && (stOrglist = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)((Long)pdorgList.get(0)), (boolean)true)).size() == 1) {
                        DynamicObjectCollection stCol = this.getModel().getDataEntity().getDynamicObjectCollection("headinveorg");
                        stCol.clear();
                        Map stOrgDynMap = BusinessDataServiceHelper.loadFromCache((Object[])stOrglist.toArray(), (String)"bos_org");
                        if (stOrgDynMap.size() > 0) {
                            DynamicObject obj = stCol.addNew();
                            obj.set("fbasedataid", stOrgDynMap.get(stOrglist.get(0)));
                            this.getView().updateView("headinveorg");
                            break;
                        }
                    }
                }
                this.getModel().setValue("headinveorg", null);
                this.getView().updateView("headinveorg");
                break;
            }
            case "headinveorg": {
                List stList;
                List pdOrglist;
                DynamicObjectCollection stCol = this.getModel().getDataEntity().getDynamicObjectCollection("headinveorg");
                DynamicObjectCollection headprdorg = this.getModel().getDataEntity().getDynamicObjectCollection("headprdorg");
                if (stCol.size() != 1 || headprdorg.size() != 0 || (pdOrglist = OrgUnitServiceHelper.getAllToOrg((String)"05", (String)"04", (Long)((Long)(stList = stCol.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList())).get(0)), (boolean)true)).size() != 1) break;
                headprdorg.clear();
                Map pdOrgDynMap = BusinessDataServiceHelper.loadFromCache((Object[])pdOrglist.toArray(), (String)"bos_org");
                if (pdOrgDynMap.size() <= 0) break;
                DynamicObject obj = stCol.addNew();
                obj.set("fbasedataid", pdOrgDynMap.get(pdOrglist.get(0)));
                this.getView().updateView("headprdorg");
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject costAccount = filter.getDynamicObject("costaccount");
        if (costAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"HalfPrdStructureRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject beginperiod = filter.getDynamicObject("beginperiod");
        if (beginperiod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u671f\u95f4\u3002", (String)"HalfPrdStructureRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject endperiod = filter.getDynamicObject("endperiod");
        if (endperiod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u671f\u95f4\u3002", (String)"HalfPrdStructureRptPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection mulproduct = filter.getDynamicObjectCollection("mulproduct");
        if (mulproduct == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ea7\u54c1", (String)"HalfPrdStructureRptPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject materialGrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
        if (materialGrpstd == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"HalfPrdStructureRptPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject currency = filter.getDynamicObject("currency");
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6210\u672c\u8d26\u7c3f\u7684\u5e01\u79cd\u3002", (String)"HalfPrdStructureRptPlugin_7", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        return super.verifyQuery(queryParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"HalfPrdStructureRptPlugin_8", (String)"macc-sca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"HalfPrdStructureRptPlugin_10", (String)"macc-sca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"sca_halfprdstructurerpt", (IDataModel)this.getModel());
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private void setStartAndEndPeriod() {
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        long costAccountId = this.getModel().getDataEntity().getLong("costaccount.id");
        if (orgId == 0L || costAccountId == 0L) {
            return;
        }
        Long curPeriod1 = this.getCalCurPeriod(orgId, costAccountId);
        if (!CadEmptyUtils.isEmpty((Long)curPeriod1)) {
            this.getModel().setValue("beginperiod", (Object)curPeriod1);
            this.getModel().setValue("endperiod", (Object)curPeriod1);
        }
        this.getView().updateView("beginperiod");
        this.getView().updateView("endperiod");
    }

    private Long getCalCurPeriod(Long org, Long costAccount) {
        QFilter periodfilter = new QFilter("org", "=", (Object)org);
        periodfilter.and(new QFilter("entry.costaccount", "=", (Object)costAccount));
        DynamicObject calSysctrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod.id currentperiod", (QFilter[])periodfilter.toArray());
        return calSysctrlEntity == null ? 0L : calSysctrlEntity.getLong("currentperiod");
    }

    private void adjustEndPeriodByStartPeriod(Object startPeriod) {
        if (startPeriod == null) {
            return;
        }
        DynamicObject endPeriod = this.getModel().getDataEntity().getDynamicObject("endperiod");
        if (endPeriod == null) {
            return;
        }
        long endPeriodId = endPeriod.getLong("id");
        long startPeriodId = ((DynamicObject)startPeriod).getLong("id");
        if (startPeriodId > endPeriodId) {
            this.getModel().setValue("endperiod", (Object)startPeriodId);
            this.getView().updateView("endperiod");
        }
    }

    private void adjustStartPeriodByEndPeriod(Object endPeriod) {
        if (endPeriod == null) {
            return;
        }
        DynamicObject startPeriod = this.getModel().getDataEntity().getDynamicObject("beginperiod");
        if (startPeriod == null) {
            return;
        }
        long startPeriodId = startPeriod.getLong("id");
        long endPeriodId = ((DynamicObject)endPeriod).getLong("id");
        if (endPeriodId < startPeriodId) {
            this.getModel().setValue("beginperiod", endPeriod);
            this.getView().updateView("beginperiod");
        }
    }

    private void init() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"headprdorg", "headinveorg"});
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (isaccount && permAccountOrgIds.contains(currentOrgId)) {
            this.getModel().setValue("org", (Object)currentOrgId);
        }
        Long orgId = this.getModel().getDataEntity().getLong("org.id");
        this.setCostAccount(orgId);
        this.setStartAndEndPeriod();
    }

    private void setCostAccount(Long orgId) {
        if (CadEmptyUtils.isEmpty((Long)orgId)) {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("currency", null);
            return;
        }
        Long costAccount = this.getCostAccountByAccoutOrg(orgId);
        if (costAccount != 0L) {
            this.getModel().setValue("costaccount", (Object)costAccount);
            this.setVisableProdOrgAndInveOrg(costAccount);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.setCurrency();
    }

    private void setOrg(Object costAccount, String setField) {
        if (costAccount == null) {
            return;
        }
        QFilter orgQFilter = new QFilter("id", "=", (Object)((DynamicObject)costAccount).getLong("id"));
        DynamicObject sysparam = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter[]{orgQFilter});
        if (sysparam == null) {
            this.getModel().setValue(setField, null);
        } else {
            this.getModel().setValue(setField, (Object)sysparam.getDynamicObject("calorg").getLong("id"));
        }
        this.getView().updateView(setField);
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter accountorgQF = new QFilter("org", "=", (Object)accountOrgId);
        QFilter enablestdtQF = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        enablestdtQF.and("appnum", "=", (Object)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        QFilter isinitaccountQF = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount costaccount,entryentity.costaccount.ismainaccount ismainaccount", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF, isinitaccountQF}, (String)"entryentity.costaccount.ismainaccount desc,entryentity.costaccount.id desc");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)result)) {
            return 0L;
        }
        if (((DynamicObject)result.get(0)).getBoolean("ismainaccount") || result.size() == 1) {
            return ((DynamicObject)result.get(0)).getLong("costaccount");
        }
        return 0L;
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private QFilter getCostAccountF7QFilter(String appNum) {
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        QFilter orgFilter = new QFilter("org", "in", (Object)permAccountOrgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, appnumFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (costAccountIds.size() > 0) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0);
    }

    private void setVisableProdOrgAndInveOrg(Long costAccountId) {
        if (CadEmptyUtils.isEmpty((Long)costAccountId)) {
            return;
        }
        DynamicObject costaccount = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"id,restoredimension,restorecalcrange", (QFilter[])new QFilter("costaccount", "=", (Object)costAccountId).toArray());
        if (costaccount == null) {
            return;
        }
        String restoredimension = costaccount.getString("restoredimension");
        String restorecalcrangeSet = costaccount.getString("restorecalcrange");
        if ("B".equals(restoredimension)) {
            this.getPageCache().put("need_prdorg_cache", "Y");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"headprdorg"});
        } else {
            this.getPageCache().put("need_prdorg_cache", "N");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"headprdorg"});
        }
        if (restorecalcrangeSet.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue())) {
            this.getPageCache().put("need_storg_cache", "Y");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"headinveorg"});
        } else {
            this.getPageCache().put("need_storg_cache", "N");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"headinveorg"});
        }
    }
}

