/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.enums.ScaAllocEnum;

public class ManuExpAllocBetweenRptQuery
extends AbstractReportListDataPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final Log logger = LogFactory.getLog(ManuExpAllocBetweenRptQuery.class);
    private Long currencyId = 0L;
    private static String[] sum1Fields = new String[]{"orgnum", "costaccountnum", "periodnum", "benefcostcenternum", "expenseitemnum"};
    private static String[] sum2Fields = new String[]{"orgnum", "costaccountnum", "periodnum", "benefcostcenternum"};
    private static String[] sum3Fields = new String[]{"orgnum", "costaccountnum", "periodnum"};
    private static String[] orderByFields = new String[]{"orgnum desc", "costaccountnum desc", "periodnum desc", "benefcostcenternum desc", "expenseitemnum desc", "allocbillno desc", "amount desc"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        DynamicObject currency = filterInfo.getDynamicObject("currency");
        if (currency != null) {
            this.currencyId = (Long)currency.getPkValue();
        }
        DataSet allocData = this.queryAllocData(filterInfo);
        DataSet sumData = this.sumRowData(allocData, allocData.getRowMeta());
        String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5206\u914d\u67e5\u8be2\uff08\u6210\u672c\u4e2d\u5fc3\uff09", (String)"ManuExpAllocBetweenRptQuery_0", (String)"macc-sca-report", (Object[])new Object[0]), (String)"ManuExpAllocBetweenRptQuery_1", (String)"macc-sca-report", (Object[])new Object[0]);
        String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5206\u914d\u67e5\u8be2\uff08\u6210\u672c\u4e2d\u5fc3\uff09\u67e5\u8be2\u6210\u529f\u3002", (String)"ManuExpAllocBetweenRptQuery_1", (String)"macc-sca-report", (Object[])new Object[0]), (String)"ManuExpAllocBetweenRptQuery_1", (String)"macc-sca-report", (Object[])new Object[0]);
        this.addLog(this.logService, RequestContext.get(), opName, opDescription, "sca_mfgfeealloccorpt", ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5206\u914d\u67e5\u8be2\uff08\u6210\u672c\u4e2d\u5fc3\uff09", (String)"ManuExpAllocBetweenRptQuery_0", (String)"macc-sca-report", (Object[])new Object[0]));
        return sumData;
    }

    private DataSet sumRowData(DataSet query, RowMeta rowMeta) {
        Date start = new Date();
        DataSet sum1 = this.sumByGroupFields(query.copy(), sum1Fields, rowMeta);
        DataSet sum2 = this.sumByGroupFields(sum1.copy(), sum2Fields, rowMeta);
        DataSet sum3 = this.sumByGroupFields(sum2.copy(), sum3Fields, rowMeta);
        Date end = new Date();
        logger.info("\u5236\u9020\u8d39\u7528\u5206\u914d\u67e5\u8be2\uff08\u6210\u672c\u4e2d\u5fc3\uff09\u5408\u8ba1\u884c\u8017\u65f6\uff1a" + (end.getTime() - start.getTime()) + "\u6beb\u79d2");
        return query.union(sum1.union(sum2).union(sum3)).orderBy(orderByFields);
    }

    private DataSet queryAllocData(FilterInfo info) {
        Date start = new Date();
        StringBuilder fields = new StringBuilder();
        String baseField = "billno AS allocbillno, org AS orgnum, costaccount AS costaccountnum, period AS periodnum, bizdate AS bizdate, case when entryentity.seq = 1 then amount else 0 end amount,expenseitem AS expenseitemnum, benefcostcenter AS benefcostcenternum, currency AS currencys, costdriver AS costdriver, ";
        String fieldEntry = "entryentity.allocamt AS allocamt, entryentity.allocvalue AS allocvalue, entryentity.costobject AS costobject, entryentity.costobject.material AS material, entryentity.subelement.name AS subelement,entryentity.element AS element";
        fields.append(baseField);
        fields.append(fieldEntry);
        List<QFilter> filters = this.getMfgCoFilters(info);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("queryAllocData"), (String)"sca_mfgfeeallocco", (String)fields.toString(), (QFilter[])filters.toArray(new QFilter[0]), null);
        String groupfields = "orgnum,costaccountnum,periodnum,expenseitemnum,benefcostcenternum,currencys,costdriver,allocvalue,element,subelement";
        if (info.getBoolean("isbill")) {
            groupfields = groupfields + ",allocbillno,bizdate";
        }
        groupfields = "0".equals(info.getString("displaytype")) ? groupfields + ",material" : groupfields + ",material,costobject";
        GroupbyDataSet set = dataSet.groupBy(groupfields.split(",")).sum("allocamt").sum("amount");
        Date end = new Date();
        logger.info("\u5236\u9020\u8d39\u7528\u5206\u914d\u67e5\u8be2\uff08\u6210\u672c\u4e2d\u5fc3\uff09\u67e5\u8be2\u8017\u65f6\uff1a" + (end.getTime() - start.getTime()) + "\u6beb\u79d2");
        return set.finish();
    }

    private List<QFilter> getMfgCoFilters(FilterInfo info) {
        DynamicObject org = info.getDynamicObject("org");
        DynamicObject costaccount = info.getDynamicObject("costaccount");
        DynamicObject currency = info.getDynamicObject("currency");
        DynamicObject beginperiod = info.getDynamicObject("beginperiod");
        DynamicObject endperiod = info.getDynamicObject("endperiod");
        DynamicObject expenseitem = info.getDynamicObject("expenseitem");
        DynamicObject benefcostcenter = info.getDynamicObject("benefcostcenter");
        String displaytype = info.getString("displaytype");
        DynamicObjectCollection product = info.getDynamicObjectCollection("product");
        DynamicObjectCollection costobjs = info.getDynamicObjectCollection("costobjs");
        boolean unallocate = info.getBoolean("unallocate");
        info.getString("appnum");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (org != null) {
            filters.add(new QFilter("org", "=", org.getPkValue()));
        }
        if (costaccount != null) {
            filters.add(new QFilter("costaccount", "=", costaccount.getPkValue()));
        }
        if (currency != null) {
            filters.add(new QFilter("currency", "=", currency.getPkValue()));
        }
        if (expenseitem != null) {
            filters.add(new QFilter("expenseitem", "=", expenseitem.getPkValue()));
        }
        if (benefcostcenter != null) {
            filters.add(new QFilter("benefcostcenter", "=", benefcostcenter.getPkValue()));
        }
        if (beginperiod != null) {
            Long begindateId = beginperiod.getLong("id");
            filters.add(new QFilter("period", ">=", (Object)begindateId));
        }
        if (endperiod != null) {
            Long endperiodId = endperiod.getLong("id");
            filters.add(new QFilter("period", "<=", (Object)endperiodId));
        }
        if (unallocate) {
            filters.add(new QFilter("allocstatus", "=", (Object)ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue()));
        } else {
            filters.add(new QFilter("allocstatus", "in", (Object)new String[]{ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue(), ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue(), ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue()}));
        }
        if ("0".equals(displaytype) && product != null && product.size() > 0) {
            Set pros = product.stream().map(a -> a.getPkValue()).collect(Collectors.toSet());
            filters.add(new QFilter("entryentity.costobject.material", "in", pros));
        } else if ("1".equals(displaytype) && costobjs != null && costobjs.size() > 0) {
            Set costs = costobjs.stream().map(a -> a.getPkValue()).collect(Collectors.toSet());
            filters.add(new QFilter("entryentity.costobject", "in", costs));
        }
        return filters;
    }

    private DataSet sumByGroupFields(DataSet data, String[] fields, RowMeta rowMeta) {
        String[] fieldNames = rowMeta.getFieldNames();
        DataSet sumRows = data.groupBy(fields).sum("allocamt").sum("amount").finish();
        String[] sumFields = sumRows.getRowMeta().getFieldNames();
        ArrayList<Object[]> sumResult = new ArrayList<Object[]>(10);
        while (sumRows.hasNext()) {
            Row row = sumRows.next();
            Object[] objects = new Object[fieldNames.length];
            for (String field : sumFields) {
                objects[rowMeta.getFieldIndex((String)field)] = row.get(field);
            }
            objects[rowMeta.getFieldIndex((String)"subelement")] = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"ManuExpAllocBetweenRptQuery_2", (String)"macc-sca-report", (Object[])new Object[0]);
            objects[rowMeta.getFieldIndex((String)"currencys")] = this.currencyId;
            sumResult.add(objects);
        }
        return Algo.create((String)"sum").createDataSet(sumResult, rowMeta);
    }

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    private void addLog(ILogService logService, RequestContext requestContext, String opName, String opDescription, String entityName, String modelName) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(requestContext.getUserId()));
        logInfo.setBizAppID(AppMetadataCache.getAppInfo((String)type.getAppId()).getId());
        logInfo.setBizObjID(modelName);
        logInfo.setOrgID(Long.valueOf(requestContext.getOrgId()));
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(requestContext.getClient());
        logInfo.setClientIP(requestContext.getLoginIP());
        logInfo.setClientName(requestContext.getClient());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(opDescription);
        logService.addLog(logInfo);
    }
}

