/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class ManuExpAllocRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        BasedataEdit endperiod;
        BasedataEdit beginperiod;
        BasedataEdit costcenter;
        BasedataEdit costaccount;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit profitcostcenter = (BasedataEdit)this.getView().getControl("profitcostcenter");
        if (profitcostcenter != null) {
            profitcostcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((costaccount = (BasedataEdit)this.getView().getControl("costaccount")) != null) {
            costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((costcenter = (BasedataEdit)this.getView().getControl("costcenter")) != null) {
            costcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((beginperiod = (BasedataEdit)this.getView().getControl("beginperiod")) != null) {
            beginperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((endperiod = (BasedataEdit)this.getView().getControl("endperiod")) != null) {
            endperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOrg();
        this.setCostaccount();
        this.setCurrency();
        this.setPeriod();
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String key = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ManuExpAllocRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
            arg0.setCancel(true);
            return;
        }
        switch (key) {
            case "profitcostcenter": {
                QFilter qfId = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                qfId.and(new QFilter("orgduty", "!=", (Object)5));
                showParameter.getListFilterParameter().setFilter(qfId);
                break;
            }
            case "costaccount": {
                QFilter costAccountFilter = StartCostHelper.getEndInitCostAccountIdsFilter((Long)((Long)org.getPkValue()), (String)"sca");
                showParameter.getListFilterParameter().getQFilters().add(costAccountFilter);
                break;
            }
            case "costcenter": {
                QFilter orgFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                showParameter.getListFilterParameter().getQFilters().add(orgFilter);
                break;
            }
            case "beginperiod": 
            case "endperiod": {
                DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("org");
                if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                    arg0.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ManuExpAllocRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    return;
                }
                DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
                if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                    arg0.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ManuExpAllocRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                    return;
                }
                showParameter.getListFilterParameter().getQFilters().add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)accountOrg.getLong("id"), (Long)costAccount.getLong("id")));
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject endperiod;
        DynamicObject beginperiod;
        DynamicObject currency;
        DynamicObject costaccount;
        FilterInfo filter = queryParam.getFilter();
        boolean ispass = true;
        DynamicObject org = filter.getDynamicObject("org");
        if (org == null) {
            ispass = false;
        }
        if ((costaccount = filter.getDynamicObject("costaccount")) == null) {
            ispass = false;
        }
        if ((currency = filter.getDynamicObject("currency")) == null) {
            ispass = false;
        }
        if ((beginperiod = filter.getDynamicObject("beginperiod")) == null) {
            ispass = false;
        }
        if ((endperiod = filter.getDynamicObject("endperiod")) == null) {
            ispass = false;
        }
        if (!ispass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5185\u5bb9\u672a\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"ManuExpAllocRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            return;
        }
        DynamicObject costAccountDO = (DynamicObject)costAccount;
        Long currency = CalcRptHelper.getCurrency((DynamicObject)costAccountDO);
        this.getModel().setValue("currency", (Object)currency);
        this.setPeriod();
    }

    private void setPeriod() {
        Long costaccountId;
        QFilter costaccountQF;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            this.getModel().setValue("beginperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        Long orgId = org.getLong("id");
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, costaccountQF = new QFilter("entry.costaccount", "=", (Object)(costaccountId = Long.valueOf(costaccount.getLong("id"))))});
        if (res != null && res.size() > 0) {
            Long currentperiod = ((DynamicObject)res.get(0)).getLong("currentperiod");
            this.getModel().setValue("beginperiod", (Object)currentperiod);
            this.getModel().setValue("endperiod", (Object)currentperiod);
        } else {
            this.getModel().setValue("beginperiod", null);
            this.getModel().setValue("endperiod", null);
        }
        this.getView().updateView("beginperiod");
        this.getView().updateView("endperiod");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        this.getView().getFormShowParameter();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String formId = showParameter.getFormId();
        if ("org".equals(key)) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getModel().setValue("costaccount", null);
                this.getModel().setValue("beginperiod", null);
                this.getModel().setValue("endperiod", null);
                this.getModel().setValue("currency", null);
                if (!"sca_mfgfeealloccorpt".equals(formId)) {
                    this.getModel().setValue("costcenter", null);
                    this.getModel().setValue("profitcostcenter", null);
                }
            } else {
                QFilter[] qFilter = new QFilter[]{new QFilter("ismainaccount", "=", (Object)"1"), new QFilter("enablestandardcost", "=", (Object)"1"), new QFilter("calorg", "=", org.get("id"))};
                DynamicObject[] costAccounts = BusinessDataServiceHelper.load((String)"cal_bd_costaccount", (String)"id", (QFilter[])qFilter);
                this.getView().getModel().setValue("costaccount", costAccounts.length > 0 ? costAccounts[0] : null);
                if (!"sca_mfgfeealloccorpt".equals(formId)) {
                    this.getModel().setValue("costcenter", null);
                    this.getModel().setValue("profitcostcenter", null);
                }
            }
        } else if ("costaccount".equals(key)) {
            DynamicObject costaccount = this.getModel().getDataEntity().getDynamicObject(key);
            if (costaccount != null) {
                this.setCurrencyAndPeriod(costaccount);
            } else {
                this.getModel().setValue("currency", null);
                this.getModel().setValue("beginperiod", null);
                this.getModel().setValue("endperiod", null);
            }
        } else if ("beginperiod".equals(key)) {
            DynamicObject beginperiod = this.getModel().getDataEntity().getDynamicObject(key);
            DynamicObject endperiod = this.getModel().getDataEntity().getDynamicObject("endperiod");
            if (beginperiod != null && endperiod != null) {
                DynamicObject fullBegin = BusinessDataServiceHelper.loadSingle((Object)beginperiod.getPkValue(), (String)beginperiod.getDynamicObjectType().getName());
                DynamicObject fullEnd = BusinessDataServiceHelper.loadSingle((Object)endperiod.getPkValue(), (String)endperiod.getDynamicObjectType().getName());
                Date bbegindate = fullBegin.getDate("begindate");
                Date ebegindate = fullEnd.getDate("begindate");
                if (bbegindate != null && ebegindate != null && bbegindate.getTime() > ebegindate.getTime()) {
                    this.getModel().setValue("endperiod", (Object)beginperiod);
                }
            }
        } else if ("endperiod".equals(key)) {
            DynamicObject beginperiod = this.getModel().getDataEntity().getDynamicObject("beginperiod");
            DynamicObject endperiod = this.getModel().getDataEntity().getDynamicObject(key);
            if (beginperiod != null && endperiod != null) {
                DynamicObject fullBegin = BusinessDataServiceHelper.loadSingle((Object)beginperiod.getPkValue(), (String)beginperiod.getDynamicObjectType().getName());
                DynamicObject fullEnd = BusinessDataServiceHelper.loadSingle((Object)endperiod.getPkValue(), (String)endperiod.getDynamicObjectType().getName());
                Date bbegindate = fullBegin.getDate("begindate");
                Date ebegindate = fullEnd.getDate("begindate");
                if (bbegindate != null && ebegindate != null && bbegindate.getTime() > ebegindate.getTime()) {
                    this.getModel().setValue("beginperiod", (Object)endperiod);
                }
            } else {
                this.getModel().setValue("beginperiod", (Object)endperiod);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("donothing".equals(operateKey)) {
            ReportList reportList = (ReportList)this.getControl("reportlistap");
            int[] selectedRows = reportList.getEntryState().getSelectedRows();
            if (CadEmptyUtils.isEmpty((int[])selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u5e26\u5355\u636e\u7f16\u7801\u7684\u6570\u636e\u3002", (String)"ManuExpAllocRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
                return;
            }
            IReportListModel c = reportList.getReportModel();
            DynamicObject rowData = c.getRowData(selectedRows[0]);
            String billno = rowData.getString("billno");
            if ("".equals(billno)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u5e26\u5355\u636e\u7f16\u7801\u7684\u6570\u636e\u3002", (String)"ManuExpAllocRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
                return;
            }
            DynamicObject mfgfeebill = BusinessDataServiceHelper.loadSingle((String)"sca_mfgfeebill", (String)"id", (QFilter[])new QFilter("billno", "=", (Object)billno).toArray());
            Object pk = mfgfeebill.getPkValue();
            ArrayList<Object> pkList = new ArrayList<Object>();
            pkList.add(pk);
            IReportView view = this.getView();
            SrcBillShowerUtils.showSearchUpBill((IFormView)view, (String)"sca_mfgfeebill", pkList);
            pkList.remove(0);
            this.getNext(pk, pkList);
            if (pkList.size() > 0) {
                SrcBillShowerUtils.showSearchUpBill((IFormView)view, (String)"sca_mfgfeealloccc", pkList);
            }
            String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5206\u914d\u67e5\u8be2\uff08\u6210\u672c\u4e2d\u5fc3\u95f4\uff09", (String)"ManuExpAllocRptPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]), (String)"ManuExpAllocRptPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]);
            String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5206\u914d\u67e5\u8be2\uff08\u6210\u672c\u4e2d\u5fc3\u95f4\uff09\u8054\u67e5\u5355\u636e\u6210\u529f\u3002", (String)"ManuExpAllocRptPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]), (String)"ManuExpAllocRptPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]);
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"sca_faccostdistributerpt", (IDataModel)this.getModel());
        }
    }

    private DynamicObject getNext(Object pk, List<Object> pkList) {
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"sca_mfgfeealloccc", (String)"id", (QFilter[])new QFilter("srcbillid", "=", pk).toArray());
        if (queryOne != null) {
            pkList.add(queryOne.get("id"));
            return this.getNext(queryOne.get("id"), pkList);
        }
        return null;
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List columns = e.getColumns();
        Object summaryway = this.getModel().getValue("summaryway");
        for (AbstractReportColumn a : columns) {
            ReportColumn reportColumn = (ReportColumn)a;
            String key = reportColumn.getFieldKey();
            if (summaryway.equals("0") && (key.equals("costcenter2") || key.equals("costcentername2"))) {
                reportColumn.setHide(true);
                reportColumn.setHideSingleColumnRow(true);
                continue;
            }
            if (!summaryway.equals("1") || !key.equals("costcenter1") && !key.equals("costcentername1")) continue;
            reportColumn.setHide(true);
            reportColumn.setHideSingleColumnRow(true);
        }
    }

    private void setOrg() {
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        Long orgId = RequestContext.get().getOrgId();
        boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
        if (!isAccounting) {
            return;
        }
        model.setValue("org", (Object)orgId);
        view.updateView("org");
    }

    private void setCostaccount() {
        IDataModel model = this.getModel();
        DynamicObject org = model.getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getModel().setValue("costaccount", null);
            return;
        }
        model.setValue("costaccount", (Object)StartCostHelper.getCostAccountByAccoutOrg((Long)org.getLong("id"), (String)"sca"));
        this.getView().updateView("costaccount");
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }
}

