/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ManuExpAllocRptQuery
extends AbstractReportListDataPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final Log logger = LogFactory.getLog(ManuExpAllocRptQuery.class);
    private static final String SCA_GUIJI = "sca_mfgfeebill";
    private static final String SCA_COSTCENTER = "sca_mfgfeealloccc";
    private String sumType = "0";
    private boolean expendSub = false;
    private Long currency = 0L;
    private static String[] sum1Fields = new String[]{"period", "calorg", "entrycostaccount", "entrycostitem", "costcenter2"};
    private static String[] sum2Fields = new String[]{"period", "calorg", "entrycostaccount", "entrycostitem"};
    private static String[] orderByFields = new String[]{"period desc", "calorg desc", "entrycostaccount desc", "entrycostitem desc", "costcenter2 desc"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(16);
        this.init(reportQueryParam, filterMap);
        DataSet query = this.queryDataSet(filterMap);
        DataSet dataSet = this.sumRowData(query.copy(), query.getRowMeta());
        String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5206\u914d\u67e5\u8be2\uff08\u6210\u672c\u4e2d\u5fc3\u95f4\uff09", (String)"ManuExpAllocRptQuery_0", (String)"macc-sca-report", (Object[])new Object[0]), (String)"ManuExpAllocRptQuery_1", (String)"macc-sca-report", (Object[])new Object[0]);
        String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5206\u914d\u67e5\u8be2\uff08\u6210\u672c\u4e2d\u5fc3\u95f4\uff09\u67e5\u8be2\u6210\u529f\u3002", (String)"ManuExpAllocRptQuery_1", (String)"macc-sca-report", (Object[])new Object[0]), (String)"ManuExpAllocRptQuery_2", (String)"macc-sca-report", (Object[])new Object[0]);
        this.addLog(this.logService, RequestContext.get(), opName, opDescription, "sca_faccostdistributerpt", ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5206\u914d\u67e5\u8be2\uff08\u6210\u672c\u4e2d\u5fc3\u95f4\uff09", (String)"ManuExpAllocRptQuery_0", (String)"macc-sca-report", (Object[])new Object[0]));
        return dataSet;
    }

    private DataSet sumRowData(DataSet query, RowMeta rowMeta) {
        Date start = new Date();
        DataSet finish = query.copy().groupBy(new String[]{"period", "calorg", "entrycostaccount", "costcenter1", "costcenter2", "entrycostitem", "billno"}).avg("totalamt").sum("disamt").finish();
        if ("0".equals(this.sumType)) {
            sum1Fields = new String[]{"period", "calorg", "entrycostaccount", "costcenter1", "entrycostitem"};
            sum2Fields = new String[]{"period", "calorg", "entrycostaccount", "costcenter1"};
            orderByFields = new String[]{"period desc", "calorg desc", "entrycostaccount desc", "costcenter1 desc", "entrycostitem desc"};
        }
        DataSet sum1 = this.sumByGroupFields(finish, sum1Fields, rowMeta);
        DataSet sum2 = this.sumByGroupFields(sum1.copy(), sum2Fields, rowMeta);
        DataSet sum3 = this.sumByGroupFields(sum2.copy(), new String[]{"period"}, rowMeta);
        Date end = new Date();
        logger.info("\u6570\u636e\u6c42\u548c\u6d88\u8017\u65f6\u95f4\uff1a" + (end.getTime() - start.getTime()) + "\u6beb\u79d2");
        return query.union(sum1.union(sum2).union(sum3)).orderBy(orderByFields);
    }

    private DataSet sumByGroupFields(DataSet data, String[] fields, RowMeta rowMeta) {
        String[] fieldNames = rowMeta.getFieldNames();
        DataSet sumRows = data.groupBy(fields).sum("disamt").sum("totalamt").finish();
        String[] sumFields = sumRows.getRowMeta().getFieldNames();
        ArrayList<Object[]> sumResult = new ArrayList<Object[]>(10);
        while (sumRows.hasNext()) {
            Row row = sumRows.next();
            Object[] objects = new Object[fieldNames.length];
            for (String field : sumFields) {
                objects[rowMeta.getFieldIndex((String)field)] = row.get(field);
            }
            objects[rowMeta.getFieldIndex((String)"subelement")] = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"ManuExpAllocRptQuery_2", (String)"macc-sca-report", (Object[])new Object[0]);
            objects[rowMeta.getFieldIndex((String)"entrycurrency")] = this.currency;
            sumResult.add(objects);
        }
        return Algo.create((String)"sum").createDataSet(sumResult, rowMeta);
    }

    private void init(ReportQueryParam report, Map<String, QFilter> filterMap) {
        Date start = new Date();
        FilterInfo filterInfo = report.getFilter();
        this.currency = (Long)this.getFilterItemValue(filterInfo, "currency");
        Object summaryway = this.getFilterItemValue(filterInfo, "summaryway");
        if (null != summaryway) {
            this.sumType = summaryway.toString();
        }
        Date end1 = new Date();
        logger.info("\u521d\u59cb\u5316\u6570\u636e\u6d88\u8017\u65f6\u95f4\uff1a" + (end1.getTime() - start.getTime()) + "\u6beb\u79d2");
        QFilter mfgFeeFilter = this.getGuiJiBillFilter(report);
        filterMap.put(SCA_GUIJI, mfgFeeFilter);
        QFilter costCenterFilter = this.getCostCenterFilter(report);
        filterMap.put(SCA_COSTCENTER, costCenterFilter);
        Date end2 = new Date();
        logger.info("\u521d\u59cb\u5316\u8fc7\u6ee4\u5668\u6d88\u8017\u65f6\u95f4\uff1a" + (end2.getTime() - end1.getTime()) + "\u6beb\u79d2");
    }

    private DataSet queryDataSet(Map<String, QFilter> filterMap) {
        Date start = new Date();
        DataSet guiJiData = this.queryGuiJiData(filterMap);
        DataSet costCenterData = this.queryCostCenterData(filterMap);
        Date end = new Date();
        DataSet dataSet = guiJiData.join(costCenterData, JoinType.LEFT).on("id", "root").select(guiJiData.getRowMeta().getFieldNames(), costCenterData.getRowMeta().getFieldNames()).finish();
        logger.info("\u67e5\u8be2\u6d88\u8017\uff1a" + (end.getTime() - start.getTime()) + "\u6beb\u79d2");
        return dataSet;
    }

    private DataSet queryGuiJiData(Map<String, QFilter> filterMap) {
        String fields = "id,period,org as calorg,costaccount as entrycostaccount,costcenter as costcenter1,costcenter as costcenter2,expenseitem as entrycostitem,billno,totalamount AS totalamt,createtime AS bizdate," + this.currency + " entrycurrency";
        QFilter filter = filterMap.get(SCA_GUIJI);
        return QueryServiceHelper.queryDataSet((String)"query_guiji", (String)SCA_GUIJI, (String)fields, (QFilter[])filter.toArray(), null);
    }

    private DataSet queryCostCenterData(Map<String, QFilter> filterMap) {
        String costQueryFields = "id as cid,billno as cbillno,srcbillid AS srcbillid,costcenter,entryentity.benefcostcenter as entryprofitcostcenter,entryentity.allocamt AS disamt,entryentity.element.name AS element,entryentity.subelement.name AS subelement";
        QFilter filter = filterMap.get(SCA_COSTCENTER);
        DataSet costcenter = QueryServiceHelper.queryDataSet((String)"query_costcenter", (String)SCA_COSTCENTER, (String)costQueryFields, (QFilter[])filter.toArray(), null);
        DataSet leaf = this.getLeafWithRootData(costcenter.copy());
        return costcenter.join(leaf, JoinType.INNER).on("cid", "cid").select(costcenter.getRowMeta().getFieldNames(), new String[]{"root"}).finish();
    }

    private DataSet getLeafWithRootData(DataSet data) {
        Date start = new Date();
        DataSet copy = data.copy();
        HashSet<LeafData> leafData = new HashSet<LeafData>(10);
        while (copy.hasNext()) {
            Row row = copy.next();
            leafData.add(new LeafData(row.getLong("cid"), row.getLong("srcbillid")));
        }
        HashSet<LeafData> leafSet = new HashSet<LeafData>();
        for (LeafData leafData2 : leafData) {
            Long l = leafData2.getCid();
            boolean hasLeaf = false;
            for (LeafData datum : leafData) {
                Long srcBillId = datum.getSrcBillId();
                if (!l.equals(srcBillId)) continue;
                hasLeaf = true;
                break;
            }
            if (hasLeaf) continue;
            leafSet.add(leafData2);
        }
        ArrayList<Object[]> objs = new ArrayList<Object[]>(10);
        for (LeafData leafData3 : leafSet) {
            LeafData root = this.diGuiGet(leafData3, leafData);
            leafData3.setRoot(root.getSrcBillId());
            String[] names = this.getRowMeta().getFieldNames();
            Object[] objects = new Object[names.length];
            objects[0] = leafData3.getCid();
            objects[1] = root.getSrcBillId();
            objs.add(objects);
        }
        Date date = new Date();
        logger.info("\u5bfb\u627e\u53f6\u5b50\u8282\u70b9\u6d88\u8017\u65f6\u95f4\uff1a" + (date.getTime() - start.getTime()) + "\u6beb\u79d2");
        return Algo.create((String)"getRootbyLeaf").createDataSet(objs, this.getRowMeta()).groupBy(new String[]{"cid", "root"}).finish();
    }

    protected RowMeta getRowMeta() {
        ArrayList<Field> field = new ArrayList<Field>();
        field.add(new Field("cid", (DataType)DataType.LongType));
        field.add(new Field("root", (DataType)DataType.LongType));
        return new RowMeta(field.toArray(new Field[0]));
    }

    private LeafData diGuiGet(LeafData node, Set<LeafData> leafSet) {
        LeafData root = null;
        Long srcBillId = node.getSrcBillId();
        for (LeafData leafData : leafSet) {
            Long lcid = leafData.getCid();
            if (!lcid.equals(srcBillId)) continue;
            root = this.diGuiGet(leafData, leafSet);
            break;
        }
        if (root == null) {
            root = node;
        }
        return root;
    }

    private QFilter getCommonFilter(FilterInfo filterInfo) {
        Object value = this.getFilterItemValue(filterInfo, "org");
        QFilter filter = new QFilter("org", "=", value);
        value = this.getFilterItemValue(filterInfo, "costaccount");
        filter.and(new QFilter("costaccount", "=", value));
        FilterItemInfo startPeriod = filterInfo.getFilterItem("beginperiod");
        DynamicObject startPeriodObj = (DynamicObject)startPeriod.getValue();
        startPeriodObj = BusinessDataServiceHelper.loadSingle((Object)startPeriodObj.getPkValue().toString(), (String)"bd_period");
        Date[] startPeriods = this.getPeriodStartAndEndTime(Long.valueOf(startPeriodObj.getPkValue().toString()));
        FilterItemInfo endPeriod = filterInfo.getFilterItem("endperiod");
        Date[] endPeriods = this.getPeriodStartAndEndTime(Long.valueOf(((DynamicObject)endPeriod.getValue()).getPkValue().toString()));
        if (startPeriods != null && endPeriods != null) {
            QFilter[] filters = new QFilter[]{new QFilter("begindate", ">=", (Object)startPeriods[0]).and(new QFilter("enddate", "<=", (Object)endPeriods[1]).and(new QFilter("periodtype", "=", startPeriodObj.getDynamicObject("periodtype").getPkValue())))};
            DynamicObject[] periods = BusinessDataServiceHelper.load((String)"bd_period", (String)"id", (QFilter[])filters);
            ArrayList<Object> periodList = new ArrayList<Object>(10);
            for (DynamicObject period : periods) {
                periodList.add(period.getPkValue());
            }
            filter.and(new QFilter("period", "in", periodList));
        }
        if (null != (value = this.getFilterItemValue(filterInfo, "costitem"))) {
            filter.and(new QFilter("expenseitem", "in", value));
        }
        return filter;
    }

    private QFilter getGuiJiBillFilter(ReportQueryParam report) {
        FilterInfo filterInfo = report.getFilter();
        QFilter filter = this.getCommonFilter(filterInfo);
        Object costCenter = this.getFilterItemValue(report.getFilter(), "costcenter");
        if (null != costCenter) {
            filter.and(new QFilter("costcenter", "in", costCenter));
        }
        return filter;
    }

    private QFilter getCostCenterFilter(ReportQueryParam report) {
        Object costCenterValue;
        FilterInfo reportFilter = report.getFilter();
        QFilter filter = this.getCommonFilter(reportFilter);
        Object costCenter = this.getFilterItemValue(report.getFilter(), "costcenter");
        if (null != costCenter) {
            Object value = this.getFilterItemValue(report.getFilter(), "isdowncost");
            if (null != value) {
                this.expendSub = Boolean.parseBoolean(value.toString());
            }
            if (this.expendSub) {
                ArrayList<Long> cloneCostCenters = new ArrayList<Long>(10);
                List costCenterList = (List)costCenter;
                for (Long cloneCostCenter : costCenterList) {
                    cloneCostCenters.add(cloneCostCenter);
                }
                filter.and(new QFilter("costcenter", "in", this.getJuniorCostCenter(cloneCostCenters)));
            } else {
                filter.and(new QFilter("costcenter", "in", costCenter));
            }
        }
        if (null != (costCenterValue = this.getFilterItemValue(reportFilter, "profitcostcenter"))) {
            filter.and(new QFilter("entryentity.benefcostcenter.id", "in", costCenterValue));
        }
        return filter;
    }

    public Object getFilterItemValue(FilterInfo filterInfo, String propName) {
        FilterItemInfo filterItem = filterInfo.getFilterItem(propName);
        if (filterItem != null && filterItem.getValue() != null) {
            Object value = filterItem.getValue();
            if (value instanceof DynamicObject) {
                return ((DynamicObject)value).getPkValue();
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection values = (DynamicObjectCollection)value;
                return values.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            }
            return value;
        }
        return null;
    }

    public List<Long> getJuniorCostCenter(List<Long> list) {
        QFilter filters = new QFilter("parent.id", "in", list);
        filters.and("id", "not in", list);
        DynamicObjectCollection query2 = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])filters.toArray(), null);
        if (query2.size() > 0) {
            for (int i = 0; i < query2.size(); ++i) {
                list.add(((DynamicObject)query2.get(i)).getLong("id"));
            }
            this.getJuniorCostCenter(list);
        }
        return list;
    }

    public Date[] getPeriodStartAndEndTime(Long periodId) {
        QFilter filter = new QFilter("id", "=", (Object)periodId);
        Object[] periods = BusinessDataServiceHelper.load((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((Object[])periods)) {
            return null;
        }
        Date[] dates = new Date[]{periods[0].getDate("begindate"), periods[0].getDate("enddate")};
        return dates;
    }

    private void addLog(ILogService logService, RequestContext requestContext, String opName, String opDescription, String entityName, String modelName) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(requestContext.getUserId()));
        logInfo.setBizAppID(AppMetadataCache.getAppInfo((String)type.getAppId()).getId());
        logInfo.setBizObjID(modelName);
        logInfo.setOrgID(Long.valueOf(requestContext.getOrgId()));
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(requestContext.getClient());
        logInfo.setClientIP(requestContext.getLoginIP());
        logInfo.setClientName(requestContext.getClient());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(opDescription);
        logService.addLog(logInfo);
    }

    private static class LeafData {
        private Long cid;
        private Long srcBillId;
        private Long root;

        LeafData(Long cid, Long srcBillId) {
            this.cid = cid;
            this.srcBillId = srcBillId;
        }

        public Long getCid() {
            return this.cid;
        }

        public Long getSrcBillId() {
            return this.srcBillId;
        }

        public Long getRoot() {
            return this.root;
        }

        public void setRoot(Long root) {
            this.root = root;
        }
    }
}

