/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang.StringUtils;

public class PurchasePriceVarianceQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(PurchasePriceVarianceQueryPlugin.class);

    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        FilterInfo filterInfo = param.getFilter();
        QFilter[] adjustFilter = this.getAdjustQueryFilter(filterInfo);
        DataSet costadjust = this.queryCostAdjust(adjustFilter);
        QFilter[] recordFilter = this.getRecordQueryFilter(filterInfo);
        DataSet costrecord = this.queryCostRecord(recordFilter);
        DataSet finish = costadjust.join(costrecord, JoinType.INNER).on("invbillid", "id").on("invbillentryid", "entryid").select(costadjust.getRowMeta().getFieldNames(), costrecord.getRowMeta().getFieldNames()).finish();
        DataSet purinbill = this.queryPurInBill();
        DataSet dataSet = finish.leftJoin(purinbill).on("bizbillid", "purinbillid").on("bizbillentryid", "purentryid").select(finish.getRowMeta().getFieldNames(), purinbill.getRowMeta().getFieldNames()).finish();
        DataSet bomSetting = this.queryBomSetting(this.getBomSettingFilter(filterInfo));
        dataSet = this.unionMaterialType(dataSet, bomSetting);
        DataSet purorder = this.queryPurOrder();
        DataSet set = dataSet.leftJoin(purorder).on("mainbillid", "poid").on("mainbillentryid", "pobillentryid").select(dataSet.getRowMeta().getFieldNames(), purorder.getRowMeta().getFieldNames()).finish();
        DynamicObjectCollection po = filterInfo.getDynamicObjectCollection("purorder");
        if (po != null && po.size() > 0) {
            Set billid = po.stream().map(a -> a.getPkValue()).collect(Collectors.toSet());
            QFilter filter = new QFilter("id", "in", billid);
            filter.and(new QFilter("billentry.entrysettleorg", "=", ((DynamicObject)filterInfo.getValue("org")).getPkValue()));
            DataSet query = QueryServiceHelper.queryDataSet((String)"aa", (String)"pm_purorderbill", (String)"billentry.id as entryid", (QFilter[])filter.toArray(), null);
            HashSet<Long> poentryid = new HashSet<Long>(10);
            while (query.hasNext()) {
                Row next = query.next();
                poentryid.add(next.getLong("entryid"));
            }
            String join = StringUtils.join(poentryid, (String)",");
            if (StringUtils.isNotEmpty((String)join)) {
                set = set.filter("pobillentryid in (" + join + ")");
            }
        }
        return set;
    }

    private DataSet queryCostAdjust(QFilter[] filter) {
        DataSet costadjust = QueryServiceHelper.queryDataSet((String)"queryCostAdjust", (String)"cal_stdcostdiffbill", (String)this.getCostAdjustFields(), (QFilter[])filter, null);
        return costadjust;
    }

    private DataSet queryCostRecord(QFilter[] recordFilter) {
        DataSet costrecord = QueryServiceHelper.queryDataSet((String)"queryCostRecord", (String)"cal_costrecord_subentity", (String)this.getCostRecordFields(), (QFilter[])recordFilter, null);
        return costrecord;
    }

    private DataSet queryPurInBill() {
        return QueryServiceHelper.queryDataSet((String)"queryPurInBill", (String)"im_purinbill", (String)"id purinbillid,billentry.id purentryid,supplier,supplier.internal_company as innerorg,billentry.mainbillid mainbillid,billentry.mainbillentryid mainbillentryid", null, null);
    }

    private DataSet queryPurOrder() {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObjectCollection purorder = filterInfo.getDynamicObjectCollection("purorder");
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (purorder != null && purorder.size() > 0) {
            filter.and(new QFilter("id", "in", purorder.stream().map(a -> a.getPkValue()).collect(Collectors.toSet())));
        }
        return QueryServiceHelper.queryDataSet((String)"queryPurOrder", (String)"pm_purorderbill", (String)"id poid,billno pobillno,settlecurrency,exratedate,exchangerate,auditdate,billentry.id pobillentryid,billentry.price poprice,case when billentry.srcbillentity='conm_purcontract' then billentry.srcbillnumber else '' end conmbillno, billentry.seq as poentryseq", (QFilter[])filter.toArray(), null);
    }

    private DataSet queryBomSetting(QFilter[] filter) {
        return QueryServiceHelper.queryDataSet((String)"queryBomSetting", (String)"cad_bomsetting", (String)"material bommaterial,costtype,isdowncalc,effectdate,expdate", (QFilter[])filter, null);
    }

    private DataSet unionMaterialType(DataSet costadjust, DataSet bomSetting) {
        HashMap<String, List> map = new HashMap<String, List>();
        while (bomSetting.hasNext()) {
            Row bom = bomSetting.next();
            Long material = bom.getLong("bommaterial");
            Long costtype = bom.getLong("costtype");
            MaterilType materilType = new MaterilType(bom.getDate("effectdate"), bom.getDate("expdate"), bom.getBoolean("isdowncalc"));
            List list = map.computeIfAbsent(costtype + "@" + material, a -> new ArrayList());
            list.add(materilType);
        }
        DataSet copy = costadjust.copy();
        RowMeta rowMeta = copy.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        ArrayList<Object[]> list = new ArrayList<Object[]>(10);
        while (copy.hasNext()) {
            Row row = copy.next();
            Long materialnum = row.getLong("materialnum");
            Long costtype = row.getLong("costtype");
            Date bizdate = row.getDate("bizdate");
            List materialTypes = (List)map.get(costtype + "@" + materialnum);
            String mType = "B";
            if (materialTypes != null && materialTypes.size() > 0) {
                for (MaterilType type : materialTypes) {
                    Date startDate = type.getStartDate();
                    Date endDate = type.getEndDate();
                    boolean isDown = type.getIsDown();
                    if (startDate == null || endDate == null || startDate.getTime() > bizdate.getTime() || bizdate.getTime() > endDate.getTime() || !isDown) continue;
                    mType = "A";
                    break;
                }
            }
            Object[] objects = new Object[fieldNames.length];
            for (String name : fieldNames) {
                objects[rowMeta.getFieldIndex((String)name)] = "materialtype".equals(name) ? mType : row.get(name);
            }
            list.add(objects);
        }
        return Algo.create((String)"macc.cad.rpt.bomsetting").createDataSet(list.iterator(), rowMeta);
    }

    private QFilter[] getAdjustQueryFilter(FilterInfo info) throws ParseException {
        DynamicObjectCollection material;
        DynamicObject costaccount;
        QFilter filter = new QFilter("createtype", "=", (Object)"X");
        filter.and(new QFilter("entryentity.diff_g", "!=", (Object)0));
        DynamicObject org = info.getDynamicObject("org");
        if (org != null) {
            filter.and(new QFilter("calorg", "=", org.getPkValue()));
        }
        if ((costaccount = info.getDynamicObject("costaccount")) != null) {
            filter.and(new QFilter("costaccount", "=", costaccount.getPkValue()));
        }
        Date enddate = info.getDate("enddate");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        if (enddate != null) {
            String end = format.format(enddate);
            enddate = format.parse(end);
        }
        Date startdate = info.getDate("startdate");
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        if (startdate != null) {
            String start = format2.format(startdate);
            startdate = format2.parse(start);
        }
        filter.and(new QFilter("bookdate", ">=", (Object)startdate));
        filter.and(new QFilter("bookdate", "<=", (Object)enddate));
        DynamicObjectCollection invorgs = info.getDynamicObjectCollection("invorg");
        if (invorgs != null && invorgs.size() > 0) {
            Set invorgIds = invorgs.stream().map(a -> a.getPkValue()).collect(Collectors.toSet());
            filter.and(new QFilter("entryentity.storageorgunit", "in", invorgIds));
        }
        if ((material = info.getDynamicObjectCollection("material")) != null && material.size() > 0) {
            Set materialIds = material.stream().map(a -> a.getPkValue()).collect(Collectors.toSet());
            filter.and(new QFilter("entryentity.material", "in", materialIds));
        }
        filter.and(new QFilter("entryentity.invbizentityobject", "=", (Object)"cal_costrecord"));
        logger.info(filter.toString());
        return filter.toArray();
    }

    private QFilter[] getRecordQueryFilter(FilterInfo info) {
        DynamicObject costaccount;
        QFilter filter = new QFilter("entry.subentrycostelement.costsubelement.number", "=", (Object)"SE001");
        DynamicObject org = info.getDynamicObject("org");
        if (org != null) {
            filter.and(new QFilter("calorg", "=", org.getPkValue()));
        }
        if ((costaccount = info.getDynamicObject("costaccount")) != null) {
            filter.and(new QFilter("costaccount", "=", costaccount.getPkValue()));
        }
        filter.and(new QFilter("entry.subentrycostelement.sub_unitstandardcost", "!=", (Object)0));
        logger.info(filter.toString());
        return filter.toArray();
    }

    private QFilter[] getBomSettingFilter(FilterInfo info) {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        DynamicObject costaccount = info.getDynamicObject("costaccount");
        if (costaccount != null) {
            DynamicObject costtype = costaccount.getDynamicObject("costtype");
            if (costtype != null) {
                filter.and(new QFilter("costtype", "=", costtype.getPkValue()));
            } else {
                return null;
            }
        }
        Date enddate = info.getDate("enddate");
        Date startdate = info.getDate("startdate");
        filter.and(new QFilter("effectdate", ">=", (Object)startdate));
        filter.and(new QFilter("expdate", "<=", (Object)enddate));
        return filter.toArray();
    }

    private String getCostAdjustFields() {
        String fields = "calorg as orgnum,costaccount as costaccountnum,costaccount.costtype as costtype,billtype,entryentity.storageorgunit as invorgnum,entryentity.material as materialnum,billno,biztype as settletype,createtype,entryentity.invbillnum as invbillno,entryentity.invbillid as invbillid,entryentity.invbillentryid as invbillentryid ,billstatus,currency,'' materialtype";
        return fields;
    }

    private String getCostRecordFields() {
        String fields = "id as id,entry entryid,billnumber purinbillno,bizbillid,entry.bizbillentryid bizbillentryid,biztype,invscheme,entry.srcbillnumber purbillno,entry.audittime as bizdate,entry.baseunit invunit,entry.subentrycostelement.sub_baseqty invqty,entry.subentrycostelement.sub_unitactualcost price,entry.subentrycostelement.sub_unitstandardcost stdprice,(entry.subentrycostelement.sub_unitactualcost*entry.subentrycostelement.sub_baseqty-entry.subentrycostelement.sub_unitstandardcost*entry.subentrycostelement.sub_baseqty) as purdiffamt,(entry.subentrycostelement.sub_unitactualcost/entry.subentrycostelement.sub_unitstandardcost - entry.subentrycostelement.sub_unitstandardcost/entry.subentrycostelement.sub_unitstandardcost)*100 diffrate";
        return fields;
    }

    private static class MaterilType {
        private Date startDate;
        private Date endDate;
        private boolean isDown;

        MaterilType(Date startDate, Date endDate, Boolean isDown) {
            this.startDate = startDate;
            this.endDate = endDate;
            this.isDown = isDown;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public boolean getIsDown() {
            return this.isDown;
        }
    }
}

