/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class WipDiffSumRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit numberText = (TextEdit)this.getView().getControl("pombillno");
        numberText.addClickListener((ClickListener)this);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costobject = (BasedataEdit)this.getControl("costobject");
        costobject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener(evt -> {
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipDiffSumRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"WipDiffSumRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)Long.valueOf(String.valueOf(accountOrg.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
        });
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        List<String> hideFields = Collections.singletonList("stdqty");
        boolean isShowDetail = this.getModel().getDataEntity().getBoolean("isshowdetail");
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)obj;
                if (!isShowDetail || !"diff".equals(reportColumn.getFieldKey())) continue;
                it.remove();
                continue;
            }
            if (!(obj instanceof ReportColumnGroup)) continue;
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)obj;
            if (!isShowDetail && "multdiff".equals(reportColumnGroup.getFieldKey())) {
                it.remove();
            }
            List reportColumns = reportColumnGroup.getChildren();
            for (int index = 0; index < reportColumns.size(); ++index) {
                Object column = reportColumns.get(index);
                if (!(column instanceof ReportColumn)) continue;
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if (!isShowDetail && hideFields.contains(key)) {
                    col.setHide(true);
                }
                if (!isShowDetail || !"totalqty".equals(col.getFieldKey())) continue;
                col.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b9e\u9645\u7528\u91cf", (String)"WipDiffSumRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0])));
            }
        }
        this.getView().updateView("reportlistap");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initOrg();
        this.initBizType();
    }

    private void initBizType() {
        ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = reportShowParameter.getCustomParams();
        if (customParams != null && customParams.size() > 0) {
            String isSettle = (String)customParams.get("bizstatus");
            this.getModel().setValue("bizstatus", (Object)isSettle);
            this.getView().updateView("bizstatus");
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if ("pombillno".equals(fieldKey)) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipDiffSumRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection selecetCostObject = this.getModel().getDataEntity().getDynamicObjectCollection("costobject");
            Set selecetCostObjectid = selecetCostObject.stream().map(s -> s.getLong("fbasedataid.id")).collect(Collectors.toSet());
            QFilter orgqf = new QFilter("org", "=", (Object)org.getLong("id"));
            if (selecetCostObjectid.size() > 0) {
                orgqf.and("id", "in", selecetCostObjectid);
            }
            DynamicObjectCollection costobjectByOrg = QueryServiceHelper.query((String)"cad_costobject", (String)"probill", (QFilter[])orgqf.toArray());
            Set probills = costobjectByOrg.stream().map(s -> s.getLong("probill")).collect(Collectors.toSet());
            QFilter probillFilter = new QFilter("treeentryentity.id", "in", probills);
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pom_mftorder", (boolean)true, (int)0);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pombillno"));
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            filters.add(probillFilter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("pombillno".equals(e.getActionId())) {
            StringBuffer str = new StringBuffer();
            if (e.getReturnData() != null && e.getReturnData() instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection col = (ListSelectedRowCollection)e.getReturnData();
                int rowIndex = 0;
                for (ListSelectedRow row : col) {
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"pom_mftorder", (String)"billno");
                    str.append(obj.getString("billno"));
                    if (rowIndex + 1 < col.size()) {
                        str.append(";");
                    }
                    ++rowIndex;
                }
                this.getModel().setValue("pombillno", (Object)str);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.setCostAccount();
                break;
            }
            case "costaccount": {
                this.setCurrencyAndPeriod(newValue);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Object period;
        Object currency;
        Object costAccount;
        boolean isPass = true;
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfo = null;
        itemInfo = filterInfo.getFilterItem("org");
        Object org = itemInfo.getValue();
        if (org == null) {
            isPass = false;
        }
        if ((costAccount = (itemInfo = filterInfo.getFilterItem("costaccount")).getValue()) == null) {
            isPass = false;
        }
        if ((currency = (itemInfo = filterInfo.getFilterItem("currency")).getValue()) == null) {
            isPass = false;
        }
        if ((period = (itemInfo = filterInfo.getFilterItem("period")).getValue()) == null) {
            isPass = false;
        }
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"WipDiffSumRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
            return false;
        }
        String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5728\u5236\u54c1\u5dee\u5f02\u6c47\u603b\u62a5\u8868\u67e5\u8be2", (String)"WipDiffSumRptPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]), (String)"WipDiffSumRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]);
        String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5728\u5236\u54c1\u5dee\u5f02\u6c47\u603b\u8868\u67e5\u8be2\u6210\u529f\u3002", (String)"WipDiffSumRptPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]), (String)"WipDiffSumRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]);
        WriteLogUtils.addLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"sca_wipdiffsumrpt");
        return super.verifyQuery(queryParam);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        switch (name) {
            case "org": {
                List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)permAccountOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "costaccount": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipDiffSumRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                listShowParameter.getListFilterParameter().getQFilters().add(StartCostHelper.getEndInitCostAccountIdsFilter((Long)Long.valueOf(org.getPkValue().toString()), (String)"sca"));
                break;
            }
            case "costcenter": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"WipDiffSumRptPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter qfId = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                QFilter qfOrgDuty = new QFilter("orgduty.number", "=", (Object)"4");
                listShowParameter.getListFilterParameter().getQFilters().add(qfId);
                listShowParameter.getListFilterParameter().getQFilters().add(qfOrgDuty);
                break;
            }
            case "costobject": {
                DynamicObject datamodel = this.getModel().getDataEntity();
                DynamicObjectCollection costcenters = datamodel.getDynamicObjectCollection("costcenter");
                if (CollectionUtils.isEmpty((Collection)costcenters)) {
                    if (org != null) {
                        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
                        listShowParameter.getListFilterParameter().getQFilters().add(orgFilter);
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"WipDiffSumRptPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]));
                        beforeF7SelectEvent.setCancel(true);
                    }
                } else {
                    List ids = costcenters.stream().map(e -> e.get(2)).collect(Collectors.toList());
                    QFilter costcenterFilter = new QFilter("costcenter", "in", ids);
                    listShowParameter.getListFilterParameter().getQFilters().add(costcenterFilter);
                }
                String pombillno = datamodel.getString("pombillno");
                if (pombillno == null || "".equals(pombillno)) break;
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("srcbillnumber", "in", (Object)pombillno.split(";")));
            }
        }
    }

    private void initOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.getView().updateView("org");
        }
        org = (DynamicObject)this.getModel().getValue("org");
        this.setCostAccount();
    }

    private void setCostAccount() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        this.getModel().setValue("costcenter", null);
        this.getModel().setValue("costobject", null);
        this.getModel().setValue("pombillno", (Object)"");
        this.getModel().setValue("headsubelement", null);
        if (org == null) {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("period", null);
            this.getModel().setValue("currency", null);
            return;
        }
        Long mainBookId = StartCostHelper.getCostAccountByAccoutOrg((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (mainBookId != null && mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("period", null);
            this.getView().updateView("period");
        }
        this.getView().updateView("costaccount");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount != null) {
            this.setCurrencyAndPeriod(costAccount);
        }
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = ((DynamicObject)costAccount).getDynamicObject("calpolicy");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", calpolicy.getPkValue())});
        this.getModel().setValue("currency", dynamicObject.get("currency"));
        this.getView().updateView("currency");
        this.setPeriod();
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            this.getModel().setValue("period", (Object)new Object[]{currentperiod});
            this.getView().updateView("period");
        }
    }
}

