/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WipUpdateDiffRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        TextEdit numberText = (TextEdit)this.getView().getControl("pombillno");
        numberText.addClickListener((ClickListener)this);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener(evt -> {
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipUpdateDiffRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"WipUpdateDiffRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)Long.valueOf(String.valueOf(accountOrg.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.init();
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        switch (name) {
            case "org": {
                List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)permAccountOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "costaccount": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipUpdateDiffRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                listShowParameter.getListFilterParameter().getQFilters().add(StartCostHelper.getEndInitCostAccountIdsFilter((Long)Long.valueOf(org.getPkValue().toString()), (String)"sca"));
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipUpdateDiffRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject costaccount = filter.getDynamicObject("costaccount");
        if (costaccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"WipUpdateDiffRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject period = filter.getDynamicObject("period");
        if (period == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u671f\u95f4", (String)"WipUpdateDiffRptPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject currency = filter.getDynamicObject("currency");
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u7ef4\u62a4\u5e01\u79cd\u3002", (String)"WipUpdateDiffRptPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.setCostAccount();
                break;
            }
            case "costaccount": {
                this.setCurrency();
                this.setPeriod();
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if ("pombillno".equals(fieldKey)) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WipUpdateDiffRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                return;
            }
            QFilter orgqf = new QFilter("org", "=", (Object)org.getLong("id"));
            DynamicObjectCollection costobjectByOrg = QueryServiceHelper.query((String)"cad_costobject", (String)"probill", (QFilter[])orgqf.toArray());
            Set probills = costobjectByOrg.stream().map(s -> s.getLong("probill")).collect(Collectors.toSet());
            QFilter probillFilter = new QFilter("treeentryentity.id", "in", probills);
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pom_mftorder", (boolean)true, (int)0);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pombillno"));
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            filters.add(probillFilter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("pombillno".equals(e.getActionId())) {
            StringBuffer str = new StringBuffer();
            if (e.getReturnData() != null && e.getReturnData() instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection col = (ListSelectedRowCollection)e.getReturnData();
                int rowIndex = 0;
                for (ListSelectedRow row : col) {
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"pom_mftorder", (String)"billno");
                    str.append(obj.getString("billno"));
                    if (rowIndex + 1 < col.size()) {
                        str.append(";");
                    }
                    ++rowIndex;
                }
                this.getModel().setValue("pombillno", (Object)str);
            }
        }
    }

    private void init() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.getView().updateView("org");
        }
        org = (DynamicObject)this.getModel().getValue("org");
        this.setCostAccount();
    }

    private void setCostAccount() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        this.getModel().setValue("pombillno", (Object)"");
        if (org == null) {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("period", null);
            this.getModel().setValue("currency", null);
            return;
        }
        Long mainBookId = StartCostHelper.getCostAccountByAccoutOrg((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (mainBookId != null && mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("period", null);
            this.getView().updateView("period");
        }
        this.getView().updateView("costaccount");
        this.setCurrency();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount != null) {
            this.setPeriod();
        }
    }

    private static Long getCostAccountByAccoutOrg(Long accountOrgId) {
        String orderby;
        QFilter accountorgQF = new QFilter("calorg", "=", (Object)accountOrgId);
        QFilter enablestdtQF = new QFilter("enablestandardcost", "=", (Object)Boolean.TRUE);
        QFilter ismainaccountQF = new QFilter("ismainaccount", "=", (Object)Boolean.TRUE);
        QFilter enable = new QFilter("enable", "=", (Object)true);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id, name,ismainaccount", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF, ismainaccountQF, enable}, (String)(orderby = "ismainaccount DESC, number ASC"));
        if (result != null && result.size() != 0 && result.size() <= 1) {
            DynamicObject costaccount = (DynamicObject)result.get(0);
            return costaccount.getLong("id");
        }
        return 0L;
    }

    public void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("period", null);
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            this.getModel().setValue("period", (Object)currentperiod);
            this.getView().updateView("period");
        }
    }
}

