/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.report.WipRptQuery;
import kd.macc.sca.report.helper.ScaRptHelper;

public class WipUpdateDiffRptQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(WipRptQuery.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        DataSet updateApplyBillResult;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        DataSet costChangeBillResult = this.queryCosChangeBill(filterInfo);
        DataSet tradeBillResult = costChangeBillResult.join(updateApplyBillResult = this.queryUpdateApplyBill(), JoinType.LEFT).on("id", "updatebillid").select(costChangeBillResult.getRowMeta().getFieldNames(), updateApplyBillResult.getRowMeta().getFieldNames()).finish();
        if (tradeBillResult != null) {
            DataSet copyTradebill = tradeBillResult.copy();
            HashSet<String> manuIds = new HashSet<String>();
            while (copyTradebill.hasNext()) {
                Row bill = copyTradebill.next();
                String manubill = bill.getString("manubill");
                if (!StringUtils.isNotEmpty((String)manubill)) continue;
                manuIds.add(manubill);
            }
            if (manuIds.size() > 0) {
                String manuFactureFields = ScaRptHelper.getManuFactureFields();
                QFilter filter = new QFilter("billno", "in", manuIds);
                DataSet pom_manufacturebill = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "_manufacturebill"), (String)"pom_mftorder", (String)manuFactureFields, (QFilter[])new QFilter[]{filter}, null);
                String[] tradeFields = new String[]{"'" + filterInfo.getDynamicObject("org").getPkValue() + "' as settleorg", "'" + filterInfo.getDynamicObject("period").getPkValue() + "' as settleperiod", "tradetype", "tradebillno", "applybillno", "bookdate", "trademateriel", "resource", "tradeqty", "tradebaseunit", "subelement", "amount", "productcost", "updatedcost", "deviation", "costcenter", "costobject", "'" + filterInfo.getDynamicObject("currency").getPkValue() + "' as entrycurrency"};
                tradeBillResult = pom_manufacturebill.join(tradeBillResult, JoinType.LEFT).on("manubill", "manubill").on("manuentryseq", "manuentryseq").select(pom_manufacturebill.getRowMeta().getFieldNames(), tradeFields).finish();
            }
        }
        String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5728\u5236\u54c1\u66f4\u65b0\u5dee\u5f02\u8868\u67e5\u8be2\u3002", (String)"WipUpdateDiffRptQuery_0", (String)"macc-sca-report", (Object[])new Object[0]), (String)"WipUpdateDiffRptQuery_1", (String)"macc-sca-report", (Object[])new Object[0]);
        String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5728\u5236\u54c1\u66f4\u65b0\u5dee\u5f02\u8868\u67e5\u8be2\u6210\u529f\u3002", (String)"WipUpdateDiffRptQuery_1", (String)"macc-sca-report", (Object[])new Object[0]), (String)"WipUpdateDiffRptQuery_2", (String)"macc-sca-report", (Object[])new Object[0]);
        WriteLogUtils.addLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"sca_updatediffrpt");
        if (tradeBillResult == null) {
            return tradeBillResult;
        }
        return tradeBillResult.orderBy(new String[]{"manubill desc", "bookdate desc"});
    }

    private DataSet queryUpdateApplyBill() {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cad_costupdatenew", (String)"billno as applybillno ,updatebillid as updatebillid", null, null);
        return dataSet;
    }

    private DataSet queryCosChangeBill(FilterInfo filterInfo) {
        logger.info("wip\u53d1\u751f\u989d\u62a5\u8868\u67e5\u8be2\u66f4\u65b0\u6210\u672c\u786e\u8ba4\u5355");
        QFilter[] filters = ScaRptHelper.getCosChangeBillFilters(filterInfo);
        String fields = ScaRptHelper.getUpdateDiffCosChangeFields();
        DataSet dataset = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "_queryCosChangeBill"), (String)"cad_costupdateestablished", (String)fields, (QFilter[])filters, null);
        return dataset;
    }
}

