/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.anal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.common.helper.MatBaseDataFilterHelper;
import kd.macc.sca.report.anal.ProExecutionCostAnalParam;

public class ProExecutionCostAnalRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static String[] CLEAR_STR_MAT = new String[]{"costobjectnumber", "costobject", "bizstatus", "srcbillnumber", "srcbillrow", "tracknumber"};

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit numberText = (TextEdit)this.getView().getControl("pombillno");
        numberText.addClickListener((ClickListener)this);
        TextEdit omNumberText = (TextEdit)this.getView().getControl("ombillno");
        omNumberText.addClickListener((ClickListener)this);
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            filterParameter.getQFilters().add(qfId);
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(evt -> {
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProExecutionCostAnalRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(new QFilter("id", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg.getLong("id"), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())));
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProExecutionCostAnalRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Long acctOrgId = org.getLong("id");
            qFilters.add(StartCostHelper.getEnabledCostAccountIdsFilter((Long)acctOrgId, (String)this.getView().getFormShowParameter().getAppId()));
        });
        BasedataEdit costCenter = (BasedataEdit)this.getControl("qcostcenter");
        costCenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProExecutionCostAnalRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(showOrgDutyFilter);
            qFilters.add(calorgsFilter);
        });
        MulBasedataEdit mulMaterial = (MulBasedataEdit)this.getControl("mulmaterial");
        mulMaterial.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProExecutionCostAnalRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            HashSet<Long> orgSet = new HashSet<Long>(16);
            orgSet.add(org.getLong("id"));
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(new ArrayList(orgSet)));
        });
        BasedataEdit configuredCodeEdit = (BasedataEdit)this.getControl("mulconfiguredcode");
        configuredCodeEdit.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection materials = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
            HashSet<Long> matIds = new HashSet<Long>(16);
            for (DynamicObject material : materials) {
                DynamicObject matObj = (DynamicObject)material.get("fbasedataid");
                matIds.add(matObj.getLong("masterid"));
            }
            if (!CadEmptyUtils.isEmpty(matIds)) {
                List configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(matIds);
                ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                qFilters.add(new QFilter("id", "in", (Object)configCodeIds));
            }
        });
        ReportList control = (ReportList)this.getView().getControl("reportlistap");
        control.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                ProExecutionCostAnalRptPlugin.this.hyperLinkBillNoClick(evt);
            }
        });
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProExecutionCostAnalRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
            return;
        }
        if ("pombillno".equals(fieldKey)) {
            QFilter orgqf = new QFilter("org", "=", (Object)org.getLong("id"));
            orgqf.and("isoutsource", "=", (Object)Boolean.FALSE);
            DataSet rows = QueryServiceHelper.queryDataSet((String)"getCostObjectInfo", (String)"cad_costobject", (String)"probill", (QFilter[])orgqf.toArray(), null);
            HashSet probills = new HashSet(16);
            rows.forEach(s -> probills.add(s.getLong("probill")));
            QFilter probillFilter = new QFilter("treeentryentity.id", "in", probills);
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pom_mftorder", (boolean)true, (int)0);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pombillno"));
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            filters.add(probillFilter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if ("ombillno".equals(fieldKey)) {
            QFilter orgqf = new QFilter("org", "=", (Object)org.getLong("id"));
            orgqf.and("isoutsource", "=", (Object)Boolean.TRUE);
            DataSet rows = QueryServiceHelper.queryDataSet((String)"getCostObjectInfo", (String)"cad_costobject", (String)"probill", (QFilter[])orgqf.toArray(), null);
            HashSet omProbills = new HashSet(16);
            rows.forEach(s -> omProbills.add(s.getLong("probill")));
            QFilter probillFilter = new QFilter("treeentryentity.id", "in", omProbills);
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"om_mftorder", (boolean)true, (int)0);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ombillno"));
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            filters.add(probillFilter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("pombillno".equals(e.getActionId())) {
            StringBuffer str = new StringBuffer();
            if (e.getReturnData() != null && e.getReturnData() instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection col = (ListSelectedRowCollection)e.getReturnData();
                int rowIndex = 0;
                for (ListSelectedRow row : col) {
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"pom_mftorder", (String)"billno");
                    str.append(obj.getString("billno"));
                    if (rowIndex + 1 < col.size()) {
                        str.append(";");
                    }
                    ++rowIndex;
                }
                this.getModel().setValue("pombillno", (Object)str);
            }
        } else if ("ombillno".equals(e.getActionId())) {
            StringBuffer str = new StringBuffer();
            if (e.getReturnData() != null && e.getReturnData() instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection col = (ListSelectedRowCollection)e.getReturnData();
                int rowIndex = 0;
                for (ListSelectedRow row : col) {
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"om_mftorder", (String)"billno");
                    str.append(obj.getString("billno"));
                    if (rowIndex + 1 < col.size()) {
                        str.append(";");
                    }
                    ++rowIndex;
                }
                this.getModel().setValue("ombillno", (Object)str);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String paramStr = (String)fsp.getCustomParam("param");
        if (!CadEmptyUtils.isEmpty((String)paramStr)) {
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
            this.getModel().setValue("org", paramMap.get("org"));
            this.getModel().setValue("manuorg", paramMap.get("manuorg"));
            this.getModel().setValue("costaccount", paramMap.get("costaccount"));
            this.getModel().setValue("pombillno", paramMap.get("pombillno"));
            this.getModel().setValue("currency", paramMap.get("currency"));
            this.getModel().setValue("startdate", (Object)paramMap.getOrDefault("startdate", new Date()));
            this.getModel().setValue("enddate", (Object)paramMap.getOrDefault("enddate", new Date()));
            this.getModel().setValue("qbizstatus", (Object)paramMap.getOrDefault("qbizstatus", "ALL"));
            this.getModel().setValue("showstandardcost", (Object)paramMap.getOrDefault("showstandardcost", true));
            this.getModel().setValue("showsum", (Object)paramMap.getOrDefault("showsum", false));
            this.getModel().setValue("showplancost", (Object)paramMap.getOrDefault("showplancost", false));
            this.getModel().setValue("showbulk", (Object)paramMap.getOrDefault("showbulk", false));
            this.getView().updateView("org");
            this.getView().updateView("manuorg");
            this.getView().updateView("costaccount");
            this.getView().updateView("currency");
            this.getView().updateView("startdate");
            this.getView().updateView("enddate");
            this.getView().updateView("qbizstatus");
            this.getView().updateView("showstandardcost");
            this.getView().updateView("pombillno");
            this.getView().updateView("showsum");
            this.getView().updateView("showplancost");
            this.getView().updateView("showbulk");
            ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
            filter.search();
        }
    }

    protected void hyperLinkBillNoClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        DynamicObject row = evt.getRowData();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        String formId = "";
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        if ("srcbillnumber".equals(fieldName)) {
            formId = "sca_wipaccumamtrpt";
            filterInfo.addFilterItem("org", (Object)org.getLong("id"), "=");
            filterInfo.addFilterItem("costaccount", (Object)costAccount.getLong("id"), "=");
            filterInfo.addFilterItem("currency", (Object)currency.getLong("id"), "=");
            filterInfo.addFilterItem("bustype", (Object)"ALL", "=");
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
            if (curPeriod != null) {
                filterInfo.addFilterItem("period", (Object)curPeriod.getLong("id"), "=");
            }
            filterInfo.addFilterItem("pombillno", (Object)row.getString("srcbillnumber"), "=");
        }
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setQueryParam(queryParam);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        switch (propertyName) {
            case "org": {
                this.setOther();
                this.setCostAccount();
                this.setManuorg();
                this.getModel().setValue("manuorg", null);
                break;
            }
            case "costaccount": {
                this.setCurrency();
                break;
            }
            case "pombillno": {
                if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                    return;
                }
                Object pomBillNo = this.getModel().getValue("pombillno");
                if (pomBillNo == null) break;
                String[] split = String.valueOf(pomBillNo).split(";");
                QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                qFilter.and("srcbillnumber", "in", Arrays.asList(split));
                DataSet rows = QueryServiceHelper.queryDataSet((String)"getCostObjectInfo", (String)"cad_costobject", (String)"material,configuredcode,tracknumber", (QFilter[])qFilter.toArray(), null);
                HashSet materialIds = new HashSet(16);
                HashSet configuredCodeIds = new HashSet(16);
                HashSet trackNumberIds = new HashSet(16);
                rows.forEach(s -> {
                    materialIds.add(s.getLong("material"));
                    configuredCodeIds.add(s.getLong("configuredcode"));
                    trackNumberIds.add(s.getLong("tracknumber"));
                });
                DynamicObjectCollection mulmaterial = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
                DynamicObjectCollection mulconfiguredcode = this.getModel().getDataEntity().getDynamicObjectCollection("mulconfiguredcode");
                DynamicObjectCollection multracknumber = this.getModel().getDataEntity().getDynamicObjectCollection("multracknumber");
                mulmaterial.forEach(s -> materialIds.add(s.getDynamicObject("fbasedataid").getLong("id")));
                mulconfiguredcode.forEach(s -> configuredCodeIds.add(s.getDynamicObject("fbasedataid").getLong("id")));
                multracknumber.forEach(s -> trackNumberIds.add(s.getDynamicObject("fbasedataid").getLong("id")));
                this.getModel().setValue("mulmaterial", (Object)materialIds.toArray());
                this.getModel().setValue("mulconfiguredcode", (Object)configuredCodeIds.toArray());
                this.getModel().setValue("multracknumber", (Object)trackNumberIds.toArray());
                break;
            }
            case "ombillno": {
                if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                    return;
                }
                Object omBillNo = this.getModel().getValue("ombillno");
                if (omBillNo == null) break;
                String[] split = String.valueOf(omBillNo).split(";");
                QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                qFilter.and("srcbillnumber", "in", Arrays.asList(split));
                DataSet rows = QueryServiceHelper.queryDataSet((String)"getCostObjectInfo", (String)"cad_costobject", (String)"material,configuredcode,tracknumber", (QFilter[])qFilter.toArray(), null);
                HashSet materialIds = new HashSet(16);
                HashSet configuredCodeIds = new HashSet(16);
                HashSet trackNumberIds = new HashSet(16);
                rows.forEach(s -> {
                    materialIds.add(s.getLong("material"));
                    configuredCodeIds.add(s.getLong("configuredcode"));
                    trackNumberIds.add(s.getLong("tracknumber"));
                });
                DynamicObjectCollection mulmaterial = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
                DynamicObjectCollection mulconfiguredcode = this.getModel().getDataEntity().getDynamicObjectCollection("mulconfiguredcode");
                DynamicObjectCollection multracknumber = this.getModel().getDataEntity().getDynamicObjectCollection("multracknumber");
                mulmaterial.forEach(s -> materialIds.add(s.getDynamicObject("fbasedataid").getLong("id")));
                mulconfiguredcode.forEach(s -> configuredCodeIds.add(s.getDynamicObject("fbasedataid").getLong("id")));
                multracknumber.forEach(s -> trackNumberIds.add(s.getDynamicObject("fbasedataid").getLong("id")));
                this.getModel().setValue("mulmaterial", (Object)materialIds.toArray());
                this.getModel().setValue("mulconfiguredcode", (Object)configuredCodeIds.toArray());
                this.getModel().setValue("multracknumber", (Object)trackNumberIds.toArray());
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOrg();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.setCostAccount();
            this.setCurrency();
        }
        this.setManuorg();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String paramStr = (String)fsp.getCustomParam("param");
        if (!CadEmptyUtils.isEmpty((String)paramStr)) {
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
            this.getModel().setValue("startdate", (Object)paramMap.getOrDefault("startdate", new Date()));
            this.getModel().setValue("enddate", (Object)paramMap.getOrDefault("enddate", new Date()));
        } else {
            Date date = DateUtils.getCurrentSystemDate();
            if (this.getModel().getValue("startdate") == null) {
                this.getModel().setValue("startdate", (Object)date);
            }
            if (this.getModel().getValue("enddate") == null) {
                this.getModel().setValue("enddate", (Object)date);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        if ("exportexcel".equals(operateKey) && !PermItemCheckHelper.isPerm((String)"sca_proexecostanalrpt", (String)"4730fc9f000004ae", (String)this.getView().getFormShowParameter().getAppId(), (Long)org.getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u751f\u4ea7\u6267\u884c\u6210\u672c\u5206\u6790\u8868\u201d\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProExecutionCostAnalRptPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean isPass;
        boolean enableMulFactory;
        super.verifyQuery(queryParam);
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "currency", "startdate", "enddate"});
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null && (enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id")))) {
            pros.add("manuorg");
        }
        if (!(isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"ProExecutionCostAnalRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
            return false;
        }
        ProExecutionCostAnalParam queryPram = this.buildQueryParam(this.getModel().getDataEntity());
        this.getQueryParam().getCustomParam().put(ProExecutionCostAnalParam.class.getName(), queryPram);
        return true;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        ReportUtils.clearFileNameValue((String[])CLEAR_STR_MAT, (DynamicObjectCollection)rowData, (String[])CLEAR_STR_MAT);
    }

    private void setOther() {
        this.getModel().setValue("qcostcenter", null);
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("manuorg", null);
        this.getModel().setValue("mulmaterial", null);
        Date date = DateUtils.getCurrentSystemDate();
        this.getModel().setValue("startdate", (Object)date);
        this.getModel().setValue("enddate", (Object)date);
        this.getModel().setValue("showstandardcost", (Object)false);
        this.getModel().setValue("showplancost", (Object)true);
    }

    private ProExecutionCostAnalParam buildQueryParam(DynamicObject dataEntity) {
        String bizStatus;
        DynamicObjectCollection mulMaterial;
        String omBillNo;
        String pomBillNo;
        ProExecutionCostAnalParam param = new ProExecutionCostAnalParam();
        DynamicObject org = dataEntity.getDynamicObject("org");
        param.setOrgId(org.getLong("id"));
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        param.setCostAccountId(costAccount.getLong("id"));
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        param.setCurrencyId(currency.getLong("id"));
        int amtPrecision = currency.getInt("amtprecision");
        param.setAmtPrecision(amtPrecision);
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        if (enableMulFactory) {
            DynamicObject manuorg = dataEntity.getDynamicObject("manuorg");
            param.setManuOrgId(manuorg.getLong("id"));
        }
        Date startDate = dataEntity.getDate("startdate");
        param.setStartDate(startDate);
        Date endDate = dataEntity.getDate("enddate");
        Calendar c = Calendar.getInstance();
        c.setTime(endDate);
        c.add(6, 1);
        endDate = c.getTime();
        param.setEndDate(endDate);
        DynamicObject costCenter = dataEntity.getDynamicObject("qcostcenter");
        if (costCenter != null) {
            param.setCostCenterId(costCenter.getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty((String)(pomBillNo = dataEntity.getString("pombillno")))) {
            param.setProBillNumbers(new ArrayList<String>(Arrays.asList(pomBillNo.split(";"))));
        }
        if (!CadEmptyUtils.isEmpty((String)(omBillNo = dataEntity.getString("ombillno")))) {
            List<String> proBillNumbers = param.getProBillNumbers();
            proBillNumbers.addAll(Arrays.asList(pomBillNo.split(";")));
            param.setProBillNumbers(proBillNumbers);
        }
        if ((mulMaterial = (DynamicObjectCollection)this.getModel().getValue("mulmaterial")) != null) {
            param.setMaterialIds(mulMaterial.stream().map(material -> material.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((String)(bizStatus = (String)this.getModel().getValue("qbizstatus"))) && !"ALL".equalsIgnoreCase(bizStatus)) {
            param.setBizStatus(bizStatus);
        }
        Boolean showStandardCost = (Boolean)this.getModel().getValue("showstandardcost");
        param.setShowStandardCost(showStandardCost);
        Boolean showPlanCost = (Boolean)this.getModel().getValue("showplancost");
        param.setShowPlanCost(showPlanCost);
        Boolean showBulk = (Boolean)this.getModel().getValue("showbulk");
        param.setShowBulk(showBulk);
        boolean showsum = dataEntity.getBoolean("showsum");
        param.setShowsum(showsum);
        DynamicObjectCollection mulConfiguredCode = (DynamicObjectCollection)this.getModel().getValue("mulconfiguredcode");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulConfiguredCode)) {
            List<Long> configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            param.setConfiguredCodeIds(configuredCodeIds);
        } else if (!CadEmptyUtils.isEmpty(param.getMaterialIds())) {
            param.setConfiguredCodeIds(Collections.singletonList(0L));
        }
        DynamicObjectCollection mulTracknumber = (DynamicObjectCollection)this.getModel().getValue("multracknumber");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulTracknumber)) {
            List<Long> trackNumberIds = mulTracknumber.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            param.setTrackNumberIds(trackNumberIds);
        } else if (!CadEmptyUtils.isEmpty(param.getMaterialIds())) {
            param.setTrackNumberIds(Collections.singletonList(0L));
        }
        return param;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ProExecutionCostAnalRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"ProExecutionCostAnalRptPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"sca_proexecostanalrpt", (IDataModel)this.getModel());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>(16);
        removedPros.add("currency");
        removedPros.add("costcenter");
        removedPros.add("costobjectnumber");
        removedPros.add("baseunit");
        removedPros.add("mat");
        removedPros.add("matresource");
        removedPros.add("resource");
        removedPros.add("matname");
        removedPros.add("matnum");
        removedPros.add("resourcenum");
        removedPros.add("matresourcenum");
        removedPros.add("matunit");
        removedPros.add("unit");
        removedPros.add("resourcename");
        removedPros.add("product");
        removedPros.add("srcauditdate");
        removedPros.add("bookdate");
        removedPros.add("sumrow");
        return !removedPros.contains(split[0]);
    }

    private void setManuorg() {
        Object org = this.getModel().getValue("org");
        if (!ObjectUtils.isEmpty((Object)org)) {
            DynamicObject orgData = (DynamicObject)org;
            boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)((Long)orgData.getPkValue()));
            this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (orgIds.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
                this.getView().updateView("org");
            }
        }
    }

    private void setCostAccount() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long mainBookId = CostAccountHelper.getCostAccountByAccoutOrg((Long)((DynamicObject)org).getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
    }

    private void setCurrency() {
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
            this.getModel().setValue("currency", null);
        } else {
            this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccountObj));
        }
    }
}

