/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.anal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.report.anal.ProExecutionCostAnalParam;
import kd.macc.sca.report.anal.ProExecutionHandleDataRow;
import kd.macc.sca.report.anal.ProExecutionHandleResultRow;

public class ProExecutionCostAnalSourceCF
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(ProExecutionCostAnalSourceCF.class);
    private Set<String> hideProps = Sets.newHashSet((Object[])new String[]{"currency", "unit", "mat", "matname", "matnum", "matunit", "resource", "resourcenum", "resourcename", "inputqty", "outputqty", "tracknumber"});
    private Set<String> planHideProps = Sets.newHashSet((Object[])new String[]{"sumplanqty", "sumplanamt", "planqty", "planamt", "planamtdiff", "planqtydiff"});
    private Set<String> standardHideProps = Sets.newHashSet((Object[])new String[]{"sumstandardqty", "sumstandardamt", "standardqty", "standardamt", "standardamtdiff", "standardqtydiff", "planstandardqtydiff", "planstandardamtdiff"});
    private Set<String> planStandardHideProps = Sets.newHashSet((Object[])new String[]{"planstandardqtydiff", "planstandardamtdiff"});
    private List<String> all_Cost = Lists.newArrayList((Object[])new String[]{"sumplanqty", "sumplanamt", "sumstandardqty", "sumstandardamt"});
    private List<String> in_Cost = Lists.newArrayList((Object[])new String[]{"planqty", "planamt", "planamtdiff", "standardqty", "standardamt", "standardamtdiff", "actualqty", "actualamt", "standardqtydiff", "planqtydiff", "planstandardqtydiff", "planstandardamtdiff"});
    private List<String> qtyProps = Lists.newArrayList((Object[])new String[]{"sumplanqty", "sumstandardqty", "planqty", "standardqty", "actualqty", "standardqtydiff", "planqtydiff", "planstandardqtydiff"});
    private List<String> amrProps = Lists.newArrayList((Object[])new String[]{"sumplanamt", "sumstandardamt", "planamt", "planamtdiff", "standardamt", "standardamtdiff", "actualamt", "planstandardamtdiff"});
    private List<String> hyProps = Lists.newArrayList((Object[])new String[]{"srcbillnumber"});
    private ProExecutionCostAnalParam proExecutionCostAnalParam;

    public void setupCtx(ReportDataCtx ctx) {
        super.setupCtx(ctx);
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.proExecutionCostAnalParam = (ProExecutionCostAnalParam)ctx.getParam(ProExecutionCostAnalParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        super.transFormAfterGroup(transCollector, ctx);
        this.logger.info("\u5904\u7406\u6570\u636e\uff0c\u5173\u8054\u5165\u5e93\u6570\u91cf\u3001\u5b8c\u5de5\u6570\u91cf\u3001\u5b9e\u9645\u6210\u672c\u3001\u8ba1\u5212\u6210\u672c\u3001\u6807\u51c6\u6210\u672c");
        transCollector.add(new ProExecutionHandleDataRow(this.proExecutionCostAnalParam, ctx));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        super.transformResult(transCollector, ctx);
        transCollector.add(new ProExecutionHandleResultRow(this.proExecutionCostAnalParam));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u914d\u7f6e\u5217\u662f\u5426\u663e\u793a");
        Boolean showPlanCost = this.proExecutionCostAnalParam.getShowPlanCost();
        Boolean showStandardCost = this.proExecutionCostAnalParam.getShowStandardCost();
        Boolean showBulk = this.proExecutionCostAnalParam.getShowBulk();
        ReportColumnGroup allCost = new ReportColumnGroup();
        allCost.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5de5\u5355\u603b\u4f53\u6210\u672c", (String)"ProExecutionCostAnalSourceCF_0", (String)"macc-sca-report", (Object[])new Object[0])));
        allCost.setFieldKey("allcost");
        ReportColumnGroup inCost = new ReportColumnGroup();
        inCost.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b9e\u9645\u5165\u5e93\u6210\u672c", (String)"ProExecutionCostAnalSourceCF_1", (String)"macc-sca-report", (Object[])new Object[0])));
        inCost.setFieldKey("incost");
        Iterator<AbstractReportColumn> iterator = cols.iterator();
        while (iterator.hasNext()) {
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            if (!(showPlanCost.booleanValue() && showStandardCost.booleanValue() || !this.planStandardHideProps.contains(fieldKey))) {
                repCol.setHide(true);
            }
            if (!showBulk.booleanValue() && fieldKey.equals("isbulk")) {
                repCol.setHide(true);
            }
            if (!showPlanCost.booleanValue() && this.planHideProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (!showStandardCost.booleanValue() && this.standardHideProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (this.hideProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (this.hyProps.contains(fieldKey)) {
                repCol.setHyperlink(true);
            }
            String caption = repCol.getCaption().getLocaleValue();
            if (ResManager.loadKDString((String)"\u4ea7\u54c1\u7f16\u7801.\u540d\u79f0", (String)"ProExecutionCostAnalSourceCF_2", (String)"macc-sca-report", (Object[])new Object[0]).equals(caption)) {
                repCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ea7\u54c1\u540d\u79f0", (String)"ProExecutionCostAnalSourceCF_3", (String)"macc-sca-report", (Object[])new Object[0])));
            }
            if (ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u7f16\u7801.\u540d\u79f0", (String)"ProExecutionCostAnalSourceCF_4", (String)"macc-sca-report", (Object[])new Object[0]).equals(caption)) {
                repCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u540d\u79f0", (String)"ProExecutionCostAnalSourceCF_5", (String)"macc-sca-report", (Object[])new Object[0])));
            }
            if (ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801.\u540d\u79f0", (String)"ProExecutionCostAnalSourceCF_6", (String)"macc-sca-report", (Object[])new Object[0]).equals(caption)) {
                repCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u540d\u79f0", (String)"ProExecutionCostAnalSourceCF_7", (String)"macc-sca-report", (Object[])new Object[0])));
            }
            if (ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7\u7f16\u7801", (String)"ProExecutionCostAnalSourceCF_8", (String)"macc-sca-report", (Object[])new Object[0]).equals(caption)) {
                repCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7", (String)"ProExecutionCostAnalSourceCF_9", (String)"macc-sca-report", (Object[])new Object[0])));
            }
            if (this.qtyProps.contains(fieldKey)) {
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                repCol.setFieldType("qty");
                repCol.setMeasureUnitField("baseunit");
                repCol.setNoDisplayScaleZero(false);
            }
            if (this.amrProps.contains(fieldKey)) {
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                repCol.setNoDisplayScaleZero(false);
            }
            if (this.all_Cost.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                allCost.getChildren().add(repCol);
                iterator.remove();
            }
            if (!this.in_Cost.contains(fieldKey)) continue;
            repCol.setNoDisplayScaleZero(false);
            repCol.setZeroShow(false);
            repCol.setHideSingleColumnRow(false);
            inCost.getChildren().add(repCol);
            iterator.remove();
        }
        cols.add((AbstractReportColumn)allCost);
        cols.add((AbstractReportColumn)inCost);
        return cols;
    }

    private List<QFilter> getFixedFilter() {
        List<Long> trackNumberIds;
        List<Long> configuredCodeIds;
        List<Long> materialIds;
        String bizStatus;
        Long costCenterId;
        Date endDate;
        Date startDate;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>(10);
        Long orgId = this.proExecutionCostAnalParam.getOrgId();
        filters.add(new QFilter("org", "=", (Object)orgId));
        Long manuOrgId = this.proExecutionCostAnalParam.getManuOrgId();
        if (!CadEmptyUtils.isEmpty((Long)manuOrgId)) {
            filters.add(new QFilter("manuorg", "=", (Object)manuOrgId));
        }
        if ((startDate = this.proExecutionCostAnalParam.getStartDate()) != null) {
            filters.add(new QFilter("bookdate", ">=", (Object)startDate));
        }
        if ((endDate = this.proExecutionCostAnalParam.getEndDate()) != null) {
            filters.add(new QFilter("bookdate", "<", (Object)endDate));
        }
        if (!CadEmptyUtils.isEmpty((Long)(costCenterId = this.proExecutionCostAnalParam.getCostCenterId()))) {
            filters.add(new QFilter("costcenter", "=", (Object)costCenterId));
        }
        if (!CadEmptyUtils.isEmpty((String)(bizStatus = this.proExecutionCostAnalParam.getBizStatus()))) {
            filters.add(new QFilter("bizstatus", "=", (Object)bizStatus));
        }
        if (!CadEmptyUtils.isEmpty(materialIds = this.proExecutionCostAnalParam.getMaterialIds())) {
            commonFilters.add(new QFilter("product", "in", materialIds));
        }
        if (!CadEmptyUtils.isEmpty(configuredCodeIds = this.proExecutionCostAnalParam.getConfiguredCodeIds())) {
            commonFilters.add(new QFilter("configuredcode", "in", configuredCodeIds));
        }
        if (!CadEmptyUtils.isEmpty(trackNumberIds = this.proExecutionCostAnalParam.getTrackNumberIds())) {
            commonFilters.add(new QFilter("tracknumber", "in", trackNumberIds));
        }
        this.proExecutionCostAnalParam.setCostTypeId(this.getCostTypeId());
        this.proExecutionCostAnalParam.setCommonFilters(filters);
        commonFilters.addAll(filters);
        return commonFilters;
    }

    private Long getCostTypeId() {
        Long orgId = this.proExecutionCostAnalParam.getOrgId();
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        Long manuOrgId = this.proExecutionCostAnalParam.getManuOrgId();
        Long costAccountId = this.proExecutionCostAnalParam.getCostAccountId();
        if (enableMulFactory && manuOrgId != null) {
            long invOrg = 0L;
            List invList = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)manuOrgId, (boolean)true);
            if (!CadEmptyUtils.isEmpty((List)invList)) {
                invOrg = Sets.newHashSet((Iterable)invList).contains(manuOrgId) ? manuOrgId.longValue() : ((Long)invList.get(0)).longValue();
            }
            this.proExecutionCostAnalParam.setInvOrg(invOrg);
            return CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)costAccountId, (Long)orgId, (Long)manuOrgId);
        }
        this.proExecutionCostAnalParam.setInvOrg(0L);
        return CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)costAccountId, (Long)orgId, null);
    }
}

