/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.clac;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.rpt.UnabSorbCalcParam;
import kd.macc.sca.report.clac.DataSetDealRow;
import kd.macc.sca.report.clac.UnabSorbCalcHandleDataRow;

public class UnabSorbCalcSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(UnabSorbCalcSourceCf.class);
    private Set<String> hideProps = Sets.newHashSet((Object[])new String[]{"period", "costcenter", "currency", "mfgtype", "productgroupnum", "productgroup", "mfgmaterialnumber", "mfgtotaldiffqty", "mfgversion", "costcenterord"});
    private Set<String> matHideProps = Sets.newHashSet((Object[])new String[]{"period", "costcenter", "manuorg", "manuorgnum", "costobject", "costobjectnumber", "mfgmaterial", "mfgmaterialnumber", "mfgmaterialname", "mfgmodelnum", "mfgunit", "mfgauxpty"});
    private List<String> mfgPdStartProps = Lists.newArrayList((Object[])new String[]{"mfgpdstartqty", "mfgpdstartamt"});
    private List<String> mfgPdCurrProps = Lists.newArrayList((Object[])new String[]{"mfgpdcurrqty", "mfgpdcurramt"});
    private List<String> mfgPdEndProps = Lists.newArrayList((Object[])new String[]{"mfgpdendqty", "mfgpdendamt"});
    private List<String> mfgPdDiffProps = Lists.newArrayList((Object[])new String[]{"mfgpddiffqty", "mfgpddiffamt"});
    private List<String> mfgTotalDiffProps = Lists.newArrayList((Object[])new String[]{"mfgtotaldiffqty", "mfgtotaldiffamt"});
    private List<String> qtyProps = Lists.newArrayList((Object[])new String[]{"mfgpdstartqty", "mfgpdcurrqty", "mfgpdendqty", "mfgpddiffqty", "mfgtotaldiffqty"});
    private UnabSorbCalcParam unabSorbCalcParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.unabSorbCalcParam = (UnabSorbCalcParam)ctx.getParam(UnabSorbCalcParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        super.transFormAfterGroup(transCollector, ctx);
        this.logger.info("\u5904\u7406\u7269\u6599\u5206\u7c7b,\u5206\u7c7b\u7ea7\u6b21\u5f00\u59cb");
        transCollector.add(new UnabSorbCalcHandleDataRow(this.unabSorbCalcParam, ctx));
        this.logger.info("\u5904\u7406\u7269\u6599\u5206\u7c7b,\u5206\u7c7b\u7ea7\u6b21\u7ed3\u675f");
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u6570\u636e\u6700\u7ec8\u5904\u7406\u5f00\u59cb");
        transCollector.add(new DataSetDealRow(this.unabSorbCalcParam));
        this.logger.info("\u6570\u636e\u6700\u7ec8\u5904\u7406\u7ed3\u675f");
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u914d\u7f6e\u5217\u662f\u5426\u663e\u793a");
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)this.unabSorbCalcParam.getOrgId());
        boolean onlyMaterialType = this.unabSorbCalcParam.getOnlyMaterialType();
        ReportColumnGroup mfgPdStart = new ReportColumnGroup();
        mfgPdStart.setCaption(new LocaleString(ResManager.loadKDString((String)"\u671f\u521d\u5728\u4ea7\u54c1", (String)"UnabSorbCalcSourceCf_0", (String)"macc-sca-report", (Object[])new Object[0])));
        mfgPdStart.setFieldKey("mfgpdstart");
        ReportColumnGroup mfgPdCurr = new ReportColumnGroup();
        mfgPdCurr.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u6295\u4ea7", (String)"UnabSorbCalcSourceCf_1", (String)"macc-sca-report", (Object[])new Object[0])));
        mfgPdCurr.setFieldKey("mfgpdcurr");
        ReportColumnGroup mfgPdEnd = new ReportColumnGroup();
        mfgPdEnd.setCaption(new LocaleString(ResManager.loadKDString((String)"\u671f\u672b\u5728\u4ea7\u54c1", (String)"UnabSorbCalcSourceCf_2", (String)"macc-sca-report", (Object[])new Object[0])));
        mfgPdEnd.setFieldKey("mfgpdend");
        ReportColumnGroup mfgPdDiff = new ReportColumnGroup();
        mfgPdDiff.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u5dee\u5f02\u8f6c\u51fa", (String)"UnabSorbCalcSourceCf_3", (String)"macc-sca-report", (Object[])new Object[0])));
        mfgPdDiff.setFieldKey("mfgpddiff");
        ReportColumnGroup mfgTotalDiff = new ReportColumnGroup();
        mfgTotalDiff.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7d2f\u8ba1\u5dee\u5f02\u8f6c\u51fa", (String)"UnabSorbCalcSourceCf_4", (String)"macc-sca-report", (Object[])new Object[0])));
        mfgTotalDiff.setFieldKey("mfgTotalDiff");
        Iterator<AbstractReportColumn> iterator = cols.iterator();
        while (iterator.hasNext()) {
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            if (onlyMaterialType && this.matHideProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (this.hideProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (!enableMulFactory && "manuorg".equals(fieldKey)) {
                repCol.setHide(true);
            }
            if (this.qtyProps.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                repCol.setFieldType("qty");
                repCol.setMeasureUnitField("mfgunit");
                repCol.setNoDisplayScaleZero(false);
            }
            if (this.mfgPdStartProps.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                mfgPdStart.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.mfgPdCurrProps.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                mfgPdCurr.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.mfgPdEndProps.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                mfgPdEnd.getChildren().add(repCol);
                iterator.remove();
            }
            if (this.mfgPdDiffProps.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                mfgPdDiff.getChildren().add(repCol);
                iterator.remove();
            }
            if (!this.mfgTotalDiffProps.contains(fieldKey)) continue;
            repCol.setNoDisplayScaleZero(false);
            repCol.setZeroShow(false);
            repCol.setHideSingleColumnRow(false);
            mfgTotalDiff.getChildren().add(repCol);
            iterator.remove();
        }
        cols.add((AbstractReportColumn)mfgPdStart);
        cols.add((AbstractReportColumn)mfgPdCurr);
        cols.add((AbstractReportColumn)mfgPdEnd);
        cols.add((AbstractReportColumn)mfgPdDiff);
        cols.add((AbstractReportColumn)mfgTotalDiff);
        return cols;
    }

    private List<QFilter> getOtherFilter() {
        ArrayList<QFilter> otherFilters = new ArrayList<QFilter>(10);
        List materialIds = this.unabSorbCalcParam.getMaterialIds();
        List costObjectIds = this.unabSorbCalcParam.getCostObjectIds();
        if (!CadEmptyUtils.isEmpty((List)materialIds) || !CadEmptyUtils.isEmpty((List)costObjectIds)) {
            Set<Long> mainCostObjectIds = this.getMainCostobjectIds(this.unabSorbCalcParam.getCommonFilters(), costObjectIds, materialIds);
            otherFilters.add(new QFilter("qcostobject", "in", mainCostObjectIds));
        }
        return otherFilters;
    }

    private List<QFilter> getFixedFilter() {
        String bizStatus;
        List costCenterIds;
        Long costCenterGroupId;
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>(10);
        Long orgId = this.unabSorbCalcParam.getOrgId();
        commonFilters.add(new QFilter("org", "=", (Object)orgId));
        Long costAccountId = this.unabSorbCalcParam.getCostAccountId();
        commonFilters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        List periodIds = this.unabSorbCalcParam.getPeriodIds();
        commonFilters.add(periodIds.size() == 1 ? new QFilter("period", "=", periodIds.get(0)) : new QFilter("period", "in", (Object)periodIds));
        List manuOrgIds = this.unabSorbCalcParam.getManuOrgIds();
        if (!CadEmptyUtils.isEmpty((List)manuOrgIds)) {
            commonFilters.add(new QFilter("costobject.manuorg", "in", (Object)manuOrgIds));
        }
        if ((costCenterGroupId = this.unabSorbCalcParam.getCostCenterGroupId()) != null) {
            costCenterIds = CostCenterHelper.getCostCenterByCCGroup((Long)costCenterGroupId);
            commonFilters.add(new QFilter("costcenter", "in", (Object)costCenterIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(costCenterIds = this.unabSorbCalcParam.getCostCenterIds()))) {
            commonFilters.add(costCenterIds.size() == 1 ? new QFilter("costcenter", "=", costCenterIds.get(0)) : new QFilter("costcenter", "in", (Object)costCenterIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(bizStatus = this.unabSorbCalcParam.getBizStatus()))) {
            commonFilters.add(new QFilter("bizstatus", "=", (Object)bizStatus));
        }
        this.unabSorbCalcParam.setCommonFilters(commonFilters);
        List<QFilter> otherFilters = this.getOtherFilter();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.addAll(commonFilters);
        filters.addAll(otherFilters);
        return filters;
    }

    private Set<Long> getMainCostobjectIds(List<QFilter> commonFilters, List<Long> costObjectIds, List<Long> materialIds) {
        DataSet dataSet;
        ArrayList<QFilter> calResultFilter = new ArrayList<QFilter>(10);
        calResultFilter.addAll(commonFilters);
        HashSet<Long> ids = new HashSet<Long>(16);
        calResultFilter.add(new QFilter("unabsorbentry.mfgtype", "=", (Object)"5"));
        if (costObjectIds != null && !costObjectIds.isEmpty()) {
            calResultFilter.add(new QFilter("unabsorbentry.mfgobj", "in", costObjectIds));
        }
        if (materialIds != null && !materialIds.isEmpty()) {
            calResultFilter.add(new QFilter("unabsorbentry.mfgobj.material", "in", materialIds));
        }
        if ((dataSet = QueryServiceHelper.queryDataSet((String)"costobject", (String)"sca_calcresult", (String)"costobject mainCostObjectId,unabsorbentry.mfgobj costobjectId,unabsorbentry.mfgobj.material materialId", (QFilter[])calResultFilter.toArray(new QFilter[0]), (String)"")) != null && dataSet.hasNext()) {
            for (Row row : dataSet) {
                ids.add(row.getLong("mainCostObjectId"));
            }
        }
        return ids;
    }
}

