/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.cost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;

public class AddTotalRowFunction
extends ReduceGroupFunction {
    private RowMeta rowMeta;

    public AddTotalRowFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public Iterator<Object[]> reduce(Iterator<Row> iterator) {
        ArrayList<Object[]> resultList = new ArrayList<Object[]>();
        BigDecimal periodTotalQty = BigDecimal.ZERO;
        BigDecimal periodTotalAmt = BigDecimal.ZERO;
        BigDecimal transinTotalQty = BigDecimal.ZERO;
        BigDecimal transinTotalAmt = BigDecimal.ZERO;
        BigDecimal purTotalQty = BigDecimal.ZERO;
        BigDecimal purTotalAmt = BigDecimal.ZERO;
        BigDecimal maxYearTotalQty = BigDecimal.ZERO;
        BigDecimal maxYearTotalAmt = BigDecimal.ZERO;
        Long currency = 0L;
        boolean isFirst = true;
        while (iterator.hasNext()) {
            BigDecimal sumAmt;
            Row row = iterator.next();
            if (isFirst) {
                isFirst = false;
                currency = row.getLong(this.rowMeta.getFieldIndex("currency"));
            }
            BigDecimal qty = row.getBigDecimal(this.rowMeta.getFieldIndex("qty"));
            periodTotalQty = periodTotalQty.add(qty);
            BigDecimal amount = row.getBigDecimal(this.rowMeta.getFieldIndex("amount"));
            periodTotalAmt = periodTotalAmt.add(amount);
            BigDecimal transinQty = row.getBigDecimal(this.rowMeta.getFieldIndex("transinqty"));
            transinTotalQty = transinTotalQty.add(this.isNullOrZero(transinQty) ? BigDecimal.ZERO : transinQty);
            BigDecimal transinAmt = row.getBigDecimal(this.rowMeta.getFieldIndex("transinamount"));
            transinTotalAmt = transinTotalAmt.add(this.isNullOrZero(transinAmt) ? BigDecimal.ZERO : transinAmt);
            BigDecimal purQty = row.getBigDecimal(this.rowMeta.getFieldIndex("purqty"));
            purTotalQty = purTotalQty.add(this.isNullOrZero(purQty) ? BigDecimal.ZERO : purQty);
            BigDecimal purAmt = row.getBigDecimal(this.rowMeta.getFieldIndex("puramount"));
            purTotalAmt = purTotalAmt.add(this.isNullOrZero(purAmt) ? BigDecimal.ZERO : purAmt);
            BigDecimal sumQty = row.getBigDecimal(this.rowMeta.getFieldIndex("sumqty"));
            if (sumQty != null && sumQty.compareTo(maxYearTotalQty) > 0) {
                maxYearTotalQty = sumQty;
            }
            if ((sumAmt = row.getBigDecimal(this.rowMeta.getFieldIndex("sumamt"))) == null || sumAmt.compareTo(maxYearTotalAmt) <= 0) continue;
            maxYearTotalAmt = sumAmt;
        }
        Object[] totalCountRowData = new Object[this.rowMeta.getFields().length];
        totalCountRowData[this.rowMeta.getFieldIndex((String)"period")] = 0L;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"level")] = ResManager.loadKDString((String)"\u603b\u8ba1", (String)"AddTotalRowFunction_0", (String)"macc-sca-report", (Object[])new Object[0]);
        totalCountRowData[this.rowMeta.getFieldIndex((String)"linetype")] = "2";
        totalCountRowData[this.rowMeta.getFieldIndex((String)"isTop")] = 1;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"currency")] = currency;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"baseunit")] = 0L;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"qty")] = periodTotalQty;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"amount")] = periodTotalAmt;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"qty")] = periodTotalQty;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"amount")] = periodTotalAmt;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"transinqty")] = transinTotalQty;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"transinamount")] = transinTotalAmt;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"purqty")] = purTotalQty;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"puramount")] = purTotalAmt;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"sumqty")] = maxYearTotalQty;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"sumamt")] = maxYearTotalAmt;
        resultList.add(totalCountRowData);
        return resultList.iterator();
    }

    private boolean isNullOrZero(BigDecimal value) {
        return value == null || value.compareTo(BigDecimal.ZERO) == 0;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

