/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.cost;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class CostRedLevelPeriodYearFunction
extends MapFunction {
    private static final long serialVersionUID = 4078799106560892878L;
    private RowMeta srcMeta;

    public CostRedLevelPeriodYearFunction(RowMeta rowMeta) {
        this.srcMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public RowX map(RowX row) {
        BigDecimal sumUnitAmt;
        BigDecimal sumPerQty;
        BigDecimal sumPrice;
        Integer level = row.getInteger(this.getSourceRowMeta().getFieldIndex("level"));
        BigDecimal sumQty = row.getBigDecimal(this.srcMeta.getFieldIndex("qty"));
        BigDecimal sumAmt = row.getBigDecimal(this.srcMeta.getFieldIndex("amount"));
        BigDecimal headQty = row.getBigDecimal(this.srcMeta.getFieldIndex("headqty"));
        boolean isSumQtyZero = this.isNullOrZero(sumQty);
        boolean isHeadQtyZero = this.isNullOrZero(headQty);
        BigDecimal bigDecimal = sumPrice = isSumQtyZero ? BigDecimal.ZERO : sumAmt.divide(sumQty, 10, 4);
        if (level == 0) {
            sumPerQty = BigDecimal.ONE;
            sumUnitAmt = sumPrice;
        } else {
            sumPerQty = isHeadQtyZero ? BigDecimal.ZERO : (sumQty == null ? BigDecimal.ZERO : sumQty.divide(headQty, 10, 4));
            sumUnitAmt = isHeadQtyZero ? BigDecimal.ZERO : sumAmt.divide(headQty, 10, 4);
        }
        row.set(this.srcMeta.getFieldIndex("sumperqty"), (Object)sumPerQty);
        row.set(this.srcMeta.getFieldIndex("sumqty"), (Object)sumQty);
        row.set(this.srcMeta.getFieldIndex("sumamt"), (Object)sumAmt);
        row.set(this.srcMeta.getFieldIndex("sumprice"), (Object)sumPrice);
        row.set(this.srcMeta.getFieldIndex("sumunitamt"), (Object)sumUnitAmt);
        return row;
    }

    private boolean isNullOrZero(BigDecimal value) {
        return value == null || value.compareTo(BigDecimal.ZERO) == 0;
    }
}

