/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.cost;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;

public class CostReductionLevelFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 2232400386910032900L;

    public RowMeta getResultRowMeta() {
        return this.getSourceRowMeta();
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<RowX> targetRows = new ArrayList<RowX>();
        BigDecimal headQty = BigDecimal.ZERO;
        BigDecimal headTotalAmt = BigDecimal.ZERO;
        BigDecimal headTransinQty = BigDecimal.ZERO;
        BigDecimal headTransinAmt = BigDecimal.ZERO;
        BigDecimal headPurQty = BigDecimal.ZERO;
        BigDecimal headPurAmt = BigDecimal.ZERO;
        Long material = 0L;
        boolean isZeroLevel = false;
        for (RowX row : iterable) {
            BigDecimal purUnitAmt;
            BigDecimal transinUnitAmt;
            BigDecimal curUnitAmt;
            BigDecimal purPerQty;
            BigDecimal transinPerQty;
            BigDecimal perQty;
            BigDecimal purPrice;
            Integer level = row.getInteger(this.getSourceRowMeta().getFieldIndex("level"));
            material = row.getLong(this.getSourceRowMeta().getFieldIndex("material"));
            BigDecimal curAmt = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("amount"));
            BigDecimal curQty = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("qty"));
            BigDecimal transinQty = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("transinqty"));
            BigDecimal transinAmount = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("transinamount"));
            BigDecimal purQty = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("purqty"));
            BigDecimal purAmount = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("puramount"));
            headQty = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("headqty"));
            headTotalAmt = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("headtotalamt"));
            headTransinQty = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("headtransinqty"));
            headTransinAmt = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("headtransinamt"));
            headPurQty = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("headpurqty"));
            headPurAmt = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("headpuramt"));
            boolean isCurQtyZero = this.isNullOrZero(curQty);
            boolean isTransinQtyZero = this.isNullOrZero(transinQty);
            boolean isPurQtyZero = this.isNullOrZero(purQty);
            boolean isHeadQtyZero = this.isNullOrZero(headQty);
            boolean isHeadTransinQtyZero = this.isNullOrZero(headTransinQty);
            boolean isHeadPurQtyZero = this.isNullOrZero(headPurQty);
            BigDecimal curPrice = isCurQtyZero ? BigDecimal.ZERO : curAmt.divide(curQty, 10, 4);
            BigDecimal transinPrice = isTransinQtyZero ? BigDecimal.ZERO : transinAmount.divide(transinQty, 10, 4);
            BigDecimal bigDecimal = purPrice = isPurQtyZero ? BigDecimal.ZERO : purAmount.divide(purQty, 10, 4);
            if (level == 0) {
                isZeroLevel = true;
                perQty = isHeadQtyZero && this.isNullOrZero(headTotalAmt) ? BigDecimal.ZERO : BigDecimal.ONE;
                transinPerQty = isHeadTransinQtyZero && this.isNullOrZero(headTransinAmt) ? BigDecimal.ZERO : BigDecimal.ONE;
                purPerQty = isHeadPurQtyZero && this.isNullOrZero(headPurAmt) ? BigDecimal.ZERO : BigDecimal.ONE;
                curUnitAmt = curPrice;
                transinUnitAmt = transinPrice;
                purUnitAmt = purPrice;
                row.set(this.getSourceRowMeta().getFieldIndex("elementname"), (Object)ResManager.loadKDString((String)"\u7269\u6599", (String)"CostReductionLevelFunction_0", (String)"macc-sca-report", (Object[])new Object[0]));
                row.set(this.getSourceRowMeta().getFieldIndex("subelementname"), (Object)ResManager.loadKDString((String)"\u4ea7\u54c1\u7ea7", (String)"CostReductionLevelFunction_1", (String)"macc-sca-report", (Object[])new Object[0]));
            } else {
                perQty = isHeadQtyZero ? BigDecimal.ZERO : curQty.divide(headQty, 10, 4);
                transinPerQty = isHeadTransinQtyZero ? BigDecimal.ZERO : transinQty.divide(headTransinQty, 10, 4);
                purPerQty = isHeadPurQtyZero ? BigDecimal.ZERO : purQty.divide(headPurQty, 10, 4);
                curUnitAmt = isHeadQtyZero ? BigDecimal.ZERO : curAmt.divide(headQty, 10, 4);
                transinUnitAmt = isHeadTransinQtyZero ? BigDecimal.ZERO : transinAmount.divide(headTransinQty, 10, 4);
                purUnitAmt = isHeadPurQtyZero ? BigDecimal.ZERO : purAmount.divide(headPurQty, 10, 4);
            }
            row.set(this.getSourceRowMeta().getFieldIndex("perqty"), (Object)perQty);
            row.set(this.getSourceRowMeta().getFieldIndex("curprice"), (Object)curPrice);
            row.set(this.getSourceRowMeta().getFieldIndex("curunitamt"), (Object)curUnitAmt);
            row.set(this.getSourceRowMeta().getFieldIndex("transinperqty"), (Object)transinPerQty);
            row.set(this.getSourceRowMeta().getFieldIndex("transinprice"), (Object)transinPrice);
            row.set(this.getSourceRowMeta().getFieldIndex("transinunitamt"), (Object)transinUnitAmt);
            row.set(this.getSourceRowMeta().getFieldIndex("purperqty"), (Object)purPerQty);
            row.set(this.getSourceRowMeta().getFieldIndex("purprice"), (Object)purPrice);
            row.set(this.getSourceRowMeta().getFieldIndex("purunitamt"), (Object)purUnitAmt);
            targetRows.add(row);
        }
        if (!isZeroLevel && targetRows.size() > 0) {
            RowX zeroRow = new RowX(this.getSourceRowMeta().getFieldCount());
            for (int i = 0; i < this.getSourceRowMeta().getFieldCount(); ++i) {
                zeroRow.set(i, ((RowX)targetRows.get(0)).get(i));
            }
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("level"), (Object)"0");
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("submaterial"), (Object)material);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("perqty"), (Object)(this.isNullOrZero(headQty) && this.isNullOrZero(headTotalAmt) ? BigDecimal.ZERO : BigDecimal.ONE));
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("qty"), (Object)headQty);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("amount"), (Object)headTotalAmt);
            BigDecimal curPrice = this.isNullOrZero(headQty) ? BigDecimal.ZERO : headTotalAmt.divide(headQty, 10, 4);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("curprice"), (Object)curPrice);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("curunitamt"), (Object)curPrice);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("transinperqty"), (Object)(this.isNullOrZero(headTransinQty) && this.isNullOrZero(headTransinAmt) ? BigDecimal.ZERO : BigDecimal.ONE));
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("transinqty"), (Object)headTransinQty);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("transinamount"), (Object)headTransinAmt);
            BigDecimal transinPrice = this.isNullOrZero(headTransinQty) ? BigDecimal.ZERO : headTransinAmt.divide(headTransinQty, 10, 4);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("transinprice"), (Object)transinPrice);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("transinunitamt"), (Object)transinPrice);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("purperqty"), (Object)(this.isNullOrZero(headPurQty) && this.isNullOrZero(headPurAmt) ? BigDecimal.ZERO : BigDecimal.ONE));
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("purqty"), (Object)headPurQty);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("puramount"), (Object)headPurAmt);
            BigDecimal purPrice = this.isNullOrZero(headPurQty) ? BigDecimal.ZERO : headPurAmt.divide(headPurQty, 10, 4);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("purprice"), (Object)purPrice);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("purunitamt"), (Object)purPrice);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("elementname"), (Object)ResManager.loadKDString((String)"\u7269\u6599", (String)"CostReductionLevelFunction_0", (String)"macc-sca-report", (Object[])new Object[0]));
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("subelementname"), (Object)ResManager.loadKDString((String)"\u4ea7\u54c1\u7ea7", (String)"CostReductionLevelFunction_1", (String)"macc-sca-report", (Object[])new Object[0]));
            targetRows.add(zeroRow);
        }
        for (RowX rowX : targetRows) {
            collector.collect(rowX);
        }
    }

    private boolean isNullOrZero(BigDecimal value) {
        return value == null || value.compareTo(BigDecimal.ZERO) == 0;
    }
}

