/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.cost;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.report.cost.CostRedLevelParam;
import kd.macc.sca.report.cost.DiySumRow;
import kd.macc.sca.report.cost.DiyTotalRow;
import kd.macc.sca.report.cost.HandleFinalRow;

public class CostReductionLevelRptSource
implements IReportDataHandle {
    private static final String[] COMPLETE_GROUP_FIELDS = new String[]{"amount", "qty", "perqty", "curunitamt", "curprice"};
    private static final String[] TRANS_GROUP_FIELDS = new String[]{"transinamount", "transinqty", "transinperqty", "transinunitamt", "transinprice"};
    private static final String[] PUR_GROUP_FIELDS = new String[]{"puramount", "purqty", "purperqty", "purunitamt", "purprice"};
    private static final String[] SUM_GROUP_FIELDS = new String[]{"sumperqty", "sumqty", "sumprice", "sumunitamt", "sumamt"};
    private static final String[] HIDE_FIELDS = new String[]{"materialver", "element", "headtransinqty", "headtransinamt", "headpurqty", "headpuramt", "subelement", "currency", "periodyear", "headqty", "headtotalamt"};
    private static final String[] ORDER_FIELDS = new String[]{"material", "productname", "productmodelnum", "baseunit", "auxprop", "level", "element", "elementname", "subelement", "subelementname", "entrymaterialtype", "submaterial", "submaterialname", "submaterialauxprop", "subbaseunit"};
    private CostRedLevelParam costRedLevelParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.costRedLevelParam = (CostRedLevelParam)ctx.getParam(CostRedLevelParam.class.getName());
        ctx.setShowBlockEntity(false);
        this.costRedLevelParam.setShowKeyCols(ctx.getShowKeyCols());
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
        this.configKeyCols(ctx);
    }

    private void configKeyCols(ReportDataCtx ctx) {
        Set showKeyCols = ctx.getShowKeyCols();
        ctx.setShowKeyCols(showKeyCols);
        ctx.setShowBlockEntity(false);
        ctx.isShowTotalQty();
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        for (SrcBlockConf blockConf : blockCollector) {
            QFilter dataFs = blockConf.getDataFs();
            String disPlayLevel = this.costRedLevelParam.getDisPlayLevel();
            QFilter qFilter = new QFilter("entryentity.level", "<=", (Object)Integer.parseInt(disPlayLevel));
            List<Long> materialIds = this.costRedLevelParam.getMaterialIds();
            if (!CadEmptyUtils.isEmpty(materialIds)) {
                qFilter.and(new QFilter("entryentity.submaterial", "in", materialIds));
            } else {
                DynamicObjectCollection materialType = this.costRedLevelParam.getMaterialType();
                DynamicObject materialGrpStd = this.costRedLevelParam.getMaterialGroupStd();
                if (materialType != null || materialGrpStd != null && materialGrpStd.getLong("id") != 730148448254487552L) {
                    Set allMaterialIds = MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)materialType, (boolean)false, (DynamicObject)materialGrpStd, (boolean)true);
                    qFilter.and(InFilterHelper.getQFilterByBachSize((String)"entryentity.submaterial", new ArrayList(allMaterialIds), (String)"in", (int)20000));
                }
            }
            if (dataFs == null) continue;
            dataFs.and(qFilter);
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new HandleFinalRow(this.costRedLevelParam));
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new DiySumRow());
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new DiyTotalRow(this.costRedLevelParam));
    }

    private List<QFilter> getFixedFilter() {
        List<Long> productIds;
        List<Long> storageOrgIds;
        List<Long> manuOrgIds;
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>();
        List<Long> orgIds = this.costRedLevelParam.getOrgIds();
        commonFilters.add(new QFilter("org", "in", orgIds));
        List<Long> costAccountIds = this.costRedLevelParam.getCostAccountIds();
        commonFilters.add(new QFilter("costaccount", "in", costAccountIds));
        List<DynamicObject> periods = this.costRedLevelParam.getPeriods();
        HashSet allPeriodIds = new HashSet(16);
        for (DynamicObject period : periods) {
            QFilter qfPeriod = new QFilter("id", "<=", (Object)period.getLong("id"));
            qfPeriod.and("periodyear", "=", (Object)period.getInt("periodyear"));
            List periodKeys = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])qfPeriod.toArray(), null, (int)-1);
            periodKeys.forEach(s -> allPeriodIds.add((Long)s));
        }
        if (!CadEmptyUtils.isEmpty(allPeriodIds)) {
            QFilter qfAllPeriod = new QFilter("period", "in", allPeriodIds);
            commonFilters.add(qfAllPeriod);
        }
        if (!CadEmptyUtils.isEmpty(manuOrgIds = this.costRedLevelParam.getManuOrgIds())) {
            commonFilters.add(manuOrgIds.size() == 1 ? new QFilter("manuorg", "=", (Object)manuOrgIds.get(0)) : new QFilter("manuorg", "in", manuOrgIds));
        }
        if (!CadEmptyUtils.isEmpty(storageOrgIds = this.costRedLevelParam.getStorageOrgIds())) {
            commonFilters.add(storageOrgIds.size() == 1 ? new QFilter("storageorgunit", "=", (Object)storageOrgIds.get(0)) : new QFilter("storageorgunit", "in", storageOrgIds));
        }
        if (!CadEmptyUtils.isEmpty(productIds = this.costRedLevelParam.getProductIds())) {
            commonFilters.add(new QFilter("material", "in", productIds));
        }
        return commonFilters;
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        Iterator<AbstractReportColumn> iterator = this.getOrderColumns(cols).iterator();
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u5b8c\u5de5\u6210\u672c", (String)"CostReductionLevelRptSource_0", (String)"macc-sca-report", (Object[])new Object[0])));
        groupCol.setFieldKey("completeGroupContent");
        ReportColumnGroup transGroupCol = new ReportColumnGroup();
        transGroupCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u8c03\u5165\u6210\u672c", (String)"CostReductionLevelRptSource_1", (String)"macc-sca-report", (Object[])new Object[0])));
        transGroupCol.setFieldKey("transGroupContent");
        ReportColumnGroup purGroupCol = new ReportColumnGroup();
        purGroupCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u91c7\u8d2d\u6210\u672c", (String)"CostReductionLevelRptSource_2", (String)"macc-sca-report", (Object[])new Object[0])));
        purGroupCol.setFieldKey("purGroupContent");
        ReportColumnGroup sumGroupCol = new ReportColumnGroup();
        sumGroupCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u6210\u672c", (String)"CostReductionLevelRptSource_3", (String)"macc-sca-report", (Object[])new Object[0])));
        sumGroupCol.setFieldKey("sumGroupContent");
        List<String> hideFields = Arrays.asList(HIDE_FIELDS);
        while (iterator.hasNext()) {
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            if ("level".equals(fieldKey)) {
                repCol.setZeroShow(true);
            } else {
                repCol.setZeroShow(false);
            }
            if (hideFields.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (Arrays.asList(COMPLETE_GROUP_FIELDS).contains(fieldKey)) {
                groupCol.getChildren().add(repCol);
                iterator.remove();
            }
            if (Arrays.asList(TRANS_GROUP_FIELDS).contains(fieldKey)) {
                transGroupCol.getChildren().add(repCol);
                iterator.remove();
            }
            if (Arrays.asList(PUR_GROUP_FIELDS).contains(fieldKey)) {
                purGroupCol.getChildren().add(repCol);
                iterator.remove();
            }
            if (!Arrays.asList(SUM_GROUP_FIELDS).contains(fieldKey)) continue;
            sumGroupCol.getChildren().add(repCol);
            iterator.remove();
        }
        cols.add((AbstractReportColumn)groupCol);
        if (this.costRedLevelParam.isViewTransinCost()) {
            cols.add((AbstractReportColumn)transGroupCol);
        }
        if (this.costRedLevelParam.isViewPurCost()) {
            cols.add((AbstractReportColumn)purGroupCol);
        }
        cols.add((AbstractReportColumn)sumGroupCol);
        return cols;
    }

    private List<AbstractReportColumn> getOrderColumns(List<AbstractReportColumn> cols) {
        HashMap<String, AbstractReportColumn> reportColumns = new HashMap<String, AbstractReportColumn>(cols.size());
        for (AbstractReportColumn column : cols) {
            ReportColumn repCol = (ReportColumn)column;
            reportColumns.put(repCol.getFieldKey(), column);
        }
        List<AbstractReportColumn> orderColumns = cols;
        for (String fieldKey : ORDER_FIELDS) {
            this.dealOrderColumn(reportColumns, orderColumns, fieldKey);
        }
        return orderColumns;
    }

    private void dealOrderColumn(Map<String, AbstractReportColumn> reportColumns, List<AbstractReportColumn> orderColumns, String fieldKey) {
        for (Map.Entry<String, AbstractReportColumn> entry : reportColumns.entrySet()) {
            if (!entry.getKey().equals(fieldKey)) continue;
            orderColumns.remove(entry.getValue());
            orderColumns.add(entry.getValue());
        }
    }
}

