/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.cost;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.sca.report.cost.AddTotalRowFunction;
import kd.macc.sca.report.cost.CostRedLevelParam;
import kd.macc.sca.report.cost.MaterialTypeFunction;

public class DiyTotalRow
implements IDataTransform {
    private CostRedLevelParam costRedLevelParam;

    public DiyTotalRow(CostRedLevelParam costRedLevelParam) {
        this.costRedLevelParam = costRedLevelParam;
    }

    public DataSet doTransform(DataSet srcData) {
        if (srcData.isEmpty()) {
            DataSet emptyDs = Algo.create((String)"dataset").createDataSet(new ArrayList(10).iterator(), srcData.getRowMeta());
            return emptyDs;
        }
        srcData = this.dealMaterialGroup(srcData);
        srcData = srcData.addField("0", "isTop").orderBy(new String[]{"period ASC", "level ASC"});
        DataSet diySumDs = srcData.filter(ResManager.loadKDString((String)"level = '\u5c0f\u8ba1'", (String)"DiyTotalRow_0", (String)"macc-sca-report", (Object[])new Object[0]));
        srcData = this.excludeZeroRows(srcData.filter(ResManager.loadKDString((String)"level != '\u5c0f\u8ba1'", (String)"DiyTotalRow_1", (String)"macc-sca-report", (Object[])new Object[0])));
        if (this.costRedLevelParam.isOnlyMaterialType()) {
            srcData = srcData.groupBy(new String[]{"period", "material", "entrymaterialtype"}).reduceGroup((ReduceGroupFunction)new MaterialTypeFunction(srcData.getRowMeta()));
        }
        DataSet totalRow = diySumDs.reduceGroup((ReduceGroupFunction)new AddTotalRowFunction(srcData.getRowMeta()));
        totalRow = DiyTotalRow.union(totalRow, diySumDs);
        srcData = DiyTotalRow.union(srcData, totalRow);
        if (this.costRedLevelParam.isOnlySumRow()) {
            srcData = srcData.filter(ResManager.loadKDString((String)"level = '\u5c0f\u8ba1' or level = '\u603b\u8ba1'", (String)"DiyTotalRow_2", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        srcData = this.costRedLevelParam.isTopSumRow() ? srcData.orderBy(new String[]{"isTop DESC", "period ASC", "level ASC", "material DESC"}) : srcData.orderBy(new String[]{"isTop ASC", "period ASC", "level ASC", "material DESC"});
        return srcData;
    }

    public static DataSet union(DataSet dataSet1, DataSet dataSet2) {
        dataSet2 = dataSet2.select(dataSet1.getRowMeta().getFieldNames());
        dataSet1 = dataSet1.union(dataSet2);
        return dataSet1;
    }

    private DataSet excludeZeroRows(DataSet srcData) {
        StringBuilder sb = new StringBuilder();
        sb.append("!(");
        sb.append("qty==0 and amount==0 and sumqty==0 and sumprice==0 ");
        if (this.costRedLevelParam.isViewTransinCost()) {
            sb.append("and transinqty==0 and transinamount==0 ");
        }
        if (this.costRedLevelParam.isViewPurCost()) {
            sb.append("and purqty==0 and puramount==0 ");
        }
        sb.append(")");
        return srcData.filter(sb.toString());
    }

    private DataSet dealMaterialGroup(DataSet resultDs) {
        DynamicObject materialGrpStd = this.costRedLevelParam.getMaterialGroupStd();
        if (!resultDs.isEmpty() && materialGrpStd != null && materialGrpStd.getLong("id") != 730148448254487552L) {
            DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet(null, (boolean)false, (DynamicObject)materialGrpStd);
            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultDs.getRowMeta().getFieldNames()));
            fieldNames.remove("entrymaterialtype");
            fieldNames.add("case when materialgroupname is null then entrymaterialtype else materialgroupname end as entrymaterialtype");
            return resultDs.leftJoin(materialDataSet).on("material", "material").select(resultDs.getRowMeta().getFieldNames(), new String[]{"materialgroupname"}).finish().select(fieldNames.toArray(new String[0]));
        }
        return resultDs;
    }
}

