/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.cost;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.sca.report.cost.CostRedLevelParam;
import kd.macc.sca.report.cost.CostRedLevelPeriodYearFunction;
import kd.macc.sca.report.cost.CostReductionLevelFunction;

public class HandleFinalRow
implements IDataXTransform {
    private static final String selectFields = "period,periodyear,material,productname,productmodelnum,headtransinqty,headtransinamt,headpurqty,headpuramt,transinamount,transinqty,transinperqty,transinunitamt,transinprice,puramount,purqty,purperqty,purunitamt,purprice,headtotalamt,baseunit,materialver,currency,level,element,elementname,subelementname,subelement,entrymaterialtype,submaterial,submaterialname,subbaseunit,headqty,perqty,qty,curprice,curunitamt,amount";
    private CostRedLevelParam costRedLevelParam;

    public HandleFinalRow(CostRedLevelParam costRedLevelParam) {
        this.costRedLevelParam = costRedLevelParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = srcData.groupBy(new String[]{"period", "material", "materialver"}).reduceGroup((GroupReduceFunction)new CostReductionLevelFunction());
        DataSetX allPeriodData = null;
        List<String> selectFieldsList = Arrays.asList(selectFields.split(","));
        StringBuilder mainSelectFields = new StringBuilder();
        mainSelectFields.append(selectFields);
        Set<String> showKeyCols = this.costRedLevelParam.getShowKeyCols();
        for (String keyCol : showKeyCols) {
            if (selectFieldsList.contains(keyCol)) continue;
            mainSelectFields.append(",").append(keyCol);
        }
        String[] selectFieldsArr = mainSelectFields.toString().split(",");
        List<DynamicObject> periods = this.costRedLevelParam.getPeriods();
        for (DynamicObject period : periods) {
            DataSetX selectPeriodData = srcData.filter("period = " + period.getLong("id"));
            DataSetX yearData = srcData.filter("period <= " + period.getLong("id") + " and periodyear = " + period.getInt("periodyear")).addFields(new Field[]{new Field("currentperiod", (DataType)DataType.LongType)}, new Object[]{period.getLong("id")});
            yearData = yearData.groupBy(new String[]{"material", "materialver", "currency", "level", "baseunit", "element", "subelement", "entrymaterialtype", "submaterial", "currentperiod"}).sum("headqty").sum("perqty").sum("qty").sum("amount").sum("sumperqty").sum("sumqty").sum("sumprice").sum("sumunitamt").sum("sumamt");
            yearData = yearData.map((MapFunction)new CostRedLevelPeriodYearFunction(yearData.getRowMeta()));
            selectPeriodData = selectPeriodData.leftJoin(yearData).on("period", "currentperiod").on("material", "material").on("materialver", "materialver").on("currency", "currency").on("level", "level").on("element", "element").on("subelement", "subelement").on("entrymaterialtype", "entrymaterialtype").on("submaterial", "submaterial").select(selectFieldsArr, new String[]{"sumperqty", "sumqty", "sumprice", "sumunitamt", "sumamt"});
            selectPeriodData = selectPeriodData.map(new MapFunction(){

                public RowX map(RowX rowX) {
                    return rowX;
                }

                public RowMeta getResultRowMeta() {
                    return this.sourceRowMeta;
                }
            });
            if (allPeriodData == null) {
                allPeriodData = selectPeriodData;
                continue;
            }
            allPeriodData = HandleFinalRow.union(allPeriodData, selectPeriodData);
        }
        return allPeriodData;
    }

    private static DataSetX union(DataSetX dataSet1, DataSetX dataSet2) {
        dataSet2 = dataSet2.select(dataSet1.getRowMeta().getFieldNames());
        dataSet1 = dataSet1.union(dataSet2);
        return dataSet1;
    }
}

