/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.costrecovry.item;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.sca.report.costrecovry.item.CostReductionItemParam;

public class CostReductionItemPeriodYearFunction
extends MapFunction {
    private static final long serialVersionUID = 4078799106560892878L;
    private static final Log logger = LogFactory.getLog(CostReductionItemPeriodYearFunction.class);
    private RowMeta srcMeta;
    private CostReductionItemParam args;

    public CostReductionItemPeriodYearFunction(RowMeta rowMeta, CostReductionItemParam args) {
        this.srcMeta = rowMeta;
        this.args = args;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public RowX map(RowX row) {
        BigDecimal sumPrice;
        Integer level = row.getInteger(this.getSourceRowMeta().getFieldIndex("level"));
        BigDecimal sumPerQty = row.getBigDecimal(this.srcMeta.getFieldIndex("perqty"));
        BigDecimal sumQty = row.getBigDecimal(this.srcMeta.getFieldIndex("qty"));
        BigDecimal sumAmt = row.getBigDecimal(this.srcMeta.getFieldIndex("amount"));
        BigDecimal headQty = row.getBigDecimal(this.srcMeta.getFieldIndex("headqty"));
        boolean isSumQtyZero = sumQty.compareTo(BigDecimal.ZERO) == 0;
        boolean isHeadQtyZero = headQty.compareTo(BigDecimal.ZERO) == 0;
        BigDecimal bigDecimal = sumPrice = isSumQtyZero ? BigDecimal.ZERO : sumAmt.divide(sumQty, 10, 4);
        BigDecimal sumUnitAmt = level == 0 ? sumPrice : (isHeadQtyZero ? BigDecimal.ZERO : sumAmt.divide(headQty, 10, 4));
        row.set(this.srcMeta.getFieldIndex("sumperqty"), (Object)sumPerQty);
        row.set(this.srcMeta.getFieldIndex("sumqty"), (Object)sumQty);
        row.set(this.srcMeta.getFieldIndex("sumamt"), (Object)sumAmt);
        row.set(this.srcMeta.getFieldIndex("sumprice"), (Object)sumPrice);
        row.set(this.srcMeta.getFieldIndex("sumunitamt"), (Object)sumUnitAmt);
        return row;
    }
}

