/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.costrecovry.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.report.costrecovry.item.CostReductionItemParam;
import kd.macc.sca.report.costrecovry.item.DiySumRow;
import kd.macc.sca.report.costrecovry.item.DiyTotalRow;
import kd.macc.sca.report.costrecovry.item.HandleFinalRow;

public class CostReductionItemSourcePlugin
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(CostReductionItemSourcePlugin.class);
    private static final String[] COMPLETE_GROUP_FIELDS = new String[]{"amount", "qty", "perqty", "curunitamt", "curprice"};
    private static final String[] SUM_GROUP_FIELDS = new String[]{"sumperqty", "sumqty", "sumprice", "sumunitamt", "sumamt"};
    private static final String[] DELETE_FIELDS = new String[]{"materialver", "currency", "element", "subelement", "headqty", "headtotalamt", "level"};
    private static final String[] ORDER_FIELDS = new String[]{"material_ref_name", "material_ref_modelnum", "material_ref_baseunit.name", "auxprop", "elementname", "subelementname", "submaterial_ref_group.number", "submaterial_ref_group.name", "submaterial", "submaterial_ref_name", "submaterial_ref_baseunit.name", "submaterialauxprop"};
    private LocaleString localeCurComCost = new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u5b8c\u5de5\u6210\u672c", (String)"CostReductionItemSourcePlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
    private LocaleString localeCurYearComCost = new LocaleString(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u6210\u672c", (String)"CostReductionItemSourcePlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
    private LocaleString localeProductName = new LocaleString(ResManager.loadKDString((String)"\u4ea7\u54c1\u540d\u79f0", (String)"CostReductionItemSourcePlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
    private LocaleString localeMaterialName = new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"CostReductionItemSourcePlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
    private LocaleString localeMaterialGroupNumber = new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u7f16\u7801", (String)"CostReductionItemSourcePlugin_4", (String)"macc-sca-report", (Object[])new Object[0]));
    private LocaleString localeMaterialGroupName = new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u540d\u79f0", (String)"CostReductionItemSourcePlugin_5", (String)"macc-sca-report", (Object[])new Object[0]));
    private LocaleString localeBaseUnit = new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"CostReductionItemSourcePlugin_6", (String)"macc-sca-report", (Object[])new Object[0]));
    private LocaleString localeModelNum = new LocaleString(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"CostReductionItemSourcePlugin_7", (String)"macc-sca-report", (Object[])new Object[0]));
    private CostReductionItemParam costReductionItemParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.costReductionItemParam = (CostReductionItemParam)ctx.getParam(CostReductionItemParam.class.getName());
        ctx.setShowBlockEntity(false);
        this.costReductionItemParam.setShowKeyCols(ctx.getShowKeyCols());
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
        this.configKeyCols(ctx);
    }

    private void configKeyCols(ReportDataCtx ctx) {
        Set showKeyCols = ctx.getShowKeyCols();
        ctx.setShowKeyCols(showKeyCols);
        ctx.setShowBlockEntity(false);
        ctx.isShowTotalQty();
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        this.logger.info("\u4fee\u6539\u56fa\u5b9a\u6570\u636e\u5757");
        for (SrcBlockConf blockConf : blockCollector) {
            String srcEntity = blockConf.getSrcEntity();
            QFilter dataFs = blockConf.getDataFs();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u6765\u6e90\u5b9e\u4f53\u6807\u8bc6:{},\u7528\u6237\u914d\u7f6e\u8fc7\u6ee4\u6761\u4ef6:{}", (Object)srcEntity, (Object)dataFs);
            }
            if (dataFs == null || dataFs.getValue() == null) {
                return;
            }
            if (!CadEmptyUtils.isEmpty(this.costReductionItemParam.getMulMaterialIds())) {
                dataFs.and("entryentity.submaterial", "in", this.costReductionItemParam.getMulMaterialIds());
                continue;
            }
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)this.costReductionItemParam.getMulMaterialTypes()) && (this.costReductionItemParam.getMaterialGrpStd() == null || this.costReductionItemParam.getMaterialGrpStd().getLong("id") == 730148448254487552L)) continue;
            Set materialIds = MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)this.costReductionItemParam.getMulMaterialTypes(), (boolean)false, (DynamicObject)this.costReductionItemParam.getMaterialGrpStd(), (boolean)false);
            dataFs.and("entryentity.submaterial", "in", (Object)materialIds);
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("transFormAfterUnion\u591a\u4e2a\u6570\u636e\u5757union\u5b8c\u6210\u540e\u6267\u884c\uff0c\u53ef\u5728\u6b64\u6dfb\u52a0\u81ea\u5df1\u5b9e\u73b0\u7684IDataXTransform\u5904\u7406\u6570\u636e");
        ctx.logInfo((Object)ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u5757\u6570\u636e", (String)"CostReductionItemSourcePlugin_8", (String)"macc-sca-report", (Object[])new Object[0]));
        transCollector.add(new HandleFinalRow(this.costReductionItemParam, ctx));
    }

    private List<QFilter> getFixedFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!CadEmptyUtils.isEmpty(this.costReductionItemParam.getOrgIds())) {
            filters.add(new QFilter("org", "in", this.costReductionItemParam.getOrgIds()));
        }
        if (!CadEmptyUtils.isEmpty(this.costReductionItemParam.getCostAccountIds())) {
            filters.add(new QFilter("costaccount", "in", this.costReductionItemParam.getCostAccountIds()));
        }
        if (!CadEmptyUtils.isEmpty(this.costReductionItemParam.getPrdOrgIds())) {
            filters.add(new QFilter("manuorg", "in", this.costReductionItemParam.getPrdOrgIds()));
        }
        if (!CadEmptyUtils.isEmpty(this.costReductionItemParam.getStorageOrgUnitIds())) {
            filters.add(new QFilter("storageorgunit", "in", this.costReductionItemParam.getStorageOrgUnitIds()));
        }
        if (!CadEmptyUtils.isEmpty(this.costReductionItemParam.getMulProductIds())) {
            filters.add(new QFilter("material", "in", this.costReductionItemParam.getMulProductIds()));
        }
        return filters;
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("group\u5b8c\u6210\u540e\u6267\u884c\u6570\u636e\u8f6c\u6362");
    }

    public void beforeAddSumRow(ReportDataCtx ctx) {
        this.logger.info("\u5728\u6dfb\u52a0\u6c47\u603b\u884c\u524d\u8bbe\u7f6e\u6c47\u603b\u65b9\u6848\uff0c\u6216\u8005\u5176\u4ed6\u4e0a\u4e0b\u6587\u8bbe\u7f6e");
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u6dfb\u52a0\u5b8c\u6c47\u603b\u884c\u540e\u6267\u884c\u7684\u6570\u636e\u8f6c\u6362");
        transCollector.add(new DiySumRow(this.costReductionItemParam));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u751f\u6210\u6700\u7ec8\u7684\u6570\u636e\u5305\u540e\uff0c\u6267\u884c\u7684\u6570\u636e\u8f6c\u6362");
        transCollector.add(new DiyTotalRow(this.costReductionItemParam));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u914d\u7f6e\u5217\u662f\u5426\u663e\u793a");
        Iterator<AbstractReportColumn> iterator = this.getOrderColumns(cols).iterator();
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(this.localeCurComCost);
        groupCol.setFieldKey("completeGroupContent");
        ReportColumnGroup sumGroupCol = new ReportColumnGroup();
        sumGroupCol.setCaption(this.localeCurYearComCost);
        sumGroupCol.setFieldKey("sumGroupContent");
        while (iterator.hasNext()) {
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            if (fieldKey.equals("material_ref_name")) {
                repCol.setCaption(this.localeProductName);
            } else if (fieldKey.equals("submaterial_ref_name")) {
                repCol.setCaption(this.localeMaterialName);
            } else if (fieldKey.contains("submaterial_ref_group.number")) {
                repCol.setCaption(this.localeMaterialGroupNumber);
            } else if (fieldKey.contains("submaterial_ref_group.name")) {
                repCol.setCaption(this.localeMaterialGroupName);
            } else if (fieldKey.contains("baseunit.name")) {
                repCol.setCaption(this.localeBaseUnit);
            } else if (fieldKey.contains("modelnum")) {
                repCol.setCaption(this.localeModelNum);
            }
            if (fieldKey.equals("curprice")) {
                repCol.setCurrencyField("currency");
            }
            if (fieldKey.equals("subbaseunit")) {
                repCol.setHide(Boolean.TRUE.booleanValue());
            }
            if (Arrays.asList(DELETE_FIELDS).contains(fieldKey)) {
                iterator.remove();
            }
            if (Arrays.asList(COMPLETE_GROUP_FIELDS).contains(fieldKey)) {
                groupCol.getChildren().add(repCol);
                iterator.remove();
            }
            if (!Arrays.asList(SUM_GROUP_FIELDS).contains(fieldKey)) continue;
            sumGroupCol.getChildren().add(repCol);
            iterator.remove();
        }
        cols.add((AbstractReportColumn)groupCol);
        cols.add((AbstractReportColumn)sumGroupCol);
        return cols;
    }

    private List<AbstractReportColumn> getOrderColumns(List<AbstractReportColumn> cols) {
        HashMap<String, AbstractReportColumn> reportColumns = new HashMap<String, AbstractReportColumn>(cols.size());
        for (AbstractReportColumn column : cols) {
            ReportColumn repCol = (ReportColumn)column;
            reportColumns.put(repCol.getFieldKey(), column);
        }
        List<AbstractReportColumn> orderColumns = cols;
        for (String fieldKey : ORDER_FIELDS) {
            this.dealOrderColumn(reportColumns, orderColumns, fieldKey);
        }
        return orderColumns;
    }

    private void dealOrderColumn(Map<String, AbstractReportColumn> reportColumns, List<AbstractReportColumn> orderColumns, String fieldKey) {
        for (Map.Entry<String, AbstractReportColumn> entry : reportColumns.entrySet()) {
            if (!entry.getKey().equals(fieldKey)) continue;
            orderColumns.remove(entry.getValue());
            orderColumns.add(entry.getValue());
        }
    }
}

