/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.reduction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.report.common.ReportRptHelper;
import kd.macc.sca.report.reduction.CostAnalyzeRptParam;
import kd.macc.sca.report.reduction.CostAnalyzeRptSourceCf;
import kd.macc.sca.report.reduction.CostAnalyzeUnitAmtDealFunction;

public class CostAnalyzeDataGroupHandle
implements IDataXTransform {
    private CostAnalyzeRptParam rptParam = null;
    private ReportDataCtx ctx;

    public CostAnalyzeDataGroupHandle(CostAnalyzeRptParam reportParam, ReportDataCtx ctx) {
        this.rptParam = reportParam;
        this.ctx = ctx;
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = this.dealMaterialGroup(srcData);
        this.dealSubKeyColView();
        srcData = ReportRptHelper.groupDeal(srcData, this.ctx.getShowKeyCols().toArray(new String[0]), 1, this.ctx.getShowQtyCols().toArray(new String[0]));
        srcData = srcData.addFields(new Field[]{new Field("linetype", (DataType)DataType.StringType), new Field("lineorder", (DataType)DataType.StringType)}, new Object[]{"2", "1"});
        srcData = this.dealUnitCost(srcData);
        srcData = this.addTotalRow(srcData);
        srcData = srcData.orderBy(this.getOrderByStr(this.ctx.getShowKeyCols()));
        return srcData;
    }

    private DataSetX addTotalRow(DataSetX srcData) {
        DataSetX zeroDataSetX = srcData.filter("level=0");
        DataSetX detailDataSetX = srcData.filter("level<>0");
        HashSet<String> sumFields = new HashSet<String>(10);
        sumFields.add("stdunitamt");
        sumFields.add("curunitamt");
        sumFields.add("cursumamt");
        if (this.rptParam.isViewpreperiod()) {
            sumFields.add("preunitamt");
            sumFields.add("presumamt");
        }
        if (this.rptParam.isViewpreyear()) {
            sumFields.add("preyearunitamt");
            sumFields.add("preyearsumamt");
        }
        if (this.rptParam.isViewtotal()) {
            if (this.rptParam.isViewpreyear()) {
                sumFields.add("preyearallunitamt");
                sumFields.add("preyearallsumamt");
            }
            sumFields.add("curyearallunitamt");
            sumFields.add("curyearallsumamt");
        }
        DataSetX totalDataSetX = ReportRptHelper.groupDeal(zeroDataSetX, new String[0], 1, sumFields.toArray(new String[0]));
        totalDataSetX = totalDataSetX.addFields(new Field[]{new Field("linetype", (DataType)DataType.StringType), new Field("lineorder", (DataType)DataType.StringType), new Field("level", (DataType)DataType.IntegerType)}, new Object[]{"3", "2", null});
        srcData = zeroDataSetX.union(detailDataSetX);
        srcData = DataSetXHelper.unionIfRowDiffStrDefaultEmpty((DataSetX)srcData, (DataSetX)totalDataSetX);
        return srcData;
    }

    private String[] getOrderByStr(Set<String> groupSumCols) {
        ArrayList<String> fields = new ArrayList<String>(10);
        fields.add("lineorder");
        fields.add("materialnum");
        fields.add("auxprop");
        if (groupSumCols.contains("treepath")) {
            fields.add("treepath");
        } else {
            fields.add("level");
            fields.add("linetype");
        }
        if (groupSumCols.contains("elementnum")) {
            fields.add("elementnum desc");
        }
        if (groupSumCols.contains("subelementnum")) {
            fields.add("subelementnum desc");
        }
        return fields.toArray(new String[0]);
    }

    private DataSetX dealUnitCost(DataSetX srcData) {
        ArrayList<String> qtyFields = new ArrayList<String>(10);
        this.addFields("cur", qtyFields);
        if (this.rptParam.isViewpreperiod()) {
            this.addFields("pre", qtyFields);
        }
        if (this.rptParam.isViewpreyear()) {
            this.addFields("preyear", qtyFields);
        }
        if (this.rptParam.isViewtotal()) {
            if (this.rptParam.isViewpreyear()) {
                this.addFields("preyearall", qtyFields);
            }
            this.addFields("curyearall", qtyFields);
        }
        this.ctx.getShowQtyCols().addAll(qtyFields);
        srcData = DataSetXHelper.addBigDecimalFields((DataSetX)srcData, (String[])qtyFields.toArray(new String[0]));
        srcData = srcData.groupBy(new String[]{"material", "auxprop"}).reduceGroup((GroupReduceFunction)new CostAnalyzeUnitAmtDealFunction(this.rptParam, false));
        return srcData;
    }

    private void addFields(String keyPre, List<String> qtyFields) {
        for (String field : CostAnalyzeRptSourceCf.calcFields) {
            qtyFields.add(keyPre + field);
        }
    }

    private void dealSubKeyColView() {
        if (!this.rptParam.getSubShowKeyCols().contains("element")) {
            this.ctx.getShowKeyCols().removeAll(CostAnalyzeRptSourceCf.elementFields);
        }
        if (!this.rptParam.getSubShowKeyCols().contains("subelement")) {
            this.ctx.getShowKeyCols().removeAll(CostAnalyzeRptSourceCf.subelementFields);
        }
        if (!this.rptParam.getSubShowKeyCols().contains("group")) {
            this.ctx.getShowKeyCols().removeAll(CostAnalyzeRptSourceCf.groupFields);
        }
        if (!this.rptParam.getSubShowKeyCols().contains("submaterial")) {
            this.ctx.getShowKeyCols().removeAll(CostAnalyzeRptSourceCf.materialFields);
        }
        if (!this.rptParam.getSubShowKeyCols().contains("submaterialauxprop")) {
            this.ctx.getShowKeyCols().remove("submaterialauxprop");
        }
    }

    private DataSetX dealMaterialGroup(DataSetX srcData) {
        OrmInput materialDs = null;
        if (this.rptParam.getMaterialgrpstdId() == 730148448254487552L) {
            QFilter matOrgFilter = null;
            matOrgFilter = this.rptParam.isOnlysumrow() ? new QFilter("id", "in", this.rptParam.getProducts()) : BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)this.rptParam.getOrgId());
            materialDs = new OrmInput("materialDs", "bd_material", "id,number submaterialnum,group materialgroup,group.number materialgroupnum,baseunit subbaseunit", matOrgFilter.toArray());
        } else {
            QFilter filter = new QFilter("standard", "=", (Object)this.rptParam.getMaterialgrpstdId());
            if (this.rptParam.isOnlysumrow()) {
                filter.and(new QFilter("material", "in", this.rptParam.getProducts()));
            }
            materialDs = new OrmInput(CostAnalyzeDataGroupHandle.class.getName(), "bd_materialgroupdetail", "group as materialgroup,group.number as materialgroupnum,material id,material.number as submaterialnum,material.baseunit as subbaseunit", filter.toArray());
        }
        DataSetX materialDataSetX = this.ctx.getCurrentJob().fromInput((Input)materialDs);
        this.ctx.getShowKeyCols().add("materialgroup");
        this.ctx.getShowKeyCols().add("materialgroupnum");
        this.ctx.getShowKeyCols().add("submaterialnum");
        if (this.rptParam.getMaterialgrpstdId() == 730148448254487552L) {
            srcData = srcData.leftJoin(materialDataSetX).on("submaterial", "id").select(srcData.getRowMeta().getFieldNames(), new String[]{"materialgroup", "materialgroupnum", "submaterialnum", "subbaseunit"});
        } else {
            DataSetX zeroData = srcData.filter("level=0");
            DataSetX detailData = srcData.filter("level<>0");
            detailData = detailData.join(materialDataSetX).on("submaterial", "id").select(srcData.getRowMeta().getFieldNames(), new String[]{"materialgroup", "materialgroupnum", "submaterialnum", "subbaseunit"});
            zeroData = zeroData.leftJoin(materialDataSetX).on("submaterial", "id").select(srcData.getRowMeta().getFieldNames(), new String[]{"materialgroup", "materialgroupnum", "submaterialnum", "subbaseunit"});
            srcData = zeroData.union(detailData);
        }
        if (this.rptParam.getSubShowKeyCols().contains("submaterial")) {
            srcData = srcData.map(new MapFunction(){
                private static final long serialVersionUID = 1L;

                public RowMeta getResultRowMeta() {
                    return this.sourceRowMeta;
                }

                public RowX map(RowX row) {
                    Long subbaseunit = row.getLong(this.sourceRowMeta.getFieldIndex("subbaseunit"));
                    if (!CadEmptyUtils.isEmpty((Long)subbaseunit)) {
                        row.set(this.sourceRowMeta.getFieldIndex("baseunit"), (Object)subbaseunit);
                    }
                    return row;
                }
            });
        }
        return srcData;
    }
}

