/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.reduction;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.report.reduction.CostAnalyzeRptParam;

public class CostAnalyzeUnitAmtDealFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private CostAnalyzeRptParam rptParam = null;
    private boolean isTotalRow = false;

    public CostAnalyzeUnitAmtDealFunction(CostAnalyzeRptParam rptParam, boolean isTotalRow) {
        this.rptParam = rptParam;
        this.isTotalRow = isTotalRow;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<RowX> targetRows = new ArrayList<RowX>(10);
        BigDecimal curHeadQty = BigDecimal.ZERO;
        BigDecimal preHeadQty = BigDecimal.ZERO;
        BigDecimal preyearHeadQty = BigDecimal.ZERO;
        BigDecimal preyearallHeadQty = BigDecimal.ZERO;
        BigDecimal curyearallHeadQty = BigDecimal.ZERO;
        for (RowX row : iterable) {
            int level = row.getInteger(this.getSourceRowMeta().getFieldIndex("level"));
            if (level == 0) {
                preHeadQty = this.getSumQty("pre", row);
                curHeadQty = this.getSumQty("cur", row);
                preyearHeadQty = this.getSumQty("preyear", row);
                preyearallHeadQty = this.getSumQty("preyearall", row);
                curyearallHeadQty = this.getSumQty("curyearall", row);
            }
            targetRows.add(row);
        }
        for (RowX row : targetRows) {
            Long level = row.getLong(this.getSourceRowMeta().getFieldIndex("level"));
            if (level == 0L) {
                row.set(this.getSourceRowMeta().getFieldIndex("linetype"), (Object)(this.isTotalRow ? "3" : "1"));
            }
            this.calcUnitAmt(row, "pre", preHeadQty);
            this.calcUnitAmt(row, "cur", curHeadQty);
            this.calcUnitAmt(row, "preyear", preyearHeadQty);
            this.calcUnitAmt(row, "preyearall", preyearallHeadQty);
            this.calcUnitAmt(row, "curyearall", curyearallHeadQty);
            collector.collect(row);
        }
    }

    private void calcUnitAmt(RowX row, String keyPre, BigDecimal headQty) {
        int curQtyIndex = this.getSourceRowMeta().getFieldIndex(keyPre + "sumqty", false);
        int curAmtIndex = this.getSourceRowMeta().getFieldIndex(keyPre + "sumamt", false);
        int curPerQtyIndex = this.getSourceRowMeta().getFieldIndex(keyPre + "qty", false);
        int curPriceIndex = this.getSourceRowMeta().getFieldIndex(keyPre + "price", false);
        int curUnitAmtIndex = this.getSourceRowMeta().getFieldIndex(keyPre + "unitamt", false);
        if (curQtyIndex < 0 || curAmtIndex < 0 || curPerQtyIndex < 0 || curPriceIndex < 0 || curUnitAmtIndex < 0) {
            return;
        }
        BigDecimal curQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(curQtyIndex));
        BigDecimal curAmt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(curAmtIndex));
        row.set(curPerQtyIndex, (Object)CostAnalyzeUnitAmtDealFunction.getDevideCal(curQty, headQty, 10));
        row.set(curPriceIndex, (Object)CostAnalyzeUnitAmtDealFunction.getDevideCal(curAmt, curQty, this.rptParam.getPricePrecision()));
        row.set(curUnitAmtIndex, (Object)CostAnalyzeUnitAmtDealFunction.getDevideCal(curAmt, headQty, this.rptParam.getPricePrecision()));
    }

    private static BigDecimal getDevideCal(BigDecimal divider, BigDecimal dividend, int precision) {
        if (dividend.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return divider.divide(dividend, precision, 4);
    }

    private BigDecimal getSumQty(String keyPre, RowX row) {
        int index = this.getSourceRowMeta().getFieldIndex(keyPre + "sumqty", false);
        if (index >= 0) {
            return BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(index));
        }
        return BigDecimal.ZERO;
    }
}

