/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.reduction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.common.helper.MatBaseDataFilterHelper;
import kd.macc.sca.report.common.ReportRptHelper;
import kd.macc.sca.report.reduction.CostReductionRptParam;
import kd.macc.sca.report.reduction.CostReductionRptSourceCf;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class CostReductionLevelFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit costaccount = (MulBasedataEdit)this.getControl("mulcostaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit prdorg = (MulBasedataEdit)this.getControl("mulprdorg");
        prdorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit storageorgunit = (MulBasedataEdit)this.getControl("mulstorageorgunit");
        storageorgunit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit period = (MulBasedataEdit)this.getControl("mulperiod");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulmaterialtype = (MulBasedataEdit)this.getControl("mulmaterialtype");
        mulmaterialtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulmaterial = (MulBasedataEdit)this.getControl("mulmaterial");
        mulmaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulproduct = (MulBasedataEdit)this.getControl("mulproduct");
        mulproduct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        DynamicObjectCollection costAccounts = this.getModel().getDataEntity().getDynamicObjectCollection("mulcostaccount");
        DynamicObjectCollection orgObjs = this.getModel().getDataEntity().getDynamicObjectCollection("mulorg");
        List<Object> orgList = new ArrayList();
        switch (name) {
            case "mulcostaccount": {
                List permOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                qFilters.add(StartCostHelper.getUseEnabledCostAccountIdsFilter((List)permOrgIds, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())));
                break;
            }
            case "mulprdorg": {
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelFormPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                orgList = orgObjs.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                Iterator<Object> iterator = orgList.iterator();
                HashSet prdOrgSet = new HashSet(4);
                while (iterator.hasNext()) {
                    Long orgId = (Long)iterator.next();
                    List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)true);
                    prdOrgSet.addAll(productOrgs);
                }
                qFilters.add(new QFilter("id", "in", prdOrgSet));
                break;
            }
            case "mulstorageorgunit": {
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelFormPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObjectCollection prdorg = this.getModel().getDataEntity().getDynamicObjectCollection("mulprdorg");
                orgList = orgObjs.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                Set pdorgSet = prdorg.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                HashSet stOrgs = new HashSet();
                if (!CadEmptyUtils.isEmpty(pdorgSet)) {
                    for (Long l : pdorgSet) {
                        List stOrglist = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)l, (boolean)true);
                        stOrgs.addAll(stOrglist);
                    }
                } else {
                    for (Long l : orgList) {
                        List stOrglist = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)l, (boolean)true);
                        stOrgs.addAll(stOrglist);
                    }
                }
                qFilters.add(new QFilter("id", "in", stOrgs));
                break;
            }
            case "mulperiod": {
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelFormPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                TreeSet<Long> minSet = new TreeSet<Long>();
                TreeSet<Long> treeSet = new TreeSet<Long>();
                HashSet<Long> periodTypeSet = new HashSet<Long>();
                List<Long> costAccountIds = costAccounts.stream().map(p -> p.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                this.getUsePeriodFilter(costAccountIds, periodTypeSet, minSet, treeSet);
                if (periodTypeSet.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelFormPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter filters = new QFilter("periodtype", "in", periodTypeSet);
                filters.and(new QFilter("id", ">=", (Object)minSet.first()));
                filters.and(new QFilter("id", "<=", (Object)treeSet.last()));
                filters.and(new QFilter("isadjustperiod", "=", (Object)false));
                qFilters.add(filters);
                break;
            }
            case "mulproduct": {
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelFormPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                orgList = orgObjs.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                QFilter matOrgFilter = MatBaseDataFilterHelper.getBaseFilter(orgList);
                qFilters.add(matOrgFilter);
                listShowParameter.setF7ClickByFilter(false);
                break;
            }
            case "materialgrpstd": {
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelFormPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                orgList = orgObjs.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", orgList, Boolean.TRUE});
                qFilters.add(new QFilter("id", "in", (Object)ids));
                break;
            }
            case "mulmaterialtype": {
                DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
                if (materialgrpstd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostReductionLevelFormPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelFormPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                orgList = orgObjs.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgList, materialgrpstd.getPkValue(), false});
                qFilters.add(serviceResponse);
                HashMap<String, List<Object>> params = new HashMap<String, List<Object>>(2);
                params.put("useOrgs", orgList);
                listShowParameter.setCustomParams(params);
                listShowParameter.setCustomParam("groupStandard", materialgrpstd.getPkValue());
                listShowParameter.setF7ClickByFilter(false);
                break;
            }
            case "mulmaterial": {
                DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
                if (materialgrpstd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostReductionLevelFormPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccounts)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelFormPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                orgList = orgObjs.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                HashMap<String, List<Object>> params = new HashMap<String, List<Object>>(2);
                params.put("useOrgs", orgList);
                listShowParameter.setCustomParams(params);
                DynamicObjectCollection mulmaterialtype = (DynamicObjectCollection)this.getModel().getValue("mulmaterialtype");
                if (!CollectionUtils.isEmpty((Collection)mulmaterialtype) || materialgrpstd != null && materialgrpstd.getLong("id") != 730148448254487552L) {
                    qFilters.add(MaterialGroupHelper.getClassifiedMaterialIdFilter((DynamicObjectCollection)mulmaterialtype, (boolean)false, (DynamicObject)materialgrpstd));
                }
                listShowParameter.setF7ClickByFilter(false);
            }
        }
    }

    public void getUsePeriodFilter(List<Long> costAccountIds, Set<Long> periodTypeSet, TreeSet<Long> minSet, TreeSet<Long> maxSet) {
        DynamicObjectCollection periodObjs = PeriodHelper.getSysCtrlEntity(costAccountIds);
        if (!periodObjs.isEmpty()) {
            for (DynamicObject obj : periodObjs) {
                periodTypeSet.add(obj.getLong("periodtype"));
                minSet.add(obj.getLong("startperiod"));
                maxSet.add(obj.getLong("currentperiod"));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam("hpParam");
        if (CadEmptyUtils.isEmpty((String)openParamStr)) {
            this.initData();
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"mulstorageorgunit", "viewtransincost", "viewpurcost"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam("hpParam");
        if (!CadEmptyUtils.isEmpty((String)openParamStr) && !"true".equals(this.getPageCache().get("hasquery"))) {
            JSONObject param = JSONObject.fromObject((Object)openParamStr);
            this.getModel().setValue("mulorg", (Object)new Object[]{param.getLong("orgId")});
            this.getModel().setValue("mulcostaccount", (Object)new Object[]{param.getLong("costaccountId")});
            this.getModel().setValue("mulperiod", (Object)new Object[]{param.getLong("periodId")});
            this.getModel().setValue("qcurrency", (Object)param.getLong("currency"));
            this.getModel().setValue("mulproduct", (Object)param.getJSONArray("materials").toArray());
            this.getView().updateView("mulorg");
            this.getView().updateView("mulcostaccount");
            this.getView().updateView("mulperiod");
            this.getView().updateView("qcurrency");
            this.getView().updateView("mulproduct");
            if (ReportRptHelper.getDefaultfilterScheme(this.getView()) == null) {
                this.showQty(this.getModel().getDataEntity());
                ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
                filter.search();
                return;
            }
        }
        this.showQty(this.getModel().getDataEntity());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        this.getPageCache().put("hasquery", "true");
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"mulcostaccount", "mulorg", "qcurrency", "mulperiod", "mulproduct", "materialgrpstd"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u5185\u5bb9\u3002", (String)"CostReductionLevelFormPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
            return false;
        }
        CostReductionRptParam costReductionItemParam = this.buildCostReductionItemParam(this.getModel().getDataEntity());
        String appNum = AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView());
        Set costaccountIds = StartCostHelper.getEnabledCostAccount((String)appNum);
        for (Long costaccountId : costReductionItemParam.getCostAccountIds()) {
            if (costaccountIds.contains(costaccountId)) continue;
            if ("aca".equals(appNum)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u5b9e\u9645\u6210\u672c\u6838\u7b97\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CostReductionLevelFormPlugin_10", (String)"macc-sca-report", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6807\u51c6\u6210\u672c\u6838\u7b97\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CostReductionLevelFormPlugin_11", (String)"macc-sca-report", (Object[])new Object[0]));
            }
            return false;
        }
        this.getQueryParam().getCustomParam().put(CostReductionRptParam.class.getName(), costReductionItemParam);
        return true;
    }

    private void showQty(DynamicObject dataEntity) {
        boolean viewTotal = dataEntity.getBoolean("viewtotal");
        boolean viewtransincost = dataEntity.getBoolean("viewtransincost");
        boolean viewpurcost = dataEntity.getBoolean("viewpurcost");
        String showQtyCols = this.getModel().getDataEntity().getString("showqtycols");
        Set<String> showQtyCol = this.getSelectKeyHashSet(showQtyCols);
        if (viewTotal) {
            showQtyCol.addAll(CostReductionRptSourceCf.SUM_GROUP);
        } else {
            showQtyCol.removeAll(CostReductionRptSourceCf.SUM_GROUP);
        }
        if (viewtransincost) {
            showQtyCol.addAll(CostReductionRptSourceCf.TRANSIN_GROUP);
        } else {
            showQtyCol.removeAll(CostReductionRptSourceCf.TRANSIN_GROUP);
        }
        if (viewpurcost) {
            showQtyCol.addAll(CostReductionRptSourceCf.PUR_GROUP);
        } else {
            showQtyCol.removeAll(CostReductionRptSourceCf.PUR_GROUP);
        }
        StringBuilder sb = new StringBuilder();
        for (String field : showQtyCol) {
            sb.append(field).append(",");
        }
        this.getModel().setValue("showqtycols", (Object)sb.toString());
        this.getView().updateView("showqtycols");
    }

    private Set<String> getSelectKeyHashSet(String selectKey) {
        HashSet<String> selectSet = null;
        if (!StringUtils.isEmpty((CharSequence)selectKey)) {
            selectSet = new HashSet<String>(Arrays.asList(selectKey.split(",")));
            selectSet.remove("");
        } else {
            selectSet = new HashSet<String>(10);
        }
        return selectSet;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CostReductionLevelFormPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u6210\u672c\u8fd8\u539f\u5206\u7ea7\u8868", (String)"CostReductionLevelFormPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"sca_costreditemrpt", (IDataModel)this.getModel());
    }

    private void initData() {
        DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("mulorg");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (isaccount && permAccountOrgIds.contains(currentOrgId)) {
            Object[] orgCol = new Object[]{currentOrgId};
            this.getModel().setValue("mulorg", (Object)orgCol);
        }
        org = this.getModel().getDataEntity().getDynamicObjectCollection("mulorg");
        this.setCostAccount(org);
    }

    private void setCostAccount(DynamicObjectCollection org) {
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
            this.getModel().setValue("mulcostaccount", null);
            this.getModel().setValue("mulperiod", null);
            this.getModel().setValue("qcurrency", null);
            return;
        }
        Object[] costAccountCol = new Object[1];
        String appNum = this.getView().getFormShowParameter().getAppId();
        Long orgId = ((DynamicObject)org.get(0)).getDynamicObject("fbasedataid").getLong("id");
        Long costAccount = StartCostHelper.getCostAccountByOrg((Long)orgId, (String)appNum);
        if (!CadEmptyUtils.isEmpty((Long)costAccount)) {
            costAccountCol[0] = costAccount;
            this.getModel().setValue("mulcostaccount", (Object)costAccountCol);
            HashSet<Long> costAccIdSet = new HashSet<Long>(16);
            costAccIdSet.add(costAccount);
            this.validateCostReductCalDimension(costAccIdSet, null);
        } else {
            this.getModel().setValue("mulcostaccount", null);
            this.getModel().setValue("mulperiod", null);
            this.getModel().setValue("mulorg", null);
        }
        this.setCurrency();
        if (costAccount != null) {
            this.setPeriod();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObjectCollection mulCostAccount = (DynamicObjectCollection)this.getModel().getValue("mulcostaccount");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulCostAccount)) {
            return;
        }
        if ("exportexcel".equals(operateKey) || "syncexportexcel".equals(operateKey)) {
            HashSet orgIds = new HashSet(10);
            DynamicObjectCollection mulorg = (DynamicObjectCollection)this.getModel().getValue("mulorg");
            if (mulorg != null) {
                mulorg.forEach(p -> orgIds.add(p.getDynamicObject("fbasedataid").getLong("id")));
            }
            String appNum = this.getView().getFormShowParameter().getAppId();
            if (!PermItemCheckHelper.isAllPerm((String)this.getView().getModel().getDataEntityType().getName(), (String)"47150e89000000ac", (String)appNum, orgIds)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6210\u672c\u8fd8\u539f\u5206\u7ea7\u8868\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostReductionLevelFormPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection costaccount = dataEntity.getDynamicObjectCollection("mulcostaccount");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costaccount)) {
            this.getModel().setValue("qcurrency", null);
            return;
        }
        HashSet<Long> costAccIdSet = new HashSet<Long>(1);
        costAccIdSet.add(((DynamicObject)costaccount.get(0)).getDynamicObject("fbasedataid").getLong("id"));
        Set calpolicySet = StartCostHelper.getCalPolicyByCostAccount(costAccIdSet);
        if (CadEmptyUtils.isEmpty((Set)calpolicySet)) {
            this.getModel().setValue("qcurrency", null);
            return;
        }
        DynamicObjectCollection currencyCol = StartCostHelper.getCurrencyByCalPolicy((Set)calpolicySet);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)currencyCol)) {
            this.getModel().setValue("qcurrency", null);
            return;
        }
        Set currencySet = currencyCol.stream().map(r -> r.getLong("currency")).collect(Collectors.toSet());
        if (CadEmptyUtils.isEmpty(currencySet)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u79cd\u7684\u6210\u672c\u8d26\u7c3f", (String)"CostReductionLevelFormPlugin_7", (String)"macc-sca-report", (Object[])new Object[0]));
            return;
        }
        if (currencySet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u79cd\u7684\u6210\u672c\u8d26\u7c3f", (String)"CostReductionLevelFormPlugin_7", (String)"macc-sca-report", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("qcurrency", currencySet.toArray()[0]);
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection org = dataEntity.getDynamicObjectCollection("mulorg");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
            return;
        }
        DynamicObjectCollection costAccount = dataEntity.getDynamicObjectCollection("mulcostaccount");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccount)) {
            this.getModel().setValue("mulperiod", null);
            this.getView().updateView("mulperiod");
            return;
        }
        Long orgId = ((DynamicObject)org.get(0)).getDynamicObject("fbasedataid").getLong("id");
        Long costAccountId = ((DynamicObject)costAccount.get(0)).getDynamicObject("fbasedataid").getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            Object[] objects = new Object[]{currentperiod};
            this.getModel().setValue("mulperiod", (Object)objects);
            this.getView().updateView("mulperiod");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (propertyname) {
            case "mulcostaccount": {
                if (newValue == null) {
                    this.getModel().setValue("mulperiod", null);
                }
                if (newValue instanceof DynamicObjectCollection) {
                    DynamicObjectCollection costAccountCol = (DynamicObjectCollection)newValue;
                    Set<Long> costAccIdSet = costAccountCol.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                    Set orgIdSet = costAccountCol.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("calorg.id")).collect(Collectors.toSet());
                    boolean isCurrencySame = this.validateCurrencyWhenChooseCostAcc(costAccIdSet, oldValue);
                    boolean isPeriodTypeSame = this.validatePeriodTypeWhenChooseCostAcc(costAccIdSet, oldValue);
                    boolean isSysParamSame = this.validateCostReductCalDimension(costAccIdSet, oldValue);
                    if (!(isCurrencySame && isPeriodTypeSame && isSysParamSame)) {
                        if (oldValue instanceof DynamicObjectCollection) {
                            Set oldSet = ((DynamicObjectCollection)oldValue).stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                            oldSet.retainAll(costAccIdSet);
                            if (oldSet.size() == 0) {
                                this.getModel().setValue("mulperiod", null);
                                this.getModel().setValue("mulprdorg", null);
                                this.getModel().setValue("mulstorageorgunit", null);
                            }
                        }
                        this.getModel().setValue("mulorg", (Object)orgIdSet.toArray());
                        this.getView().updateView("mulorg");
                    }
                }
                this.setCurrency();
                this.setPeriod();
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialtype", null);
                this.getModel().setValue("mulmaterial", null);
                break;
            }
            case "mulmaterialtype": {
                this.getModel().setValue("mulmaterial", null);
                break;
            }
            case "mulprdorg": {
                if ("Y".equals(this.getPageCache().get("need_storg_cache"))) {
                    List stOrglist;
                    DynamicObjectCollection prdorg = this.getModel().getDataEntity().getDynamicObjectCollection("mulprdorg");
                    List pdorgList = prdorg.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                    if (prdorg.size() == 1 && (stOrglist = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)((Long)pdorgList.get(0)), (boolean)true)).size() == 1) {
                        DynamicObjectCollection stCol = this.getModel().getDataEntity().getDynamicObjectCollection("mulstorageorgunit");
                        stCol.clear();
                        Map stOrgDynMap = BusinessDataServiceHelper.loadFromCache((Object[])stOrglist.toArray(), (String)"bos_org");
                        if (stOrgDynMap.size() > 0) {
                            DynamicObject obj = stCol.addNew();
                            obj.set("fbasedataid", stOrgDynMap.get(stOrglist.get(0)));
                            this.getView().updateView("mulstorageorgunit");
                            break;
                        }
                    }
                }
                this.getModel().setValue("mulstorageorgunit", null);
                this.getView().updateView("mulstorageorgunit");
                break;
            }
            case "mulstorageorgunit": {
                List stList;
                List pdOrglist;
                DynamicObjectCollection stCol = this.getModel().getDataEntity().getDynamicObjectCollection("mulstorageorgunit");
                DynamicObjectCollection prdorg = this.getModel().getDataEntity().getDynamicObjectCollection("mulprdorg");
                if (stCol.size() != 1 || prdorg.size() != 0 || (pdOrglist = OrgUnitServiceHelper.getAllToOrg((String)"05", (String)"04", (Long)((Long)(stList = stCol.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList())).get(0)), (boolean)true)).size() != 1) break;
                prdorg.clear();
                Map pdOrgDynMap = BusinessDataServiceHelper.loadFromCache((Object[])pdOrglist.toArray(), (String)"bos_org");
                if (pdOrgDynMap.size() <= 0) break;
                DynamicObject obj = stCol.addNew();
                obj.set("fbasedataid", pdOrgDynMap.get(pdOrglist.get(0)));
                this.getView().updateView("mulprdorg");
                break;
            }
            case "viewtotal": {
                this.showQty(this.getModel().getDataEntity());
                break;
            }
            case "viewtransincost": {
                this.showQty(this.getModel().getDataEntity());
                break;
            }
            case "viewpurcost": {
                this.showQty(this.getModel().getDataEntity());
                break;
            }
        }
    }

    private boolean validateCostReductCalDimension(Set<Long> costAccIdSet, Object oldValue) {
        DynamicObjectCollection resCol = SysParamHelper.getRestoreCalcRangeByCostAccount(costAccIdSet);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)resCol)) {
            Set<String> restoredimensionSet = resCol.stream().map(r -> r.getString("restoredimension")).collect(Collectors.toSet());
            Set restorecalcrangeSet = resCol.stream().map(r -> r.getString("restorecalcrange")).collect(Collectors.toSet());
            if (restoredimensionSet.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u7ef4\u5ea6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CostReductionLevelFormPlugin_8", (String)"macc-sca-report", (Object[])new Object[0]));
                this.getModel().setValue("mulcostaccount", oldValue);
                this.getView().setVisible(Boolean.TRUE, new String[]{"mulprdorg"});
                return true;
            }
            String[] array = restoredimensionSet.toArray(new String[0]);
            if (array.length == 1) {
                String str = array[0];
                if ("B".equals(str)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"mulprdorg"});
                    this.getPageCache().put("need_prdorg_cache", "Y");
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"mulprdorg"});
                    this.getModel().setValue("mulprdorg", null);
                    this.getPageCache().put("need_prdorg_cache", "N");
                }
            }
            boolean allviewtransincost = true;
            for (String restorecalcrange : restorecalcrangeSet) {
                if (restorecalcrange.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue())) continue;
                allviewtransincost = false;
                break;
            }
            if (allviewtransincost && "Y".equals(this.getPageCache().get("need_prdorg_cache"))) {
                this.getPageCache().put("need_storg_cache", "Y");
            } else {
                this.getPageCache().put("need_storg_cache", "N");
                this.getView().setVisible(Boolean.FALSE, new String[]{"mulstorageorgunit"});
                this.getModel().setValue("mulstorageorgunit", null);
            }
        }
        return false;
    }

    private boolean validateCurrencyWhenChooseCostAcc(Set<Long> costAccIdSet, Object oldValue) {
        Boolean siCurencySame = StartCostHelper.validateCurrencyWhenChooseCostAcc(costAccIdSet);
        if (siCurencySame.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5e01\u522b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u522b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelFormPlugin_9", (String)"macc-sca-report", (Object[])new Object[0]));
            this.getModel().setValue("mulcostaccount", oldValue);
            return true;
        }
        return false;
    }

    private boolean validatePeriodTypeWhenChooseCostAcc(Set<Long> costAccIdSet, Object oldValue) {
        Set periodtypeSet;
        ArrayList<Long> costAccountIds = new ArrayList<Long>(costAccIdSet.size());
        costAccountIds.addAll(costAccIdSet);
        DynamicObjectCollection periodObjs = PeriodHelper.getSysCtrlEntity(costAccountIds);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)periodObjs) && (periodtypeSet = periodObjs.stream().map(r -> r.getLong("periodtype")).collect(Collectors.toSet())) != null && periodtypeSet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelFormPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
            this.getModel().setValue("mulcostaccount", oldValue);
            return true;
        }
        return false;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        boolean viewtransincost = this.getModel().getDataEntity().getBoolean("viewtransincost");
        boolean viewpurcost = this.getModel().getDataEntity().getBoolean("viewpurcost");
        for (AbstractReportColumn col : columns) {
            ReportColumn subcolRc;
            if (!(col instanceof ReportColumnGroup)) continue;
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)col;
            if ("entryfieldgroupaptransin".equals(reportColumnGroup.getFieldKey())) {
                for (AbstractReportColumn subcol : reportColumnGroup.getChildren()) {
                    subcolRc = (ReportColumn)subcol;
                    subcolRc.setHide(!viewtransincost);
                }
                continue;
            }
            if (!"entryfieldgroupappur".equals(reportColumnGroup.getFieldKey())) continue;
            for (AbstractReportColumn subcol : reportColumnGroup.getChildren()) {
                subcolRc = (ReportColumn)subcol;
                subcolRc.setHide(!viewpurcost);
            }
        }
    }

    private CostReductionRptParam buildCostReductionItemParam(DynamicObject dataEntity) {
        DynamicObjectCollection mulMaterial;
        DynamicObjectCollection mulMaterialTypes;
        DynamicObject materialGrpStd;
        DynamicObjectCollection mulProduct;
        DynamicObjectCollection mulPeriod;
        DynamicObject currency;
        DynamicObjectCollection mulStorageOrgUnit;
        DynamicObjectCollection mulPrdOrg;
        DynamicObjectCollection mulOrg;
        CostReductionRptParam param = new CostReductionRptParam();
        DynamicObjectCollection mulCostAccount = dataEntity.getDynamicObjectCollection("mulcostaccount");
        if (!mulCostAccount.isEmpty()) {
            param.setCostAccountIds(mulCostAccount.stream().map(p -> p.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!(mulOrg = dataEntity.getDynamicObjectCollection("mulorg")).isEmpty()) {
            param.setOrgIds(mulOrg.stream().map(p -> p.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!(mulPrdOrg = dataEntity.getDynamicObjectCollection("mulprdorg")).isEmpty()) {
            param.setPrdOrgIds(mulPrdOrg.stream().map(p -> p.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!(mulStorageOrgUnit = dataEntity.getDynamicObjectCollection("mulstorageorgunit")).isEmpty()) {
            param.setStorageOrgUnitIds(mulStorageOrgUnit.stream().map(p -> p.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if ((currency = dataEntity.getDynamicObject("qcurrency")) != null) {
            param.setCurrencyId(currency.getLong("id"));
            param.setAmtPrecision(currency.getInt("amtprecision"));
            param.setPricePrecision(currency.getInt("priceprecision"));
        }
        if (!(mulPeriod = dataEntity.getDynamicObjectCollection("mulperiod")).isEmpty()) {
            param.setPeriodids(mulPeriod.stream().map(p -> p.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!(mulProduct = dataEntity.getDynamicObjectCollection("mulproduct")).isEmpty()) {
            param.setMulProductIds(mulProduct.stream().map(p -> p.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if ((materialGrpStd = dataEntity.getDynamicObject("materialgrpstd")) != null) {
            param.setMaterialGrpStd(materialGrpStd);
            param.setMaterialGrpStdId(materialGrpStd.getLong("id"));
        }
        if (!(mulMaterialTypes = dataEntity.getDynamicObjectCollection("mulmaterialtype")).isEmpty()) {
            param.setMaterialGroup(mulMaterialTypes);
            param.setMulMaterialGroupId(mulMaterialTypes.stream().map(p -> p.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!(mulMaterial = dataEntity.getDynamicObjectCollection("mulmaterial")).isEmpty()) {
            param.setMulMaterialIds(mulMaterial.stream().map(p -> p.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        param.setOlnySumRow(dataEntity.getBoolean("onlysumrow"));
        param.setTopSumRow(dataEntity.getBoolean("topsumrow"));
        param.setViewTransinCost(dataEntity.getBoolean("viewtransincost"));
        param.setViewPurCost(dataEntity.getBoolean("viewpurcost"));
        param.setViewTotal(dataEntity.getBoolean("viewtotal"));
        param.setLevelRpt(true);
        param.setDisplayLevel(dataEntity.getInt("displaylevel"));
        param.setAppnum(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        String subshowkeycolStr = dataEntity.getString("subshowkeycols");
        if (!StringUtils.isEmpty((CharSequence)subshowkeycolStr)) {
            String[] keyCols;
            for (String col : keyCols = subshowkeycolStr.split(",")) {
                if (StringUtils.isEmpty((CharSequence)col)) continue;
                param.getSubShowKeyCols().add(col);
            }
        }
        return param;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>(16);
        removedPros.add("costaccount");
        removedPros.add("org");
        removedPros.add("prdorg");
        removedPros.add("storageorgunit");
        removedPros.add("period");
        removedPros.add("periodyear");
        removedPros.add("materialnum");
        removedPros.add("material");
        removedPros.add("group");
        removedPros.add("groupname");
        removedPros.add("submaterialnum");
        removedPros.add("submaterial");
        removedPros.add("level");
        removedPros.add("isleaf");
        removedPros.add("treepath");
        return !removedPros.contains(split[0]);
    }
}

