/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.reduction;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.report.reduction.CostReductionRptParam;

public class CostReductionSumUnitFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private CostReductionRptParam costReductionRptParam;

    public CostReductionSumUnitFunction(CostReductionRptParam costReductionRptParam) {
        this.costReductionRptParam = costReductionRptParam;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public RowX map(RowX row) {
        int precision = this.costReductionRptParam.getAmtPrecision();
        int pricePrecision = this.costReductionRptParam.getPricePrecision();
        BigDecimal curQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("curqty")));
        BigDecimal curAmt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("curamt")));
        row.set(this.getSourceRowMeta().getFieldIndex("curprice"), (Object)CostReductionSumUnitFunction.getDevideCal(curAmt, curQty, pricePrecision));
        row.set(this.getSourceRowMeta().getFieldIndex("curunitamt"), (Object)CostReductionSumUnitFunction.getDevideCal(curAmt, curQty, precision));
        BigDecimal sumQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("sumqty")));
        BigDecimal sumAmt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("sumamt")));
        row.set(this.getSourceRowMeta().getFieldIndex("sumprice"), (Object)CostReductionSumUnitFunction.getDevideCal(sumAmt, sumQty, pricePrecision));
        row.set(this.getSourceRowMeta().getFieldIndex("sumunitamt"), (Object)CostReductionSumUnitFunction.getDevideCal(sumAmt, sumQty, precision));
        if (this.costReductionRptParam.getViewTransinCost()) {
            BigDecimal transinQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("transinqty")));
            BigDecimal transinAmt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("transinamt")));
            row.set(this.getSourceRowMeta().getFieldIndex("transinprice"), (Object)CostReductionSumUnitFunction.getDevideCal(transinAmt, transinQty, pricePrecision));
            row.set(this.getSourceRowMeta().getFieldIndex("transinunitamt"), (Object)CostReductionSumUnitFunction.getDevideCal(transinAmt, transinQty, precision));
        }
        if (this.costReductionRptParam.getViewPurCost()) {
            BigDecimal purQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("purqty")));
            BigDecimal purAmt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("puramt")));
            row.set(this.getSourceRowMeta().getFieldIndex("purprice"), (Object)CostReductionSumUnitFunction.getDevideCal(purAmt, purQty, pricePrecision));
            row.set(this.getSourceRowMeta().getFieldIndex("purunitamt"), (Object)CostReductionSumUnitFunction.getDevideCal(purAmt, purQty, precision));
        }
        return row;
    }

    private static BigDecimal getDevideCal(BigDecimal divider, BigDecimal dividend, int precision) {
        if (dividend.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return divider.divide(dividend, precision, 4);
    }
}

