/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.reduction;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.DataSetXHelper;

public class CostRedutionCalcUnitAmtFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private boolean viewTotal = false;

    public CostRedutionCalcUnitAmtFunction(boolean viewTotal) {
        this.viewTotal = viewTotal;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collect) {
        DataSet dataset = DataSetXHelper.getDsFromAlgoxRows(iterable, (String[])new String[]{"keytreepath"}, (RowMeta)this.sourceRowMeta);
        ArrayList<RowX> allRowX = new ArrayList<RowX>(64);
        while (dataset.hasNext()) {
            Row row = dataset.next();
            RowX rowx = new RowX(this.sourceRowMeta.getFieldCount());
            for (int i = 0; i < this.sourceRowMeta.getFieldCount(); ++i) {
                rowx.set(i, row.get(i));
            }
            allRowX.add(rowx);
        }
        HashMap subRoxMap = Maps.newHashMapWithExpectedSize((int)16);
        for (RowX row : allRowX) {
            String treePath = row.getString(this.sourceRowMeta.getFieldIndex("keytreePath"));
            if (treePath.lastIndexOf("@") < 0) continue;
            String tmpTree = treePath.substring(0, treePath.lastIndexOf("@"));
            subRoxMap.computeIfAbsent(tmpTree, t -> Lists.newArrayList()).add(row);
        }
        this.dealCalcDiffAmt(allRowX, subRoxMap, "curunitamt");
        if (this.viewTotal) {
            this.dealCalcDiffAmt(allRowX, subRoxMap, "sumunitamt");
        }
        for (RowX row : allRowX) {
            collect.collect(row);
        }
    }

    private void dealCalcDiffAmt(List<RowX> allRowX, Map<String, List<RowX>> subRoxMap, String field) {
        int fieldindex = this.sourceRowMeta.getFieldIndex(field, false);
        if (fieldindex < 0) {
            return;
        }
        for (RowX row : allRowX) {
            BigDecimal diffAmt;
            String treePath = row.getString(this.sourceRowMeta.getFieldIndex("keytreePath"));
            BigDecimal parentAmt = row.getBigDecimal(fieldindex);
            List<RowX> subList = subRoxMap.get(treePath);
            if (subList == null || subList.size() == 1) continue;
            BigDecimal subTotalAmt = BigDecimal.ZERO;
            RowX maxRow = null;
            for (RowX subRow : subList) {
                BigDecimal subAmount = subRow.getBigDecimal(fieldindex);
                subTotalAmt = subTotalAmt.add(subAmount);
                if (maxRow != null && maxRow.getBigDecimal(fieldindex).compareTo(subAmount) >= 0) continue;
                maxRow = subRow;
            }
            if (subTotalAmt.compareTo(BigDecimal.ZERO) == 0 || (diffAmt = parentAmt.subtract(subTotalAmt)).compareTo(BigDecimal.ZERO) == 0 || maxRow == null) continue;
            maxRow.set(fieldindex, (Object)maxRow.getBigDecimal(fieldindex).add(diffAmt));
        }
    }
}

