/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.algox.utils.CostAccountHelper;

public class DiffCheckInRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private Log logger = LogFactory.getLog(DiffCheckInRptPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("forg");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("fcostaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("fperiod");
        period.addBeforeF7SelectListener(evt -> {
            DynamicObject costAccount;
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("forg");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiffCheckInRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (CadEmptyUtils.isEmpty((DynamicObject)(costAccount = this.getModel().getDataEntity().getDynamicObject("fcostaccount")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"DiffCheckInRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)Long.valueOf(String.valueOf(accountOrg.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
            }
        });
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fmaterialgroup = (BasedataEdit)this.getControl("fmaterialgroup");
        fmaterialgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fmaterial = (BasedataEdit)this.getControl("fmaterial");
        fmaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("forg");
        ArrayList<Long> orgList = new ArrayList<Long>();
        if (org != null) {
            orgList.add((Long)org.getPkValue());
        }
        switch (name) {
            case "forg": {
                List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "fcostaccount": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiffCheckInRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter costAccountFilter = StartCostHelper.getEndInitCostAccountIdsFilter((Long)((Long)org.getPkValue()), (String)"sca");
                listShowParameter.getListFilterParameter().getQFilters().add(costAccountFilter);
                break;
            }
            case "materialgrpstd": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiffCheckInRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", orgList, Boolean.TRUE});
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)ids));
                break;
            }
            case "fmaterialgroup": {
                DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
                if (materialgrpstd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"DiffCheckInRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiffCheckInRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgList, materialgrpstd.getPkValue(), false});
                listShowParameter.getListFilterParameter().getQFilters().add(serviceResponse);
                HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
                params.put("useOrgs", orgList);
                listShowParameter.setCustomParams(params);
                listShowParameter.setCustomParam("groupStandard", materialgrpstd.getPkValue());
                listShowParameter.setF7ClickByFilter(false);
                break;
            }
            case "fmaterial": {
                DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
                if (materialgrpstd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"DiffCheckInRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiffCheckInRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
                params.put("useOrgs", orgList);
                listShowParameter.setCustomParams(params);
                DynamicObjectCollection mulmaterialtype = (DynamicObjectCollection)this.getModel().getValue("fmaterialgroup");
                if (!CollectionUtils.isEmpty((Collection)mulmaterialtype) || materialgrpstd != null && materialgrpstd.getLong("id") != 730148448254487552L) {
                    listShowParameter.getListFilterParameter().getQFilters().add(MaterialGroupHelper.getClassifiedMaterialIdFilter((DynamicObjectCollection)mulmaterialtype, (boolean)false, (DynamicObject)materialgrpstd));
                }
                listShowParameter.setF7ClickByFilter(false);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        ReportQueryParam reportQueryParam = reportShowParameter.getReportQueryParam();
        if (reportQueryParam != null) {
            return;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("forg");
        if (org != null) {
            return;
        }
        this.initQueryInfo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "forg": {
                this.getModel().setValue("fcostaccount", null);
                this.getModel().setValue("fcurrency", null);
                this.getModel().setValue("fperiod", null);
                this.setCostAccount(newValue);
                break;
            }
            case "fcostaccount": {
                this.getModel().setValue("fcurrency", null);
                this.getModel().setValue("fperiod", null);
                this.setCurrencyAndPeriod(newValue);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ArrayList props = Lists.newArrayList((Object[])new String[]{"forg", "fcostaccount", "fcurrency", "fperiod"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)props);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"DiffCheckInRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
            return false;
        }
        try {
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2", (String)"DiffCheckInRptPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u8f6c\u5165\u5bf9\u6570\u62a5\u8868\u67e5\u8be2", (String)"DiffCheckInRptPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]), (String)"sca_diffallocinrpt", (IDataModel)this.getModel());
        }
        catch (Exception e) {
            this.logger.error("+++++\u5dee\u5f02\u5206\u644a\u8f6c\u5165\u5bf9\u6570\u62a5\u8868\u5199\u64cd\u4f5c\u65e5\u5fd7\u9519\u8bef" + e.getMessage());
        }
        return super.verifyQuery(queryParam);
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            return;
        }
        DynamicObject orgDO = (DynamicObject)org;
        Long costAccount = CostAccountHelper.getDefaultAccountByAcctOrg((Long)orgDO.getLong("id"), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        if (costAccount != 0L) {
            this.getModel().setValue("fcostaccount", (Object)costAccount);
        } else {
            this.getModel().setValue("fcostaccount", null);
        }
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            return;
        }
        DynamicObject costAccountDO = (DynamicObject)costAccount;
        Long currency = CalcRptHelper.getCurrency((DynamicObject)costAccountDO);
        this.getModel().setValue("fcurrency", (Object)currency);
        this.getView().setEnable(Boolean.FALSE, new String[]{"fcurrency"});
        this.setPeriod();
    }

    private void setPeriod() {
        Long costaccountId;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("forg");
        DynamicObject costaccount = dataEntity.getDynamicObject("fcostaccount");
        if (org == null || costaccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        Long currperiod = CalcRptHelper.getCurrPeriod((Long)orgId, (Long)(costaccountId = Long.valueOf(costaccount.getLong("id"))));
        if (currperiod != null && currperiod != 0L) {
            this.getModel().setValue("fperiod", (Object)currperiod);
        }
    }

    private void initQueryInfo() {
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (isaccount && permAccountOrgIds.contains(currentOrgId)) {
            this.getModel().setValue("forg", (Object)currentOrgId);
            this.setCostAccount(this.getModel().getDataEntity().getDynamicObject("forg"));
            this.setCurrencyAndPeriod(this.getModel().getDataEntity().getDynamicObject("fcostaccount"));
            this.getView().updateView();
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        String displaymodel = this.getModel().getDataEntity().getString("displaymodel");
        for (AbstractReportColumn col : columns) {
            if (!(col instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)col;
            String key = reportColumn.getFieldKey();
            if (("configuredcode".equals(key) || "productconfigcode".equals(key)) && !"2".equals(displaymodel) && !"3".equals(displaymodel)) {
                reportColumn.setHide(true);
            }
            if (!"tracknumber".equals(key) && !"producttracknumber".equals(key) || "3".equals(displaymodel)) continue;
            reportColumn.setHide(true);
        }
    }
}

