/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.tpl.IFilter;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.common.helper.MatBaseDataFilterHelper;
import kd.macc.sca.report.restore.model.PurDiffAllocParam;
import kd.macc.sca.report.restore.model.PurDiffAllocRptConstant;
import kd.macc.sca.report.restore.query.PurDiffAllocSourceCf;

public class PurDiffAllocRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgs = (BasedataEdit)this.getControl("org");
        orgs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costcenter = (BasedataEdit)this.getControl("fcostcenter");
        costcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costobject = (BasedataEdit)this.getControl("fcostobject");
        costobject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit beginPeriod = (BasedataEdit)this.getControl("startperiod");
        beginPeriod.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PurDiffAllocRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection costAccount = (DynamicObjectCollection)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PurDiffAllocRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            HashSet<Long> orgIdSet = new HashSet<Long>();
            org.forEach(o -> orgIdSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
            HashSet<Long> accountIdSet = new HashSet<Long>();
            costAccount.forEach(c -> accountIdSet.add(c.getDynamicObject("fbasedataid").getLong("id")));
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter filter = PurDiffAllocRptPlugin.getPeriodTypeFilter(this.getView().getFormShowParameter().getAppId(), orgIdSet, accountIdSet);
            if (filter == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"PurDiffAllocRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(filter);
            this.getStartPeriodFilter(qFilters, accountIdSet);
            qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
        });
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PurDiffAllocRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection costAccount = (DynamicObjectCollection)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PurDiffAllocRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            HashSet<Long> orgIdSet = new HashSet<Long>();
            org.forEach(o -> orgIdSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
            HashSet<Long> accountIdSet = new HashSet<Long>();
            costAccount.forEach(c -> accountIdSet.add(c.getDynamicObject("fbasedataid").getLong("id")));
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter filter = PurDiffAllocRptPlugin.getPeriodTypeFilter(this.getView().getFormShowParameter().getAppId(), orgIdSet, accountIdSet);
            if (filter == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"PurDiffAllocRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(filter);
            this.getStartPeriodFilter(qFilters, accountIdSet);
            qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
        });
        BasedataEdit products = (BasedataEdit)this.getControl("materials");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("org");
            HashSet orgIds = new HashSet();
            org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PurDiffAllocRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject materialGrpStdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialGrpStdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"PurDiffAllocRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(new ArrayList(orgIds)));
            DynamicObject materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgrpstd");
            DynamicObjectCollection mulmaterialGroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
            if (!CollectionUtils.isEmpty((Collection)mulmaterialGroup) || materialGroupStandard.getLong("id") != 730148448254487552L) {
                QFilter classifiedMaterialIdFilter = new QFilter("id", "in", (Object)MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)mulmaterialGroup, (boolean)false, (DynamicObject)materialGroupStandard));
                qFilters.add(classifiedMaterialIdFilter);
            }
        });
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("org");
            ArrayList orgIds = new ArrayList();
            org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PurDiffAllocRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", orgIds, Boolean.TRUE});
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(idFilter);
        });
        MulBasedataEdit mulmaterialgroup = (MulBasedataEdit)this.getControl("mulmaterialgroup");
        mulmaterialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("org");
            ArrayList orgIds = new ArrayList();
            org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"PurDiffAllocRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PurDiffAllocRptPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, materialgrpstdObj.getPkValue(), false});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap params = new HashMap(2);
            params.put("useOrgs", orgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        BasedataEdit costCenterInput = (BasedataEdit)this.getControl("fcostcenter");
        costCenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"PurDiffAllocRptPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                HashSet orgIdSet = new HashSet();
                org.forEach(o -> orgIdSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
                QFilter qfId = null;
                for (Long orgId : orgIdSet) {
                    QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactoryForList((long)orgId, null, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
                    if (qfId != null) {
                        qfId = qfId.or(costCenterIdFilter);
                        continue;
                    }
                    qfId = costCenterIdFilter;
                }
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                QFilter qfNumber = new QFilter("orgduty.number", "=", (Object)"4");
                List qFilters = filterParameter.getQFilters();
                if (qfId != null) {
                    qFilters.add(qfId);
                }
                qFilters.add(qfNumber);
            }
        });
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("org");
        HashSet<Long> orgIds = new HashSet<Long>();
        org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
        switch (name) {
            case "org": {
                List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIdsByPermItem((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"47150e89000000ac");
                Set<Long> orgs = this.getStandCostOrgs(hasPermAccountOrgIds);
                QFilter idFilter = new QFilter("id", "in", orgs);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                if (orgs.size() > 50) break;
                listShowParameter.setCustomParam("isIncludeAllSub", (Object)true);
                break;
            }
            case "costaccount": {
                if (org.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PurDiffAllocRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", this.getCostAccountIds(orgIds)));
                break;
            }
            case "fcostobject": {
                this.setCostObjectBeforeF7Select(beforeF7SelectEvent);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        ReportQueryParam reportQueryParam = reportShowParameter.getReportQueryParam();
        if (reportQueryParam != null) {
            String selectKeyVal = this.getModel().getDataEntity().getString("showkeycols");
            this.showColSet(selectKeyVal);
            return;
        }
        DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("org");
        if (!org.isEmpty()) {
            return;
        }
        this.initQueryInfo();
        String selectKeyVal = this.getModel().getDataEntity().getString("showkeycols");
        this.showColSet(selectKeyVal);
        this.showQty(this.getModel().getDataEntity().getString("difftypes"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.getModel().setValue("costaccount", null);
                this.getModel().setValue("currency", null);
                this.getModel().setValue("startperiod", null);
                this.getModel().setValue("endperiod", null);
                this.getModel().setValue("fcostcenter", null);
                this.getModel().setValue("fcostobject", null);
                this.setCostAccount();
                break;
            }
            case "costaccount": {
                this.setCurrencyAndPeriod();
                break;
            }
            case "showkeycols": {
                this.showColSet(newValue);
                break;
            }
            case "difftypes": {
                this.showQty(newValue);
                break;
            }
            case "startperiod": {
                this.setPeriodRange("begin");
                break;
            }
            case "endperiod": {
                this.setPeriodRange("end");
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialgroup", null);
                this.getModel().setValue("materials", null);
                break;
            }
            case "mulmaterialgroup": {
                this.getModel().setValue("materials", null);
                break;
            }
            case "bizstatus": {
                this.getModel().setValue("fcostobject", null);
            }
        }
    }

    private void showQty(Object newValue) {
        String selectKey = (String)newValue;
        Set<String> diffCol = this.getSelectKeyHashSet(selectKey);
        String showQtyCols = this.getModel().getDataEntity().getString("showqtycols");
        Set<String> showQtyCol = this.getSelectKeyHashSet(showQtyCols);
        this.dealDiffQtyFieldSelect("P", diffCol, showQtyCol);
        this.dealDiffQtyFieldSelect("Q", diffCol, showQtyCol);
        this.dealDiffQtyFieldSelect("S", diffCol, showQtyCol);
        this.dealDiffQtyFieldSelect("R", diffCol, showQtyCol);
        this.dealDiffQtyFieldSelect("M", diffCol, showQtyCol);
        this.dealDiffQtyFieldSelect("G", diffCol, showQtyCol);
        this.dealDiffQtyFieldSelect("H", diffCol, showQtyCol);
        this.dealDiffQtyFieldSelect("K", diffCol, showQtyCol);
        this.dealDiffQtyFieldSelect("C", diffCol, showQtyCol);
        this.dealDiffQtyFieldSelect("T", diffCol, showQtyCol);
        this.dealDiffQtyFieldSelect("X", diffCol, showQtyCol);
        this.dealDiffQtyFieldSelect("W", diffCol, showQtyCol);
        this.dealDiffQtyFieldSelect("Y", diffCol, showQtyCol);
        StringBuilder sb = new StringBuilder();
        for (String field : showQtyCol) {
            sb.append(field).append(",");
        }
        this.getModel().setValue("showqtycols", (Object)sb.toString());
        this.getView().updateView("showqtycols");
    }

    private void dealDiffQtyFieldSelect(String difftype, Set<String> diffCol, Set<String> showQtyCol) {
        String field = this.getDiffField(difftype);
        if (field == null) {
            return;
        }
        if (diffCol.contains(difftype)) {
            showQtyCol.add("start" + field);
            showQtyCol.add("curr" + field);
            showQtyCol.add("end" + field);
            showQtyCol.add("comp" + field);
            showQtyCol.add("total" + field);
        } else {
            showQtyCol.remove("start" + field);
            showQtyCol.remove("curr" + field);
            showQtyCol.remove("end" + field);
            showQtyCol.remove("comp" + field);
            showQtyCol.remove("total" + field);
        }
    }

    private String getDiffField(String difftype) {
        String field = null;
        switch (difftype) {
            case "G": {
                field = "orddiff";
                break;
            }
            case "H": {
                field = "invoicediff";
                break;
            }
            case "K": {
                field = "feediff";
                break;
            }
            case "M": {
                field = "stdcostupamt";
                break;
            }
            case "P": {
                field = "diffqty";
                break;
            }
            case "Q": {
                field = "madediff";
                break;
            }
            case "R": {
                field = "unjoindiffamt";
                break;
            }
            case "S": {
                field = "madeupamt";
                break;
            }
            case "T": {
                field = "otherdiff";
                break;
            }
            case "C": {
                field = "falldiff";
                break;
            }
            case "X": {
                field = "reservediffx";
                break;
            }
            case "W": {
                field = "reservediffw";
                break;
            }
            case "Y": {
                field = "reservediffy";
                break;
            }
        }
        return field;
    }

    private void showColSet(Object newValue) {
        boolean iscostobject;
        String selectKey = (String)newValue;
        Set<String> selectSet = this.getSelectKeyHashSet(selectKey);
        boolean isdetail = selectSet.contains("material") || selectSet.contains("materialgroup");
        this.getView().setEnable(Boolean.valueOf(isdetail), new String[]{"materialgrpstd"});
        this.getView().setEnable(Boolean.valueOf(isdetail), new String[]{"mulmaterialgroup"});
        this.getView().setEnable(Boolean.valueOf(isdetail), new String[]{"materials"});
        if (!isdetail) {
            this.getModel().setValue("mulmaterialgroup", null);
            this.getModel().setValue("materials", null);
        }
        if (iscostobject = selectSet.contains("costobject")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fcostobject", "fbizstatus"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"fproduct"});
            this.getModel().setValue("fproduct", null);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fcostobject", "fbizstatus"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"fproduct"});
            this.getModel().setValue("fcostobject", null);
            this.getModel().setValue("fbizstatus", null);
        }
        boolean isneedSelMaterial = false;
        if (!selectSet.contains("material")) {
            for (String field : PurDiffAllocRptConstant.materialField) {
                if (!selectSet.contains(field)) continue;
                isneedSelMaterial = true;
            }
        }
        if (isneedSelMaterial) {
            selectSet.add("material");
            this.setShowCol(selectSet);
        }
    }

    public static List<String> filterBigtableCols(ReportConf conf, IFilter<BigTableColConf> filter) {
        List bigTableColConf = conf.getBigTableColConf();
        ArrayList<String> fsCol = new ArrayList<String>(10);
        for (BigTableColConf colConf : bigTableColConf) {
            if (filter == null) {
                fsCol.add(colConf.getCol());
                continue;
            }
            if (!filter.filter((Object)colConf)) continue;
            fsCol.add(colConf.getCol());
        }
        return fsCol;
    }

    private void setShowCol(Set<String> selectSet) {
        StringBuilder sb = new StringBuilder();
        for (String field : selectSet) {
            sb.append(field).append(",");
        }
        this.getModel().setValue("showkeycols", (Object)sb.toString());
    }

    private Set<String> getSelectKeyHashSet(String selectKey) {
        HashSet<String> selectSet = null;
        if (!StringUtils.isEmpty((String)selectKey)) {
            selectSet = new HashSet<String>(Arrays.asList(selectKey.split(",")));
            selectSet.remove("");
        } else {
            selectSet = new HashSet<String>(10);
        }
        return selectSet;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "currency", "startperiod", "endperiod", "materialgrpstd"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"PurDiffAllocRptPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]));
            return false;
        }
        Set<String> selectSet = this.getSelectKeyHashSet(this.getModel().getDataEntity().getString("showkeycols"));
        if (selectSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6c47\u603b\u4f9d\u636e\u3002", (String)"PurDiffAllocRptPlugin_7", (String)"macc-sca-report", (Object[])new Object[0]));
            return false;
        }
        PurDiffAllocParam pram = this.buildPurDiffAllocParam(this.getModel().getDataEntity());
        this.getQueryParam().getCustomParam().put(PurDiffAllocParam.class.getName(), pram);
        return true;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        Set<String> selectSet;
        super.processRowData(gridPK, rowData, queryParam);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rowData)) {
            return;
        }
        if (this.getModel().getDataEntity().getBoolean("mergesame") && !(selectSet = this.getSelectKeyHashSet(this.getModel().getDataEntity().getString("showkeycols"))).isEmpty()) {
            for (String field : PurDiffAllocSourceCf.ADD_NUM_FIELDS) {
                if (!selectSet.contains(field)) continue;
                selectSet.add(field + "num");
            }
            HashSet<String> needDelGroupCols = new HashSet<String>(10);
            for (String col : selectSet) {
                if (!col.startsWith("element") && !col.startsWith("subelement")) continue;
                needDelGroupCols.add(col);
            }
            selectSet.removeAll(needDelGroupCols);
            ReportUtils.clearFileNameValue((String[])selectSet.toArray(new String[0]), (DynamicObjectCollection)rowData, (String[])selectSet.toArray(new String[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> unRemovedPros = new HashSet<String>(16);
        unRemovedPros.add("org");
        unRemovedPros.add("costaccount");
        unRemovedPros.add("period");
        unRemovedPros.add("currency");
        unRemovedPros.add("costcenter");
        unRemovedPros.add("costcenternum");
        unRemovedPros.add("unit");
        unRemovedPros.add("materialgroup");
        unRemovedPros.add("productunit");
        unRemovedPros.add("auxpty");
        unRemovedPros.add("version");
        unRemovedPros.add("element");
        unRemovedPros.add("subelement");
        return !unRemovedPros.contains(split[0]);
    }

    private PurDiffAllocParam buildPurDiffAllocParam(DynamicObject dataEntity) {
        PurDiffAllocParam param = new PurDiffAllocParam();
        param.setOrgIds(this.getDynValues(dataEntity, "org"));
        param.setCostaccountIds(this.getDynValues(dataEntity, "costaccount"));
        DynamicObject objDyn = dataEntity.getDynamicObject("currency");
        if (objDyn != null) {
            param.setCurrency(objDyn.getLong("id"));
            param.setAmtprecision(objDyn.getInt("amtprecision"));
            param.setPricePrecision(objDyn.getInt("priceprecision"));
        }
        param.setStartperiod(this.getDynId(dataEntity, "startperiod"));
        param.setEndperiod(this.getDynId(dataEntity, "endperiod"));
        param.setCostcenterIds(this.getDynValues(dataEntity, "fcostcenter"));
        param.setCostobjectIds(this.getDynValues(dataEntity, "fcostobject"));
        param.setProductIds(this.getDynValues(dataEntity, "fproduct"));
        param.setMaterialgrpstd(this.getDynId(dataEntity, "materialgrpstd"));
        param.setMatGroupIds(this.getDynValues(dataEntity, "mulmaterialgroup"));
        param.setMaterials(this.getDynValues(dataEntity, "materials"));
        param.setBizstatus(dataEntity.getString("fbizstatus"));
        String diffTypes = dataEntity.getString("difftypes");
        ArrayList diffTypeList = null;
        diffTypeList = StringUtils.isNotEmpty((String)diffTypes) ? Lists.newArrayList((Object[])diffTypes.split(",")) : Lists.newArrayList();
        param.setDiffTypes(diffTypeList);
        return param;
    }

    private Long getDynId(DynamicObject dataEntity, String key) {
        DynamicObject objDyn = dataEntity.getDynamicObject(key);
        if (objDyn == null) {
            return null;
        }
        return objDyn.getLong("id");
    }

    private List<Long> getDynValues(DynamicObject dataEntity, String key) {
        DynamicObjectCollection objDyns = dataEntity.getDynamicObjectCollection(key);
        if (objDyns == null) {
            return null;
        }
        return objDyns.stream().map(t -> t.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
    }

    public void setPeriodRange(String flag) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject beginperiod = dataEntity.getDynamicObject("startperiod");
        DynamicObject endperiod = dataEntity.getDynamicObject("endperiod");
        if (beginperiod == null || endperiod == null) {
            return;
        }
        if (beginperiod.getDate("begindate").compareTo(endperiod.getDate("begindate")) <= 0) {
            return;
        }
        if ("begin".equals(flag)) {
            this.getModel().setValue("endperiod", (Object)beginperiod);
        } else if ("end".equals(flag)) {
            this.getModel().setValue("startperiod", (Object)endperiod);
        }
    }

    private void initQueryInfo() {
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isAccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isAccount && PermItemCheckHelper.isPerm((String)this.getBillEntityId(), (String)"47150e89000000ac", (String)this.getView().getFormShowParameter().getAppId(), (Long)currentOrgId)) {
            this.getModel().setValue("org", (Object)new Object[]{currentOrgId});
            this.setCostAccount();
            this.getView().updateView();
        }
    }

    public void setCostAccount() {
        IDataModel model = this.getModel();
        DynamicObjectCollection org = (DynamicObjectCollection)model.getValue("org");
        if (CollectionUtils.isEmpty((Collection)org)) {
            this.getModel().setValue("costaccount", null);
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>();
        org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
        DynamicObjectCollection costAccounts = this.getCostAccount(orgIds);
        HashMap<Long, DynamicObjectCollection> orgAndCostMap = new HashMap<Long, DynamicObjectCollection>();
        for (Object costAccount : costAccounts) {
            orgAndCostMap.computeIfAbsent(costAccount.getLong("orgid"), r -> new DynamicObjectCollection()).add(costAccount);
        }
        ArrayList<Long> accountIds = new ArrayList<Long>();
        block1: for (Map.Entry entry : orgAndCostMap.entrySet()) {
            DynamicObjectCollection values = (DynamicObjectCollection)entry.getValue();
            if (values.size() == 1) {
                accountIds.add(((DynamicObject)values.get(0)).getLong("accountid"));
                continue;
            }
            for (DynamicObject value : values) {
                if (!value.getBoolean("ismainaccount")) continue;
                accountIds.add(value.getLong("accountid"));
                continue block1;
            }
        }
        QFilter orgQF = new QFilter("org", "in", orgIds);
        QFilter qFilter = new QFilter("entry.costaccount", "in", accountIds);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, qFilter});
        HashSet periods = new HashSet();
        if (!dynamicObjects.isEmpty()) {
            dynamicObjects.forEach(dynamicObject -> periods.add(dynamicObject.getLong("currentperiod")));
        }
        if (accountIds.isEmpty() || periods.size() > 1) {
            this.getModel().setValue("costaccount", null);
            return;
        }
        Set<Long> costAccountIds = this.getCostAccountIds(orgIds);
        Set collectIds = accountIds.stream().filter(costAccountIds::contains).collect(Collectors.toSet());
        if (collectIds.isEmpty()) {
            this.getModel().setValue("costaccount", null);
            return;
        }
        model.setValue("costaccount", (Object)collectIds.toArray());
        this.getView().updateView("costaccount");
        this.setCurrencyAndPeriod();
    }

    private void setCurrencyAndPeriod() {
        this.setCurrency();
        this.setPeriod();
    }

    public void setCurrency() {
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("costaccount");
        if (dynamicObjects.isEmpty()) {
            this.getModel().setValue("currency", null);
            return;
        }
        HashSet<Long> calpolicys = new HashSet<Long>();
        for (DynamicObject row : dynamicObjects) {
            DynamicObject dynamicObject = row.getDynamicObject("fbasedataid").getDynamicObject("calpolicy");
            if (dynamicObject == null) continue;
            calpolicys.add(dynamicObject.getLong("id"));
        }
        if (calpolicys.isEmpty()) {
            this.getModel().setValue("currency", null);
            return;
        }
        HashSet<Long> currencyIds = new HashSet<Long>();
        DynamicObjectCollection objectCollection = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicys)});
        for (DynamicObject dynamicObject : objectCollection) {
            currencyIds.add(dynamicObject.getLong("currency"));
        }
        if (currencyIds.isEmpty()) {
            this.getModel().setValue("currency", null);
            return;
        }
        if (currencyIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5e01\u522b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u522b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"PurDiffAllocRptPlugin_8", (String)"macc-sca-report", (Object[])new Object[0]));
            this.getModel().setValue("costaccount", null);
            this.getView().updateView("costaccount");
            return;
        }
        this.getModel().setValue("currency", currencyIds.toArray()[0]);
        this.getView().updateView("currency");
    }

    public void setPeriod() {
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
        DynamicObjectCollection account = (DynamicObjectCollection)this.getModel().getValue("costaccount");
        HashSet orgIds = new HashSet();
        HashSet costAccountIds = new HashSet();
        org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
        account.forEach(c -> costAccountIds.add(c.getDynamicObject("fbasedataid").getLong("id")));
        if (orgIds.isEmpty() || costAccountIds.isEmpty()) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        QFilter orgQF = new QFilter("org", "in", orgIds);
        QFilter costAccountQF = new QFilter("entry.costaccount", "in", costAccountIds);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id,entry.calpolicy.periodtype as periodtype, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, costAccountQF}, (String)"entry.currentperiod desc");
        if (dynamicObjects.isEmpty()) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
        } else {
            ArrayList<Long> periods = new ArrayList<Long>(10);
            HashSet periodTypes = Sets.newHashSetWithExpectedSize((int)4);
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long currentPeriod = dynamicObject.getLong("currentperiod");
                if (!periods.contains(currentPeriod)) {
                    periods.add(currentPeriod);
                }
                periodTypes.add(dynamicObject.getLong("periodtype"));
            }
            if (periodTypes.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"PurDiffAllocRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                this.getModel().setValue("startperiod", null);
                this.getModel().setValue("endperiod", null);
            } else if (!CadEmptyUtils.isEmpty(periods)) {
                this.getModel().setValue("startperiod", periods.get(0));
                this.getModel().setValue("endperiod", periods.get(0));
            } else {
                this.getModel().setValue("startperiod", null);
                this.getModel().setValue("endperiod", null);
            }
        }
        this.getView().updateView("startperiod");
        this.getView().updateView("endperiod");
    }

    public DynamicObjectCollection getCostAccount(Set<Long> orgIds) {
        QFilter accountorgQF = new QFilter("org", "in", orgIds);
        QFilter enablestdtQF = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org.id as orgid,entryentity.costaccount.id as accountid,entryentity.costaccount.ismainaccount as ismainaccount", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF});
        return result;
    }

    public static QFilter getPeriodTypeFilter(String appNum, Set<Long> orgId, Set<Long> costAccountId) {
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfOrg = new QFilter("org", "in", orgId);
        QFilter qfCostAccount = new QFilter("entryentity.costaccount", "in", costAccountId);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.calpolicy.periodtype periodtype", (QFilter[])new QFilter[]{qfAppNum, qfOrg, qfCostAccount});
        if (result.isEmpty()) {
            return new QFilter("periodtype", ">", (Object)0L);
        }
        HashSet<Long> periodTypeIds = new HashSet<Long>();
        for (DynamicObject row : result) {
            periodTypeIds.add(row.getLong("periodtype"));
        }
        if (periodTypeIds.size() > 1) {
            return null;
        }
        return new QFilter("periodtype", "in", periodTypeIds);
    }

    private void getStartPeriodFilter(List<QFilter> qFilters, Set<Long> costAccountId) {
        QFilter filter = new QFilter("entry.costaccount", "in", costAccountId);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.startperiod.id startperiod,entry.currentperiod.id currentperiod", (QFilter[])filter.toArray());
        if (result.isEmpty()) {
            qFilters.add(new QFilter("id", "=", (Object)-1L));
            return;
        }
        long startPeriod = ((DynamicObject)result.get(0)).getLong("startperiod");
        for (DynamicObject dynamicObject : result) {
            long period = dynamicObject.getLong("startperiod");
            if (period >= startPeriod) continue;
            startPeriod = period;
        }
        long lastPeriod = ((DynamicObject)result.get(0)).getLong("currentperiod");
        for (DynamicObject dynamicObject : result) {
            long period = dynamicObject.getLong("currentperiod");
            if (period <= lastPeriod) continue;
            lastPeriod = period;
        }
        qFilters.add(new QFilter("id", ">=", (Object)startPeriod));
    }

    private Set<Long> getStandCostOrgs(List<Long> hasPermAccountOrgIds) {
        QFilter filter = new QFilter("org", "in", hasPermAccountOrgIds);
        filter.and("appnum", "=", (Object)"sca");
        HashSet<Long> orgSet = new HashSet<Long>(16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org", (QFilter[])new QFilter[]{filter});
        if (dynamicObjects.isEmpty()) {
            orgSet.add(-1L);
            return orgSet;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            orgSet.add(dynamicObject.getLong("org"));
        }
        return orgSet;
    }

    private Set<Long> getCostAccountIds(Set<Long> orgIds) {
        HashSet<Long> costIds = new HashSet<Long>();
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and("reductstrategy", "=", (Object)"ITEMIZED_REDUCT");
        filter.and("tab", "=", (Object)"costaccounttabpage");
        DynamicObjectCollection sysParams = QueryServiceHelper.query((String)"cad_sysparam", (String)"costaccount.id as costAccountId", (QFilter[])new QFilter[]{filter});
        if (sysParams.isEmpty()) {
            costIds.add(-1L);
        }
        sysParams.forEach(s -> costIds.add(s.getLong("costAccountId")));
        return costIds;
    }

    private void setCostObjectBeforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject dataModel = this.getModel().getDataEntity();
        DynamicObjectCollection org = dataModel.getDynamicObjectCollection("org");
        DynamicObjectCollection costCenter = dataModel.getDynamicObjectCollection("fcostcenter");
        String bizstatus = dataModel.getString("fbizstatus");
        if (org.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"PurDiffAllocRptPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        HashSet orgIds = new HashSet();
        org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
        QFilter filter = new QFilter("org", "in", orgIds);
        if (!CollectionUtils.isEmpty((Collection)costCenter)) {
            HashSet centerId = new HashSet();
            costCenter.forEach(o -> centerId.add(o.getDynamicObject("fbasedataid").getLong("id")));
            filter.and(new QFilter("costcenter", "in", centerId));
        }
        if ("A".equals(bizstatus) || "B".equals(bizstatus)) {
            filter.and(new QFilter("bizstatus", "=", (Object)bizstatus));
        }
        listShowParameter.getListFilterParameter().getQFilters().add(filter);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
            return;
        }
        if ("exportexcel".equals(operateKey) && !PermItemCheckHelper.isPerm((String)this.getBillEntityId(), (String)"4730fc9f000004ae", (String)this.getView().getFormShowParameter().getAppId(), (Long)((DynamicObject)org.get(0)).getDynamicObject("fbasedataid").getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PurDiffAllocRptPlugin_13", (String)"macc-sca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"PurDiffAllocRptPlugin_10", (String)"macc-sca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"PurDiffAllocRptPlugin_12", (String)"macc-sca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getBillEntityId(), (IDataModel)this.getModel());
    }
}

