/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore.function;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffResultCompRptDealUnallocdiffFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private Set<String> amtCols = new HashSet<String>();
    private static final String[] qtyArray = new String[]{"startqty", "currqty", "compqty", "endqty", "totalqty"};
    private boolean isSetCompAmt = false;

    public DiffResultCompRptDealUnallocdiffFunction(Set<String> qtyCols, boolean isSetCompAmt) {
        this.amtCols.addAll(qtyCols);
        this.amtCols.removeAll(Arrays.asList(qtyArray));
        this.isSetCompAmt = isSetCompAmt;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public RowX map(RowX row) {
        int index = this.sourceRowMeta.getFieldIndex("isunallocdiff", false);
        if (index < 0) {
            return row;
        }
        String isunallocdiff = row.getString(index);
        if ("true".equals(isunallocdiff)) {
            isunallocdiff = "1";
        } else if ("false".equals(isunallocdiff)) {
            isunallocdiff = "0";
        }
        row.set(index, (Object)isunallocdiff);
        if (!this.isSetCompAmt) {
            return row;
        }
        if ("1".equals(row.getString(index)) && !"B".equals(row.getString(this.sourceRowMeta.getFieldIndex("producttype")))) {
            for (String col : this.amtCols) {
                if (!col.startsWith("comp")) continue;
                String colField = col.replace("comp", "");
                int comindex = this.sourceRowMeta.getFieldIndex("comp" + colField);
                int totalindex = this.sourceRowMeta.getFieldIndex("total" + colField);
                BigDecimal comamt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(comindex));
                if (comamt.compareTo(BigDecimal.ZERO) == 0) continue;
                row.set(comindex, (Object)BigDecimal.ZERO);
                BigDecimal totalamt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(totalindex));
                row.set(totalindex, (Object)totalamt.subtract(comamt));
            }
        }
        return row;
    }
}

