/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffResultCompRptResUnitFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private Set<String> showKeyCols;
    private int pricePrecision = 4;

    public DiffResultCompRptResUnitFunction(int pricePrecision, Set<String> showKeyCols) {
        this.showKeyCols = showKeyCols;
        this.pricePrecision = pricePrecision;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashSet<Long> materials = new HashSet<Long>(10);
        int materialIndex = this.getSourceRowMeta().getFieldIndex("material");
        int materialNumIndex = this.getSourceRowMeta().getFieldIndex("materialnum");
        int dataTypeIndex = this.getSourceRowMeta().getFieldIndex("datatype");
        int unitIndex = this.getSourceRowMeta().getFieldIndex("unit");
        ArrayList<RowX> targetRoxs = new ArrayList<RowX>(10);
        for (RowX rowX : iterable) {
            int productIndex;
            Long material;
            targetRoxs.add(rowX);
            if (!CadEmptyUtils.isEmpty((Long)rowX.getLong(unitIndex)) || !this.showKeyCols.contains("product") || materials.contains(material = rowX.getLong(productIndex = this.getSourceRowMeta().getFieldIndex("product")))) continue;
            materials.add(material);
        }
        Map<Long, String> matUnitMap = this.getMatUnitMap(materials);
        for (RowX rowX : targetRoxs) {
            Long unit = rowX.getLong(unitIndex);
            if (CadEmptyUtils.isEmpty((Long)unit)) {
                String[] split;
                String productInfo;
                int productIndex;
                Long product;
                String dataType = rowX.getString(dataTypeIndex);
                if (!"1".equals(dataType) && CadEmptyUtils.isEmpty((Long)rowX.getLong(materialIndex))) {
                    if (this.showKeyCols.contains("product") && matUnitMap.containsKey(product = rowX.getLong(productIndex = this.getSourceRowMeta().getFieldIndex("product")))) {
                        productInfo = matUnitMap.get(product);
                        split = productInfo.split("@");
                        rowX.set(materialIndex, (Object)product);
                        rowX.set(materialNumIndex, (Object)split[1]);
                    }
                    rowX.set(unitIndex, (Object)10L);
                    this.setQty("start", rowX);
                    this.setQty("curr", rowX);
                    this.setQty("comp", rowX);
                    this.setQty("end", rowX);
                    this.setQty("total", rowX);
                } else if (this.showKeyCols.contains("product") && matUnitMap.containsKey(product = rowX.getLong(productIndex = this.getSourceRowMeta().getFieldIndex("product"))) && matUnitMap.get(product) != null) {
                    productInfo = matUnitMap.get(product);
                    split = productInfo.split("@");
                    rowX.set(unitIndex, (Object)split[0]);
                }
            }
            collector.collect(rowX);
        }
    }

    private Map<Long, String> getMatUnitMap(Set<Long> materials) {
        QFilter filter = new QFilter("id", "in", materials);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getMatPrecisionMap", (String)"bd_material", (String)"id,number,baseunit", (QFilter[])new QFilter[]{filter}, null);
        HashMap<Long, String> matUnitMap = new HashMap<Long, String>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            matUnitMap.put(row.getLong("id"), row.getLong("baseunit") + "@" + row.getString("number"));
        }
        return matUnitMap;
    }

    private void setQty(String startPre, RowX paramRowX) {
        int qtyIndex = this.sourceRowMeta.getFieldIndex(String.format("%sqty", startPre));
        BigDecimal qty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)paramRowX.getBigDecimal(qtyIndex));
        BigDecimal newQty = qty.divide(new BigDecimal("60"), this.pricePrecision, 4);
        paramRowX.set(qtyIndex, (Object)newQty);
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }
}

