/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore.handle;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.exception.KDBizException;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.report.restore.function.DiffResultCompRptCalcSubTotalFunction;
import kd.macc.sca.report.restore.function.DiffResultCompRptCalcUnitFunction;
import kd.macc.sca.report.restore.function.DiffResultCompRptDealUnallocdiffFunction;
import kd.macc.sca.report.restore.model.DiffResultCompParam;

public class DiffResultCompRptHandleGroupRow
implements IDataXTransform {
    private DiffResultCompParam reportParam;
    private ReportDataCtx ctx;
    private DataSet costobejctCompDs;
    private static final String[] qtyArray = new String[]{"startqty", "currqty", "compqty", "endqty", "totalqty"};
    private static final String[] proQtyArray = new String[]{"prostartqty", "procurrqty", "procompqty", "proendqty", "prototalqty"};

    public DiffResultCompRptHandleGroupRow(DiffResultCompParam reportParam, ReportDataCtx ctx, DataSet costobejctCompDs) {
        this.ctx = ctx;
        this.reportParam = reportParam;
        this.costobejctCompDs = costobejctCompDs;
    }

    public DataSetX doTransform(DataSetX srcDataDsx) {
        DataSetX costobejctCompDsX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(this.costobejctCompDs));
        srcDataDsx = srcDataDsx.leftJoin(costobejctCompDsX).on("period", "period").on("costobject", "costobject").select(srcDataDsx.getRowMeta().getFieldNames(), proQtyArray);
        Set detailShowCols = this.ctx.getShowKeyCols();
        if (!this.reportParam.isDisplayUnallocDiff() || detailShowCols.contains("isunallocdiff")) {
            srcDataDsx = srcDataDsx.map((MapFunction)new DiffResultCompRptDealUnallocdiffFunction(this.ctx.getShowQtyCols(), !this.reportParam.isDisplayUnallocDiff()));
        }
        if (this.reportParam.isShowDetail()) {
            HashSet compShowCols = new HashSet(detailShowCols);
            compShowCols.removeAll(this.reportParam.getDetailCols());
            detailShowCols.removeAll(this.reportParam.getNeedClearFields());
            DataSetX detailDataDsx = this.groupSumAndMaxDeal(srcDataDsx, detailShowCols.toArray(new String[0]), this.ctx.getShowQtyCols().toArray(new String[0]), null);
            detailDataDsx = detailDataDsx.addFields(new Field[]{new Field("datatype", (DataType)DataType.StringType)}, new Object[]{"6"});
            DataSetX comtDataDsx = this.groupDeal(srcDataDsx, compShowCols.toArray(new String[0]), 2, proQtyArray);
            if (!CadEmptyUtils.isEmpty(this.reportParam.getNeedClearFields())) {
                compShowCols.removeAll(this.reportParam.getNeedClearFields());
                comtDataDsx = this.groupSumAndMaxDeal(comtDataDsx, compShowCols.toArray(new String[0]), proQtyArray, null);
            }
            comtDataDsx = comtDataDsx.addFields(new Field[]{new Field("datatype", (DataType)DataType.StringType)}, new Object[]{"1"});
            comtDataDsx = comtDataDsx.addFields(new Field[]{new Field("startqty", (DataType)DataType.BigDecimalType), new Field("currqty", (DataType)DataType.BigDecimalType), new Field("compqty", (DataType)DataType.BigDecimalType), new Field("endqty", (DataType)DataType.BigDecimalType), new Field("totalqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
            comtDataDsx = comtDataDsx.map(new MapFunction(){
                private static final long serialVersionUID = 1L;

                public RowMeta getResultRowMeta() {
                    return this.sourceRowMeta;
                }

                public RowX map(RowX paramRowX) {
                    for (String qtyField : qtyArray) {
                        paramRowX.set(this.sourceRowMeta.getFieldIndex(qtyField), (Object)BigDecimalUtils.getBigDecimalOrZero((BigDecimal)paramRowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("pro" + qtyField))));
                    }
                    return paramRowX;
                }
            });
            detailDataDsx = DataSetXHelper.unionIfRowDiff((DataSetX)detailDataDsx, (DataSetX)comtDataDsx);
            srcDataDsx = detailDataDsx.groupBy(compShowCols.toArray(new String[0])).reduceGroup((GroupReduceFunction)new DiffResultCompRptCalcSubTotalFunction(this.reportParam.getPricePrecision(), this.ctx.getShowQtyCols()));
        } else {
            srcDataDsx = this.groupSumAndMaxDeal(srcDataDsx, detailShowCols.toArray(new String[0]), this.ctx.getShowQtyCols().toArray(new String[0]), proQtyArray);
            detailShowCols.removeAll(this.reportParam.getNeedClearFields());
            srcDataDsx = srcDataDsx.map(new MapFunction(){
                private static final long serialVersionUID = 1L;

                public RowMeta getResultRowMeta() {
                    return this.sourceRowMeta;
                }

                public RowX map(RowX paramRowX) {
                    for (String qtyField : qtyArray) {
                        paramRowX.set(this.sourceRowMeta.getFieldIndex(qtyField), (Object)BigDecimalUtils.getBigDecimalOrZero((BigDecimal)paramRowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("pro" + qtyField))));
                    }
                    return paramRowX;
                }
            });
            srcDataDsx = this.groupSumAndMaxDeal(srcDataDsx, detailShowCols.toArray(new String[0]), this.ctx.getShowQtyCols().toArray(new String[0]), proQtyArray);
            srcDataDsx = srcDataDsx.map((MapFunction)new DiffResultCompRptCalcUnitFunction(this.reportParam.getPricePrecision()));
            srcDataDsx = srcDataDsx.addFields(new Field[]{new Field("datatype", (DataType)DataType.StringType)}, new Object[]{"1"});
        }
        return srcDataDsx;
    }

    private DataSetX groupDeal(DataSetX srcDataSetX, String[] groupArr, int oper, String[] operArr) {
        if (groupArr.length == 0) {
            throw new KDBizException("group field is null");
        }
        DataSetX dataDsx = null;
        Grouper detailGrouper = srcDataSetX.groupBy(groupArr);
        for (String showQtyCol : operArr) {
            if (oper == 1) {
                if (dataDsx == null) {
                    dataDsx = detailGrouper.sum(showQtyCol);
                    continue;
                }
                dataDsx = dataDsx.sum(showQtyCol);
                continue;
            }
            dataDsx = dataDsx == null ? detailGrouper.max(showQtyCol) : dataDsx.max(showQtyCol);
        }
        if (dataDsx == null) {
            return srcDataSetX;
        }
        return dataDsx;
    }

    private DataSetX groupSumAndMaxDeal(DataSetX srcDataSetX, String[] groupArr, String[] sumArr, String[] maxArr) {
        if (groupArr.length == 0) {
            throw new KDBizException("group field is null");
        }
        DataSetX dataDsx = null;
        Grouper detailGrouper = srcDataSetX.groupBy(groupArr);
        if (sumArr != null) {
            for (String showQtyCol : sumArr) {
                dataDsx = dataDsx == null ? detailGrouper.sum(showQtyCol) : dataDsx.sum(showQtyCol);
            }
        }
        if (maxArr != null) {
            for (String showQtyCol : maxArr) {
                dataDsx = dataDsx == null ? detailGrouper.max(showQtyCol) : dataDsx.max(showQtyCol);
            }
        }
        if (dataDsx == null) {
            return srcDataSetX;
        }
        return dataDsx;
    }
}

