/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore.handle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.Grouper;
import kd.bos.algox.MapFunction;
import kd.bos.exception.KDBizException;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.sca.report.restore.handle.DiffResultComRptDealSumInputFunction;
import kd.macc.sca.report.restore.model.DiffResultCompParam;
import org.apache.commons.lang.StringUtils;

public class DiffResultCompRptHandleYearFinishRow
implements IDataXTransform {
    private DiffResultCompParam reportParam;
    private ReportDataCtx ctx;

    public DiffResultCompRptHandleYearFinishRow(DiffResultCompParam reportParam, ReportDataCtx ctx) {
        this.reportParam = reportParam;
        this.ctx = ctx;
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (!this.reportParam.isViewTotal()) {
            return srcData;
        }
        ArrayList compFields = Lists.newArrayList((Object[])new String[]{"compqty", "compprice", "compamt", "compdiffqty", "compmadediff", "compmadeupamt", "compunjoindiffamt", "compstdcostupamt", "comporddiff", "compinvoicediff", "compfeediff", "compfalldiff", "compotherdiff", "compreservediffx", "compreservediffw", "compreservediffy", "compdiffsum", "compactprice", "compactcostupamt"});
        ArrayList yearCompFields = Lists.newArrayList((Object[])new String[]{"totalqty", "totalprice", "totalamt", "totaldiffqty", "totalmadediff", "totalmadeupamt", "totalunjoindiffamt", "totalstdcostupamt", "totalorddiff", "totalinvoicediff", "totalfeediff", "totalfalldiff", "totalotherdiff", "totalreservediffx", "totalreservediffw", "totalreservediffy", "totaldiffsum", "totalactprice", "totalactcostupamt"});
        HashMap<String, String> yearFinishMap = new HashMap<String, String>(16);
        int count = 0;
        for (String compField : compFields) {
            if (this.ctx.getShowQtyCols().contains(compField)) {
                yearFinishMap.put(compField, (String)yearCompFields.get(count));
            }
            ++count;
        }
        DataSetX curSrcData = srcData.filter("period in (" + StringUtils.join((Object[])this.reportParam.getPeriodIds().toArray(), (char)',') + ")");
        ArrayList<String> yearFinishFields = new ArrayList<String>(10);
        yearFinishFields.addAll(yearFinishMap.values());
        curSrcData = curSrcData.map((MapFunction)new DiffResultComRptDealSumInputFunction(yearFinishFields));
        HashSet groupCols = new HashSet(16);
        Set showKeyCols = this.ctx.getShowKeyCols();
        groupCols.addAll(showKeyCols);
        groupCols.remove("period");
        DataSetX periodX = null;
        for (Map.Entry<Long, Set<Long>> entry : this.reportParam.getPeriodYearMap().entrySet()) {
            if (CadEmptyUtils.isEmpty(entry.getValue())) continue;
            DataSetX yearData = srcData.filter("period in (" + StringUtils.join((Object[])entry.getValue().toArray(), (char)',') + ")");
            yearData = this.groupSumDeal(yearData, groupCols.toArray(new String[0]), yearFinishMap);
            yearData = yearData.addFields(new Field[]{new Field("period", (DataType)DataType.LongType)}, new Object[]{entry.getKey()});
            if (periodX == null) {
                periodX = yearData;
                continue;
            }
            periodX = periodX.union(yearData);
        }
        if (periodX != null) {
            curSrcData = DataSetXHelper.unionIfRowDiff((DataSetX)curSrcData, periodX);
            curSrcData = this.groupSumAndMaxDeal(curSrcData, this.ctx.getShowKeyCols().toArray(new String[0]), this.ctx.getShowQtyCols().toArray(new String[0]), null);
        }
        srcData = curSrcData;
        return srcData;
    }

    private DataSetX groupSumDeal(DataSetX srcDataSetX, String[] groupArr, Map<String, String> yearFinishMap) {
        if (groupArr.length == 0) {
            throw new KDBizException("group field is null");
        }
        DataSetX dataDsx = null;
        Grouper detailGrouper = srcDataSetX.groupBy(groupArr);
        if (yearFinishMap != null) {
            for (Map.Entry<String, String> yearFinish : yearFinishMap.entrySet()) {
                if (dataDsx == null) {
                    dataDsx = detailGrouper.sum(yearFinish.getKey(), yearFinish.getValue());
                    continue;
                }
                dataDsx = dataDsx.sum(yearFinish.getKey(), yearFinish.getValue());
            }
        }
        if (dataDsx == null) {
            return srcDataSetX;
        }
        return dataDsx;
    }

    private DataSetX groupSumAndMaxDeal(DataSetX srcDataSetX, String[] groupArr, String[] sumArr, String[] maxArr) {
        if (groupArr.length == 0) {
            throw new KDBizException("group field is null");
        }
        DataSetX dataDsx = null;
        Grouper detailGrouper = srcDataSetX.groupBy(groupArr);
        if (sumArr != null) {
            for (String showQtyCol : sumArr) {
                dataDsx = dataDsx == null ? detailGrouper.sum(showQtyCol) : dataDsx.sum(showQtyCol);
            }
        }
        if (maxArr != null) {
            for (String showQtyCol : maxArr) {
                dataDsx = dataDsx == null ? detailGrouper.max(showQtyCol) : dataDsx.max(showQtyCol);
            }
        }
        if (dataDsx == null) {
            return srcDataSetX;
        }
        return dataDsx;
    }
}

