/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore.handle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.Grouper;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.report.restore.function.DiffResultCompRptCalcUnitFunction;
import kd.macc.sca.report.restore.function.DiffRptCommonCalcDiffSumFunction;
import kd.macc.sca.report.restore.model.PurDiffAllocParam;
import kd.macc.sca.report.restore.query.PurDiffAllocSourceCf;

public class PurDiffAllocRptHandleSumRow
implements IDataXTransform {
    private PurDiffAllocParam reportParam;
    private ReportDataCtx ctx;

    public PurDiffAllocRptHandleSumRow(PurDiffAllocParam reportParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.reportParam = reportParam;
    }

    public DataSetX doTransform(DataSetX srcDataDsx) {
        srcDataDsx = srcDataDsx.addFields(new Field[]{new Field("sumnumo", (DataType)DataType.IntegerType), new Field("costcenternumo", (DataType)DataType.IntegerType), new Field("periodnumo", (DataType)DataType.IntegerType), new Field("allo", (DataType)DataType.IntegerType)}, new Object[]{0, 0, 0, 0});
        srcDataDsx = srcDataDsx.map(new MapFunction(){
            private static final long serialVersionUID = 1L;

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX paramRowX) {
                String datatype = paramRowX.getString(this.sourceRowMeta.getFieldIndex("datatype"));
                if (!"6".equals(datatype)) {
                    paramRowX.set(this.sourceRowMeta.getFieldIndex("sumnumo"), (Object)1);
                }
                return paramRowX;
            }
        });
        DataSetX compDataDsx = srcDataDsx.filter("datatype='1'");
        HashSet<String> groupCols = new HashSet<String>(this.ctx.getShowKeyCols());
        DataSetX costcenterDsx = null;
        if (groupCols.contains("costcenter")) {
            List<String> inKeys = this.getDownKeyCols("costcenter");
            groupCols.removeAll(inKeys);
            costcenterDsx = this.groupSumQtyField(compDataDsx, groupCols, this.ctx.getShowQtyCols(), "7", 0, 1, 0, 0);
            costcenterDsx = costcenterDsx.map((MapFunction)new DiffResultCompRptCalcUnitFunction(this.reportParam.getPricePrecision()));
            srcDataDsx = DataSetXHelper.unionIfRowDiff((DataSetX)srcDataDsx, (DataSetX)costcenterDsx);
        }
        DataSetX periodDsx = null;
        if (groupCols.contains("period")) {
            List<String> inKeys = this.getDownKeyCols("period");
            groupCols.removeAll(inKeys);
            periodDsx = costcenterDsx != null ? this.groupSumQtyField(costcenterDsx, groupCols, this.ctx.getShowQtyCols(), "8", 0, 0, 1, 0) : this.groupSumQtyField(compDataDsx, groupCols, this.ctx.getShowQtyCols(), "8", 0, 0, 1, 0);
            periodDsx = periodDsx.map((MapFunction)new DiffResultCompRptCalcUnitFunction(this.reportParam.getPricePrecision()));
            srcDataDsx = DataSetXHelper.unionIfRowDiff((DataSetX)srcDataDsx, (DataSetX)periodDsx);
        }
        DataSetX totalDsx = null;
        totalDsx = periodDsx != null ? periodDsx : (costcenterDsx != null ? costcenterDsx : compDataDsx);
        HashSet<String> groupFields = new HashSet<String>(16);
        groupFields.add("currency");
        totalDsx = this.groupSumQtyField(totalDsx, groupFields, this.ctx.getShowQtyCols(), "9", 0, 0, 0, 1);
        totalDsx = totalDsx.map((MapFunction)new DiffResultCompRptCalcUnitFunction(this.reportParam.getPricePrecision()));
        srcDataDsx = DataSetXHelper.unionIfRowDiff((DataSetX)srcDataDsx, (DataSetX)totalDsx);
        srcDataDsx = srcDataDsx.map((MapFunction)new DiffRptCommonCalcDiffSumFunction());
        List<String> orderFields = this.getSortField();
        return srcDataDsx.orderBy(orderFields.toArray(new String[0]));
    }

    private List<String> getSortField() {
        List<String> inKeys = this.getUpKeyCols("startqty");
        ArrayList<String> orderFields = new ArrayList<String>(10);
        orderFields.add("allo asc");
        List<String> notSortField = Arrays.asList("currency", "datatype", "unit");
        List<String> hasOrderField = Arrays.asList("period", "costcenter");
        List<String> descField = Collections.singletonList("producttype");
        for (String key : inKeys) {
            if (!this.ctx.getShowKeyCols().contains(key) || notSortField.contains(key) || key.startsWith("element") || key.startsWith("subelement")) continue;
            if (!PurDiffAllocSourceCf.ADD_NUM_FIELDS.contains(key)) {
                if (descField.contains(key)) {
                    orderFields.add(key + " desc");
                } else {
                    orderFields.add(key + " asc");
                }
            }
            if (!hasOrderField.contains(key)) continue;
            orderFields.add(key + "numo asc");
        }
        orderFields.add("sumnumo desc");
        return orderFields;
    }

    private List<String> getDownKeyCols(String inkey) {
        boolean isNeedJd = false;
        ArrayList<String> inKeys = new ArrayList<String>(10);
        for (String col : this.reportParam.getAllKeyCols()) {
            if (inkey.equals(col) || (inkey + "num").equals(col)) {
                isNeedJd = true;
                continue;
            }
            if (!isNeedJd) continue;
            inKeys.add(col);
        }
        return inKeys;
    }

    private List<String> getUpKeyCols(String inkey) {
        boolean isNeedJd = false;
        ArrayList<String> inKeys = new ArrayList<String>(10);
        for (String col : this.reportParam.getAllKeyCols()) {
            if (inkey.equals(col) || (inkey + "num").equals(col)) {
                isNeedJd = true;
                continue;
            }
            if (isNeedJd) continue;
            inKeys.add(col);
        }
        return inKeys;
    }

    private DataSetX groupSumQtyField(DataSetX srcDsx, Set<String> groupFields, Set<String> qtyFields, String datatype, int sumnumo, int costcenternumo, int periodnumo, int allo) {
        DataSetX sumDsx = null;
        Grouper grouper = srcDsx.groupBy(groupFields.toArray(new String[0]));
        for (String showQtyCol : qtyFields) {
            if (sumDsx == null) {
                sumDsx = grouper.sum(showQtyCol);
                continue;
            }
            sumDsx = sumDsx.sum(showQtyCol);
        }
        if (sumDsx == null) {
            sumDsx = srcDsx.filter("1!=1");
        }
        return sumDsx.addFields(new Field[]{new Field("datatype", (DataType)DataType.StringType), new Field("sumnumo", (DataType)DataType.IntegerType), new Field("costcenternumo", (DataType)DataType.IntegerType), new Field("periodnumo", (DataType)DataType.IntegerType), new Field("allo", (DataType)DataType.IntegerType)}, new Object[]{datatype, sumnumo, costcenternumo, periodnumo, allo});
    }
}

