/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IFilter;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.report.restore.handle.DiffResultCompRptHandleFinalRow;
import kd.macc.sca.report.restore.handle.DiffResultCompRptHandleGroupRow;
import kd.macc.sca.report.restore.handle.DiffResultCompRptHandleSumRow;
import kd.macc.sca.report.restore.handle.DiffResultCompRptHandleUnitRow;
import kd.macc.sca.report.restore.handle.DiffResultCompRptHandleYearFinishRow;
import kd.macc.sca.report.restore.model.DiffResultCompParam;
import kd.macc.sca.report.restore.model.PurDiffAllocRptConstant;
import org.apache.commons.lang.StringUtils;

public class DiffResultCompRptSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(DiffResultCompRptSourceCf.class);
    private DiffResultCompParam reportParam;
    public static final List<String> ADD_NUM_FIELDS = Arrays.asList("costcenter", "costobject", "product", "element", "subelement", "material", "materialgroup");

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.reportParam = (DiffResultCompParam)ctx.getParam(DiffResultCompParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
        this.dealDimension(ctx, this.reportParam);
    }

    private void dealDimension(ReportDataCtx ctx, DiffResultCompParam reportParam) {
        List<String> allkeyCols = DiffResultCompRptSourceCf.filterBigtableCols(ctx.getReportConf(), null);
        reportParam.setAllKeyCols(allkeyCols);
        boolean isNeedJd = false;
        for (String col : allkeyCols) {
            if ("element".equals(col) || "subelement".equals(col) || "elementnum".equals(col)) {
                isNeedJd = true;
            }
            if (!isNeedJd) continue;
            if (ctx.getShowKeyCols().contains(col)) {
                reportParam.setShowDetail(true);
            }
            reportParam.getDetailCols().add(col);
        }
        ctx.getShowKeyCols().add("currency");
        for (String field : ADD_NUM_FIELDS) {
            if (!ctx.getShowKeyCols().contains(field)) continue;
            ctx.getShowKeyCols().add(field + "num");
        }
        if (ctx.getShowKeyCols().contains("material")) {
            ctx.getShowKeyCols().add("unit");
        }
        if (ctx.getShowKeyCols().contains("materialgroup") && ctx.getShowKeyCols().add("material")) {
            ctx.getShowKeyCols().add("product");
            reportParam.getNeedClearFields().add("material");
            reportParam.getNeedClearFields().add("product");
        }
        if (ctx.getShowKeyCols().add("costobject")) {
            reportParam.getNeedClearFields().add("costobject");
        }
        if (ctx.getShowKeyCols().add("period")) {
            reportParam.getNeedClearFields().add("period");
        }
        if (ctx.getShowKeyCols().add("isunallocdiff")) {
            reportParam.getNeedClearFields().add("isunallocdiff");
        }
        if (!reportParam.isDisplayUnallocDiff() && ctx.getShowKeyCols().add("producttype")) {
            reportParam.getNeedClearFields().add("producttype");
        }
    }

    public static List<String> filterBigtableCols(ReportConf conf, IFilter<BigTableColConf> filter) {
        List bigTableColConf = conf.getBigTableColConf();
        ArrayList<String> fsCol = new ArrayList<String>(10);
        for (BigTableColConf colConf : bigTableColConf) {
            if (filter == null) {
                fsCol.add(colConf.getCol());
                continue;
            }
            if (!filter.filter((Object)colConf)) continue;
            fsCol.add(colConf.getCol());
        }
        return fsCol;
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("transFormAfterUnion\u591a\u4e2a\u6570\u636e\u5757union\u5b8c\u6210\u540e\u6267\u884c\uff0c\u53ef\u5728\u6b64\u6dfb\u52a0\u81ea\u5df1\u5b9e\u73b0\u7684IDataXTransform\u5904\u7406\u6570\u636e");
        ctx.logInfo((Object)ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u5757\u6570\u636e", (String)"DiffResultCompRptSourceCf_0", (String)"macc-sca-report", (Object[])new Object[0]));
        transCollector.add(new DiffResultCompRptHandleYearFinishRow(this.reportParam, ctx));
        transCollector.add(new DiffResultCompRptHandleFinalRow(this.reportParam, ctx));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        super.beforeGroupData(ctx);
        ctx.setGroupPlans(null);
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new DiffResultCompRptHandleGroupRow(this.reportParam, ctx, DiffResultCompRptSourceCf.getCostobjectCompDs(this.reportParam)));
        transCollector.add(new DiffResultCompRptHandleUnitRow(this.reportParam, ctx));
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new DiffResultCompRptHandleSumRow(this.reportParam, ctx));
    }

    private List<QFilter> getFixedFilter() {
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>(10);
        commonFilters.add(new QFilter("org", "in", this.reportParam.getOrgIds()));
        commonFilters.add(new QFilter("costaccount", "in", this.reportParam.getCostaccountIds()));
        List<Long> periodIds = this.reportParam.getPeriodIds();
        HashSet<Long> queryPeriodIds = new HashSet<Long>(periodIds);
        if (this.reportParam.isViewTotal()) {
            for (Long periodId : periodIds) {
                Set yearPeriodIds = PeriodHelper.getCurPeriodYear((Long)periodId);
                this.reportParam.getPeriodYearMap().put(periodId, yearPeriodIds);
                queryPeriodIds.addAll(yearPeriodIds);
            }
        }
        if (this.reportParam.isViewTotal()) {
            commonFilters.add(new QFilter("period", "in", queryPeriodIds));
        } else {
            commonFilters.add(new QFilter("period", ">=", (Object)this.reportParam.getStartperiod()));
            commonFilters.add(new QFilter("period", "<=", (Object)this.reportParam.getEndperiod()));
        }
        if (!CadEmptyUtils.isEmpty(this.reportParam.getCostobjectIds())) {
            Set<Long> objectIds = DiffResultCompRptSourceCf.getDiffCalcResultMainCostObjectId(commonFilters, this.reportParam.getCostobjectIds());
            this.reportParam.getCostobjectIds().clear();
            this.reportParam.getCostobjectIds().addAll(objectIds);
            commonFilters.add(new QFilter("maincostobject", "in", objectIds));
        }
        if (!CadEmptyUtils.isEmpty(this.reportParam.getCostcenterIds())) {
            commonFilters.add(new QFilter("costcenter", "in", this.reportParam.getCostcenterIds()));
        }
        if ("A".equals(this.reportParam.getBizstatus()) || "B".equals(this.reportParam.getBizstatus())) {
            commonFilters.add(new QFilter("bizstatus", "=", (Object)this.reportParam.getBizstatus()));
        }
        if (!CadEmptyUtils.isEmpty(this.reportParam.getProductIds())) {
            commonFilters.add(new QFilter("product", "in", this.reportParam.getProductIds()));
        }
        if (!CadEmptyUtils.isEmpty(this.reportParam.getMaterials())) {
            commonFilters.add(new QFilter("material", "in", this.reportParam.getMaterials()));
        }
        return commonFilters;
    }

    private static Set<Long> getDiffCalcResultMainCostObjectId(List<QFilter> filters, Object costobjectVal) {
        ArrayList<QFilter> csfilters = new ArrayList<QFilter>(filters);
        csfilters.add(new QFilter("entryentity1.relacostobject1", "in", costobjectVal));
        csfilters.add(new QFilter("entryentity1.type1", "=", (Object)"5"));
        DataSet ds = QueryServiceHelper.queryDataSet((String)"diffcalcresult", (String)"sca_diffcalcresult", (String)"costobject", (QFilter[])csfilters.toArray(new QFilter[0]), null);
        ds = ds.groupBy(new String[]{"costobject"}).finish();
        HashSet<Long> objectIds = new HashSet<Long>(16);
        for (Row row : ds) {
            objectIds.add(row.getLong("costobject"));
        }
        return objectIds;
    }

    private static DataSet getCostobjectCompDs(DiffResultCompParam reportParam) {
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>(10);
        commonFilters.add(new QFilter("org", "in", reportParam.getOrgIds()));
        commonFilters.add(new QFilter("costaccount", "in", reportParam.getCostaccountIds()));
        HashSet<Long> queryPeriodIds = new HashSet<Long>(10);
        if (reportParam.isViewTotal()) {
            for (Map.Entry<Long, Set<Long>> entry : reportParam.getPeriodYearMap().entrySet()) {
                Set<Long> periodIds = entry.getValue();
                if (CadEmptyUtils.isEmpty(periodIds)) continue;
                queryPeriodIds.addAll(periodIds);
            }
        }
        if (reportParam.isViewTotal()) {
            commonFilters.add(new QFilter("period", "in", queryPeriodIds));
        } else {
            commonFilters.add(new QFilter("period", ">=", (Object)reportParam.getStartperiod()));
            commonFilters.add(new QFilter("period", "<=", (Object)reportParam.getEndperiod()));
        }
        if (!CadEmptyUtils.isEmpty(reportParam.getCostobjectIds())) {
            commonFilters.add(new QFilter("costobject", "in", reportParam.getCostobjectIds()));
        }
        commonFilters.add(new QFilter("entryentity1.type1", "=", (Object)"5"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"diffcalcresult", (String)"sca_diffcalcresult", (String)"period,entryentity1.relacostobject1 costobject,entryentity1.material1 material,entryentity1.baseunit1 unit,entryentity1.startqty1 prostartqty,entryentity1.currqty1 procurrqty,entryentity1.compqty1 procompqty,entryentity1.endqty1 proendqty,0.00 prototalqty", (QFilter[])commonFilters.toArray(new QFilter[0]), null);
        if (reportParam.isViewTotal()) {
            DataSet curDataSet = dataSet.copy().filter("period in (" + StringUtils.join((Object[])reportParam.getPeriodIds().toArray(), (char)',') + ")");
            DataSet periodDataSet = null;
            for (Map.Entry<Long, Set<Long>> entry : reportParam.getPeriodYearMap().entrySet()) {
                if (CadEmptyUtils.isEmpty(entry.getValue())) continue;
                DataSet copyDataSet = dataSet.copy();
                DataSet yearData = copyDataSet.filter("period in (" + StringUtils.join((Object[])entry.getValue().toArray(), (char)',') + ")");
                yearData = yearData.groupBy(new String[]{"costobject", "material", "unit"}).sum("procompqty", "prototalqty").finish();
                yearData = yearData.select(entry.getKey().toString() + "L as period,costobject,material,unit,0.00 prostartqty,0.00 procurrqty,0.00 procompqty,0.00 proendqty,prototalqty");
                if (periodDataSet == null) {
                    periodDataSet = yearData;
                    continue;
                }
                periodDataSet = periodDataSet.union(yearData);
            }
            dataSet = curDataSet.union(periodDataSet);
            dataSet = dataSet.groupBy(new String[]{"period", "costobject", "material", "unit"}).sum("prostartqty").sum("procurrqty").sum("procompqty").sum("proendqty").sum("prototalqty").finish();
        }
        return dataSet;
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u914d\u7f6e\u5217\u662f\u5426\u663e\u793a ");
        ReportColumnGroup startdiff = new ReportColumnGroup();
        startdiff.setCaption(new LocaleString(ResManager.loadKDString((String)"\u671f\u521d\u5728\u4ea7\u54c1", (String)"DiffResultCompRptSourceCf_1", (String)"macc-sca-report", (Object[])new Object[0])));
        startdiff.setFieldKey("startdiff");
        ReportColumnGroup currdiff = new ReportColumnGroup();
        currdiff.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u6295\u5165", (String)"DiffResultCompRptSourceCf_2", (String)"macc-sca-report", (Object[])new Object[0])));
        currdiff.setFieldKey("currdiff");
        ReportColumnGroup compdiff = new ReportColumnGroup();
        compdiff.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u5b8c\u5de5", (String)"DiffResultCompRptSourceCf_3", (String)"macc-sca-report", (Object[])new Object[0])));
        compdiff.setFieldKey("compdiff");
        ReportColumnGroup enddiff = new ReportColumnGroup();
        enddiff.setCaption(new LocaleString(ResManager.loadKDString((String)"\u671f\u672b\u5728\u4ea7", (String)"DiffResultCompRptSourceCf_4", (String)"macc-sca-report", (Object[])new Object[0])));
        enddiff.setFieldKey("enddiff");
        ReportColumnGroup totaldiff = new ReportColumnGroup();
        totaldiff.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5", (String)"DiffResultCompRptSourceCf_5", (String)"macc-sca-report", (Object[])new Object[0])));
        totaldiff.setFieldKey("totaldiff");
        Iterator<AbstractReportColumn> iterator = cols.iterator();
        while (iterator.hasNext()) {
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            if (!this.reportParam.getDiffTypes().contains("P") && PurDiffAllocRptConstant.diffTypes_P_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("Q") && PurDiffAllocRptConstant.diffTypes_Q_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("S") && PurDiffAllocRptConstant.diffTypes_S_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("R") && PurDiffAllocRptConstant.diffTypes_R_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("M") && PurDiffAllocRptConstant.diffTypes_M_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("G") && PurDiffAllocRptConstant.diffTypes_G_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("H") && PurDiffAllocRptConstant.diffTypes_H_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("K") && PurDiffAllocRptConstant.diffTypes_K_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("C") && PurDiffAllocRptConstant.diffTypes_C_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("T") && PurDiffAllocRptConstant.diffTypes_T_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("X") && PurDiffAllocRptConstant.diffTypes_X_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("W") && PurDiffAllocRptConstant.diffTypes_W_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("Y") && PurDiffAllocRptConstant.diffTypes_Y_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if ("currency".equals(fieldKey)) {
                repCol.setHide(true);
            }
            if ("endprice".equals(fieldKey) || "endamt".equals(fieldKey)) {
                repCol.setHide(true);
            }
            if ("startprice".equals(fieldKey) || "startamt".equals(fieldKey)) {
                repCol.setHide(true);
            }
            if (PurDiffAllocRptConstant.qtyField.contains(fieldKey) && ctx.getShowKeyCols().contains("unit")) {
                repCol.setMeasureUnitField("unit");
            }
            if ("amount".equals(repCol.getFieldType()) && ctx.getShowKeyCols().contains("currency")) {
                repCol.setCurrencyField("currency");
            }
            if (fieldKey.startsWith("start")) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                startdiff.getChildren().add(repCol);
                iterator.remove();
            }
            if (fieldKey.startsWith("curr") && !"currency".equals(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                currdiff.getChildren().add(repCol);
                iterator.remove();
            }
            if (fieldKey.startsWith("comp")) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                compdiff.getChildren().add(repCol);
                iterator.remove();
            }
            if (fieldKey.startsWith("end")) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                enddiff.getChildren().add(repCol);
                iterator.remove();
            }
            if (!fieldKey.startsWith("total")) continue;
            repCol.setNoDisplayScaleZero(false);
            repCol.setZeroShow(false);
            repCol.setHideSingleColumnRow(false);
            totaldiff.getChildren().add(repCol);
            iterator.remove();
        }
        cols.add((AbstractReportColumn)startdiff);
        cols.add((AbstractReportColumn)currdiff);
        cols.add((AbstractReportColumn)compdiff);
        if (!totaldiff.getChildren().isEmpty() && this.reportParam.isViewTotal()) {
            cols.add((AbstractReportColumn)totaldiff);
        }
        cols.add((AbstractReportColumn)enddiff);
        return cols;
    }
}

