/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.checkdata;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.business.checkdata.CheckDataTask;
import kd.macc.sca.business.checkdata.CheckDataTaskEntry;
import kd.macc.sca.business.checkdata.ExceptionObj;
import kd.macc.sca.business.checkdata.ResultStatus;
import kd.macc.sca.business.checkdata.RunningStatus;

public class CheckDataResult {
    protected static final Log logger = LogFactory.getLog(CheckDataResult.class);
    private static final String RUNNING_STATUS = "A";
    private static final String COMPLETED_STATUS = "B";
    private DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"sca_datacheckresult");

    public CheckDataResult(CheckDataTask task) {
        this.result.set("checktask", (Object)task.getTaskId());
        this.result.set("user", (Object)RequestContext.get().getUserId());
        this.result.set("checktime", (Object)new Date());
        this.result.set("status", (Object)RUNNING_STATUS);
        this.result.set("appnum", (Object)task.getAppNum());
        DynamicObjectCollection col = this.result.getDynamicObjectCollection("entryentity");
        for (CheckDataTaskEntry entry : task.getCheckTaskEntry()) {
            DynamicObject resultEntry = col.addNew();
            resultEntry.set("checkitem", (Object)entry.getCheckItemId());
            resultEntry.set("runingstatus", (Object)RunningStatus.WAITING.getValue());
        }
        this.updateDB();
    }

    public void beginRun(Long checkItemId) {
        for (DynamicObject resultEntry : this.result.getDynamicObjectCollection("entryentity")) {
            if (!checkItemId.equals(resultEntry.getLong("checkitem_id"))) continue;
            resultEntry.set("runingstatus", (Object)RunningStatus.RUNNING.getValue());
        }
        this.updateDB();
    }

    public void dealRuntimeException(Long checkItemId, String description, boolean isLastItem) {
        this.updateCheckResult(checkItemId, ResultStatus.EXCEPTION, RunningStatus.COMPLETED, description, null, isLastItem);
    }

    public void afterRun(Long checkItemId, ResultStatus status, String description, List<ExceptionObj> exceptionList, boolean isLastItem) {
        this.updateCheckResult(checkItemId, status, RunningStatus.COMPLETED, description, exceptionList, isLastItem);
    }

    private void updateCheckResult(Long checkItemId, ResultStatus status, RunningStatus runStatus, String description, List<ExceptionObj> exceptionList, boolean isLastItem) {
        for (DynamicObject resultEntry : this.result.getDynamicObjectCollection("entryentity")) {
            if (!checkItemId.equals(resultEntry.getLong("checkitem_id"))) continue;
            if (status != null) {
                resultEntry.set("entrystatus", (Object)status.getValue());
            }
            if (runStatus != null) {
                resultEntry.set("runingstatus", (Object)runStatus.getValue());
            }
            if (ResultStatus.SUCCESS == status) {
                description = ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u6210\u529f\uff0c\u65e0\u975e\u6cd5\u6570\u636e\u3002", (String)"CheckDataResult_0", (String)"macc-sca-business", (Object[])new Object[0]);
            }
            resultEntry.set("description", (Object)description);
            if (exceptionList == null || exceptionList.isEmpty()) break;
            DynamicObjectCollection resultDetail = resultEntry.getDynamicObjectCollection("subentryentity");
            for (ExceptionObj obj : exceptionList) {
                DynamicObject detail = resultDetail.addNew();
                detail.set("objid", (Object)obj.getId());
                detail.set("objtype", (Object)obj.getEntityType());
                detail.set("objdes", (Object)obj.getDescription());
                detail.set("extralinfo", (Object)obj.getExtralInfo());
                detail.set("isrepaired", (Object)Boolean.FALSE);
            }
        }
        if (isLastItem) {
            this.result.set("status", (Object)COMPLETED_STATUS);
        }
        this.updateDB();
    }

    private void updateDB() {
        try (TXHandle handle = TX.requiresNew();){
            this.result = (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.result})[0];
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
    }
}

