/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.checkdata;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.macc.sca.business.checkdata.CheckDataParam;
import kd.macc.sca.business.checkdata.CheckDataResult;
import kd.macc.sca.business.checkdata.CheckDataTask;
import kd.macc.sca.business.checkdata.CheckDataTaskEntry;
import kd.macc.sca.business.checkdata.ExceptionObj;
import kd.macc.sca.business.checkdata.OperateLevel;
import kd.macc.sca.business.checkdata.ResultStatus;
import kd.macc.sca.business.checkdata.item.IDataCheck;

public class CheckDataTaskExecutor {
    private static final Log logger = LogFactory.getLog(CheckDataTaskExecutor.class);

    public CheckDataResult commitSync(CheckDataTask task, CheckDataParam param) {
        CheckDataResult result = new CheckDataResult(task);
        List<CheckDataTaskEntry> entryList = task.getCheckTaskEntry();
        int size = entryList.size();
        for (int i = 0; i < size; ++i) {
            boolean isLastItem = i == size - 1;
            CheckDataTaskEntry entry = entryList.get(i);
            List<ExceptionObj> objList = null;
            result.beginRun(entry.getCheckItemId());
            IDataCheck dataCheck = null;
            try {
                dataCheck = entry.createDataCheck();
                objList = dataCheck.collectExceptionObj(param);
            }
            catch (Exception e) {
                result.dealRuntimeException(entry.getCheckItemId(), e.getClass().getName() + ":" + e.getMessage(), isLastItem);
                if (dataCheck == null) continue;
                logger.error("\u68c0\u67e5\u63d2\u4ef6" + dataCheck.getClass().getName() + "\u8fd0\u884c\u5f02\u5e38", (Throwable)e);
                continue;
            }
            if (objList == null || objList.isEmpty()) {
                result.afterRun(entry.getCheckItemId(), ResultStatus.SUCCESS, entry.getTips(), objList, isLastItem);
                continue;
            }
            ResultStatus status = null;
            status = OperateLevel.ERROR == entry.getAlarmLevel() ? ResultStatus.ERROR : ResultStatus.WARNING;
            result.afterRun(entry.getCheckItemId(), status, entry.getTips(), objList, isLastItem);
        }
        return result;
    }

    public void commit(final CheckDataTask task, final CheckDataParam param) {
        ThreadPools.executeOnce((String)"kd.macc.sca.business.checkdata.CheckDataTaskExecutor", (Runnable)new Runnable(){

            @Override
            public void run() {
                CheckDataTaskExecutor.this.commitSync(task, param);
            }
        });
    }
}

