/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.checkdata.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.sca.business.checkdata.CheckDataParam;
import kd.macc.sca.business.checkdata.ExceptionObj;
import kd.macc.sca.business.checkdata.item.DataEntityDataCheck;
import kd.macc.sca.business.checkdata.item.IDataCheck;

public class CostCloseAccount
extends DataEntityDataCheck
implements IDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(CheckDataParam param) {
        ArrayList<ExceptionObj> list = new ArrayList<ExceptionObj>(16);
        Set calOrgIds = StartCostHelper.getEnabledOrg((String)param.getAppNum());
        if (calOrgIds.size() == 0) {
            return list;
        }
        QFilter qfCalOrg = new QFilter("calorg", "in", (Object)calOrgIds);
        QFilter qfEnable = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter qfEnableStardardCost = new QFilter("enablestandardcost", "=", (Object)"sca".equals(param.getAppNum()));
        String selectFields = "id,name,calorg,calsystem";
        DynamicObjectCollection costAccount = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)selectFields, (QFilter[])new QFilter[]{qfCalOrg, qfEnable, qfEnableStardardCost});
        selectFields = "entry.costaccount AS costaccount,entry.calpolicy.periodtype.id AS periodtypeid";
        QFilter qfIsEnable = new QFilter("entry.isenabled", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection sysCtrlEntity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)selectFields, (QFilter[])new QFilter[]{qfIsEnable});
        if (sysCtrlEntity.size() == 0) {
            return list;
        }
        HashMap<Long, Long> sysCtrlIds = new HashMap<Long, Long>(16);
        for (DynamicObject ctrl : sysCtrlEntity) {
            sysCtrlIds.put(ctrl.getLong("costaccount"), ctrl.getLong("periodtypeid"));
        }
        Date curDate = CostCloseAccount.getFirstDayDateOfMonth(param.getExecuteDate());
        QFilter qfPeriodType = new QFilter("periodtype", "in", sysCtrlIds.values());
        QFilter qfBeginDate = new QFilter("begindate", "<=", (Object)curDate);
        QFilter qfEndDate = new QFilter("enddate", ">", (Object)curDate);
        selectFields = "periodtype,periodnumber,begindate,enddate";
        DynamicObjectCollection period = QueryServiceHelper.query((String)"bd_period", (String)selectFields, (QFilter[])new QFilter[]{qfPeriodType, qfBeginDate, qfEndDate});
        HashMap<Long, DynamicObject> periodInfo = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject pd : period) {
            periodInfo.put(pd.getLong("periodtype"), pd);
        }
        HashSet<Long> orgIds = new HashSet<Long>(16);
        costAccount.forEach(p -> orgIds.add(p.getLong("calorg")));
        DynamicObjectCollection accSysColl = this.getAccountSys(orgIds);
        if (accSysColl.size() == 0) {
            return list;
        }
        HashSet<Long> ownerIdSet = new HashSet<Long>();
        for (DynamicObject accSysInfo : accSysColl) {
            ownerIdSet.add(accSysInfo.getLong("ownerid"));
        }
        Map<String, Date> map = this.getCloseAccount(ownerIdSet);
        if (map.size() == 0) {
            return list;
        }
        HashMap<String, Date> curCloseAccount = new HashMap<String, Date>(16);
        String splitSign = "@";
        for (DynamicObject accSys : accSysColl) {
            Date colseDate = map.get(accSys.getString("ownerid"));
            if (colseDate == null) continue;
            curCloseAccount.put(accSys.getString("id") + splitSign + accSys.getString("calorgid"), colseDate);
        }
        ExceptionObj exceObj = null;
        String tip = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\uff1a%s \u6ca1\u6709\u5173\u8d26\u3002", (String)"CostCloseAccount_0", (String)"macc-sca-business", (Object[])new Object[0]);
        Long costAccountId = 0L;
        for (DynamicObject account : costAccount) {
            DynamicObject periodType;
            Long periodTypeId;
            costAccountId = account.getLong("id");
            String sysOrg = account.getString("calsystem") + splitSign + account.getString("calorg");
            Date closeDate = (Date)curCloseAccount.get(sysOrg);
            if (closeDate == null || (periodTypeId = (Long)sysCtrlIds.get(costAccountId)) == null || (periodType = (DynamicObject)periodInfo.get(periodTypeId)) == null || closeDate.compareTo(periodType.getDate("begindate")) >= 0) continue;
            list.add(this.setException(exceObj, tip, account));
        }
        return list;
    }

    private Map<String, Date> getCloseAccount(Set<Long> owners) {
        QFilter qfOwner = new QFilter("owner", "in", owners);
        QFilter qfIsLeaf = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_closeaccounttable", (String)"owner,closedate", (QFilter[])new QFilter[]{qfOwner, qfIsLeaf});
        HashMap<String, Date> map = new HashMap<String, Date>(16);
        for (DynamicObject info : infos) {
            map.put(info.getDynamicObject("owner").getPkValue().toString(), info.getDate("closedate"));
        }
        return map;
    }

    private DynamicObjectCollection getAccountSys(Set<Long> orgIds) {
        QFilter qfBizOrg = new QFilter("bizorgentry.bizorg", "<>", (Object)0L);
        if (orgIds != null) {
            qfBizOrg.and("bizorgentry.bizacctorg", "in", orgIds);
        }
        String selectFields = "id,bizorgentry.bizorg as ownerid,bizorgentry.bizacctorg as calorgid";
        return QueryServiceHelper.query((String)"bd_accountingsys", (String)selectFields, (QFilter[])new QFilter[]{qfBizOrg}, null);
    }

    private ExceptionObj setException(ExceptionObj exceObj, String tip, DynamicObject account) {
        exceObj = new ExceptionObj(0L, "cal_bd_costaccount");
        exceObj.setDescription(String.format(tip, account.getString("name")));
        exceObj.setExtralInfo(account.getString("id"));
        return exceObj;
    }
}

