/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.checkdata.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.business.checkdata.CheckDataParam;
import kd.macc.sca.business.checkdata.ExceptionObj;
import kd.macc.sca.business.checkdata.item.DataEntityDataCheck;
import kd.macc.sca.business.checkdata.item.IDataCheck;

public class PlannedBillAndMfgOrder
extends DataEntityDataCheck
implements IDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(CheckDataParam param) {
        QFilter qfAppNum;
        QFilter qfSoType;
        ArrayList<ExceptionObj> list = new ArrayList<ExceptionObj>(16);
        Date date = PlannedBillAndMfgOrder.getFirstDayDateOfMonth(param.getExecuteDate());
        QFilter qfBizDate = new QFilter("bizdate", ">=", (Object)date);
        DynamicObjectCollection plannedBill = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"costobject.srcbillnumber srcbillnumber,costobject.srcbillrow srcbillrow,costobject.material.masterid material,bizdate,qty", (QFilter[])new QFilter[]{qfBizDate, qfSoType = new QFilter("costobject.sotype", "=", (Object)"PB"), qfAppNum = new QFilter("appnum", "=", (Object)param.getAppNum())});
        if (plannedBill.size() == 0) {
            return list;
        }
        HashSet planInfos = new HashSet();
        String splitSign = "@";
        plannedBill.forEach(p -> planInfos.add(p.getString("srcbillnumber") + splitSign + p.getString("srcbillrow") + splitSign + p.getString("material") + splitSign + p.getString("bizdate") + splitSign + p.getString("qty")));
        HashSet orderNos = new HashSet();
        plannedBill.forEach(p -> orderNos.add(p.getString("srcbillnumber")));
        QFilter qfBillNo = new QFilter("billno", "in", orderNos);
        QFilter qfCreateTime = new QFilter("createtime", ">=", (Object)date);
        QFilter qfPlanStatus = new QFilter("treeentryentity.taskstatus", "!=", (Object)"A");
        DynamicObjectCollection mfgOrder = QueryServiceHelper.query((String)"pom_mftorder", (String)"billno,treeentryentity.seq seq,treeentryentity.material.masterid material,createtime,treeentryentity.qty qty", (QFilter[])new QFilter[]{qfBillNo, qfCreateTime, qfPlanStatus});
        HashSet orderInfos = new HashSet();
        mfgOrder.forEach(p -> orderInfos.add(p.getString("billno") + splitSign + p.getString("seq") + splitSign + p.getString("material") + splitSign + p.getString("createtime") + splitSign + p.getString("qty")));
        String tip1 = ResManager.loadKDString((String)"\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u5f52\u96c6\u4e0e\u751f\u4ea7\u5de5\u5355\u7684\u6570\u636e\u4e0d\u4e00\u81f4\u3002", (String)"PlannedBillAndMfgOrder_0", (String)"macc-sca-business", (Object[])new Object[0]);
        String tip2 = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u884c\u53f7\uff1a%2$s", (String)"PlannedBillAndMfgOrder_1", (String)"macc-sca-business", (Object[])new Object[0]);
        ExceptionObj exceObj = null;
        for (String planInfo : planInfos) {
            if (orderInfos.size() > 0 && orderInfos.contains(planInfo)) continue;
            exceObj = new ExceptionObj(0L, "cad_plannedoutputbill");
            exceObj.setDescription(tip1);
            String[] infos = planInfo.split(splitSign);
            if (infos == null || infos.length != 5) continue;
            exceObj.setExtralInfo(String.format(tip2, infos[0], infos[1]));
            list.add(exceObj);
        }
        return list;
    }
}

