/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.checkdata.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.business.checkdata.CheckDataParam;
import kd.macc.sca.business.checkdata.ExceptionObj;
import kd.macc.sca.business.checkdata.item.DataEntityDataCheck;
import kd.macc.sca.business.checkdata.item.IDataCheck;

public class PlannedBillHasStdCost
extends DataEntityDataCheck
implements IDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(CheckDataParam param) {
        ArrayList<ExceptionObj> list = new ArrayList<ExceptionObj>(16);
        Date date = PlannedBillHasStdCost.getFirstDayDateOfMonth(param.getExecuteDate());
        QFilter qfBizDate = new QFilter("bizdate", ">=", (Object)date);
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)param.getAppNum());
        String selectFields = "billno,costobject.name AS costobjectname,costobject.material.name AS materialname,costobject.material.masterid AS material";
        DynamicObjectCollection planned = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{qfBizDate, qfBillStatus, qfAppNum});
        if (planned.size() == 0) {
            return list;
        }
        HashSet materialIds = new HashSet(16);
        QFilter qfMaterial = new QFilter("material", "in", materialIds);
        selectFields = "material.masterid AS material";
        DynamicObjectCollection matCostInfo = QueryServiceHelper.query((String)"cad_matcostinfo", (String)selectFields, (QFilter[])new QFilter[]{qfMaterial});
        HashSet matIds = new HashSet(16);
        matCostInfo.forEach(p -> matIds.add(p.getLong("material")));
        String tip = ResManager.loadKDString((String)"\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u5355\u636e\u7f16\u53f7\uff1a%1$s \u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff1a%2$s \u7269\u6599\uff1a%3$s \u65e0\u7269\u6599\u6210\u672c\u4fe1\u606f\u3002", (String)"PlannedBillHasStdCost_0", (String)"macc-sca-business", (Object[])new Object[0]);
        ExceptionObj exceObj = null;
        for (DynamicObject plan : planned) {
            if (matIds.contains(plan.getLong("material"))) continue;
            exceObj = new ExceptionObj(0L, "cad_plannedoutputbill");
            exceObj.setDescription(String.format(tip, plan.getString("billno"), plan.getString("costobjectname"), plan.getString("materialname")));
            exceObj.setExtralInfo(plan.getString("material"));
            list.add(exceObj);
        }
        return list;
    }
}

