/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.Data.Material;
import kd.macc.cad.algox.StandCostCalculateService;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.common.helper.MaterialRangeImportHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.helper.MaterialRangeCalcHelper;
import kd.macc.sca.mservice.MaterialRangeCalcService;

public class MaterialRangeCalcServiceImpl
implements MaterialRangeCalcService {
    private static final Log LOG = LogFactory.getLog(MaterialRangeCalcServiceImpl.class);
    private static final String SEL_FIELD_AUTO_CALC = "id,material,materialattr,configmat";

    public int doMaterialRangeCalculate(List<Long> idList, Long produceOrgId) {
        long taskId = 0L;
        try {
            Map<Boolean, List<Long>> resultMap = MaterialRangeCalcServiceImpl.queryMaterialRangeImport(idList);
            if (CadEmptyUtils.isEmpty(resultMap)) {
                LOG.info("doMaterialRangeCalculate end produceOrgId={}, resultMap is empty", (Object)produceOrgId);
            }
            int totalSuccess = 0;
            for (Map.Entry<Boolean, List<Long>> entry : resultMap.entrySet()) {
                QFilter qFilterBatch;
                DynamicObjectCollection dynamicObjects;
                Long routeRuleSettingId;
                List<Long> ids = entry.getValue();
                if (CadEmptyUtils.isEmpty((Long)produceOrgId)) {
                    LOG.error("doMaterialRangeCalculate start process error.produceOrgId is empty");
                    return 0;
                }
                LOG.info("doMaterialRangeCalculate start process ,prodOrgId={}", (Object)produceOrgId);
                Long mockCostType = MaterialRangeCalcHelper.getMockCostTypeByProduceOrgId((Long)produceOrgId);
                if (CadEmptyUtils.isEmpty((Long)mockCostType)) {
                    LOG.info("doMaterialRangeCalculate end produceOrgId={}, mockCostType is empty", (Object)produceOrgId);
                    return 0;
                }
                Long rulePlanId = MaterialRangeCalcHelper.getRulePlanIdByCostType((Long)mockCostType);
                if (CadEmptyUtils.isEmpty((Long)rulePlanId)) {
                    LOG.info("doMaterialRangeCalculate end mockCostType={}, rulePlanId is empty", (Object)mockCostType);
                    return 0;
                }
                Long boolRuleId = MaterialRangeCalcHelper.getBoomRuleIdByCostType((Long)mockCostType);
                if (CadEmptyUtils.isEmpty((Long)boolRuleId)) {
                    LOG.info("doMaterialRangeCalculate task mockCostType={}, boolRuleId is empty", (Object)mockCostType);
                    if (!entry.getKey().booleanValue()) continue;
                }
                if (CadEmptyUtils.isEmpty((Long)(routeRuleSettingId = MaterialRangeCalcHelper.getRouteRuleSettingIdByCostType((Long)mockCostType)))) {
                    LOG.info("doMaterialRangeCalculate task mockCostType={}, routeRuleSettingId is empty", (Object)mockCostType);
                    if (!entry.getKey().booleanValue()) continue;
                }
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)(dynamicObjects = QueryServiceHelper.query((String)"cad_autocalcmatrange", (String)SEL_FIELD_AUTO_CALC, (QFilter[])(qFilterBatch = new QFilter("id", "in", ids)).toArray())))) {
                    LOG.error("doMaterialRangeCalculate task fail, material range data is empty,produceOrgId={},materialIdList={}", (Object)produceOrgId, ids);
                    return 0;
                }
                int success = this.doCheckCalculate(dynamicObjects, rulePlanId, mockCostType, boolRuleId, routeRuleSettingId, ids, entry.getKey());
                totalSuccess += success;
            }
            return totalSuccess;
        }
        catch (Exception e) {
            LOG.error("doMaterialRangeCalculate task fail produceOrgId={},taskId={}", new Object[]{produceOrgId, taskId, e});
            return 0;
        }
    }

    public static Map<Boolean, List<Long>> queryMaterialRangeImport(List<Long> idList) {
        QFilter qFilter = new QFilter("id", "in", idList);
        DataSet dataSetDb = QueryServiceHelper.queryDataSet((String)MaterialRangeImportHelper.class.getName(), (String)"cad_autocalcmatrange", (String)"id,configmat", (QFilter[])qFilter.toArray(), null);
        if (dataSetDb == null || dataSetDb.isEmpty()) {
            return new HashMap<Boolean, List<Long>>();
        }
        HashMap<Boolean, List<Long>> resultMap = new HashMap<Boolean, List<Long>>(2);
        dataSetDb.forEach(item -> {
            ArrayList<Long> tempList = (ArrayList<Long>)resultMap.get(item.getBoolean("configmat"));
            if (CadEmptyUtils.isEmpty((List)tempList)) {
                tempList = new ArrayList<Long>();
            }
            tempList.add(item.getLong("id"));
            resultMap.put(item.getBoolean("configmat"), tempList);
        });
        return resultMap;
    }

    private List<Material> getMaterialInfoList(DynamicObjectCollection dynamicObjects) {
        ArrayList<Material> materialList = new ArrayList<Material>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            Material material = new Material();
            if (CadEmptyUtils.isEmpty((Long)dynamicObject.getLong("material")) || CadEmptyUtils.isEmpty((String)dynamicObject.getString("materialattr"))) continue;
            material.setMaterialId(dynamicObject.getLong("material"));
            material.setMaterialAttr(dynamicObject.getString("materialattr"));
            material.setKeycol();
            materialList.add(material);
        }
        return materialList;
    }

    public int doCheckCalculate(DynamicObjectCollection dynamicObjectCollection, Long rulePlanId, Long mockCostType, Long boolRuleId, Long routeRuleSettingId, List<Long> idList, boolean configAttr) {
        List<Material> materialList = this.getMaterialInfoList(dynamicObjectCollection);
        StandCostCalcParam standCostCalcParam = new StandCostCalcParam();
        standCostCalcParam.setMaterials(materialList);
        standCostCalcParam.setCalcDate(new Date());
        standCostCalcParam.setCalcCurLevel(Boolean.TRUE.booleanValue());
        standCostCalcParam.setPriceRuleScheme(rulePlanId);
        standCostCalcParam.setCostTypeId(String.valueOf(mockCostType));
        standCostCalcParam.setPriceprecision(this.getPriceprecision(mockCostType));
        standCostCalcParam.setScopetype(1);
        standCostCalcParam.setCheckType(1);
        standCostCalcParam.setBomRuleSetting(boolRuleId);
        standCostCalcParam.setStartBomRuleCalc(Boolean.valueOf(true));
        standCostCalcParam.setRouteRuleSetting(routeRuleSettingId);
        standCostCalcParam.setConfigMat(Boolean.valueOf(configAttr));
        StdCalculateHelper.createReport((StandCostCalcParam)standCostCalcParam, (String)ResManager.loadKDString((String)"\u6210\u672c\u81ea\u52a8\u5377\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"MaterialRangeCalcServiceImpl_0", (String)"macc-sca-mservice", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6210\u672c\u81ea\u52a8\u5377\u7b97", (String)"MaterialRangeCalcServiceImpl_1", (String)"macc-sca-mservice", (Object[])new Object[0]));
        Long taskId = standCostCalcParam.getTaskId();
        LOG.info("doCheckCalculate service start taskId={}", (Object)taskId);
        this.updateMaterialRangeCalc(idList, taskId);
        StandCostCalculateService standCostCalculateService = new StandCostCalculateService();
        standCostCalculateService.doCheckCalculate(standCostCalcParam);
        int success = this.updateMaterialRangeResult(taskId, dynamicObjectCollection);
        LOG.info("doCheckCalculate service end taskId={}, total={}, success={}", new Object[]{taskId, materialList.size(), success});
        return success;
    }

    private int getPriceprecision(Long costTypeId) {
        QFilter filter = new QFilter("id", "=", (Object)costTypeId);
        DynamicObject costType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"currency.priceprecision priceprecision", (QFilter[])new QFilter[]{filter});
        if (costType == null) {
            return 10;
        }
        return costType.getInt("priceprecision");
    }

    private void updateMaterialRangeCalc(List<Long> ids, Long taskId) {
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(ids.size());
        for (Long id : ids) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("taskId", -5, (Object)taskId), new SqlParameter("status", 4, (Object)1), new SqlParameter("rundate", 91, (Object)new Date()), new SqlParameter("id", -5, (Object)id)};
            paramsList.add(params);
        }
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)"update t_cad_autocalcmatrange set ftaskId = ?, fstatus = ?, frundate = ? where fid = ?", paramsList);
    }

    private int updateMaterialRangeResult(Long taskId, DynamicObjectCollection dynamicObjectCollection) {
        List<DynamicObject> taskMaterialInfoList = this.queryMaterialCalcResult(taskId);
        HashSet taskMaterialIdSet = new HashSet();
        if (!CadEmptyUtils.isEmpty(taskMaterialInfoList)) {
            taskMaterialInfoList.forEach(item -> taskMaterialIdSet.add(item.getLong("material")));
        }
        int success = 0;
        ArrayList<SqlParameter[]> parameterList = new ArrayList<SqlParameter[]>();
        for (DynamicObject material : dynamicObjectCollection) {
            SqlParameter[] params = new SqlParameter[3];
            Long materialId = material.getLong("material");
            int status = 3;
            if (!CadEmptyUtils.isEmpty(taskMaterialIdSet) && taskMaterialIdSet.contains(materialId)) {
                status = 2;
                ++success;
            }
            params[0] = new SqlParameter("status", 4, (Object)status);
            params[1] = new SqlParameter("rundate", 91, (Object)new Date());
            params[2] = new SqlParameter("id", -5, (Object)material.getLong("id"));
            parameterList.add(params);
        }
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)"update t_cad_autocalcmatrange set fstatus = ?, frundate = ? where fid = ?", parameterList);
        return success;
    }

    private List<DynamicObject> queryMaterialCalcResult(Long taskId) {
        QFilter qFilter = new QFilter("task", "=", (Object)taskId);
        DynamicObjectCollection taskMaterialInfoList = QueryServiceHelper.query((String)"cad_calcsimulationresult", (String)"id,task,material", (QFilter[])qFilter.toArray());
        return taskMaterialInfoList;
    }
}

