/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc;

import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.macc.sca.common.costcalc.CostCalcArgs;

public class CostCalcFilterBuilder {
    public QFilter buildCalcResultCommonFilter(CostCalcArgs args, List<Object> costObjects, boolean isPeriod, boolean isCostObject, boolean isCostAcct) {
        if (args.getOrgId() == null) {
            return null;
        }
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        if (isCostAcct && args.getCostAccountId() != null) {
            filter.and(new QFilter("costaccount", "=", (Object)args.getCostAccountId()));
        }
        if (isPeriod && args.getPeriodId() != null) {
            filter.and(new QFilter("period", "=", (Object)args.getPeriodId()));
        }
        if (isCostObject && costObjects != null) {
            filter.and(new QFilter("costobject", "in", costObjects));
        }
        return filter;
    }

    public void warpQFilter4Org(List<QFilter> filters, String orgFields, CostCalcArgs inputArgs) {
        filters.add(new QFilter(orgFields, "=", (Object)inputArgs.getOrgId()));
        filters.add(new QFilter("costaccount", "=", (Object)inputArgs.getCostAccountId()));
    }

    public void warpQFilter4OrgNoAcct(List<QFilter> filters, String orgFields, CostCalcArgs inputArgs) {
        filters.add(new QFilter(orgFields, "=", (Object)inputArgs.getOrgId()));
    }

    public void warpQFilter4BizDate(List<QFilter> filters, String orgFields, boolean hasAcct, CostCalcArgs inputArgs) {
        if (hasAcct) {
            this.warpQFilter4Org(filters, orgFields, inputArgs);
        } else {
            this.warpQFilter4OrgNoAcct(filters, orgFields, inputArgs);
        }
        filters.add(new QFilter("bizdate", ">=", (Object)inputArgs.getStartDate()));
        filters.add(new QFilter("bizdate", "<=", (Object)inputArgs.getEndDate()));
    }

    public void warpQFilter4BookDate(List<QFilter> filters, String orgFields, boolean hasAcct, CostCalcArgs inputArgs) {
        if (hasAcct) {
            this.warpQFilter4Org(filters, orgFields, inputArgs);
        } else {
            this.warpQFilter4OrgNoAcct(filters, orgFields, inputArgs);
        }
        filters.add(new QFilter("bookdate", ">=", (Object)inputArgs.getStartDate()));
        filters.add(new QFilter("bookdate", "<=", (Object)inputArgs.getEndDate()));
    }

    public void warpQFilter4Period(List<QFilter> filters, String orgFields, boolean hasAcct, CostCalcArgs inputArgs) {
        if (hasAcct) {
            this.warpQFilter4Org(filters, orgFields, inputArgs);
        } else {
            this.warpQFilter4OrgNoAcct(filters, orgFields, inputArgs);
        }
        filters.add(new QFilter("period", "=", (Object)inputArgs.getPeriodId()));
    }

    public void wrapQFilter4CostObjects(List<QFilter> filters, String filed, List<Object> costObjects) {
        if (costObjects != null && !costObjects.isEmpty()) {
            filters.add(new QFilter(filed, "in", costObjects));
        }
    }

    public QFilter wrapQFilter4OrgAndCostCenter(List<QFilter> filters, String orgField, String costCenterField, CostCalcArgs args) {
        if (args.getOrgId() == null) {
            return null;
        }
        QFilter filter = new QFilter(orgField, "=", (Object)args.getOrgId());
        filters.add(filter);
        return filter;
    }

    public String buildQFilterLogString(List<QFilter> qFilters) {
        if (qFilters == null || qFilters.isEmpty()) {
            return "";
        }
        return this.buildQFilterLogString(qFilters.toArray(new QFilter[0]));
    }

    public String buildQFilterLogString(QFilter[] qFilters) {
        if (qFilters == null || qFilters.length == 0) {
            return "";
        }
        if (qFilters.length == 1) {
            return qFilters[0].toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < qFilters.length; ++i) {
            if (i > 0) {
                sb.append(", \r\n");
            }
            sb.append(this.buildQFilterLogString(qFilters[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    public String buildQFilterLogString(QFilter qfilter) {
        if (qfilter == null) {
            return "";
        }
        return qfilter.toString();
    }
}

