/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.ReadWhere;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.algox.utils.CommonUtils;
import kd.macc.sca.algox.utils.TaskHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.common.costcalc.CalcReportEntryRow;
import kd.macc.sca.common.costcalc.CalcReportHeader;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.common.costcalc.TaskRecordEntryRow;
import kd.macc.sca.common.costcalc.TaskRecordHeader;
import kd.macc.sca.mservice.costcalc.CostCalcContext;
import org.apache.commons.lang3.StringUtils;

public class TaskRecorder {
    protected static final Log logger = LogFactory.getLog(TaskRecorder.class);
    private static final String INSERT_CHECKDETAIL_ENTRY_SQL = "INSERT INTO t_sca_checkdetailentry (FId,FEntryId,fentrycostcenterid,fcheckdetail) VALUES (?,?,?,?)";
    private IDataEntityType recordHeadType;
    private IDataEntityType recordEntryType;
    private TaskRecordHeader taskRecord;
    private CalcReportHeader calcReport;
    private CalcReportHeader checkReport;

    public IDataEntityType getRecordHeadType() {
        if (this.recordHeadType == null) {
            this.recordHeadType = OrmUtils.getDataEntityType(TaskRecordHeader.class);
        }
        return this.recordHeadType;
    }

    public IDataEntityType getRecordEntryType() {
        if (this.recordEntryType == null) {
            this.recordEntryType = OrmUtils.getDataEntityType(TaskRecordEntryRow.class);
        }
        return this.recordEntryType;
    }

    public TaskRecordHeader getTaskRecord() {
        return this.taskRecord;
    }

    public CalcReportHeader getCalcReport() {
        return this.calcReport;
    }

    public void setCalcReport(CalcReportHeader calcReport) {
        this.calcReport = calcReport;
    }

    public CalcReportHeader getCheckReport() {
        return this.checkReport;
    }

    public void setCheckReport(CalcReportHeader checkReport) {
        this.checkReport = checkReport;
    }

    public TaskRecordHeader loadOrCreateTaskRecord(CostCalcContext context) {
        Long id = context.getInputArgs().getTaskRecordId();
        if (id == null || Long.compare(0L, id) == 0) {
            id = DBServiceHelper.genGlobalLongId();
        } else {
            this.taskRecord = this.loadTaskRecord(id);
            if (this.taskRecord != null) {
                return this.taskRecord;
            }
        }
        this.taskRecord = this.createAndSaveTaskRecord(context, id);
        context.getInputArgs().setTaskRecordId(id);
        return this.taskRecord;
    }

    public void upateTaskRecord(int mProgess, String status) {
        this.upateTaskRecord(mProgess, status, 0, 0, 0L);
    }

    public void upateTaskRecord(int mProgess, String status, int currBat, int totalBat, Long checkResultId) {
        if (this.taskRecord == null) {
            return;
        }
        int totalProgress = this.taskRecord.getProgress() + mProgess;
        logger.info(String.format("\u66f4\u65b0\u8fdb\u5ea6\uff1a %s + %s = %s", this.taskRecord.getProgress(), mProgess, totalProgress));
        if (mProgess >= 100) {
            this.taskRecord.setProgress(100);
        } else if (totalProgress >= 100) {
            this.taskRecord.setProgress(99);
        } else {
            this.taskRecord.setProgress(totalProgress);
        }
        this.taskRecord.setTime(TimeUtils.getSecond((Date)this.taskRecord.getStartTime(), (Date)new Date()));
        this.taskRecord.setStatus(status);
        this.taskRecord.setDirtyFlag("Progress");
        this.taskRecord.setDirtyFlag("Time");
        this.taskRecord.setDirtyFlag("Status");
        if (currBat != 0) {
            String json = String.format("{\"currBat\":%s,\"totalBat\":%s,\"checkResultId\":%s}", currBat, totalBat, checkResultId);
            this.taskRecord.setNextPagePara(json);
        }
        BusinessDataWriter.update((IDataEntityType)this.getRecordHeadType(), (Object[])new Object[]{this.taskRecord});
    }

    public void saveHeader() {
        if (this.taskRecord != null) {
            BusinessDataWriter.update((IDataEntityType)this.getRecordHeadType(), (Object[])new Object[]{this.taskRecord});
        }
    }

    public void updateAndSaveCalcReport(int checkWay) {
        if (this.taskRecord == null) {
            return;
        }
        if (this.calcReport == null) {
            return;
        }
        this.calcReport.setUseTime(this.taskRecord.getTime());
        this.calcReport.setProgress(this.taskRecord.getProgress());
        this.calcReport.setStatus(this.taskRecord.getStatus());
        this.calcReport.setNextPagePara(this.taskRecord.getNextPagePara());
        this.calcReport.setDirtyFlag("TaskName");
        this.calcReport.setDirtyFlag("UseTime");
        this.calcReport.setDirtyFlag("Progress");
        this.calcReport.setDirtyFlag("Status");
        this.calcReport.setDirtyFlag("NextPagePara");
        if (checkWay == 0) {
            return;
        }
        this.calcReport.getEntryRows().clear();
        ArrayList entryRows = new ArrayList(this.taskRecord.getEntryRows().values());
        for (TaskRecordEntryRow entryRow : entryRows) {
            CalcReportEntryRow rptEntryRow = this.calcReport.addNewEntryRow();
            rptEntryRow.setSeq(entryRow.getSeq());
            rptEntryRow.setEntryId(entryRow.getEntryId());
            rptEntryRow.setDetailConfig(entryRow.getDetailConfig());
            rptEntryRow.setDetailStep(entryRow.getSubName());
            rptEntryRow.setSubNextEntity(entryRow.getSubNextEntity());
            rptEntryRow.setDetailStatus(entryRow.getSubStatus());
            rptEntryRow.setSubTime(entryRow.getSubTime());
            rptEntryRow.setSubParam(entryRow.getSubParam());
            rptEntryRow.setDetail(entryRow.getDetail());
            rptEntryRow.setSubStartTime(entryRow.getSubStartIime());
            if (!entryRow.getSubStatus().equals("3") && !entryRow.getSubStatus().equals("7")) continue;
            rptEntryRow.setErrLog(entryRow.getDetail());
        }
        BusinessDataWriter.delete((IDataEntityType)CalcReportEntryRow.getDataEntityType(), (Object[])this.calcReport.getEntryRows().stream().map(CalcReportEntryRow::getEntryId).toArray());
        BusinessDataWriter.save((IDataEntityType)CalcReportEntryRow.getDataEntityType(), (Object[])this.calcReport.getEntryRows().toArray());
        BusinessDataWriter.update((IDataEntityType)CalcReportHeader.getDataEntityType(), (Object[])new Object[]{this.calcReport});
    }

    public boolean createCheckDetailHead(CostCalcArgs inputArgs) {
        boolean isCreateFlag = false;
        if (this.taskRecord == null) {
            return isCreateFlag;
        }
        for (Map.Entry entry : this.taskRecord.getEntryRows().entrySet()) {
            boolean flag;
            if (FinshCalcCheck.CALCTASKCHECK.equals(entry.getKey()) || TaskHelper.PDENDENTRY_CHECK_TASKID.equals(entry.getKey()) || !(flag = this.createCheckDetailHead(((TaskRecordEntryRow)entry.getValue()).getEntryId(), inputArgs, ((TaskRecordEntryRow)entry.getValue()).getSubName()))) continue;
            isCreateFlag = true;
            this.upateTaskRecordDetail((Long)entry.getKey(), "3");
            this.upateTaskRecordDetailPara((Long)entry.getKey(), ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b\u4e2d\u5b58\u5728\u9519\u8bef\u9879\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\u3002", (String)"TaskRecorder_0", (String)"macc-sca-mservice", (Object[])new Object[0]), null);
        }
        return isCreateFlag;
    }

    private boolean createCheckDetailHead(Long taskDetailId, CostCalcArgs inputArgs, String curItem) {
        if (this.isNeedGenerateBill(taskDetailId) && !QueryServiceHelper.exists((String)"sca_checkdetail", (Object)taskDetailId)) {
            DynamicObject checkDetail = this.createCheckDetailDyn(inputArgs, taskDetailId, curItem);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"sca_checkdetail");
            SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{checkDetail});
            return true;
        }
        return false;
    }

    public DynamicObject createCheckDetailDyn(CostCalcArgs inputArgs, long itemId, String curItem) {
        DynamicObject checkDetail = BusinessDataServiceHelper.newDynamicObject((String)"sca_checkdetail");
        checkDetail.set("id", (Object)itemId);
        checkDetail.set("org", (Object)inputArgs.getOrgId());
        checkDetail.set("costaccount", (Object)inputArgs.getCostAccountId());
        checkDetail.set("period", (Object)inputArgs.getPeriodId());
        checkDetail.set("currency", (Object)inputArgs.getCurrencyId());
        checkDetail.set("checkitemdesc", (Object)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b58\u5728\u9519\u8bef\u4fe1\u606f\u3002", (String)"TaskRecorder_3", (String)"macc-sca-mservice", (Object[])new Object[0]), curItem));
        checkDetail.set("calcdate", (Object)TimeServiceHelper.now());
        if (inputArgs.getCostCenterIds() != null && !inputArgs.getCostCenterIds().isEmpty()) {
            DynamicObjectCollection costcenterDyns = checkDetail.getDynamicObjectCollection("costcenter");
            for (Long costcenter : inputArgs.getCostCenterIds()) {
                DynamicObject obj = costcenterDyns.addNew();
                obj.set("fbasedataid_id", (Object)costcenter);
            }
        }
        return checkDetail;
    }

    private boolean isNeedGenerateBill(Long taskDetailId) {
        int size = 0;
        String strSql = "SELECT count(1) value FROM t_sca_checkdetailentry WHERE FId = " + taskDetailId;
        try (DataSet batSizeData = DB.queryDataSet((String)"TaskRecordGetEntrySize", (DBRoute)CommonUtils.getCalDBRouteKey(), (String)strSql);){
            if (batSizeData.hasNext()) {
                Row row = batSizeData.next();
                size = Integer.parseInt(row.get("value").toString());
            }
        }
        return size > 0;
    }

    public Long getCurrentTaskRecordDetail() {
        long currentItem = 0L;
        for (Map.Entry entry : this.taskRecord.getEntryRows().entrySet()) {
            TaskRecordEntryRow entryRow = (TaskRecordEntryRow)entry.getValue();
            if ("2".equals(entryRow.getSubStatus())) {
                currentItem = (Long)entry.getKey();
                break;
            }
            if (currentItem != 0L || !"1".equals(entryRow.getSubStatus())) continue;
            currentItem = (Long)entry.getKey();
        }
        if (CadEmptyUtils.isEmpty((Long)currentItem)) {
            String subName = ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b\u8c03\u5ea6", (String)"TaskRecorder_2", (String)"macc-sca-mservice", (Object[])new Object[0]);
            return this.createTaskRecordDetail(subName, "");
        }
        return currentItem;
    }

    public void upateTaskRecordDetail(Long taskConfigDetailId, String status) {
        this.upateTaskRecordDetail(taskConfigDetailId, status, null, null);
    }

    public void upateTaskRecordDetail(Long taskConfigDetailId, String status, int currBatch, int totalBatch) {
        this.upateTaskRecordDetail(taskConfigDetailId, status, null, null, currBatch, totalBatch);
    }

    public void upateTaskRecordDetail(Long taskConfigDetailId, String status, String errInfo, String errMsg) {
        this.upateTaskRecordDetail(taskConfigDetailId, status, errInfo, errMsg, 0, 0);
    }

    public void upateTaskRecordDetail(Long taskConfigDetailId, String status, String errInfo, String errMsg, int currBatch, int totalBatch) {
        if (this.taskRecord == null || taskConfigDetailId == null) {
            return;
        }
        TaskRecordEntryRow recordEntryRow = (TaskRecordEntryRow)this.taskRecord.getEntryRows().get(taskConfigDetailId);
        if (recordEntryRow == null) {
            return;
        }
        recordEntryRow.setSubStatus(status);
        recordEntryRow.setDirtyFlag("SubStatus");
        if (currBatch != 0) {
            String batchName = String.format("(%1$s/%2$s%3$s)", currBatch, totalBatch, ResManager.loadKDString((String)"\u6279", (String)"TaskRecorder_4", (String)"macc-sca-mservice", (Object[])new Object[0]));
            int index = recordEntryRow.getSubName().lastIndexOf(40);
            if (index > 0) {
                recordEntryRow.setSubName(recordEntryRow.getSubName().substring(0, index) + batchName);
            } else {
                recordEntryRow.setSubName(recordEntryRow.getSubName() + batchName);
            }
        }
        if ("2".equals(status)) {
            recordEntryRow.setSubStartIime(TimeServiceHelper.now());
            recordEntryRow.setDirtyFlag("SubStartIime");
        }
        if ("4".equals(status) || "7".equals(status)) {
            long oldTime = recordEntryRow.getSubTime();
            Long subTime = TimeUtils.getMilliSecond((Date)recordEntryRow.getSubStartIime(), (Date)TimeServiceHelper.now());
            recordEntryRow.setSubTime(subTime + oldTime);
            recordEntryRow.setDirtyFlag("SubTime");
        }
        if ("7".equals(status)) {
            if (!CadEmptyUtils.isEmpty((String)errInfo)) {
                recordEntryRow.setSubParam(StringUtils.substring((String)errInfo, (int)0, (int)255));
                recordEntryRow.setDirtyFlag("SubParam");
                if (recordEntryRow.getDetail() == null) {
                    recordEntryRow.setDetail(recordEntryRow.getSubParam());
                }
            }
            if (!CadEmptyUtils.isEmpty((String)errMsg)) {
                recordEntryRow.setSubParam_Tag(errMsg);
                recordEntryRow.setDirtyFlag("SubParam_Tag");
            }
        }
        BusinessDataWriter.update((IDataEntityType)this.getRecordEntryType(), (Object[])new Object[]{recordEntryRow});
    }

    public void upateTaskRecordDetailSubTime(Long taskConfigDetailId, long costTime) {
        if (this.taskRecord == null || CadEmptyUtils.isEmpty((Long)taskConfigDetailId)) {
            return;
        }
        TaskRecordEntryRow recordEntryRow = (TaskRecordEntryRow)this.taskRecord.getEntryRows().get(taskConfigDetailId);
        if (recordEntryRow == null) {
            return;
        }
        if (costTime < 0L) {
            return;
        }
        recordEntryRow.setSubTime(costTime);
        BusinessDataWriter.update((IDataEntityType)this.getRecordEntryType(), (Object[])new Object[]{recordEntryRow});
    }

    public void upateTaskRecordDetailPara(Long taskConfigDetailId, String detail, String nextPagePara) {
        if (this.taskRecord == null || taskConfigDetailId == null) {
            return;
        }
        TaskRecordEntryRow recordEntryRow = (TaskRecordEntryRow)this.taskRecord.getEntryRows().get(taskConfigDetailId);
        if (recordEntryRow == null) {
            return;
        }
        recordEntryRow.setDetail(detail);
        recordEntryRow.setSubParam(nextPagePara);
        recordEntryRow.setDirtyFlag("Detail");
        recordEntryRow.setDirtyFlag("SubParam");
        BusinessDataWriter.update((IDataEntityType)this.getRecordEntryType(), (Object[])new Object[]{recordEntryRow});
    }

    public long createTaskRecordDetail(String subName, String subNextEntity) {
        long taskId = DBServiceHelper.genGlobalLongId();
        TaskRecordEntryRow recordRow = new TaskRecordEntryRow();
        TaskRecordEntryRow maxSeqEntryRow = null;
        for (Map.Entry entry : this.taskRecord.getEntryRows().entrySet()) {
            if (maxSeqEntryRow != null && maxSeqEntryRow.getSeq() >= ((TaskRecordEntryRow)entry.getValue()).getSeq()) continue;
            maxSeqEntryRow = (TaskRecordEntryRow)entry.getValue();
        }
        int seq = 1;
        if (maxSeqEntryRow != null) {
            seq = maxSeqEntryRow.getSeq() + 1;
        }
        recordRow.setEntryId(taskId);
        recordRow.setId(this.taskRecord.getId());
        recordRow.setSeq(seq);
        recordRow.setDetailConfig(0L);
        recordRow.setSubName(subName);
        recordRow.setSubNextEntity(subNextEntity);
        recordRow.setSubStatus("2");
        recordRow.setSubStartIime(TimeServiceHelper.now());
        this.taskRecord.getEntryRows().put(taskId, recordRow);
        BusinessDataWriter.save((IDataEntityType)this.getRecordEntryType(), (Object[])new Object[]{recordRow});
        return taskId;
    }

    private TaskRecordHeader createAndSaveTaskRecord(CostCalcContext context, Long taskRecordId) {
        DynamicObject taskConfig = context.getTaskConfig();
        TaskRecordHeader recordHeader = new TaskRecordHeader();
        Date startTime = TimeServiceHelper.now();
        recordHeader.setId(taskRecordId.longValue());
        recordHeader.setTaskName(taskConfig.getString("name"));
        recordHeader.setStartTime(startTime);
        recordHeader.setTime(0L);
        recordHeader.setStatus("2");
        recordHeader.setProgress(0);
        recordHeader.setExecutor(Long.parseLong(RequestContext.get().getUserId()));
        recordHeader.setNextPage(taskConfig.getString("nextentity"));
        recordHeader.setTaskConfig(context.getTaskConfigId().longValue());
        DynamicObjectCollection taskConfigEntrys = taskConfig.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject entry : taskConfigEntrys) {
            TaskRecordEntryRow recordRow = new TaskRecordEntryRow();
            recordRow.setEntryId(DBServiceHelper.genGlobalLongId());
            recordRow.setId(taskRecordId.longValue());
            recordRow.setSeq(seq);
            recordRow.setDetailConfig(((Long)entry.getPkValue()).longValue());
            recordRow.setSubName(entry.getString("subname"));
            recordRow.setSubNextEntity(entry.getString("subnextentity"));
            recordRow.setSubStatus("1");
            if (seq == 1) {
                recordRow.setSubStartIime(startTime);
            }
            recordHeader.getEntryRows().put(recordRow.getDetailConfig(), recordRow);
            ++seq;
        }
        SaveServiceHelper.save((IDataEntityType)this.getRecordHeadType(), (Object[])new Object[]{recordHeader});
        if (!recordHeader.getEntryRows().isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)this.getRecordEntryType(), (Object[])recordHeader.getEntryRows().values().toArray());
        }
        return recordHeader;
    }

    private TaskRecordHeader loadTaskRecord(Long taskRecordId) {
        Object[] entryObjs;
        Object[] recordObjs = BusinessDataServiceHelper.load((Object[])new Object[]{taskRecordId}, (IDataEntityType)this.getRecordHeadType());
        if (recordObjs == null || recordObjs.length == 0) {
            return null;
        }
        TaskRecordHeader recordHead = (TaskRecordHeader)recordObjs[0];
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)this.getRecordEntryType());
        dataManager.setSelectHeadOnly(true);
        ArrayList<SqlParameter> sqlParams = new ArrayList<SqlParameter>(1);
        sqlParams.add(new SqlParameter("fid", -5, (Object)taskRecordId));
        ReadWhere where = new ReadWhere("fid = ?", sqlParams);
        for (Object entryObj : entryObjs = dataManager.read(where)) {
            TaskRecordEntryRow entryRow = (TaskRecordEntryRow)entryObj;
            recordHead.getEntryRows().put(entryRow.getDetailConfig(), entryRow);
        }
        return recordHead;
    }

    public void insertCalcErrorInfo(Long taskConfigDetailId, Long costcenter, String errorInfo) {
        if (this.taskRecord == null) {
            return;
        }
        TaskRecordEntryRow recordEntryRow = (TaskRecordEntryRow)this.taskRecord.getEntryRows().get(taskConfigDetailId);
        if (recordEntryRow == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)errorInfo)) {
            return;
        }
        if (costcenter == null) {
            costcenter = 0L;
        }
        if (errorInfo.length() > 255) {
            errorInfo = errorInfo.substring(0, 255);
        }
        ArrayList<Object[]> entrys = new ArrayList<Object[]>();
        Object[] entry = new Object[]{recordEntryRow.getEntryId(), ID.genLongId(), costcenter, errorInfo};
        entrys.add(entry);
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)INSERT_CHECKDETAIL_ENTRY_SQL, entrys);
    }
}

