/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractCalcCheckAction;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.SingleCalcCheckContext;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.TimeUtils;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.mservice.costcalc.CalcTaskType;
import kd.macc.sca.mservice.costcalc.TaskRecorder;
import kd.macc.sca.mservice.costcalc.action.AbstractCalcAction;
import net.sf.json.JSONObject;

class CheckAction
extends AbstractCalcAction {
    private static final Log logger = LogFactory.getLog(CheckAction.class);
    private static final String CHECK_ACTION_CONCURRENCY_SWITCH = "checkActionSwitch";
    private static final String CHECK_LEVEL_WARN = "1";
    private static final String CHECK_LEVEL_NO_PASS = "2";
    private TaskRecorder taskRecorder;

    CheckAction() {
    }

    @Override
    public Long getDetailTaskConfigId() {
        return FinshCalcCheck.CALCTASKCHECK;
    }

    @Override
    protected void doExecute() {
        logger.info("\u6570\u636e\u68c0\u67e5\uff1a\u5f00\u59cb");
        this.taskRecorder = this.getResultManager().getTaskRecorder();
        if (this.getContext().getInputArgs().getCheckWay() == 1) {
            this.taskRecorder.upateTaskRecordDetail(this.getDetailTaskConfigId(), CHECK_LEVEL_NO_PASS);
        }
        Long checkResultId = this.getContext().getInputArgs().getCheckReportId();
        this.getResultManager().setCheckResultId(checkResultId);
        this.doCheck(checkResultId);
        this.getContext().getInputArgs().setCheckResultId(checkResultId);
        if (this.getContext().getCheckNoPassCount() > 0) {
            this.getContext().getInputArgs().setCalc(Boolean.valueOf(false));
        } else {
            this.getContext().getInputArgs().setCalc(Boolean.valueOf(true));
        }
        if (this.getContext().getInputArgs().getCheckWay() == 1) {
            this.taskRecorder.upateTaskRecord(10, CHECK_LEVEL_NO_PASS);
            String checkSattus = "4";
            if (this.getContext().getCheckNoPassCount() > 0) {
                checkSattus = "3";
            } else if (this.getContext().getCheckRemaindCount() > 0) {
                checkSattus = "7";
            }
            this.taskRecorder.upateTaskRecordDetail(this.getDetailTaskConfigId(), checkSattus);
            String detail = ResManager.loadKDString((String)"\u68c0\u67e5\u62a5\u544a", (String)"CheckAction_0", (String)"macc-sca-mservice", (Object[])new Object[0]);
            JSONObject nextPagePara = new JSONObject();
            nextPagePara.accumulate("checkResultId", (Object)checkResultId.toString());
            this.taskRecorder.upateTaskRecordDetailPara(this.getDetailTaskConfigId(), detail, nextPagePara.toString());
        }
        logger.info(String.format("\u6570\u636e\u68c0\u67e5\uff1a\u7ed3\u675f\u3002 checkResultId: %s", checkResultId));
    }

    private void doCheck(Long checkResultId) {
        boolean isConcurrency;
        CalcTaskType taskType = this.getContext().getTaskType();
        Date startTime = new Date();
        List<AbstractCalcCheckAction> checkActions = this.createCheckActions(taskType, checkResultId);
        boolean bl = isConcurrency = CadBgParamUtils.getCadParamForInt((String)CHECK_ACTION_CONCURRENCY_SWITCH, (int)1) == 1;
        if (isConcurrency) {
            this.doCheckWithConcurrency(checkActions, checkResultId);
        } else {
            for (AbstractCalcCheckAction action : checkActions) {
                action.execute();
            }
        }
        this.getContext().setCusmTimeForCheck(TimeUtils.getSecondTime((Date)startTime, (Date)new Date()));
        if (!CadEmptyUtils.isEmpty(checkActions)) {
            this.getContext().setCheckNoPassCount(Integer.parseInt(String.valueOf(checkActions.get(0).getContext().getFailCount())));
            this.getContext().setCheckRemaindCount(Integer.parseInt(String.valueOf(checkActions.get(0).getContext().getRemindCount())));
        }
    }

    private void doCheckWithConcurrency(List<AbstractCalcCheckAction> checkActions, Long checkResultId) {
        if (CadEmptyUtils.isEmpty(checkActions)) {
            return;
        }
        long startConcurrencyMills = System.currentTimeMillis();
        final AtomicInteger remindCount = new AtomicInteger(0);
        final AtomicInteger failCount = new AtomicInteger(0);
        logger.info("doCheckWithConcurrency start checkActions size={}, checkResultId={}", (Object)checkActions.size(), (Object)checkResultId);
        try {
            final CountDownLatch countDownLatch = new CountDownLatch(checkActions.size());
            for (final AbstractCalcCheckAction action : checkActions) {
                final long startMills = System.currentTimeMillis();
                ThreadHelper.execute((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            logger.info("doCheckWithConcurrency cycle start action name={}", (Object)action.getClass().getName());
                            action.execute();
                            AbstractSingleCalcCheckAction abstractSingleCalcCheckAction = (AbstractSingleCalcCheckAction)action;
                            SingleCalcCheckContext singleCalcCheckContext = abstractSingleCalcCheckAction.getSingleCheckContext();
                            boolean pass = singleCalcCheckContext.isPass();
                            if (!pass) {
                                if (CheckAction.CHECK_LEVEL_WARN.equals(singleCalcCheckContext.getCheckLevel())) {
                                    remindCount.incrementAndGet();
                                }
                                if (CheckAction.CHECK_LEVEL_NO_PASS.equals(singleCalcCheckContext.getCheckLevel())) {
                                    failCount.incrementAndGet();
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.error("doCheckWithConcurrency cycle end error action name={}, costTime={},exception=", new Object[]{action.getClass().getName(), System.currentTimeMillis() - startMills, e});
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                        logger.info("doCheckWithConcurrency cycle end action name={}, costTime={}", (Object)action.getClass().getName(), (Object)(System.currentTimeMillis() - startMills));
                    }
                }, (TaskType)TaskType.SCA_CALCHECK);
            }
            countDownLatch.await();
            checkActions.get(0).getContext().setFailCount(Long.valueOf(failCount.longValue()));
            checkActions.get(0).getContext().setRemindCount(Long.valueOf(remindCount.longValue()));
            logger.info("doCheckWithConcurrency end checkActions size={}, failCount={}, remindCount={} checkResultId={}, costTime={}", new Object[]{checkActions.size(), failCount.intValue(), remindCount.intValue(), checkResultId, System.currentTimeMillis() - startConcurrencyMills});
        }
        catch (Exception e) {
            logger.error("doCheckWithConcurrency Exception,checkResultId={}, exception=", (Object)checkResultId, (Object)e);
            throw new KDBizException("doCheckWithConcurrency checkResultId=" + checkResultId + " ,exception=" + e);
        }
    }

    protected boolean getCheckResult(Long checkResultId, Long[] checkItemId) {
        QFilter filter = new QFilter("id", "=", (Object)checkResultId);
        filter.and(new QFilter("entryentity.result", "=", (Object)CHECK_LEVEL_NO_PASS));
        filter.and(new QFilter("entryentity.id", "in", (Object)checkItemId));
        DynamicObjectCollection chekcResult = QueryServiceHelper.query((String)"sca_checkresult", (String)"entryentity.id", (QFilter[])new QFilter[]{filter});
        return chekcResult.size() == 0;
    }
}

