/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.common.costcalc.CalcReportExpEntryRow;
import kd.macc.sca.common.costcalc.CalcReportHeader;
import kd.macc.sca.common.costcalc.CalcResultEntryRow;
import kd.macc.sca.common.costcalc.CalcResultHeader;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.CostCalcFilterBuilder;
import kd.macc.sca.mservice.costcalc.action.AbstractSingleBatchAction;
import kd.macc.sca.mservice.costcalc.groupkey.CostObjectKey;

class CreateCostConfirmAction
extends AbstractSingleBatchAction {
    private static final Log logger = LogFactory.getLog(CreateCostConfirmAction.class);
    private static final String ALGO_KEY_LOAD_CHANGED = "kd.macc.sca.mservice.costcalc.action.CreateCostConfirmAction.loadChangedObject";
    private static final String ALGO_KEY_LOAD_FINISHED = "kd.macc.sca.mservice.costcalc.action.CreateCostConfirmAction.loadCompletedObject";
    private CostCalcArgs args;

    CreateCostConfirmAction() {
    }

    @Override
    protected void doExecute() {
        logger.info(String.format("\u751f\u6210\u6210\u672c\u786e\u8ba4\u5355\uff1a\u5f00\u59cb\uff0c\u7b2c %s/ %s\u6279\uff0c\u5171 %s \u5f20", this.getSingleBatchContext().getCurrBatchSeq(), this.getSingleBatchContext().getBatchCount(), this.getSingleBatchContext().getCostObjectIds().size()));
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordDetail(FinshCalcCheck.CALCTASKGENCOSTCONFIRM, "2");
        }
        this.args = this.getContext().getInputArgs();
        this.createAndSave();
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordProcess(FinshCalcCheck.CALCTASKGENCOSTCONFIRM, "2");
            this.upateTaskRecordDetail(FinshCalcCheck.CALCTASKGENCOSTCONFIRM, "4");
        }
        logger.info("\u751f\u6210\u6210\u672c\u786e\u8ba4\u5355\uff1a\u7ed3\u675f");
    }

    private Set<Long> createAndSave() {
        HashSet<Long> confirmIds = new HashSet<Long>(10);
        HashSet<Long> autoConfirmIds = new HashSet<Long>(10);
        ArrayList<DynamicObject> costConfirBills = new ArrayList<DynamicObject>(10);
        ArrayList<CalcReportExpEntryRow> rptExpEntryRows = new ArrayList<CalcReportExpEntryRow>(10);
        Map<CostObjectKey, DynamicObject> existCostConFirmObjs = this.loadExistCostConfirm();
        CalcReportHeader rpt = this.getResultManager().getCalcReport();
        Map<Long, DynamicObject> costObjects = this.loadCostObjects();
        for (Map.Entry<Long, CalcResultHeader> entry : this.getSingleBatchResultManager().getCalcResults().entrySet()) {
            CalcResultHeader calcResult = entry.getValue();
            CalcResultEntryRow totalRow = calcResult.getTotalRow();
            CostObjectKey key = new CostObjectKey(null, calcResult.getCostAccount(), null, null, calcResult.getPeriod(), calcResult.getCostObject());
            DynamicObject costConfirmBill = existCostConFirmObjs.get(key);
            if (costConfirmBill == null) {
                costConfirmBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_costconfirm");
                costConfirmBill.set("id", (Object)DBServiceHelper.genGlobalLongId());
            }
            Long confirmId = (Long)costConfirmBill.getPkValue();
            this.getSingleBatchResultManager().getCostConfirmIds().add(confirmId);
            this.getResultManager().getCostConfirmIds().add(confirmId);
            costConfirmBill.set("org", (Object)calcResult.getOrg());
            costConfirmBill.set("costaccount", (Object)calcResult.getCostAccount());
            costConfirmBill.set("costcenter", (Object)calcResult.getCostCenter());
            costConfirmBill.set("period", (Object)calcResult.getPeriod());
            costConfirmBill.set("costobject", (Object)calcResult.getCostObject());
            DynamicObject costObject = costObjects.get(calcResult.getCostObject());
            if (costObject != null) {
                costConfirmBill.set("material", costObject.get("material.masterid"));
                costConfirmBill.set("bomversion", costObject.get("bomversion.id"));
                costConfirmBill.set("auxpty", costObject.get("auxpty.id"));
            }
            costConfirmBill.set("currency", (Object)this.args.getCurrencyId());
            BigDecimal diffRate = BigDecimal.ZERO;
            BigDecimal totalamount = calcResult.getTotalRowTotalAmt();
            BigDecimal totalstdamount = calcResult.getTotalRowStdTotalAmt();
            BigDecimal diffAmount = totalamount.subtract(totalstdamount);
            if (diffAmount != null && totalstdamount != null && BigDecimal.ZERO.compareTo(totalstdamount) != 0) {
                diffRate = diffAmount.divide(totalstdamount, 4, 4);
            }
            costConfirmBill.set("absorbamount", (Object)totalamount);
            costConfirmBill.set("stdamount", (Object)totalstdamount);
            costConfirmBill.set("diff", (Object)diffAmount);
            costConfirmBill.set("diffrate", (Object)diffRate);
            costConfirmBill.set("bizstatus", (Object)"A");
            costConfirmBill.set("srcbill", (Object)calcResult.getId());
            costConfirBills.add(costConfirmBill);
            if (diffRate.compareTo(this.args.getMinDiffRate()) < 0 || diffRate.compareTo(this.args.getMaxDiffRate()) > 0) {
                CalcReportExpEntryRow expEntryRow = rpt.addNewExpEntryRow();
                expEntryRow.setCostObject(calcResult.getCostObject());
                expEntryRow.setActualCost(totalamount);
                expEntryRow.setStandardCost(totalstdamount);
                expEntryRow.setDifferentMoney(diffAmount);
                expEntryRow.setDifferentRatio(diffRate);
                rptExpEntryRows.add(expEntryRow);
            }
            confirmIds.add(confirmId);
            autoConfirmIds.add(confirmId);
        }
        this.getSingleBatchResultManager().getCalcResults().clear();
        SaveServiceHelper.save((DynamicObject[])costConfirBills.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((IDataEntityType)CalcReportExpEntryRow.getDataEntityType(), (Object[])rptExpEntryRows.toArray());
        if (!autoConfirmIds.isEmpty()) {
            Map<String, Object> opMeta = this.loadConfirmOp();
            if (opMeta == null) {
                logger.warn("\u6210\u672c\u786e\u8ba4\u5355\u4e0d\u5b58\u5728\u786e\u8ba4\u64cd\u4f5c(op_confirm\u6216confirm)\uff0c\u65e0\u6cd5\u81ea\u52a8\u786e\u8ba4");
            } else {
                String opKey = (String)opMeta.get("key");
                OperationServiceHelper.executeOperate((String)opKey, (String)"sca_costconfirm", (Object[])autoConfirmIds.toArray(), (OperateOption)OperateOption.create());
                this.getSingleBatchResultManager().getAutoConfirmIds().addAll(autoConfirmIds);
            }
        }
        return confirmIds;
    }

    private Map<Long, DynamicObject> loadCostObjects() {
        HashSet<String> selectFields = new HashSet<String>(4);
        selectFields.add("id");
        selectFields.add("material");
        selectFields.add("bomversion");
        selectFields.add("auxpty");
        MainEntityType subType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"cad_costobject", selectFields);
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])this.getSingleBatchContext().getCostObjectIds().toArray(), (DynamicObjectType)subType);
        HashMap<Long, DynamicObject> costObjects = new HashMap<Long, DynamicObject>();
        if (objs != null) {
            for (DynamicObject obj : objs) {
                costObjects.put((Long)obj.getPkValue(), obj);
            }
        }
        return costObjects;
    }

    private Set<Long> loadChangedObjectIds() {
        Date[] dates = this.getContext().getCurrPeriodDate(this.args.getPeriodId());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("org", "=", (Object)this.args.getOrgId()));
        filters.add(new QFilter("costaccount", "=", (Object)this.args.getCostAccountId()));
        filters.add(new QFilter("costobject", "in", this.getSingleBatchContext().getCostObjectIds()));
        filters.add(new QFilter("bizstatus", "!=", (Object)"B"));
        filters.add(new QFilter("createtime", ">=", (Object)dates[0]));
        filters.add(new QFilter("createtime", "<=", (Object)dates[1]));
        HashSet<Long> changeRecordCostObjects = new HashSet<Long>();
        try (DataSet changeRecords = QueryServiceHelper.queryDataSet((String)ALGO_KEY_LOAD_CHANGED, (String)"sca_costchangerecord", (String)"id, costobject", (QFilter[])filters.toArray(new QFilter[0]), null);){
            while (changeRecords.hasNext()) {
                Row row = changeRecords.next();
                changeRecordCostObjects.add(row.getLong("costobject"));
            }
        }
        return changeRecordCostObjects;
    }

    private Set<Long> loadFinishedObjectIds(Set<Long> costObjectIds) {
        if (costObjectIds.isEmpty()) {
            return new HashSet<Long>(0);
        }
        QFilter commonQF = new QFilter("costobject", "in", costObjectIds);
        commonQF.and("costaccount", "=", (Object)this.args.getCostAccountId());
        commonQF.and("bizstatus", "=", (Object)"B");
        HashSet<Long> compcostObjectIds = new HashSet<Long>(costObjectIds.size());
        try (DataSet costObjectAccounts = QueryServiceHelper.queryDataSet((String)ALGO_KEY_LOAD_FINISHED, (String)"cad_costobjectaccount", (String)"id, costobject", (QFilter[])new QFilter[]{commonQF}, null);){
            while (costObjectAccounts.hasNext()) {
                Row row = costObjectAccounts.next();
                compcostObjectIds.add(row.getLong("costobject"));
            }
        }
        return compcostObjectIds;
    }

    public Map<String, Object> loadConfirmOp() {
        List opList = EntityMetadataCache.getDataEntityOperate((String)"sca_costconfirm");
        for (Map opMeta : opList) {
            String key = (String)opMeta.get("key");
            if (!StringUtils.equals((CharSequence)"op_confirm", (CharSequence)key) && !StringUtils.equals((CharSequence)"confirm", (CharSequence)key)) continue;
            return opMeta;
        }
        return null;
    }

    private Map<CostObjectKey, DynamicObject> loadExistCostConfirm() {
        DynamicObject[] costConfirmLoads;
        HashMap<CostObjectKey, DynamicObject> costConFirmMap = new HashMap<CostObjectKey, DynamicObject>(16);
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(10);
        CostCalcFilterBuilder filterBuilder = this.getContext().getFilterBuilder();
        filterBuilder.warpQFilter4Period(qfList, "org", true, this.args);
        filterBuilder.wrapQFilter4CostObjects(qfList, "costobject", this.getSingleBatchContext().getCostObjectIds());
        List costConfirmIds = QueryServiceHelper.queryPrimaryKeys((String)"sca_costconfirm", (QFilter[])qfList.toArray(new QFilter[0]), null, (int)-1);
        for (DynamicObject costConfirmLoad : costConfirmLoads = BusinessDataServiceHelper.load((Object[])costConfirmIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"sca_costconfirm"))) {
            CostObjectKey key = new CostObjectKey(null, costConfirmLoad.getLong("costaccount.id"), null, null, costConfirmLoad.getLong("period.id"), costConfirmLoad.getLong("costobject.id"));
            costConFirmMap.put(key, costConfirmLoad);
        }
        return costConFirmMap;
    }
}

