/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.action.AbstractSingleBatchAction;

public class DeleteNotinCalcRangeResultAction
extends AbstractSingleBatchAction {
    private static final Log logger = LogFactory.getLog(DeleteNotinCalcRangeResultAction.class);
    private static final String ALGO_KEY_PRE = DeleteNotinCalcRangeResultAction.class.getCanonicalName();
    private static final String SQL_UPDATE_CALC_RESULT = "update t_sca_calcresult set forgid = ? where fid = ?";
    private CostCalcArgs args;

    @Override
    protected void doExecute() {
        this.args = this.getContext().getInputArgs();
        if (this.args.getIsSourceUpdate()) {
            return;
        }
        if (this.getSingleBatchContext().getCurrBatchSeq() == 1) {
            Set<Long> unConfirmBillIds;
            Set<Long> costObjectIds = this.loadOtherCostObjectIds();
            if (costObjectIds.isEmpty()) {
                logger.info("DeleteNotinCalcRangeResultAction-\u65e0\u5931\u6548\u7684\u8ba1\u7b97\u7ed3\u679c\u8868\u6570\u636e");
                return;
            }
            QFilter costAccountFilter = new QFilter("costaccount", "=", (Object)this.args.getCostAccountId());
            costAccountFilter.and("costobject", "in", costObjectIds);
            costAccountFilter.and("bizstatus", "=", (Object)"B");
            DataSet closeCostObjectDs = QueryServiceHelper.queryDataSet((String)"costobjectaccount", (String)"cad_costobjectaccount", (String)"costobject", (QFilter[])costAccountFilter.toArray(), null);
            Set settleCostobjectIds = ScaCalcHelper.getLongIdSetFromDs((DataSet)closeCostObjectDs, (String)"costobject", (boolean)false);
            costObjectIds.removeAll(settleCostobjectIds);
            if (costObjectIds.isEmpty()) {
                logger.info("DeleteNotinCalcRangeResultAction-\u65e0\u5931\u6548\u7684\u8ba1\u7b97\u7ed3\u679c\u8868\u6570\u636e");
                return;
            }
            this.logCostobjectId(costObjectIds);
            Set<Long> resultIds = this.loadExpiredCalcResultIds(costObjectIds);
            if (!resultIds.isEmpty()) {
                this.expireCalcResult(resultIds);
                for (Long resultId : resultIds) {
                    this.getSingleBatchResultManager().getExpiredCalcResultIds().add(resultId);
                }
            }
            if (!(unConfirmBillIds = this.loadUnConfirmBillIds(costObjectIds)).isEmpty()) {
                Object[] pks = unConfirmBillIds.toArray();
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"sca_costconfirm");
                DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])pks);
                logger.info(String.format("\u5220\u9664\u672a\u786e\u8ba4\u7684\u6210\u672c\u786e\u8ba4\u5355 %s \u5f20 : %s", unConfirmBillIds.size(), StringUtils.join((Object[])pks, (String)",")));
            }
        }
    }

    private void logCostobjectId(Set<Long> costObjectIds) {
        StringBuilder sb = new StringBuilder();
        for (Long id : costObjectIds) {
            sb.append(id).append(",");
            if (sb.length() <= 2000) continue;
            logger.info(String.format("DeleteNotinCalcRangeResultAction-\u5931\u6548\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61id:%s", sb.toString()));
            sb = new StringBuilder();
        }
        logger.info(String.format("DeleteNotinCalcRangeResultAction-\u5931\u6548\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61id:%s", sb.toString()));
    }

    private Set<Long> loadOtherCostObjectIds() {
        HashSet<Long> otherCostObjectIds = new HashSet<Long>();
        QFilter orgFilter = new QFilter("org", "=", (Object)this.args.getOrgId());
        orgFilter.and(new QFilter("costaccount", "=", (Object)this.args.getCostAccountId()));
        orgFilter.and(new QFilter("period", "=", (Object)this.args.getPeriodId()));
        orgFilter.and(new QFilter("bizstatus", "=", (Object)"A"));
        if (!CollectionUtils.isEmpty((Collection)this.args.getCostCenterIds())) {
            orgFilter.and(new QFilter("costcenter", "in", (Object)this.args.getCostCenterIds()));
        }
        if (this.args.getManuOrgId() != null && this.args.getManuOrgId() > 0L) {
            orgFilter.and(new QFilter("costobject.manuorg", "=", (Object)this.args.getManuOrgId()));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadOtherCostObjectIds"), (String)"sca_calcresult", (String)"billno, costobject", (QFilter[])new QFilter[]{orgFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long costObjectId = row.getLong("costobject");
                if (this.args.getCostObjectIds().contains(costObjectId)) continue;
                otherCostObjectIds.add(costObjectId);
            }
        }
        logger.info(String.format("\u83b7\u53d6\u672a\u7ed3\u7b97\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff08\u4ece\u8ba1\u7b97\u7ed3\u679c\u5355\u53d6\uff0c\u6392\u9664\u672c\u6b21\u6210\u672c\u8ba1\u7b97\u4f1a\u5305\u542b\u7684\u6838\u7b97\u5bf9\u8c61\uff09\uff0c\u5171\u53d6\u51fa %s \u5f20\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", otherCostObjectIds.size(), this.getContext().getFilterBuilder().buildQFilterLogString(orgFilter)));
        return otherCostObjectIds;
    }

    private Set<Long> loadExpiredCalcResultIds(Set<Long> costObjectIds) {
        QFilter filter = this.getContext().getFilterBuilder().buildCalcResultCommonFilter(this.args, new ArrayList<Object>(costObjectIds), true, true, true);
        if (!CollectionUtils.isEmpty((Collection)this.args.getCostCenterIds())) {
            filter.and(new QFilter("costcenter", "in", (Object)this.args.getCostCenterIds()));
        }
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY_PRE, (String)"sca_calcresult", (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong(0));
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u5931\u6548\u7684\u6210\u672c\u8ba1\u7b97\u7ed3\u679c\uff0c\u5171\u53d6\u51fa\u5355\u636e%s\u5f20\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", ids.size(), this.getContext().getFilterBuilder().buildQFilterLogString(filter)));
        return ids;
    }

    private Set<Long> loadUnConfirmBillIds(Set<Long> costObjectIds) {
        if (costObjectIds.isEmpty()) {
            return new HashSet<Long>(0);
        }
        QFilter filter = this.getContext().getFilterBuilder().buildCalcResultCommonFilter(this.args, new ArrayList<Object>(costObjectIds), true, true, true);
        if (!this.args.getCostCenterIds().isEmpty()) {
            filter.and(new QFilter("costcenter", "in", (Object)this.args.getCostCenterIds()));
        }
        filter.and(new QFilter("bizstatus", "=", (Object)"A"));
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadUnConfirmBillIds"), (String)"sca_costconfirm", (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong("id"));
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u5f53\u671f\u672a\u786e\u8ba4\u5931\u6548\u7684\u6210\u672c\u786e\u8ba4\u5355%s\u5f20\uff0c\u5f85\u5220\u9664\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", ids.size(), this.getContext().getFilterBuilder().buildQFilterLogString(filter)));
        return ids;
    }

    private void expireCalcResult(Set<Long> calcResultIds) {
        if (calcResultIds == null || calcResultIds.isEmpty()) {
            return;
        }
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(calcResultIds.size());
        for (Long id : calcResultIds) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("org", -5, (Object)999999L), new SqlParameter("id", -5, (Object)id)};
            paramsList.add(params);
        }
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_calcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)this.getContext().getInputArgs().getPeriodId())});){
            DB.executeBatch((DBRoute)new DBRoute("cal"), (String)SQL_UPDATE_CALC_RESULT, paramsList);
        }
    }

    private void deleteNotVoucher(Set<Long> costObjectIds) {
        QFilter filter = this.getContext().getFilterBuilder().buildCalcResultCommonFilter(this.args, new ArrayList<Object>(costObjectIds), true, true, true);
        filter.and("vouchernum", "=", (Object)" ");
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(".deleteNotVoucher"), (String)"sca_resourceabsorb", (String)"id", (QFilter[])filter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong("id"));
            }
        }
        if (!ids.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sca_resourceabsorb"), (Object[])ids.toArray());
        }
        logger.info(String.format("\u5220\u9664\u65e0\u51ed\u8bc1\u7684\u8d44\u6e90\u8d39\u7528\u5438\u6536\u6210\u672c\u5355 %s \u5f20\uff0c\u5220\u9664\u6761\u4ef6\uff1a\r\n %s", ids.size(), this.getContext().getFilterBuilder().buildQFilterLogString(filter)));
    }
}

