/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.sca.algox.utils.PeriodHelper;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.CalcTaskType;
import kd.macc.sca.mservice.costcalc.action.AbstractCalcAction;

public class InitializeAction
extends AbstractCalcAction {
    private static final Log logger = LogFactory.getLog(InitializeAction.class);
    private CostCalcArgs args;
    private DynamicObject costAcctObj;

    @Override
    protected void doExecute() {
        this.args = this.getContext().getInputArgs();
        if (this.args.getCostAccountId() == null || Long.compare(0L, this.args.getCostAccountId()) == 0) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6267\u884c\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u8bf7\u4f20\u5165\u6210\u672c\u8d26\u7c3f\u53c2\u6570\u503c\u3002", (String)"InitializeAction_0", (String)"macc-sca-mservice", (Object[])new Object[0]));
        }
        ArrayList<String> selectFields = new ArrayList<String>(4);
        selectFields.add("calorg");
        selectFields.add("costtype");
        selectFields.add("calpolicy");
        MainEntityType subCostAcctType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"cal_bd_costaccount", selectFields);
        this.costAcctObj = BusinessDataServiceHelper.loadSingleFromCache((Object)this.args.getCostAccountId(), (DynamicObjectType)subCostAcctType);
        this.initEnableFactory();
        this.checkAndInitOrg();
        this.checkAndInitPeriod();
        this.checkAndInitCurrency();
        this.checkAndInitCostType();
        this.checkAndInitCalType();
        this.initCheckWay();
    }

    private void initEnableFactory() {
        this.args.setEnableMulFactory(CostAccountHelper.isEnableMulFactory((Long)this.args.getCostAccountId()));
    }

    private void checkAndInitOrg() {
        Long calOrgId = this.costAcctObj.getLong("calorg.id");
        if (calOrgId == null || Long.compare(0L, calOrgId) == 0) {
            if (this.args.getOrgId() == null || Long.compare(0L, this.args.getOrgId()) == 0) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6267\u884c\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u8bf7\u4f20\u5165\u6838\u7b97\u7ec4\u7ec7\u53c2\u6570\u503c\u3002", (String)"InitializeAction_1", (String)"macc-sca-mservice", (Object[])new Object[0]));
            }
            return;
        }
        if (this.args.getOrgId() == null || Long.compare(0L, this.args.getOrgId()) == 0) {
            this.args.setOrgId(calOrgId);
        } else if (Long.compare(this.args.getOrgId(), calOrgId) != 0) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u4f20\u5165\u7684\u6838\u7b97\u7ec4\u7ec7\u53c2\u6570\u503c%1$s\uff0c\u548c\u8d26\u7c3f\u7684\u6838\u7b97\u7ec4\u7ec7%2$s\u4e0d\u4e00\u81f4\u3002", (String)"InitializeAction_3", (String)"macc-sca-mservice", (Object[])new Object[0]), this.args.getOrgId(), calOrgId));
        }
    }

    private void checkAndInitPeriod() {
        QFilter qfCostAccount;
        QFilter qfOrg;
        DynamicObject sysCtrlEntity;
        if ((this.args.getPeriodId() == null || Long.compare(0L, this.args.getPeriodId()) == 0) && (sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id,entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg = new QFilter("org", "=", (Object)this.args.getOrgId()), qfCostAccount = new QFilter("entry.costaccount", "=", (Object)this.args.getCostAccountId())})) != null) {
            this.args.setPeriodId(Long.valueOf(sysCtrlEntity.getLong("currentperiod")));
        }
        if (this.args.getStartDate() == null || this.args.getEndDate() == null) {
            Date[] dates = this.getContext().getCurrPeriodDate(this.args.getPeriodId());
            if (this.args.getStartDate() == null) {
                this.args.setStartDate(dates[0]);
            }
            if (this.args.getEndDate() == null) {
                this.args.setEndDate(dates[1]);
            }
        }
        if (this.args.getPrePeriodId() == null) {
            this.args.setPrePeriodId(PeriodHelper.getPrePeriodId((Object)this.args.getPeriodId()));
        }
    }

    private void checkAndInitCurrency() {
        if (this.args.getCurrencyId() == null || Long.compare(0L, this.args.getCurrencyId()) == 0) {
            Long calpolicy = this.costAcctObj.getLong("calpolicy.id");
            if (calpolicy == null || Long.compare(0L, calpolicy) == 0) {
                return;
            }
            DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy)});
            this.args.setCurrencyId(Long.valueOf(result.getLong("currency")));
        }
    }

    private void checkAndInitCostType() {
        Long costTypeId = this.costAcctObj.getLong("costtype.masterid");
        this.args.setCostTypeId(costTypeId);
    }

    private void checkAndInitCalType() {
        if (this.getContext().getTaskType() == CalcTaskType.FinishCalc || this.getContext().getTaskType() == CalcTaskType.RealtimeFinishCalc) {
            this.args.setMatCalType("3");
            this.args.setMfgCalType("4");
        } else if (this.getContext().getTaskType() == CalcTaskType.PeriodEndCalc) {
            this.args.setMatCalType("1");
            this.args.setMfgCalType("2");
        }
    }

    private void initCheckWay() {
        if (this.getContext().getTaskType() == CalcTaskType.FinishCalcCheck || this.getContext().getTaskType() == CalcTaskType.PeriodEndCalcCheck) {
            this.args.setCheckWay(0);
        } else {
            this.args.setCheckWay(1);
        }
    }
}

