/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.algox.utils.TaskHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.common.costcalc.CalcResultEntryRow;
import kd.macc.sca.common.costcalc.CalcResultHeader;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.common.costcalc.ShareHelper;
import kd.macc.sca.common.costcalc.groupkey.MatFinalGroupKey;
import kd.macc.sca.common.helper.ProAllocStdHelper;
import kd.macc.sca.mservice.costcalc.CalcTaskType;
import kd.macc.sca.mservice.costcalc.CostCalcFilterBuilder;
import kd.macc.sca.mservice.costcalc.ProAllocHelper;
import kd.macc.sca.mservice.costcalc.TaskRecorder;
import kd.macc.sca.mservice.costcalc.action.AbstractSingleBatchAction;
import kd.macc.sca.mservice.costcalc.action.StdCostCalcHelper;
import kd.macc.sca.mservice.costcalc.groupkey.MatStdCostItem;
import kd.macc.sca.mservice.costcalc.groupkey.MatStdCostKey;
import kd.macc.sca.mservice.costcalc.groupkey.MaterialKey;

class MatFinalCalcAction
extends AbstractSingleBatchAction {
    private static final Log logger = LogFactory.getLog(MatFinalCalcAction.class);
    private static final String[] ADJUST_DATATYPES = new String[]{"1", "2", "3"};
    private CostCalcArgs args;
    private TaskRecorder taskRecorder;
    private CostCalcFilterBuilder filterBuilder;
    private Map<MatFinalGroupKey, CalcResultEntryRow> sumEntryRows = new HashMap<MatFinalGroupKey, CalcResultEntryRow>();
    private Set<Long> onlyClearOnce = new HashSet<Long>();

    MatFinalCalcAction() {
    }

    private String getSelectField() {
        return "id,org orgid,costaccount costaccountid,costobject costobjectid,entryentity.obj belongobj,entryentity.producttype producttype,costcenter costcenterid,period periodid,entryentity.resource resourceid,entryentity.costlevel costlevel,entryentity.calcbasis calcbasis,entryentity.element elementid,entryentity.subelement subelementid,entryentity.material materialid,entryentity.auxpty auxptyid,entryentity.matversion matversionid,entryentity.keycol keycol,entryentity.keycolid keycolid,%s,entryentity.difftype difftype,entryentity.caltype caltype,0 stdqty,0 stdcost,0 totalqty,0 totalamount,%s,entryentity.diff diff,0 totalstdqty,0 totalstdamount,0 costupdatediffamt";
    }

    private String getSelectFieldOfDatatype() {
        return "id,org orgid,costaccount costaccountid,entryentity.obj costobjectid,entryentity.producttype producttype,costcenter costcenterid,period periodid,entryentity.resource resourceid,'' costlevel,entryentity.calcbasis calcbasis,entryentity.element elementid,entryentity.subelement subelementid,entryentity.material materialid,entryentity.auxpty auxptyid,entryentity.matversion matversionid,%s,entryentity.difftype difftype,entryentity.caltype caltype,0 stdqty,0 stdcost,0 totalqty,0 totalamount,%s,entryentity.diff diff,0 totalstdqty,0 totalstdamount,0 costupdatediffamt";
    }

    private String getSelectField4TotalComp() {
        return "id,org orgid,costaccount costaccountid,costobject costobjectid,entryentity.obj belongobj,entryentity.producttype producttype,costcenter costcenterid,period periodid,entryentity.resource resourceid,entryentity.costlevel costlevel,entryentity.calcbasis calcbasis,entryentity.element elementid,entryentity.subelement subelementid,entryentity.material materialid,entryentity.auxpty auxptyid,entryentity.matversion matversionid,entryentity.keycol keycol,entryentity.keycolid keycolid,entryentity.datatype datatype,entryentity.difftype difftype,entryentity.caltype caltype,0 stdqty,0 stdcost,entryentity.totalqty totalqty,entryentity.totalamount totalamount,0 pdstartqty,0 pdstartamount,0 pdcurrqty,0 pdcurramount,0 pdcompqty,0 pdcompanount,0 pdendqty,0 pdendamount,entryentity.diff diff,entryentity.stdqty totalstdqty,entryentity.stdamount totalstdamount,entryentity.costupdatediffamt costupdatediffamt";
    }

    @Override
    public Long getDetailTaskConfigId() {
        if (this.getContext().isFinishCalc()) {
            return FinshCalcCheck.CALCTASKTOTALFINISHFEE;
        }
        return TaskHelper.PDENDENTRY_MFGCALC_TASKID;
    }

    public MathContext getMathContext() {
        if (this.getContext() != null) {
            return this.getContext().getAmountMathContext();
        }
        return new MathContext(10, RoundingMode.HALF_UP);
    }

    @Override
    protected void doExecute() {
        logger.info(String.format("\u5b8c\u5de5\u53ca\u7d2f\u8ba1\u8d39\u7528\uff1a\u5f00\u59cb\uff0c\u7b2c %s/ %s\u6279\uff0c\u5171 %s \u5f20", this.getSingleBatchContext().getCurrBatchSeq(), this.getSingleBatchContext().getBatchCount(), this.getSingleBatchContext().getCostObjectIds().size()));
        this.args = this.getContext().getInputArgs();
        this.taskRecorder = this.getResultManager().getTaskRecorder();
        this.filterBuilder = this.getContext().getFilterBuilder();
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordDetail(this.getDetailTaskConfigId(), "2");
        }
        this.doCalcuate();
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordProcess(this.getDetailTaskConfigId(), "2");
            this.upateTaskRecordDetail(this.getDetailTaskConfigId(), "4");
        }
        logger.info("\u5b8c\u5de5\u53ca\u7d2f\u8ba1\u8d39\u7528\uff1a\u7ed3\u675f");
    }

    private void doCalcuate() {
        this.doCalcPrePeriodData();
        this.doCalcCurrentPeriodData();
        this.doCalcAbsorbAdjustData();
        this.doCalcCurrentUpdateDiff();
        this.doCalcCompleted();
        this.doCalcPrevPeriodTotalCompData();
        this.doCalcResultSumRow();
    }

    private void doCalcCurrentUpdateDiff() {
        logger.info(String.format("\u6210\u672c\u66f4\u65b0\u5dee\u5f02\uff1a\u5f00\u59cb\uff0c\u7b2c %s/ %s\u6279\uff0c\u5171 %s \u5f20", this.getSingleBatchContext().getCurrBatchSeq(), this.getSingleBatchContext().getBatchCount(), this.getSingleBatchContext().getCostObjectIds().size()));
        this.args = this.getContext().getInputArgs();
        ArrayList<QFilter> costupdateeQF = new ArrayList<QFilter>();
        this.filterBuilder.wrapQFilter4OrgAndCostCenter(costupdateeQF, "productentry.org", "productentry.costcenter", this.getContext().getInputArgs());
        costupdateeQF.add(new QFilter("productentry.period", "=", (Object)this.getContext().getInputArgs().getPeriodId()));
        costupdateeQF.add(new QFilter("productentry.costaccountbook", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        costupdateeQF.add(new QFilter("productentry.costobject", "in", this.getSingleBatchContext().getMainSideCostObjectIds()));
        costupdateeQF.add(new QFilter("productentry.updatediff", "!=", (Object)0));
        costupdateeQF.add(new QFilter("productentry.updatediff", "is not null", null));
        String selectFields = "id, productentry.org orgid,productentry.costaccountbook costaccountid,productentry.costcenter costcenterid,productentry.costobject.mainproobj costobjectid,productentry.costobject belongobj,productentry.costobject.producttype producttype,productentry.calcbasis calcbasis,productentry.procelement.masterid elementid,productentry.procsubelement.masterid subelementid,productentry.prosubmaterial.masterid materialid,productentry.promatversion.id matversionid,productentry.proauxpty.id auxptyid,productentry.resource resourceid,productentry.updatediff updatediff,productentry.costlevel costlevel,'3' difftype";
        int rowCount = 0;
        String[] dataTypes = new String[]{"1", "2"};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadCostUpdateEstablished"), (String)"cad_costupdateestablished", (String)selectFields, (QFilter[])costupdateeQF.toArray(new QFilter[0]), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ++rowCount;
                BigDecimal amount = row.getBigDecimal("updatediff");
                for (String dataType : dataTypes) {
                    MatFinalGroupKey key = this.buildGroupKey(row, dataType);
                    Long costObjectId = row.getLong("costobjectid");
                    if (CadEmptyUtils.isEmpty((Long)costObjectId)) {
                        costObjectId = row.getLong("belongobj");
                    }
                    CalcResultEntryRow sumRow = this.sumEntryRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
                    sumRow.setCostObject(costObjectId.longValue());
                    sumRow.setProductType(row.getString("producttype"));
                    sumRow.setElement(row.getLong("elementid").longValue());
                    sumRow.setSubElement(row.getLong("subelementid").longValue());
                    sumRow.setResource(row.getLong("resourceid").longValue());
                    sumRow.setCostLevel(row.getString("costlevel"));
                    sumRow.setCalcbasis(row.getString("calcbasis"));
                    sumRow.setCalType(this.args.getMfgCalType());
                    sumRow.setDataType(dataType);
                    sumRow.addPdCurrAmount(amount.setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP));
                    sumRow.setDiffType(row.getString("difftype"));
                    sumRow.addCostUpdateDiffAmount(amount.setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP));
                    sumRow.addTaskValInfo("cad_costupdateestablished", row.getLong("id").toString(), "amount", "CostUpdateDiffAmount", amount);
                    sumRow.addTaskValInfo("cad_costupdateestablished", row.getLong("id").toString(), "amount", "PdCurrAmount", amount);
                }
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u6210\u672c\u66f4\u65b0\u786e\u8ba4\u5355\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(costupdateeQF)));
    }

    private void doCalcAbsorbAdjustData() {
        logger.info(String.format("\u5438\u6536\u6210\u672c\u8c03\u6574\u5904\u7406\uff1a\u5f00\u59cb\uff0c\u7b2c %s / %s\u6279\uff0c\u5171 %s \u5f20", this.getSingleBatchContext().getCurrBatchSeq(), this.getSingleBatchContext().getBatchCount(), this.getSingleBatchContext().getCostObjectIds().size()));
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        this.getContext().getFilterBuilder().warpQFilter4Period(filters, "org", true, this.args);
        this.getContext().getFilterBuilder().wrapQFilter4CostObjects(filters, "costobject", this.getSingleBatchContext().getCostObjectIds());
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        String selectedFields = "id,org orgid,costaccount costaccountid,costobject costobjectid,costobject belongobj,costobject.producttype producttype,costcenter costcenterid,period periodid,resource resourceid,'2' costlevel,'001' calcbasis,entryentity.element elementid,entryentity.subelement subelementid,0 materialid,0 auxptyid,0 matversionid,'2' difftype,'1' caltype,0 stdqty,0 stdcost,0 totalqty,0 totalamount,0 pdstartqty,0 pdstartamount,0 pdcurrqty,entryentity.amount pdcurramount,0 pdcompqty,0 pdcompanount,0 pdendqty,0 pdendamount,0 diffqty,0 diff,0 totalstdqty,0 totalstdamount,0 costupdatediffamt";
        int rowCount = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"MatFinalCalcAction_doCalcAbsorbAdjustData", (String)"sca_absorbadjust", (String)selectedFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                ++rowCount;
                BigDecimal amount = row.getBigDecimal("pdcurramount");
                for (String dataType : ADJUST_DATATYPES) {
                    MatFinalGroupKey key = this.buildGroupKey(row, dataType);
                    CalcResultEntryRow sumRow = this.sumEntryRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
                    sumRow.setCostObject(row.getLong("belongobj").longValue());
                    sumRow.setProductType("C");
                    sumRow.setElement(row.getLong("elementid").longValue());
                    sumRow.setSubElement(row.getLong("subelementid").longValue());
                    sumRow.setResource(row.getLong("resourceid").longValue());
                    sumRow.setCostLevel("2");
                    sumRow.setCalcbasis("001");
                    sumRow.setCalType(this.args.getMfgCalType());
                    sumRow.setDataType(dataType);
                    sumRow.addPdCurrAmount(amount.setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP));
                    sumRow.setDiffType("2");
                    sumRow.addTaskValInfo("sca_absorbadjust", row.getLong("id").toString(), "amount", "PdCurrAmount", amount);
                }
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u5438\u6536\u8c03\u6574\u5355\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(filters)));
    }

    private void doCalcPrePeriodData() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        this.filterBuilder.warpQFilter4Org(filters, "org", this.args);
        this.filterBuilder.wrapQFilter4CostObjects(filters, "costobject", this.getSingleBatchContext().getCostObjectIds());
        filters.add(new QFilter("period", "=", (Object)this.args.getPrePeriodId()));
        filters.add(new QFilter("entryentity.difftype", "in", Arrays.asList("1", "2", "3")));
        String selectField = String.format(this.getSelectField(), "entryentity.datatype datatype", "entryentity.pdendqty pdstartqty,entryentity.pdendamount pdstartamount,0 pdcurrqty,0 pdcurramount,0 pdcompqty,0 pdcompanount,0 pdendqty,0 pdendamount,entryentity.id entryid,entryentity.subentryentity.id subid,entryentity.subentryentity.calckeycol calckeycol,entryentity.subentryentity.subcurrqty subcurrqty");
        int rowCount = 0;
        HashSet<Long> entryIdSet = new HashSet<Long>(10);
        try (DataSet matAndMfgDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("sumPrePeriodData"), (String)"sca_calcresult", (String)selectField, (QFilter[])filters.toArray(new QFilter[0]), null);){
            while (matAndMfgDataSet.hasNext()) {
                CalcResultEntryRow sumRow;
                Row row = matAndMfgDataSet.next();
                String diffType = row.getString("difftype");
                String productType = row.getString("producttype");
                MatFinalGroupKey key = this.buildGroupKey(row);
                Long entryid = row.getLong("entryid");
                Long subid = row.getLong("subid");
                if ("3".equals(diffType)) {
                    sumRow = this.sumEntryRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
                    sumRow.setCostObject(row.getLong("belongobj").longValue());
                    sumRow.setProductType(row.getString("producttype"));
                    sumRow.addPdStartQty(row.getBigDecimal("pdstartqty"));
                    sumRow.addPdStartAmount(row.getBigDecimal("pdstartamount"));
                    sumRow.addTaskValInfo("sca_calcresult", row.getString("id"), "pdendqty", "PdStartQty", row.getBigDecimal("pdstartqty"));
                    sumRow.addTaskValInfo("sca_calcresult", row.getString("id"), "costupdatediffamt", "PdStartAmount", row.getBigDecimal("pdstartamount"));
                } else if ("C".equals(productType)) {
                    sumRow = this.sumEntryRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
                    sumRow.setCostObject(row.getLong("belongobj").longValue());
                    sumRow.setProductType(row.getString("producttype"));
                    if (!CadEmptyUtils.isEmpty((Long)subid)) {
                        Long calckeycolId = row.getLong("calckeycol");
                        if (!CadEmptyUtils.isEmpty((Long)calckeycolId)) {
                            sumRow.addKeycolVal(calckeycolId, row.getBigDecimal("subcurrqty"));
                        }
                        if (!entryIdSet.add(entryid)) continue;
                    }
                    sumRow.addPdStartQty(row.getBigDecimal("pdstartqty"));
                    sumRow.addPdStartAmount(row.getBigDecimal("pdstartamount"));
                    sumRow.addTaskValInfo("sca_calcresult", row.getString("id"), "pdendqty", "PdStartQty", row.getBigDecimal("pdstartqty"));
                    sumRow.addTaskValInfo("sca_calcresult", row.getString("id"), "pdendamount", "PdStartAmount", row.getBigDecimal("pdstartamount"));
                }
                ++rowCount;
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u4e0a\u671f\u671f\u672b\u6210\u672c\uff0c\u5171\u53d6\u51fa\u5206\u5f55%s\u6761\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(filters)));
    }

    private void doCalcCurrentPeriodData() {
        HashSet<String> diffTypes = new HashSet<String>(2);
        diffTypes.add("1");
        diffTypes.add("2");
        HashSet<String> calTypes = new HashSet<String>(2);
        calTypes.add(this.args.getMatCalType());
        calTypes.add(this.args.getMfgCalType());
        for (Map.Entry<Long, CalcResultHeader> entry : this.getSingleBatchResultManager().getCalcResults().entrySet()) {
            CalcResultHeader calcResult = entry.getValue();
            for (CalcResultEntryRow entryRow : calcResult.getEntryRows()) {
                if (!calTypes.contains(entryRow.getCalType()) || !diffTypes.contains(entryRow.getDiffType())) continue;
                if (StringUtils.equals((CharSequence)entryRow.getCalType(), (CharSequence)this.args.getMatCalType())) {
                    if (StringUtils.equals((CharSequence)entryRow.getDataType(), (CharSequence)"1")) {
                        this.doCalcMatCurrentPeriodData(calcResult, entryRow);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)entryRow.getDataType(), (CharSequence)"2")) continue;
                    this.doCalcSubMatCurrentPeriodData(calcResult, entryRow);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)entryRow.getCalType(), (CharSequence)this.args.getMfgCalType())) continue;
                this.doCalcFeeCurrentPeriodData(calcResult, entryRow);
                this.doCalcSubFeeCurrentPeriodData(calcResult, entryRow);
            }
        }
    }

    private void doCalcMatCurrentPeriodData(CalcResultHeader calcResult, CalcResultEntryRow entryRow) {
        MatFinalGroupKey key = this.buildGroupKey(calcResult, entryRow);
        CalcResultEntryRow sumRow = this.sumEntryRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
        sumRow.setCostObject(entryRow.getCostObject());
        sumRow.setProductType(entryRow.getProductType());
        sumRow.unionKeyColVal(entryRow.getKeycolValMap());
        sumRow.addPdCurrQty(entryRow.getPdCurrQty());
        sumRow.addPdCurrAmount(entryRow.getPdCurrAmount());
        sumRow.addAllTaskValInfos(entryRow, "PdCurrQty");
        sumRow.addAllTaskValInfos(entryRow, "PdCurrAmount");
    }

    private void doCalcSubMatCurrentPeriodData(CalcResultHeader calcResult, CalcResultEntryRow entryRow) {
        MatFinalGroupKey key = this.buildGroupKey(calcResult, entryRow);
        CalcResultEntryRow sumRow = this.sumEntryRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
        sumRow.setCostObject(entryRow.getCostObject());
        sumRow.setProductType(entryRow.getProductType());
        sumRow.addPdCurrQty(entryRow.getPdCurrQty());
        sumRow.addPdCurrAmount(entryRow.getPdCurrAmount());
        sumRow.addAllTaskValInfos(entryRow, "PdCurrQty");
        sumRow.addAllTaskValInfos(entryRow, "PdCurrAmount");
    }

    private void doCalcFeeCurrentPeriodData(CalcResultHeader calcResult, CalcResultEntryRow entryRow) {
        MatFinalGroupKey key = this.buildGroupKey(calcResult, entryRow);
        key.setDataType("1");
        CalcResultEntryRow sumRow = this.sumEntryRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
        sumRow.setCostObject(entryRow.getCostObject());
        sumRow.setProductType(entryRow.getProductType());
        sumRow.addPdCurrQty(entryRow.getPdCurrQty());
        sumRow.addPdCurrAmount(entryRow.getPdCurrAmount());
        sumRow.addAllTaskValInfos(entryRow, "PdCurrQty");
        sumRow.addAllTaskValInfos(entryRow, "PdCurrAmount");
    }

    private void doCalcSubFeeCurrentPeriodData(CalcResultHeader calcResult, CalcResultEntryRow entryRow) {
        MatFinalGroupKey key = this.buildGroupKey(calcResult, entryRow);
        key.setDataType("2");
        CalcResultEntryRow sumRow = this.sumEntryRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
        sumRow.setCostObject(entryRow.getCostObject());
        sumRow.setProductType(entryRow.getProductType());
        sumRow.addPdCurrQty(entryRow.getPdCurrQty());
        sumRow.addPdCurrAmount(entryRow.getPdCurrAmount());
        sumRow.addAllTaskValInfos(entryRow, "PdCurrQty");
        sumRow.addAllTaskValInfos(entryRow, "PdCurrAmount");
    }

    private void doCalcCompleted() {
        int rowCount = 0;
        try (DataSet compDataSet = this.loadFactnedoutputBill();){
            DataSet costInfoDataSet = compDataSet.copy().groupBy(new String[]{"manuorg", "keycol", "keycolid", "matcostid"}).finish().distinct();
            DataSet calCompDataSet = compDataSet.groupBy(new String[]{"id", "orgid", "costaccountid", "periodid", "costcenterid", "costobjectid", "belongobj", "producttype", "keycol", "keycolid", "matcostid", "materialid", "matversionid", "auxptyid", "qty", "bizdate"}).finish().distinct();
            Map<MaterialKey, Map<MatStdCostKey, List<MatStdCostItem>>> matStdCosts = this.loadMatStdCost(costInfoDataSet);
            while (calCompDataSet.hasNext()) {
                Row row = calCompDataSet.next();
                ++rowCount;
                MaterialKey matKey = new MaterialKey(row.getLong("materialid"), row.getLong("matversionid"), row.getLong("auxptyid"), row.getString("keycol"), row.getLong("keycolid"), row.getLong("matcostid"));
                Map<MatStdCostKey, List<MatStdCostItem>> matStdCost = matStdCosts.get(matKey);
                if (matStdCost == null) {
                    logger.info(String.format("\u7269\u6599\u6ca1\u6709\u627e\u5230\u6807\u51c6\u6210\u672c\uff0c\u7565\u8fc7\u672c\u884c\u5b8c\u5de5\u6210\u672c\u8ba1\u7b97\u3002\u5b8c\u5de5\u5355id = %s, \u7269\u6599 = %s, \u7248\u672c = %s, \u8f85\u52a9\u5c5e\u6027 =%s ", row.getLong("id"), matKey.getMaterialId(), matKey.getMatVersionId(), matKey.getAuxptyId()));
                    continue;
                }
                boolean existEffectCost = false;
                for (Map.Entry<MatStdCostKey, List<MatStdCostItem>> entry : matStdCost.entrySet()) {
                    MatStdCostKey costKey = entry.getKey();
                    Date bizDate = row.getDate("bizdate");
                    if (!costKey.isPurPrice().booleanValue() && (costKey.getEffectDate().getTime() > bizDate.getTime() || bizDate.getTime() >= costKey.getExpDate().getTime())) continue;
                    this.doCalcCompletedRow(row, matKey, entry.getKey(), entry.getValue());
                    existEffectCost = true;
                }
                if (existEffectCost) continue;
                logger.info(String.format("\u4e1a\u52a1\u65e5\u671f\u6ca1\u6709\u627e\u5230\u6709\u6548\u7684\u6807\u51c6\u6210\u672c\uff0c\u7565\u8fc7\u672c\u884c\u5b8c\u5de5\u6210\u672c\u8ba1\u7b97\u3002\u5b8c\u5de5\u5355id = %s, \u7269\u6599 = %s, \u7248\u672c = %s, \u8f85\u52a9\u5c5e\u6027 =%s, \u73b0\u6709\u6807\u51c6\u6210\u672c\u4ef7\u76ee\u6570 = %s ", row.getLong("id"), matKey.getMaterialId(), matKey.getMatVersionId(), matKey.getAuxptyId(), matStdCost.size()));
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u672c\u671f\u5b8c\u5de5\u5165\u5e93\u6570\u636e\uff0c\u5171\u53d6\u51fa\u5206\u5f55%s\u6761 ", rowCount));
    }

    private void doCalcCompletedRow(Row row, MaterialKey matKey, MatStdCostKey costKey, List<MatStdCostItem> costItems) {
        if (!costKey.isPurPrice().booleanValue()) {
            BigDecimal qty = row.getBigDecimal("qty");
            StdCostCalcHelper.effectTailDiff(qty, Lists.newArrayList((Object[])costItems.toArray()), this.getContext().getCurrencyAmtScale(), "dataType", "subElementId", "stdPrice", "tmpAmt", null);
        }
        for (MatStdCostItem costItem : costItems) {
            if (costKey.isPurPrice().booleanValue() || StringUtils.equals((CharSequence)costItem.getDataType(), (CharSequence)"2") || StringUtils.equals((CharSequence)costItem.getDataType(), (CharSequence)"3")) {
                this.addCompletedEntryRow(row, costItem, "2");
            }
            if (!costKey.isPurPrice().booleanValue() && !StringUtils.equals((CharSequence)costItem.getDataType(), (CharSequence)"2") && !StringUtils.equals((CharSequence)costItem.getDataType(), (CharSequence)"4")) continue;
            this.addCompletedEntryRow(row, costItem, "1");
        }
    }

    private void addCompletedEntryRow(Row row, MatStdCostItem costItem, String dataType) {
        String diffType = "";
        diffType = StringUtils.equals((CharSequence)costItem.getSubElementType(), (CharSequence)"001") || StringUtils.equals((CharSequence)costItem.getSubElementType(), (CharSequence)"002") ? "1" : "2";
        String costlevel = "";
        costlevel = "2".equals(diffType) || costItem.getResourceId() != 0L ? (StringUtils.equals((CharSequence)costItem.getDataType(), (CharSequence)"2") ? "2" : "3") : "";
        Long mainObjId = row.getLong("costobjectid");
        if (CadEmptyUtils.isEmpty((Long)mainObjId)) {
            mainObjId = row.getLong("belongobj");
        }
        MatFinalGroupKey key = new MatFinalGroupKey(row.getLong("orgid"), row.getLong("costaccountid"), row.getLong("costcenterid"), mainObjId, mainObjId, "C", costItem.getResourceId(), costlevel, costItem.getCalcbasis(), costItem.getElementId(), costItem.getSubElementId(), costItem.getMaterialId(), costItem.getAuxptyId(), costItem.getMatVersionId(), dataType, diffType, costItem.getKeycol(), costItem.getKeycolId());
        Long belongObj = row.getLong("belongobj");
        String productType = row.getString("producttype");
        CalcResultEntryRow sumRow = this.sumEntryRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
        sumRow.setCostObject(mainObjId.longValue());
        sumRow.setProductType("C");
        BigDecimal stdqty = this.getBigDecimal(row.getBigDecimal("qty")).multiply(costItem.getQty());
        sumRow.addPdCompQty(stdqty);
        BigDecimal stdcost = costItem.getTmpAmt();
        if (stdcost != null) {
            sumRow.addPdCompAmount(stdcost);
        } else {
            stdcost = this.getBigDecimal(row.getBigDecimal("qty")).multiply(costItem.getStdPrice(), this.getMathContext());
            stdcost = stdcost.setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
            sumRow.addPdCompAmount(stdcost);
        }
        MatFinalGroupKey sideJoinKey = new MatFinalGroupKey(row.getLong("orgid"), row.getLong("costaccountid"), row.getLong("costcenterid"), mainObjId, belongObj, productType, costItem.getResourceId(), costlevel, costItem.getCalcbasis(), costItem.getElementId(), costItem.getSubElementId(), costItem.getMaterialId(), costItem.getAuxptyId(), costItem.getMatVersionId(), dataType, diffType, costItem.getKeycol(), costItem.getKeycolId());
        CalcResultEntryRow sideJoinRow = this.getSingleBatchContext().getMainSideCompletionMap().computeIfAbsent(sideJoinKey, s -> new CalcResultEntryRow());
        sideJoinRow.setCostObject(belongObj.longValue());
        sideJoinRow.setProductType(productType);
        sideJoinRow.addPdCompQty(stdqty);
        sideJoinRow.addTaskValInfo("cad_factnedoutputbill", row.getString("id"), String.format("qty %s * stdQty %s", row.getBigDecimal("qty"), costItem.getQty()), "PdCompQty", stdqty);
        sideJoinRow.addPdCompAmount(stdcost);
        sideJoinRow.addTaskValInfo("cad_factnedoutputbill", row.getString("id"), String.format("qty %s * stdPrice %s", row.getBigDecimal("qty"), costItem.getStdPrice()), "PdCompAmount", stdcost);
    }

    private DataSet loadFactnedoutputBill() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        this.filterBuilder.wrapQFilter4OrgAndCostCenter(filters, "org", "costcenter", this.args);
        filters.add(new QFilter("bookdate", "<=", (Object)this.args.getEndDate()));
        filters.add(new QFilter("bookdate", ">=", (Object)this.args.getStartDate()));
        filters.add(new QFilter("entryentity.costobject", "in", this.getSingleBatchContext().getMainSideCostObjectIds()));
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        filters.add(new QFilter("appnum", "=", (Object)"sca"));
        filters.add(new QFilter("entrycost.costaccount", "=", (Object)this.args.getCostAccountId()));
        boolean isUseMatVer = kd.macc.sca.algox.utils.CostTypeHelper.isUseMatVer((Long)this.args.getCostAccountId());
        String selectFields = "id," + this.args.getOrgId().toString() + " orgid," + this.args.getCostAccountId().toString() + " costaccountid," + this.args.getPeriodId().toString() + " periodid,manuorg,entrycost.entrykeycol keycol,entrycost.entrykeycolid keycolid,entrycost.matcostid matcostid,entryentity.costobject.costcenter costcenterid,entryentity.costobject.mainproobj costobjectid,entryentity.costobject.id belongobj,entryentity.costobject.producttype producttype,entryentity.costobject.material.masterid materialid,entryentity.costobject.bomversion.id matversionid,entryentity.costobject.auxpty.id auxptyid,entryentity.qty qty,srcauditdate bizdate";
        if (!isUseMatVer) {
            selectFields = "id," + this.args.getOrgId().toString() + " orgid," + this.args.getCostAccountId().toString() + " costaccountid," + this.args.getPeriodId().toString() + " periodid,manuorg,entrycost.entrykeycol keycol,entrycost.entrykeycolid keycolid,entrycost.matcostid matcostid,entryentity.costobject.costcenter costcenterid,entryentity.costobject.mainproobj costobjectid,entryentity.costobject.id belongobj,entryentity.costobject.producttype producttype,entryentity.costobject.material.masterid materialid,0 matversionid,entryentity.costobject.auxpty.id auxptyid,entryentity.qty qty,srcauditdate bizdate";
        }
        logger.info(String.format("\u8bfb\u53d6\u672c\u671f\u5b8c\u5de5\u5165\u5e93\u6570\u636e\uff0c\u53d6\u6570\u6761\u4ef6\uff1a \r\n %s ", this.getContext().getFilterBuilder().buildQFilterLogString(filters)));
        return QueryServiceHelper.queryDataSet((String)this.getAlgoKey(""), (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    private void doCalcPrevPeriodTotalCompData() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        this.filterBuilder.warpQFilter4Org(filters, "org", this.args);
        this.filterBuilder.wrapQFilter4CostObjects(filters, "entryentity.obj", this.getSingleBatchContext().getMainSideCostObjectIds());
        filters.add(new QFilter("entryentity.caltype", "in", Arrays.asList("1", "3")));
        filters.add(new QFilter("period", "=", (Object)this.args.getPrePeriodId()));
        String selectField = this.getSelectField4TotalComp();
        int rowCount = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("sumPrevPeriodTotalCompData"), (String)"sca_calcresult", (String)selectField, (QFilter[])filters.toArray(new QFilter[0]), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ++rowCount;
                MatFinalGroupKey key = this.buildGroupKey(row);
                if (!"C".equals(key.getProductType())) {
                    CalcResultEntryRow joinSideRow = this.getSingleBatchContext().getMainSideCompletionMap().computeIfAbsent(key, s -> new CalcResultEntryRow());
                    joinSideRow.setCostObject(row.getLong("belongobj").longValue());
                    joinSideRow.setProductType(row.getString("producttype"));
                    joinSideRow.addTotalQty(row.getBigDecimal("totalqty"));
                    joinSideRow.addTotalAmount(row.getBigDecimal("totalamount"));
                    joinSideRow.addStdQty(row.getBigDecimal("totalstdqty"));
                    joinSideRow.addStdAmount(row.getBigDecimal("totalstdamount"));
                    joinSideRow.addCostUpdateDiffAmount(row.getBigDecimal("costupdatediffamt"));
                    joinSideRow.addTaskValInfo("sca_calcresult", row.getString("id"), "totalqty", "TotalQty", this.getBigDecimal(row.getBigDecimal("totalqty")));
                    joinSideRow.addTaskValInfo("sca_calcresult", row.getString("id"), "totalamount", "TotalAmount", this.getBigDecimal(row.getBigDecimal("totalamount")));
                    joinSideRow.addTaskValInfo("sca_calcresult", row.getString("id"), "stdqty", "StdQty", this.getBigDecimal(row.getBigDecimal("totalstdqty")));
                    joinSideRow.addTaskValInfo("sca_calcresult", row.getString("id"), "stdamount", "StdAmount", this.getBigDecimal(row.getBigDecimal("totalstdamount")));
                    joinSideRow.addTaskValInfo("sca_calcresult", row.getString("id"), "costupdatediffamt", "CostUpdateDiffAmount", this.getBigDecimal(row.getBigDecimal("costupdatediffamt")));
                    continue;
                }
                CalcResultEntryRow sumRow = this.sumEntryRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
                sumRow.setCostObject(row.getLong("belongobj").longValue());
                sumRow.setProductType(row.getString("producttype"));
                sumRow.addTotalQty(row.getBigDecimal("totalqty"));
                sumRow.addTotalAmount(row.getBigDecimal("totalamount"));
                sumRow.addStdQty(row.getBigDecimal("totalstdqty"));
                sumRow.addStdAmount(row.getBigDecimal("totalstdamount"));
                sumRow.addCostUpdateDiffAmount(row.getBigDecimal("costupdatediffamt"));
                sumRow.addTaskValInfo("sca_calcresult", row.getString("id"), "totalqty", "TotalQty", this.getBigDecimal(row.getBigDecimal("totalqty")));
                sumRow.addTaskValInfo("sca_calcresult", row.getString("id"), "totalamount", "TotalAmount", this.getBigDecimal(row.getBigDecimal("totalamount")));
                sumRow.addTaskValInfo("sca_calcresult", row.getString("id"), "stdqty", "StdQty", this.getBigDecimal(row.getBigDecimal("totalstdqty")));
                sumRow.addTaskValInfo("sca_calcresult", row.getString("id"), "stdamount", "StdAmount", this.getBigDecimal(row.getBigDecimal("totalstdamount")));
                sumRow.addTaskValInfo("sca_calcresult", row.getString("id"), "costupdatediffamt", "CostUpdateDiffAmount", this.getBigDecimal(row.getBigDecimal("costupdatediffamt")));
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u4e0a\u4e00\u671f\u7d2f\u8ba1\u5b8c\u5de5\u5165\u5e93\u6210\u672c\u660e\u7ec6\u884c\uff0c\u5171\u53d6\u51fa\u5206\u5f55%s\u6761\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(filters)));
    }

    private MatFinalGroupKey buildGroupKey(CalcResultHeader calcResult, CalcResultEntryRow entryRow) {
        return new MatFinalGroupKey(Long.valueOf(calcResult.getOrg()), Long.valueOf(calcResult.getCostAccount()), Long.valueOf(calcResult.getCostCenter()), Long.valueOf(calcResult.getCostObject()), Long.valueOf(entryRow.getCostObject()), entryRow.getProductType(), Long.valueOf(entryRow.getResource()), entryRow.getCostLevel(), entryRow.getCalcbasis(), Long.valueOf(entryRow.getElement()), Long.valueOf(entryRow.getSubElement()), Long.valueOf(entryRow.getMaterial()), Long.valueOf(entryRow.getAuxpty()), Long.valueOf(entryRow.getMatVersion()), entryRow.getDataType(), entryRow.getDiffType(), entryRow.getKeycol(), Long.valueOf(entryRow.getKeycolId()));
    }

    private MatFinalGroupKey buildGroupKey(Row row) {
        return new MatFinalGroupKey(row.getLong("orgid"), row.getLong("costaccountid"), row.getLong("costcenterid"), row.getLong("costobjectid"), row.getLong("belongobj"), row.getString("producttype"), row.getLong("resourceid"), row.getString("costlevel"), row.getString("calcbasis"), row.getLong("elementid"), row.getLong("subelementid"), row.getLong("materialid"), row.getLong("auxptyid"), row.getLong("matversionid"), row.getString("datatype"), row.getString("difftype"), row.getString("keycol"), row.getLong("keycolid"));
    }

    private MatFinalGroupKey buildGroupKey(Row row, String dataType) {
        Long costObjectId = row.getLong("costobjectid");
        if (CadEmptyUtils.isEmpty((Long)costObjectId)) {
            costObjectId = row.getLong("belongobj");
        }
        return new MatFinalGroupKey(row.getLong("orgid"), row.getLong("costaccountid"), row.getLong("costcenterid"), costObjectId, row.getLong("belongobj"), row.getString("producttype"), row.getLong("resourceid"), row.getString("costlevel"), row.getString("calcbasis"), row.getLong("elementid"), row.getLong("subelementid"), row.getLong("materialid"), row.getLong("auxptyid"), row.getLong("matversionid"), dataType, row.getString("difftype"), null, null);
    }

    private void doCalcResultSumRow() {
        HashSet<Object> currCostObjectIds = new HashSet<Object>(this.getSingleBatchContext().getCostObjectIds());
        for (Map.Entry<MatFinalGroupKey, CalcResultEntryRow> entry : this.sumEntryRows.entrySet()) {
            MatFinalGroupKey key = entry.getKey();
            CalcResultEntryRow srcSumRow = entry.getValue();
            if (!currCostObjectIds.contains(key.getCostObjectId())) continue;
            CalcResultHeader calcResult = this.getSingleBatchResultManager().getCalcResults().get(key.getCostObjectId());
            if (calcResult == null) {
                calcResult = this.addNewCalcResultHeader(key);
                this.onlyClearOnce.add(calcResult.getId());
            } else if (!this.onlyClearOnce.contains(calcResult.getId())) {
                this.onlyClearOnce.add(calcResult.getId());
                this.clearCalcResultSpecialEntry(calcResult);
            }
            if (key.getSubelementId() == null || Long.compare(key.getSubelementId(), 0L) == 0) continue;
            this.addCalcResultEntryRow(key, calcResult, srcSumRow);
            this.addSideJoinEntryRow(key, calcResult, srcSumRow);
        }
    }

    private void addSideJoinEntryRow(MatFinalGroupKey key, CalcResultHeader calcResult, CalcResultEntryRow srcSumRow) {
        Map<Long, Map<Long, CalcResultObjectInfo>> objectInfosMap = this.getSingleBatchContext().getObjectInfosMap();
        Map<Long, CalcResultObjectInfo> objectInfoMap = objectInfosMap.get(key.getCostObjectId());
        if (!CadEmptyUtils.isEmpty(objectInfoMap) && objectInfoMap.size() > 1) {
            for (Map.Entry<Long, CalcResultObjectInfo> objectInfoEntry : objectInfoMap.entrySet()) {
                CalcResultObjectInfo objectInfo = objectInfoEntry.getValue();
                String productType = objectInfo.getProductType();
                if ("C".equals(productType)) continue;
                long costObjectId = objectInfo.getCostObjectId();
                key.setBelongCostObjectId(Long.valueOf(costObjectId));
                key.setProductType(productType);
                if (!this.getSingleBatchContext().getMainSideCompletionMap().containsKey(key)) continue;
                CalcResultEntryRow joinSideRow = this.getSingleBatchContext().getMainSideCompletionMap().get(key);
                CalcResultEntryRow entryRow = calcResult.addNew();
                if (srcSumRow.getKeycolValMap() != null) {
                    entryRow.setKeycolValMap(srcSumRow.getKeycolValMap());
                }
                entryRow.setResource(key.getResourceId().longValue());
                entryRow.setCostLevel(key.getCostLevel());
                entryRow.setCalcbasis(key.getCalcBasis());
                entryRow.setElement(key.getElementId().longValue());
                entryRow.setSubElement(key.getSubelementId().longValue());
                entryRow.setMaterial(key.getMaterialId().longValue());
                entryRow.setAuxpty(key.getAuxptyId().longValue());
                entryRow.setMatVersion(key.getMatVersionId().longValue());
                entryRow.setKeycol(key.getKeycol());
                entryRow.setKeycolId(key.getKeycolId().longValue());
                entryRow.setCostObject(joinSideRow.getCostObject());
                entryRow.setProductType(joinSideRow.getProductType());
                entryRow.setPdCompQty(joinSideRow.getPdCompQty());
                entryRow.addAllTaskValInfos(joinSideRow, "PdCompQty");
                entryRow.setPdCompAmount(joinSideRow.getPdCompAmount());
                entryRow.addAllTaskValInfos(joinSideRow, "PdCompAmount");
                entryRow.addStdQty(joinSideRow.getStdQty().add(joinSideRow.getPdCompQty()));
                entryRow.addAllTaskValInfos(joinSideRow, "StdQty");
                entryRow.addTaskValInfo("this", "", "PdCompQty", "StdQty", joinSideRow.getPdCompQty());
                entryRow.addStdAmount(joinSideRow.getStdAmount().add(joinSideRow.getPdCompAmount()));
                entryRow.addAllTaskValInfos(joinSideRow, "StdAmount");
                entryRow.addTaskValInfo("this", "", "PdCompAmount", "StdAmount", joinSideRow.getPdCompAmount());
                entryRow.setDiffQty(joinSideRow.getDiffQty());
                entryRow.addAllTaskValInfos(joinSideRow, "DiffQty");
                entryRow.setDiffAmount(joinSideRow.getDiffAmount());
                entryRow.addAllTaskValInfos(joinSideRow, "DiffAmt");
                entryRow.setCalType(this.args.getMatCalType());
                entryRow.setDataType(key.getDataType());
                if ("3".equals(key.getDiffType())) {
                    entryRow.setDiffType("3");
                    continue;
                }
                entryRow.setDiffType(this.getContext().getMatSubElement().contains(key.getSubelementId()) ? "1" : "2");
            }
        }
    }

    private CalcResultHeader addNewCalcResultHeader(MatFinalGroupKey key) {
        CalcResultHeader calcResultHeader = new CalcResultHeader();
        this.getSingleBatchResultManager().getCalcResults().put(key.getCostObjectId(), calcResultHeader);
        calcResultHeader.setId(DBServiceHelper.genGlobalLongId());
        calcResultHeader.setBillNo("NO." + System.currentTimeMillis());
        calcResultHeader.setOrg(this.args.getOrgId().longValue());
        calcResultHeader.setCostAccount(this.args.getCostAccountId().longValue());
        calcResultHeader.setCostCenter(key.getCostCenterid().longValue());
        calcResultHeader.setCurrency(this.args.getCurrencyId().longValue());
        calcResultHeader.setPeriod(this.args.getPeriodId().longValue());
        calcResultHeader.setCostObject(key.getCostObjectId().longValue());
        Object bizDate = TimeUtils.compareToEndDate((Date)this.getContext().getInputArgs().getEndDate());
        if (bizDate != null) {
            if (bizDate instanceof Date) {
                calcResultHeader.setBizDate((Date)bizDate);
            } else if (bizDate instanceof Calendar) {
                calcResultHeader.setBizDate(((Calendar)bizDate).getTime());
            }
        }
        calcResultHeader.setBillStatus("A");
        calcResultHeader.setBizStatus("A");
        return calcResultHeader;
    }

    private CalcResultEntryRow addCalcResultEntryRow(MatFinalGroupKey key, CalcResultHeader calcResultHeader, CalcResultEntryRow srcSumRow) {
        CalcResultEntryRow entryRow = calcResultHeader.addNew();
        entryRow.setResource(key.getResourceId().longValue());
        entryRow.setCostLevel(key.getCostLevel());
        entryRow.setCalcbasis(key.getCalcBasis());
        entryRow.setElement(key.getElementId().longValue());
        entryRow.setSubElement(key.getSubelementId().longValue());
        entryRow.setMaterial(key.getMaterialId().longValue());
        entryRow.setAuxpty(key.getAuxptyId().longValue());
        entryRow.setMatVersion(key.getMatVersionId().longValue());
        entryRow.setCostObject(srcSumRow.getCostObject());
        entryRow.setProductType(srcSumRow.getProductType());
        entryRow.setKeycol(key.getKeycol());
        entryRow.setKeycolId(key.getKeycolId().longValue());
        entryRow.unionKeyColVal(srcSumRow.getKeycolValMap());
        BigDecimal pdstartqty = srcSumRow.getPdStartQty();
        entryRow.setPdStartQty(pdstartqty);
        entryRow.addAllTaskValInfos(srcSumRow, "PdStartQty");
        BigDecimal pdstartamount = srcSumRow.getPdStartAmount().setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
        entryRow.setPdStartAmount(pdstartamount);
        entryRow.addAllTaskValInfos(srcSumRow, "PdStartAmount");
        BigDecimal pdcurrqty = srcSumRow.getPdCurrQty();
        entryRow.setPdCurrQty(pdcurrqty);
        entryRow.addAllTaskValInfos(srcSumRow, "PdCurrQty");
        BigDecimal pdcurramount = srcSumRow.getPdCurrAmount().setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
        entryRow.setPdCurrAmount(pdcurramount);
        entryRow.addAllTaskValInfos(srcSumRow, "PdCurrAmount");
        BigDecimal pdcompqty = srcSumRow.getPdCompQty();
        BigDecimal pdcompanount = srcSumRow.getPdCompAmount().setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
        String proAllocStd = "";
        proAllocStd = CalcTaskType.FinishCalc == this.getContext().getTaskType() || CalcTaskType.RealtimeFinishCalc == this.getContext().getTaskType() ? "5" : ProAllocStdHelper.getProAllocStd(this.getSingleBatchContext().getProAllocStdMap(), (long)key.getCostAccountId(), (long)key.getCostCenterid(), (long)key.getSubelementId());
        if (StringUtils.isEmpty((CharSequence)proAllocStd)) {
            DynamicObject costCenterDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getCostCenterid(), (String)"bos_costcenter", (String)"id,name");
            DynamicObject subElementDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getSubelementId(), (String)"cad_subelement", (String)"name");
            String errDesc = String.format(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u5206\u914d\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\uff0c\u672a\u627e\u5230\u201c\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u201d\u3002", (String)"MatFinalCalcAction_16", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getDynamicObjectName(costCenterDy), this.getDynamicObjectName(subElementDy));
            logger.info(errDesc);
            this.taskRecorder.insertCalcErrorInfo(this.getDetailTaskConfigId(), key.getCostCenterid(), errDesc);
            return null;
        }
        Long costObjectId = key.getCostObjectId();
        Map<Long, CalcResultObjectInfo> objectInfoMap = this.getSingleBatchContext().getObjectInfosMap().get(costObjectId);
        if (CadEmptyUtils.isEmpty(objectInfoMap) || !objectInfoMap.containsKey(costObjectId)) {
            DynamicObject costObjectDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getCostObjectId(), (String)"cad_costobject", (String)"name");
            String errDesc = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6210\u672c\u6838\u7b97\u201c%s\u201d\u5bf9\u8c61\u4fe1\u606f\uff0c\u8ba1\u7b97\u5931\u8d25\u3002", (String)"MatFinalCalcAction_17", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getDynamicObjectName(costObjectDy));
            logger.info(errDesc);
            this.taskRecorder.insertCalcErrorInfo(this.getDetailTaskConfigId(), key.getCostCenterid(), errDesc);
            return null;
        }
        if (!this.mainProEndShare(key, objectInfoMap, proAllocStd, entryRow, srcSumRow)) {
            return null;
        }
        if (!this.mainJoinFinShare(key, objectInfoMap, entryRow)) {
            return null;
        }
        Map<MatFinalGroupKey, CalcResultEntryRow> mainSideCompletionMap = this.getSingleBatchContext().getMainSideCompletionMap();
        if (mainSideCompletionMap.containsKey(key)) {
            CalcResultEntryRow mainRow = mainSideCompletionMap.get(key);
            entryRow.setPdCompQty(mainRow.getPdCompQty());
            entryRow.addAllTaskValInfos(mainRow, "PdCompQty");
            entryRow.setPdCompAmount(mainRow.getPdCompAmount());
            entryRow.addAllTaskValInfos(mainRow, "PdCompAmount");
        }
        BigDecimal totalqty = srcSumRow.getTotalQty().add(entryRow.getPdCurrQty());
        String totalQtyFormula = String.format("PreTotalQty %s + PdCurrQty %s", srcSumRow.getTotalQty(), entryRow.getPdCurrQty());
        BigDecimal totalamount = srcSumRow.getTotalAmount().add(entryRow.getPdCurrAmount());
        String totalAmountFrmula = String.format("PreTotalAmount %s + PdCurrAmount %s ", srcSumRow.getTotalAmount(), entryRow.getPdCurrAmount());
        entryRow.setTotalQty(totalqty);
        entryRow.addAllTaskValInfos(srcSumRow, "TotalQty");
        entryRow.addTaskValInfo("this", "", totalQtyFormula, "TotalQty", totalqty.subtract(srcSumRow.getTotalQty()));
        entryRow.setTotalAmount(totalamount.setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP));
        entryRow.addAllTaskValInfos(srcSumRow, "TotalAmount");
        entryRow.addTaskValInfo("this", "", totalAmountFrmula, "TotalAmount", totalamount.subtract(srcSumRow.getTotalAmount()));
        BigDecimal stdqty = srcSumRow.getStdQty().add(entryRow.getPdCompQty());
        entryRow.setStdQty(stdqty);
        entryRow.addAllTaskValInfos(srcSumRow, "StdQty");
        entryRow.addTaskValInfo("this", "", "PdCompQty", "StdQty", pdcompqty);
        BigDecimal stdamount = srcSumRow.getStdAmount().add(entryRow.getPdCompAmount()).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
        entryRow.setStdAmount(stdamount);
        entryRow.addAllTaskValInfos(srcSumRow, "StdAmount");
        entryRow.addTaskValInfo("this", "", "PdCompAmount", "StdAmount", pdcompanount);
        if ("3".equals(key.getDiffType())) {
            entryRow.addCostUpdateDiffAmount(entryRow.getPdCurrAmount().subtract(entryRow.getDiffAmount()));
            entryRow.addAllTaskValInfos(srcSumRow, "CostUpdateDiffAmount");
        }
        if ("3".equals(key.getDataType())) {
            entryRow.setCalType(this.args.getMfgCalType());
        } else {
            entryRow.setCalType(this.args.getMatCalType());
        }
        entryRow.setDataType(key.getDataType());
        if ("3".equals(key.getDiffType())) {
            entryRow.setDiffType("3");
        } else {
            entryRow.setDiffType(this.getContext().getMatSubElement().contains(key.getSubelementId()) ? "1" : "2");
        }
        return entryRow;
    }

    private boolean mainJoinFinShare(MatFinalGroupKey key, Map<Long, CalcResultObjectInfo> objectInfoMap, CalcResultEntryRow entryRow) {
        Long costObjectId = key.getCostObjectId();
        BigDecimal diffQty = entryRow.getDiffQty();
        BigDecimal diffAmt = entryRow.getDiffAmount();
        if (ScaCalcHelper.isContainsProductFacted(objectInfoMap, (String)"A") && (BigDecimal.ZERO.compareTo(diffQty) != 0 || BigDecimal.ZERO.compareTo(diffAmt) != 0)) {
            logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61:{}\u5b58\u5728\u8054\u4ea7\u54c1\u5b8c\u5de5\u9700\u8981\u6309\u6743\u91cd\u5206\u644a\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02");
            BigDecimal totalRatio = BigDecimal.ZERO;
            BigDecimal maxRatio = null;
            boolean isAllFinQtyZero = true;
            for (Map.Entry<Long, CalcResultObjectInfo> objectInfoEntry : objectInfoMap.entrySet()) {
                BigDecimal finQty;
                CalcResultObjectInfo objectInfo = objectInfoEntry.getValue();
                if ("B".equals(objectInfo.getProductType()) || BigDecimal.ZERO.compareTo(finQty = objectInfo.getFinishQty()) == 0) continue;
                isAllFinQtyZero = false;
                BigDecimal weight = objectInfo.getWeight();
                BigDecimal finRatio = finQty.multiply(weight);
                totalRatio = totalRatio.add(finRatio);
                if (maxRatio != null && maxRatio.compareTo(finRatio.abs()) >= 0) continue;
                maxRatio = finRatio.abs();
            }
            if (totalRatio.compareTo(BigDecimal.ZERO) == 0 && maxRatio != null) {
                totalRatio = maxRatio;
            }
            if (totalRatio.compareTo(BigDecimal.ZERO) == 0 && !isAllFinQtyZero) {
                DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (String)"cad_costobject", (String)"costcenter,name");
                DynamicObject subElementDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getSubelementId(), (String)"cad_subelement", (String)"name");
                String errStr = String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u4ea7\u54c1\u5b8c\u5de5\u6bd4\u4f8b\u5206\u914d\u5931\u8d25\uff0c\u3010\u2211\u4e3b\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd+\u2211\u8054\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd=0\u3011\uff0c\u6210\u672c\u5bf9\u8c61\u3010%2$s\u3011\uff0c\u5b50\u8981\u7d20\u3010%3$s\u3011\u3002", (String)"MatFinalCalcAction_18", (String)"macc-sca-mservice", (Object[])new Object[0]), costObjectDyo != null ? costObjectDyo.getString("name") : "", subElementDyo != null ? subElementDyo.getString("name") : "");
                this.taskRecorder.insertCalcErrorInfo(this.getDetailTaskConfigId(), costObjectDyo != null ? costObjectDyo.getLong("costcenter.id") : 0L, errStr);
                return false;
            }
            BigDecimal diffFinQty = diffQty;
            BigDecimal diffFinAmt = diffAmt;
            CalcResultEntryRow allocMaxRow = null;
            boolean isContainMainFact = false;
            boolean isContainJoinFact = false;
            for (Map.Entry<Long, CalcResultObjectInfo> entry : objectInfoMap.entrySet()) {
                CalcResultObjectInfo objectInfo = entry.getValue();
                if ("B".equals(objectInfo.getProductType())) continue;
                BigDecimal qty = objectInfo.getFinishQty();
                BigDecimal weight = objectInfo.getWeight();
                BigDecimal finRatio = qty.multiply(weight);
                BigDecimal ratio = BigDecimal.ZERO;
                if (totalRatio.compareTo(BigDecimal.ZERO) != 0) {
                    ratio = finRatio.divide(totalRatio, 10, RoundingMode.HALF_UP);
                }
                BigDecimal allocAmt = ratio.multiply(diffAmt).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
                BigDecimal allocQty = ratio.multiply(diffQty).setScale(10, RoundingMode.HALF_UP);
                diffFinQty = diffFinQty.subtract(allocQty);
                diffFinAmt = diffFinAmt.subtract(allocAmt);
                if ("C".equals(objectInfo.getProductType())) {
                    entryRow.setDiffAmount(allocAmt);
                    entryRow.addTaskValInfo("this", "", String.format("DiffAmt %s * FinRatio %s / TotalRatio %s", diffAmt, finRatio, totalRatio), "DiffAmt", allocAmt);
                    entryRow.setDiffQty(allocQty);
                    entryRow.addTaskValInfo("this", "", String.format("DiffQty %s * FinRatio %s / TotalRatio %s", diffQty, finRatio, totalRatio), "DiffQty", allocQty);
                    if (allocMaxRow == null || allocMaxRow.getDiffAmount().compareTo(allocAmt) < 0) {
                        allocMaxRow = entryRow;
                    }
                    isContainMainFact = true;
                    continue;
                }
                String productType = objectInfo.getProductType();
                long joinCostObjectId = objectInfo.getCostObjectId();
                MatFinalGroupKey joinKey = new MatFinalGroupKey(key.getOrgId(), key.getCostAccountId(), key.getCostCenterid(), key.getCostObjectId(), Long.valueOf(joinCostObjectId), productType, key.getResourceId(), key.getCostLevel(), key.getCalcBasis(), key.getElementId(), key.getSubelementId(), key.getMaterialId(), key.getAuxptyId(), key.getMatVersionId(), key.getDataType(), key.getDiffType(), key.getKeycol(), key.getKeycolId());
                CalcResultEntryRow joinRow = this.getSingleBatchContext().getMainSideCompletionMap().computeIfAbsent(joinKey, s -> new CalcResultEntryRow());
                joinRow.setCostObject(joinCostObjectId);
                joinRow.setProductType(productType);
                joinRow.setDiffQty(allocQty);
                joinRow.addTaskValInfo("this", "", String.format("DiffQty %s * FinRatio %s / TotalRatio %s", diffQty, finRatio, totalRatio), "DiffQty", allocQty);
                joinRow.setDiffAmount(allocAmt);
                joinRow.addTaskValInfo("this", "", String.format("DiffAmt %s * FinRatio %s / TotalRatio %s", diffAmt, finRatio, totalRatio), "DiffAmt", allocAmt);
                if (allocMaxRow == null || allocMaxRow.getDiffAmount().compareTo(allocAmt) < 0) {
                    allocMaxRow = joinRow;
                }
                isContainJoinFact = true;
            }
            if (diffFinQty.compareTo(BigDecimal.ZERO) != 0 && allocMaxRow != null) {
                allocMaxRow.setDiffQty(allocMaxRow.getDiffQty().add(diffFinQty));
            }
            if (diffFinAmt.compareTo(BigDecimal.ZERO) != 0 && allocMaxRow != null) {
                allocMaxRow.setDiffAmount(allocMaxRow.getDiffAmount().add(diffFinAmt));
            }
            if (!isContainMainFact && isContainJoinFact) {
                entryRow.setDiffQty(BigDecimal.ZERO);
                entryRow.setDiffAmount(BigDecimal.ZERO);
            }
        } else {
            entryRow.setDiffQty(diffQty);
            entryRow.setDiffAmount(diffAmt);
        }
        return true;
    }

    private boolean mainProEndShare(MatFinalGroupKey key, Map<Long, CalcResultObjectInfo> objectInfoMap, String proAllocStd, CalcResultEntryRow entryRow, CalcResultEntryRow srcSumRow) {
        Long costObjectId = key.getCostObjectId();
        BigDecimal pdstartqty = entryRow.getPdStartQty();
        BigDecimal pdstartamount = entryRow.getPdStartAmount();
        BigDecimal pdcurrqty = entryRow.getPdCurrQty();
        BigDecimal pdcurramount = entryRow.getPdCurrAmount();
        BigDecimal pdcompqty = srcSumRow.getPdCompQty();
        BigDecimal pdcompanount = srcSumRow.getPdCompAmount().setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
        BigDecimal pdendqty = BigDecimal.ZERO;
        BigDecimal pdendamount = BigDecimal.ZERO;
        BigDecimal diffQty = BigDecimal.ZERO;
        BigDecimal diffAmt = BigDecimal.ZERO;
        BigDecimal proEndQty = ProAllocHelper.getMainAndJoinEndQty(objectInfoMap);
        BigDecimal proFinishQty = ProAllocHelper.getMainAndJoinFinQty(objectInfoMap);
        if (CalcTaskType.FinishCalc == this.getContext().getTaskType() || CalcTaskType.RealtimeFinishCalc == this.getContext().getTaskType()) {
            pdendqty = pdstartqty.add(pdcurrqty).subtract(pdcompqty);
            entryRow.addTaskValInfo("this", "", String.format("Std:5,PdStartQty %s + PdCurrQty %s - PdCompQty %s", pdstartqty, pdcurrqty, pdcompqty), "PdEndQty", pdendqty);
            pdendamount = pdstartamount.add(pdcurramount).subtract(pdcompanount).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
            entryRow.addTaskValInfo("this", "", String.format("Std:5,PdStartAmount %s + PdCurrAmount %s - PdCompAmount %s", pdstartamount, pdcurramount, pdcompanount), "PdEndAmount", pdendamount);
        } else if (proFinishQty.compareTo(BigDecimal.ZERO) == 0) {
            pdendqty = pdstartqty.add(pdcurrqty).subtract(pdcompqty);
            entryRow.addTaskValInfo("this", "", String.format("Std:FinQty=0,PdStartQty %s + PdCurrQty %s ", pdstartqty, pdcurrqty), "PdEndQty", pdendqty);
            pdendamount = pdstartamount.add(pdcurramount).subtract(pdcompanount).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
            entryRow.addTaskValInfo("this", "", String.format("Std:FinQty=0,PdStartAmount %s + PdCurrAmount %s ", pdstartamount, pdcurramount), "PdEndAmount", pdendamount);
        } else if ("0".equals(proAllocStd) || proEndQty.compareTo(BigDecimal.ZERO) <= 0) {
            diffQty = pdstartqty.add(pdcurrqty).subtract(pdcompqty);
            entryRow.addTaskValInfo("this", "", String.format("Std:0 or EndQty=0,PdStartQty %s + PdCurrQty %s - PdCompQty %s", pdstartqty, pdcurrqty, pdcompqty), "DiffQty", diffQty);
            diffAmt = pdstartamount.add(pdcurramount).subtract(pdcompanount).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
            entryRow.addTaskValInfo("this", "", String.format("Std:0 or EndQty=0,PdStartAmount %s + PdCurrAmount %s - PdCompAmount %s", pdstartamount, pdcurramount, pdcompanount), "DiffAmount", diffAmt);
        } else if ("5".equals(proAllocStd)) {
            pdendqty = pdstartqty.add(pdcurrqty).subtract(pdcompqty);
            entryRow.addTaskValInfo("this", "", String.format("Std:5,PdStartQty %s + PdCurrQty %s - PdCompQty %s", pdstartqty, pdcurrqty, pdcompqty), "PdEndQty", pdendqty);
            pdendamount = pdstartamount.add(pdcurramount).subtract(pdcompanount).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
            entryRow.addTaskValInfo("this", "", String.format("Std:5,PdStartAmount %s + PdCurrAmount %s - PdCompAmount %s", pdstartamount, pdcurramount, pdcompanount), "PdEndAmount", pdendamount);
        } else if ("1".equals(proAllocStd) || "2".equals(proAllocStd)) {
            BigDecimal equivalent = BigDecimal.ONE;
            if ("2".equals(proAllocStd) && (equivalent = ScaCalcHelper.getCostobjectEquivalent(this.getSingleBatchContext().getEquivalentMap(), (Long)this.getSingleBatchContext().getContext().getInputArgs().getCostAccountId(), (Long)this.getSingleBatchContext().getContext().getInputArgs().getManuOrgId(), (Long)key.getCostCenterid(), (Long)key.getCostObjectId(), (Long)key.getSubelementId())) == null) {
                DynamicObject costCenterDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getCostCenterid(), (String)"bos_costcenter", (String)"id,name");
                DynamicObject costObjectDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getCostObjectId(), (String)"cad_costobject", (String)"name");
                DynamicObject subElementDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getSubelementId(), (String)"cad_subelement", (String)"name");
                String errDesc = String.format(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u5206\u914d\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u6210\u672c\u5bf9\u8c61\u201c%2$s\u201d\u5b50\u8981\u7d20\u201c%3$s\u201d\u672a\u8bbe\u7f6e\u7ea6\u5f53\u7cfb\u6570\u3002", (String)"MatFinalCalcAction_19", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getDynamicObjectName(costCenterDy), this.getDynamicObjectName(costObjectDy), this.getDynamicObjectName(subElementDy));
                logger.info(errDesc);
                this.taskRecorder.insertCalcErrorInfo(this.getDetailTaskConfigId(), key.getCostCenterid(), errDesc);
                return false;
            }
            if (ShareHelper.existsJoinPro(objectInfoMap)) {
                logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61id\uff1a{}\u5b58\u5728\u8054\u526f\u4ea7\u54c1\u5165\u5e93\u4fe1\u606f", (Object)costObjectId);
                proFinishQty = BigDecimal.ZERO;
                proEndQty = BigDecimal.ZERO;
                for (Map.Entry<Long, CalcResultObjectInfo> objectInfoEntry : objectInfoMap.entrySet()) {
                    CalcResultObjectInfo info = objectInfoEntry.getValue();
                    if ("B".equals(info.getProductType())) continue;
                    proFinishQty = proFinishQty.add(info.getFinishQty().multiply(info.getWeight()));
                    proEndQty = proEndQty.add(info.getStartQty().add(info.getPlanQty()).subtract(info.getFinishQty()).multiply(info.getWeight()));
                }
            }
            logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61id\u3010{}\u3011,\u4e3b\u8054\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\u3010{}\u3011,\u671f\u672b\u5728\u4ea7\u6570\u91cf\u3010{}\u3011", new Object[]{costObjectId, proFinishQty, proEndQty});
            BigDecimal divider = proEndQty.multiply(equivalent).add(proFinishQty);
            if (divider.compareTo(BigDecimal.ZERO) == 0) {
                DynamicObject costCenterDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getCostCenterid(), (String)"bos_costcenter", (String)"id,name");
                DynamicObject costObjectDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getCostObjectId(), (String)"cad_costobject", (String)"name");
                DynamicObject subElementDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getSubelementId(), (String)"cad_subelement", (String)"name");
                String errDesc = String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3:%1$s ,\u5b50\u8981\u7d20: %2$s , \u6210\u672c\u6838\u7b97\u5bf9\u8c61 :%3$s , \u671f\u672b\u5728\u4ea7\u54c1\u6570\u91cf*\u7ea6\u5f53\u7cfb\u6570+\u5b8c\u5de5\u5165\u5e93\u6570\u91cf=0\u3002", (String)"MatFinalCalcAction_20", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getDynamicObjectName(costCenterDy), this.getDynamicObjectName(subElementDy), this.getDynamicObjectName(costObjectDy));
                logger.info(errDesc);
                this.taskRecorder.insertCalcErrorInfo(this.getDetailTaskConfigId(), key.getCostCenterid(), errDesc);
                return false;
            }
            pdendqty = pdstartqty.add(pdcurrqty).subtract(pdcompqty);
            pdendamount = pdstartamount.add(pdcurramount).subtract(pdcompanount).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
            BigDecimal ratio = proFinishQty.divide(divider, 10, 4);
            diffQty = pdendqty.multiply(proFinishQty).divide(divider, 10, 4).setScale(10, 4);
            entryRow.addTaskValInfo("this", "", String.format("(PdStartQty %s + PdCurrQty %s - PdCompQty %s ) * Ratio %s ", pdstartqty, pdcurrqty, pdcompqty, ratio), "DiffQty", diffQty);
            diffAmt = pdendamount.multiply(proFinishQty).divide(divider, this.getContext().getCurrencyAmtScale(), 4);
            entryRow.addTaskValInfo("this", "", String.format("(PdStartAmount %s + PdCurrAmount %s - PdCompAmount %s ) * Ratio %s", pdstartamount, pdcurramount, pdcompanount, ratio), "DiffAmt", diffAmt);
            pdendqty = pdendqty.subtract(diffQty);
            entryRow.addTaskValInfo("this", "", String.format("Std:1/2,PdStartQty %s + PdCurrQty %s - PdCompQty %s - DiffQty %s ", pdstartqty, pdcurrqty, pdcompqty, diffQty), "PdEndQty", pdendqty);
            pdendamount = pdendamount.subtract(diffAmt);
            entryRow.addTaskValInfo("this", "", String.format("Std:1/2,PdStartAmount %s + PdCurrAmount %s - PdCompAmount %s - DiffAmt %s ", pdstartamount, pdcurramount, pdcompanount, diffAmt), "PdEndAmount", pdendamount);
        }
        entryRow.setPdEndQty(pdendqty);
        entryRow.setPdEndAmount(pdendamount);
        entryRow.setDiffQty(diffQty);
        entryRow.setDiffAmount(diffAmt);
        return true;
    }

    private String getDynamicObjectName(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return "";
        }
        return dynamicObject.getString("name");
    }

    private void clearCalcResultSpecialEntry(CalcResultHeader calcResult) {
        HashSet<String> clearCalTypes = new HashSet<String>(4);
        if (StringUtils.equals((CharSequence)this.args.getMatCalType(), (CharSequence)"3")) {
            clearCalTypes.add("2");
        } else {
            clearCalTypes.add("4");
        }
        clearCalTypes.add("1");
        clearCalTypes.add("3");
        clearCalTypes.add("5");
        for (int i = calcResult.getEntryRows().size() - 1; i >= 0; --i) {
            CalcResultEntryRow entryRow = (CalcResultEntryRow)calcResult.getEntryRows().get(i);
            if ("3".equals(entryRow.getDiffType())) {
                entryRow.setCalType(this.args.getMatCalType());
                continue;
            }
            if (!clearCalTypes.contains(entryRow.getCalType())) continue;
            calcResult.getEntryRows().remove(i);
        }
    }

    private void dealPurPricesMat(Set<Long> notInCalcIds, Set<Long> purPricesIds, QFilter costtypeFilter, QFilter calcTypeFilter, QFilter stdIsMainDataFilter, QFilter materialIdFilter) {
        MaterialKey matInfo;
        HashSet<Long> purPriceMats = new HashSet<Long>(16);
        HashSet<Long> selfPriceMats = new HashSet<Long>(16);
        HashSet<MaterialKey> purPricesSet = new HashSet<MaterialKey>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("dealPurPricesMat1"), (String)"cad_bomsetting", (String)"number,material.masterid matid,material.number matnumber,bomversion.id matverId,auxprop.id auxptyId,isdowncalc,keycol,keycolid", (QFilter[])new QFilter[]{costtypeFilter, materialIdFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long matId = row.getLong("matid");
                if (row.getBoolean("isdowncalc").booleanValue()) {
                    selfPriceMats.add(matId);
                } else {
                    matInfo = new MaterialKey(matId, row.getLong("matverId"), row.getLong("auxptyId"), row.getString("keycol"), row.getLong("keycolid"));
                    purPricesSet.add(matInfo);
                }
                purPriceMats.add(matId);
            }
            if (!selfPriceMats.isEmpty()) {
                purPriceMats.removeAll(selfPriceMats);
            }
        }
        if (!purPricesSet.isEmpty() && !purPriceMats.isEmpty()) {
            Row row;
            QFilter matQf = new QFilter("material", "in", purPriceMats);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("dealPurPricesMat2"), (String)"cad_calceffectiveresult", (String)"id,material.masterid matid,matvers.id matverId,auxproperty.id auxptyId,keycol,keycolid", (QFilter[])new QFilter[]{costtypeFilter, calcTypeFilter, stdIsMainDataFilter, matQf, materialIdFilter}, null);){
                while (dataSet.hasNext()) {
                    row = dataSet.next();
                    matInfo = new MaterialKey(row.getLong("matid"), row.getLong("matverId"), row.getLong("auxptyId"), row.getString("keycol"), row.getLong("keycolid"));
                    if (!purPricesSet.contains(matInfo)) continue;
                    notInCalcIds.add(row.getLong("id"));
                }
            }
            dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("dealPurPricesMat3"), (String)"cad_purprices", (String)"id,material.masterid matid,matversion.id matverId,auxpty.id auxptyId,keycol,keycolid", (QFilter[])new QFilter[]{costtypeFilter, materialIdFilter, matQf}, null);
            var12_12 = null;
            try {
                while (dataSet.hasNext()) {
                    row = dataSet.next();
                    matInfo = new MaterialKey(row.getLong("matid"), row.getLong("matverId"), row.getLong("auxptyId"), row.getString("keycol"), row.getLong("keycolid"));
                    if (!purPricesSet.contains(matInfo)) continue;
                    purPricesIds.add(row.getLong("id"));
                }
            }
            catch (Throwable throwable) {
                var12_12 = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (var12_12 != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            var12_12.addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        logger.info(String.format("\u626b\u63cf\u5230\u9700\u8981\u6392\u9664\u7684\u751f\u6548\u5377\u7b97\u7ed3\u679c\u8868 %s \u5f20\uff0c \u5916\u8d2d\u4ef7\u76ee\u8868 %s \u5f20", notInCalcIds.size(), purPricesIds.size()));
    }

    private Map<MaterialKey, Map<MatStdCostKey, List<MatStdCostItem>>> loadMatStdCost(DataSet costInfoDataSet) {
        if (costInfoDataSet == null || costInfoDataSet.isEmpty()) {
            return this.getContext().getMatStdCosts();
        }
        HashSet<Long> matCostIds = new HashSet<Long>(200);
        while (costInfoDataSet.hasNext()) {
            Row row = costInfoDataSet.next();
            Long matcostid = row.getLong("matcostid");
            if (CadEmptyUtils.isEmpty((Long)matcostid)) continue;
            matCostIds.add(matcostid);
        }
        if (CadEmptyUtils.isEmpty(matCostIds)) {
            return this.loadMatStdCost();
        }
        HashMap<MaterialKey, Map<MatStdCostKey, List<MatStdCostItem>>> matStdCosts = new HashMap<MaterialKey, Map<MatStdCostKey, List<MatStdCostItem>>>();
        QFilter matCostIdFilter = new QFilter("matcostid", "in", matCostIds);
        QFilter calcTypeFilter = new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3", "4"});
        QFilter stdIsMainDataFilter = new QFilter("ismaindata", "=", (Object)1);
        HashSet effCostIds = Sets.newHashSet();
        this.loadCalcEffectiveResult(matStdCosts, new QFilter[]{calcTypeFilter, stdIsMainDataFilter, matCostIdFilter}, effCostIds);
        matCostIds.removeAll(effCostIds);
        if (!matCostIds.isEmpty()) {
            QFilter idFilter = new QFilter("id", "in", matCostIds);
            this.loadPurPrice(matStdCosts, new QFilter[]{idFilter});
        }
        return matStdCosts;
    }

    private Map<MaterialKey, Map<MatStdCostKey, List<MatStdCostItem>>> loadMatStdCost() {
        HashSet<MaterialKey> matKeys = new HashSet<MaterialKey>(10);
        HashSet<String> selectFields = new HashSet<String>(4);
        selectFields.add("material");
        selectFields.add("bomversion");
        selectFields.add("auxpty");
        MainEntityType subType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"cad_costobject", selectFields);
        DynamicObject[] costObjectObjs = BusinessDataServiceHelper.load((Object[])this.getSingleBatchContext().getMainSideCostObjectIds().toArray(), (DynamicObjectType)subType);
        boolean isUseMatVer = kd.macc.sca.algox.utils.CostTypeHelper.isUseMatVer((Long)this.args.getCostAccountId());
        for (DynamicObject costObject : costObjectObjs) {
            MaterialKey matKey = new MaterialKey(costObject.getLong("material.masterid"), isUseMatVer ? costObject.getLong("bomversion.id") : 0L, costObject.getLong("auxpty.id"), "", 0L);
            matKeys.add(matKey);
        }
        HashSet<Long> materialIds = new HashSet<Long>();
        for (MaterialKey matKey : matKeys) {
            if (this.getContext().getMatStdCosts().containsKey(matKey)) continue;
            materialIds.add(matKey.getMaterialId());
        }
        if (!materialIds.isEmpty()) {
            HashMap<MaterialKey, Map<MatStdCostKey, List<MatStdCostItem>>> matStdCosts = new HashMap<MaterialKey, Map<MatStdCostKey, List<MatStdCostItem>>>();
            Long costTypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)this.args.getCostAccountId(), (Long)this.args.getOrgId(), (Long)this.args.getManuOrgId());
            QFilter costtypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
            QFilter calcTypeFilter = new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3", "4"});
            QFilter stdIsMainDataFilter = new QFilter("ismaindata", "=", (Object)1);
            QFilter effectDateFilter = new QFilter("effectdate", "<=", (Object)this.args.getEndDate());
            QFilter expDateFilter = new QFilter("expdate", ">=", (Object)this.args.getStartDate());
            QFilter materilIdFilter = new QFilter("material", "in", materialIds);
            HashSet<Long> notInCalcIds = new HashSet<Long>(16);
            HashSet<Long> purPricesIds = new HashSet<Long>(16);
            this.dealPurPricesMat(notInCalcIds, purPricesIds, costtypeFilter, calcTypeFilter, stdIsMainDataFilter, materilIdFilter);
            QFilter calcIdFilter = null;
            if (!notInCalcIds.isEmpty()) {
                calcIdFilter = new QFilter("id", "not in", notInCalcIds);
            }
            HashSet effCostIds = Sets.newHashSet();
            this.loadCalcEffectiveResult(matStdCosts, new QFilter[]{costtypeFilter, calcTypeFilter, stdIsMainDataFilter, calcIdFilter, effectDateFilter, expDateFilter, materilIdFilter}, effCostIds);
            if (!purPricesIds.isEmpty()) {
                QFilter purPriceIdFilter = new QFilter("id", "in", purPricesIds);
                this.loadPurPrice(matStdCosts, new QFilter[]{purPriceIdFilter, materilIdFilter});
            }
            this.getContext().getMatStdCosts().putAll(matStdCosts);
        }
        return this.getContext().getMatStdCosts();
    }

    private void loadCalcEffectiveResult(Map<MaterialKey, Map<MatStdCostKey, List<MatStdCostItem>>> matStdCosts, QFilter[] filters, Set<Long> effCostIds) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(""), (String)"cad_calceffectiveresult", (String)"material.masterid matid,matvers.id matverId,auxproperty.id auxptyId,keycol,keycolid.id keycolid,matcostid,entryentity.submaterial.id submatid,entryentity.submatvers.id submatverId,entryentity.subauxproperty.id subauxptyId,effectdate,expdate,entryentity.resource.id resourceid,entryentity.calcbasis calcbasis,entryentity.element.masterid elementid,entryentity.subelement.masterid subelementid,entryentity.subelement.type subelementtype,entryentity.qty subqty,entryentity.stdprice stdprice,entryentity.datatype calcdatatype,entryentity.subkeycol subkeycol,entryentity.subkeycolid subkeycolid,0 ispurprice", (QFilter[])filters, null);){
            int rowCount = 0;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ++rowCount;
                MaterialKey matKey = new MaterialKey(row.getLong("matid"), row.getLong("matverId"), row.getLong("auxptyId"), row.getString("keycol"), row.getLong("keycolid"), row.getLong("matcostid"));
                effCostIds.add(row.getLong("matcostid"));
                MatStdCostKey costKey = new MatStdCostKey(matKey.getMaterialId(), matKey.getMatVersionId(), matKey.getAuxptyId(), row.getDate("effectdate"), row.getDate("expdate"), false, row.getString("keycol"), row.getLong("keycolid"));
                MatStdCostItem costItem = new MatStdCostItem(row.getLong("submatid"), row.getLong("submatverId"), row.getLong("subauxptyId"), row.getLong("resourceid"), row.getString("calcbasis"), row.getLong("elementid"), row.getLong("subelementid"), row.getString("subelementtype"), row.getBigDecimal("subqty"), row.getBigDecimal("stdprice"), row.getString("calcdatatype"), row.getString("subkeycol"), row.getLong("subkeycolid"));
                Map map = matStdCosts.computeIfAbsent(matKey, s -> new HashMap());
                List costItems = map.computeIfAbsent(costKey, s -> new ArrayList());
                costItems.add(costItem);
            }
            logger.info(String.format("\u8bfb\u53d6\u751f\u6548\u5377\u7b97\u7ed3\u679c\u8868\u5b8c\u6bd5\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(filters)));
        }
    }

    private void loadPurPrice(Map<MaterialKey, Map<MatStdCostKey, List<MatStdCostItem>>> matStdCosts, QFilter[] filters) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(""), (String)"cad_matcostinfo", (String)"material.masterid matid,0 matverId,0 auxptyId,keycol,keycolid,id matcostid,material.masterid submatid,matversion.id submatverId,auxpty.id subauxptyId,keycol subkeycol,keycolid subkeycolId,createtime effectdate,createtime expdate,0 resourceid,'' calcbasis,entryentity.element.masterid elementid,entryentity.subelement.masterid subelementid,entryentity.subelement.type subelementtype,1 subqty,entryentity.standardcost stdprice,'' calcdatatype,1 ispurprice", (QFilter[])filters, null);){
            int rowCount = 0;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                MaterialKey matKey = new MaterialKey(row.getLong("matid"), row.getLong("matverId"), row.getLong("auxptyId"), row.getString("keycol"), row.getLong("keycolid"), row.getLong("matcostid"));
                MatStdCostKey costKey = new MatStdCostKey(matKey.getMaterialId(), matKey.getMatVersionId(), matKey.getAuxptyId(), row.getDate("effectdate"), row.getDate("expdate"), true, row.getString("subkeycol"), row.getLong("subkeycolId"));
                MatStdCostItem costItem = new MatStdCostItem(row.getLong("submatid"), row.getLong("submatverId"), row.getLong("subauxptyId"), row.getLong("resourceid"), row.getString("calcbasis"), row.getLong("elementid"), row.getLong("subelementid"), row.getString("subelementtype"), row.getBigDecimal("subqty"), row.getBigDecimal("stdprice"), row.getString("calcdatatype"), row.getString("subkeycol"), row.getLong("subkeycolId"));
                Map map = matStdCosts.computeIfAbsent(matKey, s -> new HashMap());
                List costItems = map.computeIfAbsent(costKey, s -> new ArrayList());
                costItems.add(costItem);
            }
            logger.info(String.format("\u8bfb\u53d6\u5916\u8d2d\u7269\u6599\u4ef7\u76ee\u8868\u5b8c\u6bd5\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(filters)));
        }
    }
}

