/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.TaskHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.common.costcalc.CalcResultEntryRow;
import kd.macc.sca.common.costcalc.CalcResultHeader;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.CostCalcFilterBuilder;
import kd.macc.sca.mservice.costcalc.action.AbstractSingleBatchAction;

class MfgFeeCalcAction
extends AbstractSingleBatchAction {
    private static final Log logger = LogFactory.getLog(MfgFeeCalcAction.class);
    private static final String HOUR_UNIT = "10";
    private static final String SECOND_UNIT = "8";
    private CostCalcArgs args;
    private Set<Long> onlyClearOnce = new HashSet<Long>();
    private int calResultRowCount = 0;

    MfgFeeCalcAction() {
    }

    @Override
    public Long getDetailTaskConfigId() {
        if (this.getContext().isFinishCalc()) {
            return FinshCalcCheck.CALCTASKGETBEGINFEE;
        }
        return TaskHelper.PDENDENTRY_MFGALLOC_TASKID;
    }

    @Override
    protected void doExecute() {
        logger.info(String.format("\u5438\u6536\u5236\u9020\u8d39\u7528\uff1a\u5f00\u59cb\uff0c\u7b2c %s / %s\u6279\uff0c\u5171 %s \u5f20", this.getSingleBatchContext().getCurrBatchSeq(), this.getSingleBatchContext().getBatchCount(), this.getSingleBatchContext().getCostObjectIds().size()));
        this.args = this.getContext().getInputArgs();
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordDetail(this.getDetailTaskConfigId(), "2");
        }
        this.onlyClearOnce.clear();
        this.doCalcuate();
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordProcess(this.getDetailTaskConfigId(), "2");
            this.upateTaskRecordDetail(this.getDetailTaskConfigId(), "4");
        }
        logger.info(String.format("\u5438\u6536\u5236\u9020\u8d39\u7528\uff1a\u7ed3\u675f\u3002\u5171\u751f\u6210 %s \u6761\u8ba1\u7b97\u7ed3\u679c\u5236\u9020\u8d39\u7528\u660e\u7ec6\u884c", this.calResultRowCount));
    }

    private void doCalcuate() {
        DataSet absorbDataSet = this.queryResourceAbsorbDataSet();
        for (Row row : absorbDataSet) {
            String sourceType = row.getString("sourcetype");
            Long costObjectId = row.getLong("costobject");
            CalcResultHeader calcResultHeader = this.getSingleBatchResultManager().getCalcResults().get(costObjectId);
            if (calcResultHeader == null) {
                calcResultHeader = this.addNewCalcResultHeader(row, costObjectId);
                this.onlyClearOnce.add(calcResultHeader.getId());
            } else if (!this.onlyClearOnce.contains(calcResultHeader.getId())) {
                this.onlyClearOnce.add(calcResultHeader.getId());
                calcResultHeader.clearSpecialEntry(this.getContext().getInputArgs().getMfgCalType(), null);
            }
            CalcResultEntryRow resultRow = calcResultHeader.addNew();
            resultRow.setElement(row.getLong("element").longValue());
            resultRow.setSubElement(row.getLong("subelement").longValue());
            resultRow.setCostObject(row.getLong("costobject").longValue());
            resultRow.setProductType("C");
            resultRow.setCalType(this.args.getMfgCalType());
            resultRow.setDataType("3");
            resultRow.setDiffType("2");
            resultRow.setPdCurrAmount(row.getBigDecimal("amount"));
            resultRow.setKeycol(row.getString("keycol"));
            resultRow.setKeycolId(row.getLong("keycolid").longValue());
            BigDecimal qty = row.getBigDecimal("qty");
            if ("R".equals(sourceType)) {
                String calcBasis = row.getString("calcbasis");
                if ("001".equals(calcBasis)) {
                    String baseUnit = row.getString("baseunit");
                    if (HOUR_UNIT.equals(baseUnit)) {
                        qty = qty.multiply(new BigDecimal(60));
                    }
                    if (SECOND_UNIT.equals(baseUnit)) {
                        qty = qty.divide(new BigDecimal(60), 10, 4);
                    }
                }
                resultRow.setResource(row.getLong("resource").longValue());
                resultRow.setCostLevel(CadEmptyUtils.isEmpty((String)row.getString("resource")) ? "" : "2");
                resultRow.setPdCurrQty(qty.setScale(10, RoundingMode.HALF_UP));
                resultRow.setCalcbasis(row.getString("calcbasis"));
            } else {
                resultRow.setPdCurrQty(qty);
                resultRow.setMaterial(row.getLong("material").longValue());
                resultRow.setAuxpty(row.getLong("auxpty").longValue());
                resultRow.setCostLevel("2");
            }
            ++this.calResultRowCount;
        }
    }

    private DataSet queryResourceAbsorbDataSet() {
        CostCalcFilterBuilder filterBuilder = this.getContext().getFilterBuilder();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterBuilder.warpQFilter4Period(filterList, "org", true, this.args);
        filterBuilder.wrapQFilter4CostObjects(filterList, "costobject", this.getSingleBatchContext().getCostObjectIds());
        String selectFields = "org,costaccount,costobject,material,auxpty,costobject.costcenter costcenter,resource,resourceusebillno,resourceuserow,outputbillno,sourcetype,calcbasis,keycol,keycolid,entryentity.element as element,entryentity.subelement as subelement,entryentity.qty as qty,entryentity.baseunit as baseunit,entryentity.amount as amount";
        logger.info(String.format("\u8bfb\u53d6\u5438\u6536\u8d39\u7528\u6210\u672c\u5355\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", this.getContext().getFilterBuilder().buildQFilterLogString(filterList)));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.mservice.costcalc.action.MfgFeeCalcAction.queryResourceAbsorbDataSet", (String)"sca_resourceabsorb", (String)selectFields, (QFilter[])filterList.toArray(new QFilter[0]), null);
        return dataSet.groupBy(new String[]{"org", "costaccount", "costobject", "auxpty", "material", "costcenter", "resource", "sourcetype", "calcbasis", "keycol", "keycolid", "element", "subelement", "baseunit"}).sum("qty").sum("amount").finish();
    }

    private CalcResultHeader addNewCalcResultHeader(Row row, Long costObjectId) {
        CalcResultHeader calcResultHeader = new CalcResultHeader();
        this.getSingleBatchResultManager().getCalcResults().put(costObjectId, calcResultHeader);
        calcResultHeader.setId(DBServiceHelper.genGlobalLongId());
        calcResultHeader.setBillNo("NO." + System.currentTimeMillis());
        calcResultHeader.setOrg(this.args.getOrgId().longValue());
        calcResultHeader.setCostAccount(this.args.getCostAccountId().longValue());
        calcResultHeader.setCostCenter(row.getLong("costcenter").longValue());
        calcResultHeader.setCurrency(this.args.getCurrencyId().longValue());
        calcResultHeader.setPeriod(this.args.getPeriodId().longValue());
        calcResultHeader.setCostObject(costObjectId.longValue());
        Object bizDate = TimeUtils.compareToEndDate((Date)this.getContext().getInputArgs().getEndDate());
        if (bizDate != null) {
            if (bizDate instanceof Date) {
                calcResultHeader.setBizDate((Date)bizDate);
            } else if (bizDate instanceof Calendar) {
                calcResultHeader.setBizDate(((Calendar)bizDate).getTime());
            }
        }
        calcResultHeader.setBillStatus("A");
        calcResultHeader.setBizStatus("A");
        return calcResultHeader;
    }
}

