/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.mservice.costcalc.action.AbstractCalcAction;

class ReadCostObjectAction
extends AbstractCalcAction {
    private static final Log logger = LogFactory.getLog(ReadCostObjectAction.class);
    private static final String ALGO_KEY_PLAN = "ReadCostObjectAction.doExecute(plan)";
    private static final String ALGO_KEY_BEGIN = "ReadCostObjectAction.doExecute(begin)";

    ReadCostObjectAction() {
    }

    @Override
    protected void doExecute() {
        logger.info(String.format("\u8bfb\u53d6\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff1a\u5f00\u59cb\uff0c\u5df2\u4f20\u5165\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6570\u91cf: %s", this.getContext().getInputArgs().getCostObjectIds().size()));
        if (!this.getContext().getInputArgs().getCostObjectIds().isEmpty()) {
            logger.info("\u5df2\u4f20\u5165\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u4e0d\u9700\u5b9e\u65f6\u8bfb\u53d6\uff0c\u9000\u51fa");
            return;
        }
        Set<Long> set = this.readByBizDate();
        this.getContext().getInputArgs().getCostObjectIds().addAll(set);
        logger.info(String.format("\u8bfb\u53d6\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff1a\u7ed3\u675f\u3002\u53d6\u51fa\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6570\u91cf: %s", this.getContext().getInputArgs().getCostObjectIds().size()));
    }

    private Set<Long> readByBizDate() {
        HashSet<Long> set = new HashSet<Long>();
        Set manuOrgIds = this.getContext().getInputArgs().getManuOrgIds();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        this.getContext().getFilterBuilder().warpQFilter4BizDate(filters, "accountorg", false, this.getContext().getInputArgs());
        filters.add(QFilter.of((String)"qty > 0 and costobject.bizstatus = 'A' and billstatus = 'C'", (Object[])new Object[0]));
        if (manuOrgIds != null && manuOrgIds.size() > 0) {
            filters.add(new QFilter("manuorg", "in", (Object)manuOrgIds));
        }
        try (DataSet planDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY_PLAN, (String)"cad_plannedoutputbill", (String)"costobject", (QFilter[])filters.toArray(new QFilter[0]), null);){
            while (planDataSet.hasNext()) {
                Row row = planDataSet.next();
                set.add(row.getLong(0));
            }
        }
        int count = set.size();
        logger.info(String.format("\u67e5\u8be2\u672c\u671f\u6295\u4ea7\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61, \u8bfb\u51fa\u6570\u636e\u884c\u6570 = %s, \u6761\u4ef6 = '%s'", count, filters));
        ArrayList<QFilter> filterCals = new ArrayList<QFilter>();
        this.getContext().getFilterBuilder().warpQFilter4BizDate(filterCals, "org", true, this.getContext().getInputArgs());
        filterCals.add(QFilter.of((String)"entryentity.pdendqty > 0 and costobject.bizstatus = 'A'", (Object[])new Object[0]));
        if (manuOrgIds != null && manuOrgIds.size() > 0) {
            filterCals.add(new QFilter("costobject.manuorg", "in", (Object)manuOrgIds));
        }
        try (DataSet calDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY_BEGIN, (String)"sca_calcresult", (String)"costobject", (QFilter[])filterCals.toArray(new QFilter[0]), null);){
            while (calDataSet.hasNext()) {
                Row row = calDataSet.next();
                set.add(row.getLong(0));
            }
        }
        count = set.size() - count;
        logger.info(String.format("\u67e5\u8be2\u6709\u671f\u521d\u5728\u4ea7\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u8bfb\u51fa\u6570\u636e\u884c\u6570  = %s, \u6761\u4ef6 = '%s'", count, filterCals));
        return set;
    }
}

