/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.sca.common.costcalc.CalcReportHeader;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.CostCalcContext;
import kd.macc.sca.mservice.costcalc.CostCalcResultManager;
import kd.macc.sca.mservice.costcalc.action.MfgUnAbsorbFeeCalcAction;
import kd.macc.sca.mservice.costcalc.action.SingleBatchContext;
import kd.macc.sca.mservice.costcalc.action.SingleBatchResultManager;
import kd.macc.sca.mservice.costcalc.action.task.CalcTaskActionParam;

public class MfgUnAbsorbFeeCalcTaskAction
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(MfgUnAbsorbFeeCalcTaskAction.class);

    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        int skipMfgUnAbsorbFeeTask = CadBgParamUtils.getCadParamForInt((String)"skipMfgUnAbsorbFeeTask", (int)0);
        if (skipMfgUnAbsorbFeeTask == 1) {
            return;
        }
        CalcTaskActionParam originParam = null;
        Set expireObjectIds = null;
        Map elementDetails = null;
        try {
            originParam = (CalcTaskActionParam)JSONUtils.cast((String)((String)paramMap.get("param")), CalcTaskActionParam.class);
            expireObjectIds = (Set)JSON.parseObject((String)((String)paramMap.get("expireObjectIds")), (TypeReference)new TypeReference<Set<Long>>(){}, (Feature[])new Feature[0]);
            elementDetails = (Map)JSON.parseObject((String)((String)paramMap.get("elementDetails")), (TypeReference)new TypeReference<Map<Long, Long>>(){}, (Feature[])new Feature[0]);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        CostCalcArgs args = originParam.getInputArgs();
        List<Object> costObjectList = originParam.getCostObjectIdList();
        CostCalcContext context = new CostCalcContext();
        context.setInputArgs(originParam.getInputArgs());
        context.setTaskType(originParam.getTaskType());
        context.setIsConcurrency(true);
        SingleBatchContext singleBatchContext = new SingleBatchContext(context);
        singleBatchContext.getEquivalentMap().clear();
        singleBatchContext.getObjectInfosMap().clear();
        CostCalcResultManager resultManager = new CostCalcResultManager();
        IDataEntityType rptHeadType = CalcReportHeader.getDataEntityType();
        Object[] rptObjs = BusinessDataServiceHelper.load((Object[])new Object[]{context.getInputArgs().getCalcReportId()}, (IDataEntityType)rptHeadType);
        if (rptObjs != null && rptObjs.length > 0) {
            CalcReportHeader calcRpt = (CalcReportHeader)rptObjs[0];
            resultManager.setCalcReport(calcRpt);
        }
        SingleBatchResultManager singleBatchResultManager = new SingleBatchResultManager(resultManager);
        try {
            HashSet currCostObjectIds = Sets.newHashSet(costObjectList);
            MfgUnAbsorbFeeCalcAction executeAction = new MfgUnAbsorbFeeCalcAction(args, currCostObjectIds, expireObjectIds, true, elementDetails);
            executeAction.setSingleBatchContext(singleBatchContext);
            executeAction.setSingleBatchResultManager(singleBatchResultManager);
            executeAction.getFinishCalcResult(costObjectList);
            executeAction.unAbsorbCalc();
        }
        catch (Throwable e) {
            logger.error("\u672a\u5438\u6536\u8d39\u7528\u5206\u6279\u8ba1\u7b97\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", e);
            throw new KDBizException(e, null, new Object[0]);
        }
    }
}

