/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.event;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class MftOrderCloseEvent
implements IEventServicePlugin {
    private static final Log log = LogFactory.getLog(MftOrderCloseEvent.class);
    private static final String INSERT_LOG_SQL = "INSERT INTO t_sca_autocalclog (fid,fbiztype,forderentryid,fmanuorgid,forderno,forderentryseq,fsyncdate,fstatus,flastexecdate,ftrytimes,forgid,fcostaccountid,fexeclog,fclosetime,fclosebookdate) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_LOG_SQL = "UPDATE t_sca_autocalclog SET fmanuorgid=?,forderno=?,forderentryseq=?,fsyncdate=?,fstatus=?,flastexecdate=?,ftrytimes=?,forgid=?,fcostaccountid=?,fexeclog=?,fclosetime=?,fclosebookdate=? WHERE fid=?";

    public Object handleEvent(KDBizEvent e) {
        HashSet mftorderentryids = Sets.newHashSetWithExpectedSize((int)10);
        String jsonSource = e.getSource();
        log.info("\u63a5\u6536\u5de5\u5355\u5173\u95ed\u4e8b\u4ef6\u53c2\u6570\uff1a" + jsonSource);
        if (!StringUtils.isEmpty((String)jsonSource)) {
            JSONArray custparamJs = JSONArray.fromObject((Object)jsonSource);
            for (int index = 0; index < custparamJs.size(); ++index) {
                JSONObject obj = custparamJs.getJSONObject(index);
                JSONArray array = obj.getJSONArray("mftorderentryids");
                for (int i = 0; i < array.size(); ++i) {
                    mftorderentryids.add(array.getLong(i));
                }
            }
        }
        if (!mftorderentryids.isEmpty()) {
            try {
                List splitLists = Lists.partition(new ArrayList(mftorderentryids), (int)1000);
                for (List list : splitLists) {
                    this.saveEventLog(list);
                }
            }
            catch (Exception ex) {
                log.error("\u63a5\u6536\u5de5\u5355\u5173\u95ed\u4e8b\u4ef6\u5904\u7406\u51fa\u73b0\u9519\u8bef\uff1a{}", (Object)ex.getMessage());
                log.error((Throwable)ex);
                throw ex;
            }
        }
        return e.getEventId();
    }

    private void saveEventLog(List<Long> mftorderentryids) {
        HashMap entryToOrderNoMap = Maps.newHashMapWithExpectedSize((int)10);
        Map<Long, Set<Long>> orgOrderEntryIds = this.groupOrgToOrderEntrys(new ArrayList<Long>(mftorderentryids), entryToOrderNoMap);
        HashSet matchOrgEntryIds = Sets.newHashSetWithExpectedSize((int)mftorderentryids.size());
        ArrayList logParamObjs = Lists.newArrayListWithExpectedSize((int)mftorderentryids.size());
        ArrayList uptlogParamObjs = Lists.newArrayListWithExpectedSize((int)10);
        Map<String, Long> orgEntryToIdMap = this.getExistLogBill(mftorderentryids);
        if (!orgOrderEntryIds.isEmpty()) {
            for (Map.Entry<Long, Set<Long>> entry : orgOrderEntryIds.entrySet()) {
                Long orgId = entry.getKey();
                matchOrgEntryIds.addAll((Collection)entry.getValue());
                List<Long> accountIds = this.getCostaccount(orgId, "sca");
                if (CollectionUtils.isEmpty(accountIds)) {
                    String logInfo = ResManager.loadKDString((String)"\u672a\u5339\u914d\u8d26\u7c3f\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u4e0b\u662f\u5426\u5b58\u5728\u542f\u7528\u5e76\u5b8c\u6210\u521d\u59cb\u5316\u7684\u6807\u51c6\u6210\u672c\u8d26\u7c3f\u3002", (String)"MftOrderCloseEvent_0", (String)"macc-sca-mservice", (Object[])new Object[0]);
                    for (Long entryId : entry.getValue()) {
                        String key;
                        String orderNo = "";
                        Long entrySeq = 0L;
                        Long manuorg = 0L;
                        Date closetime = null;
                        Date closebookdate = null;
                        if (entryToOrderNoMap.containsKey(entryId)) {
                            Object[] val = (Object[])entryToOrderNoMap.get(entryId);
                            orderNo = (String)val[0];
                            entrySeq = (Long)val[1];
                            manuorg = (Long)val[2];
                            closetime = (Date)val[3];
                            closebookdate = (Date)val[4];
                        }
                        if (!orgEntryToIdMap.containsKey(key = String.format("%s@%s@%s", entryId, orgId, 0L))) {
                            logParamObjs.add(this.getInsertParam("00", entryId, manuorg, orderNo, entrySeq, "04", orgId, 0L, logInfo, closetime, closebookdate));
                            continue;
                        }
                        uptlogParamObjs.add(this.getUpdateParam("00", entryId, manuorg, orderNo, entrySeq, "04", orgId, 0L, logInfo, closetime, closebookdate, orgEntryToIdMap.get(key)));
                    }
                    continue;
                }
                for (Long entryId : entry.getValue()) {
                    String orderNo = "";
                    Long entrySeq = 0L;
                    Long manuorg = 0L;
                    Date closetime = null;
                    Date closebookdate = null;
                    if (entryToOrderNoMap.containsKey(entryId)) {
                        Object[] val = (Object[])entryToOrderNoMap.get(entryId);
                        orderNo = (String)val[0];
                        entrySeq = (Long)val[1];
                        manuorg = (Long)val[2];
                        closetime = (Date)val[3];
                        closebookdate = (Date)val[4];
                    }
                    for (Long accountId : accountIds) {
                        String key = String.format("%s@%s@%s", entryId, orgId, accountId);
                        if (!orgEntryToIdMap.containsKey(key)) {
                            logParamObjs.add(this.getInsertParam("00", entryId, manuorg, orderNo, entrySeq, "00", orgId, accountId, " ", closetime, closebookdate));
                            continue;
                        }
                        uptlogParamObjs.add(this.getUpdateParam("00", entryId, manuorg, orderNo, entrySeq, "00", orgId, accountId, " ", closetime, closebookdate, orgEntryToIdMap.get(key)));
                    }
                }
            }
        }
        mftorderentryids.removeAll(matchOrgEntryIds);
        String logInfo = ResManager.loadKDString((String)"\u6839\u636e\u5de5\u5355\u4fe1\u606f\u4fe1\u606f\u672a\u5339\u914d\u5230\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MftOrderCloseEvent_1", (String)"macc-sca-mservice", (Object[])new Object[0]);
        for (Long entryId : mftorderentryids) {
            String key;
            String orderNo = "";
            Long entrySeq = 0L;
            Long manuorg = 0L;
            Date closetime = null;
            Date closebookdate = null;
            if (entryToOrderNoMap.containsKey(entryId)) {
                Object[] val = (Object[])entryToOrderNoMap.get(entryId);
                orderNo = (String)val[0];
                entrySeq = (Long)val[1];
                manuorg = (Long)val[2];
                closetime = (Date)val[3];
                closebookdate = (Date)val[4];
            }
            if (!orgEntryToIdMap.containsKey(key = String.format("%s@%s@%s", entryId, 0L, 0L))) {
                logParamObjs.add(this.getInsertParam("00", entryId, manuorg, orderNo, entrySeq, "04", 0L, 0L, logInfo, closetime, closebookdate));
                continue;
            }
            uptlogParamObjs.add(this.getInsertParam("00", entryId, manuorg, orderNo, entrySeq, "04", 0L, 0L, logInfo, closetime, closebookdate));
        }
        if (!logParamObjs.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)INSERT_LOG_SQL, (List)logParamObjs);
        }
        if (!uptlogParamObjs.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)UPDATE_LOG_SQL, (List)uptlogParamObjs);
        }
    }

    private Map<String, Long> getExistLogBill(List<Long> mftorderentryids) {
        QFilter filter = new QFilter("orderentryid", "in", mftorderentryids);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"autocalclog", (String)"sca_autocalclog", (String)"id,orderentryid,org,costaccount", (QFilter[])filter.toArray(), (String)"syncdate desc");
        HashMap entryidMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : ds) {
            String key = String.format("%s@%s@%s", row.getLong("orderentryid"), row.getLong("org"), row.getLong("costaccount"));
            if (entryidMap.containsKey(key)) continue;
            entryidMap.put(key, row.getLong("id"));
        }
        return entryidMap;
    }

    private Object[] getInsertParam(String biztype, Long orderEntryId, Long manuorgId, String orderNo, Long entrySeq, String status, Long orgId, Long accountId, String log, Date closetime, Date closebookdate) {
        return new Object[]{ID.genLongId(), biztype, orderEntryId, manuorgId, orderNo, entrySeq, new Date(), status, null, 0, orgId, accountId, log, closetime, closebookdate};
    }

    private Object[] getUpdateParam(String biztype, Long orderEntryId, Long manuorgId, String orderNo, Long entrySeq, String status, Long orgId, Long accountId, String log, Date closetime, Date closebookdate, Long billid) {
        return new Object[]{manuorgId, orderNo, entrySeq, new Date(), status, null, 0, orgId, accountId, log, closetime, closebookdate, billid};
    }

    private List<Long> getCostaccount(Long accountOrgId, String appnum) {
        QFilter filter = new QFilter("org", "=", (Object)accountOrgId);
        filter.and("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        filter.and("entryentity.isinit", "=", (Object)Boolean.TRUE);
        filter.and("appnum", "=", (Object)appnum);
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)costAccountIds)) {
            return costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toList());
        }
        return null;
    }

    private Map<Long, Set<Long>> groupOrgToOrderEntrys(List<Long> mftorderentryids, Map<Long, Object[]> entryToOrderNoMap) {
        QFilter filter = new QFilter("treeentryentity.id", "in", mftorderentryids);
        filter.and("treeentryentity.producttype", "=", (Object)"C");
        DataSet pomOrderDs = QueryServiceHelper.queryDataSet((String)"pomMftOrder", (String)"pom_mftorder", (String)"id,billno,treeentryentity.seq entrySeq,treeentryentity.id entryid,org,treeentryentity.closetime closetime,treeentryentity.closebookdate closebookdate", (QFilter[])new QFilter[]{filter}, null);
        DataSet omOrderDs = QueryServiceHelper.queryDataSet((String)"pomMftOrder", (String)"om_mftorder", (String)"id,billno,treeentryentity.seq entrySeq,treeentryentity.id entryid,org,treeentryentity.closetime closetime,treeentryentity.closebookdate closebookdate", (QFilter[])new QFilter[]{filter}, null);
        pomOrderDs = pomOrderDs.union(omOrderDs);
        DataSet pomOrderCopyDs = pomOrderDs.copy();
        HashMap manuOrgToAccOrgMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap manuOrgOrderMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : pomOrderCopyDs) {
            Long org = row.getLong("org");
            manuOrgToAccOrgMap.putIfAbsent(org, Lists.newArrayList());
            manuOrgOrderMap.computeIfAbsent(org, t -> Sets.newHashSetWithExpectedSize((int)10)).add(row.getLong("entryid"));
            entryToOrderNoMap.put(row.getLong("entryid"), new Object[]{row.getString("billno"), row.getLong("entrySeq"), org, row.getDate("closetime"), row.getDate("closebookdate")});
        }
        for (Map.Entry entry : manuOrgToAccOrgMap.entrySet()) {
            List accOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)((Long)entry.getKey()), (String)"10", (boolean)true);
            if (accOrgs.isEmpty()) continue;
            ((List)entry.getValue()).addAll(accOrgs);
        }
        HashMap orgOrdersMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry entry : manuOrgToAccOrgMap.entrySet()) {
            Set manuOrgOrders = (Set)manuOrgOrderMap.get(entry.getKey());
            if (((List)entry.getValue()).isEmpty() || manuOrgOrders == null || manuOrgOrders.isEmpty()) continue;
            for (Long accOrg : (List)entry.getValue()) {
                orgOrdersMap.computeIfAbsent(accOrg, t -> Sets.newHashSetWithExpectedSize((int)10)).addAll(manuOrgOrders);
            }
        }
        return orgOrdersMap;
    }

    static class Tuple3<T1, T2, T3> {
        public final T1 t1;
        public final T2 t2;
        public final T3 t3;

        public Tuple3(T1 t1, T2 t2, T3 t3) {
            this.t1 = t1;
            this.t2 = t2;
            this.t3 = t3;
        }
    }
}

