/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.event;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.sca.common.plancost.PlanCostParams;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PomOrderSplitEvent
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(PomOrderSplitEvent.class);

    public Object handleEvent(KDBizEvent e) {
        HashSet mftorderentryids = Sets.newHashSetWithExpectedSize((int)10);
        String jsonSource = e.getSource();
        logger.info("\u63a5\u6536\u5de5\u5355\u5173\u95ed\u4e8b\u4ef6\u53c2\u6570\uff1a" + jsonSource);
        if (!StringUtils.isEmpty((String)jsonSource)) {
            JSONArray custparamJs = JSONArray.fromObject((Object)jsonSource);
            for (int index = 0; index < custparamJs.size(); ++index) {
                JSONObject obj = custparamJs.getJSONObject(index);
                JSONArray array = obj.getJSONArray("orderentryids");
                for (int i = 0; i < array.size(); ++i) {
                    mftorderentryids.add(array.getLong(i));
                }
            }
        }
        if (!mftorderentryids.isEmpty()) {
            List list = Lists.partition(new ArrayList(mftorderentryids), (int)100);
            for (List ids : list) {
                try {
                    this.addPlanCostCalcLog(ids);
                }
                catch (Exception exception) {
                    logger.info("\u8ba1\u5212\u6210\u672c\u65e5\u5fd7\u540c\u6b65\u5f02\u5e38==>{}", (Object)exception);
                }
            }
        }
        return e.getEventId();
    }

    private void addPlanCostCalcLog(List<Long> ids) {
        QFilter filter = new QFilter("treeentryentity.producttype", "=", (Object)"C");
        filter.and("treeentryentity.id", "in", ids);
        HashMap<Long, Date> idDateMap = new HashMap<Long, Date>(16);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"pom_mftorder", (String)"treeentryentity.id id,modifytime", (QFilter[])new QFilter[]{new QFilter("treeentryentity.id", "in", ids)});
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            idDateMap.put(dynamicObject.getLong("id"), dynamicObject.getDate("modifytime"));
        }
        HashMap<Long, List> orgOrderMap = new HashMap<Long, List>(ids.size());
        DynamicObjectCollection objectCollection = QueryServiceHelper.query((String)"pom_mftorder", (String)"org,id", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dynamicObject : objectCollection) {
            orgOrderMap.computeIfAbsent(dynamicObject.getLong("org"), s -> new ArrayList()).add(dynamicObject.getLong("id"));
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
        for (Map.Entry entry : orgOrderMap.entrySet()) {
            Long manuOrg = (Long)entry.getKey();
            List orderIds = (List)entry.getValue();
            PlanCostParams planCostParam = this.getCostTypeByOrg(manuOrg);
            if (planCostParam == null) {
                logger.info("\u6839\u636e\u751f\u4ea7\u7ec4\u7ec7\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b\uff0c\u751f\u4ea7\u7ec4\u7ec7==>{}", (Object)manuOrg);
                continue;
            }
            QFilter configFilter = new QFilter("org", "=", (Object)planCostParam.getOrg());
            configFilter.and("isplancost", "=", (Object)"1");
            configFilter.and("enable", "=", (Object)"1");
            DynamicObject planConfig = QueryServiceHelper.queryOne((String)"cad_plancost_setting", (String)"filter_tag", (QFilter[])new QFilter[]{configFilter});
            if (planConfig == null) {
                logger.info("\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u672a\u542f\u7528\u8ba1\u5212\u6210\u672c\uff0c\u6682\u65f6\u8df3\u8fc7\uff0c\u6838\u7b97\u7ec4\u7ec7==>{}", (Object)planCostParam.getOrg());
                continue;
            }
            QFilter billFilters = new QFilter("treeentryentity.id", "in", ids);
            billFilters.and("treeentryentity.producttype", "=", (Object)"C");
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"pom_mftorder", (String)"id,org,billno,treeentryentity.seq as seq,treeentryentity.id as entryid,treeentryentity.transmittime as transmittime", (QFilter[])new QFilter[]{billFilters});
            for (DynamicObject dynamicObject : dynamicObjects) {
                for (Map map : planCostParam.getCostTypeMap()) {
                    DynamicObject planCostObj = BusinessDataServiceHelper.newDynamicObject((String)"sca_plancostcalclog");
                    planCostObj.set("org", (Object)planCostParam.getOrg());
                    planCostObj.set("plancosttype", map.get("planCostType"));
                    planCostObj.set("accountcosttype", map.get("accountCostType"));
                    planCostObj.set("billtype", (Object)"pom_mftorder");
                    planCostObj.set("syncdate", (Object)new Date());
                    Date releaseDate = null;
                    releaseDate = (Date)idDateMap.get(dynamicObject.getLong("entryid"));
                    planCostObj.set("releasedate", (Object)releaseDate);
                    planCostObj.set("orderno", (Object)dynamicObject.getString("billno"));
                    planCostObj.set("orderentryseq", (Object)dynamicObject.getInt("seq"));
                    planCostObj.set("orderentryid", (Object)dynamicObject.getLong("entryid"));
                    planCostObj.set("status", (Object)"00");
                    planCostObj.set("lastexecdate", null);
                    planCostObj.set("trytimes", (Object)0);
                    saveList.add(planCostObj);
                }
            }
        }
        if (!saveList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        }
    }

    private PlanCostParams getCostTypeByOrg(Long manuOrg) {
        PlanCostParams planCostParam = new PlanCostParams();
        ArrayList result = new ArrayList(5);
        long queryOrg = 0L;
        Boolean account = OrgUnitServiceHelper.checkOrgFunction((Long)manuOrg, (String)"10");
        Boolean produce = OrgUnitServiceHelper.checkOrgFunction((Long)manuOrg, (String)"04");
        if (account.booleanValue() && produce.booleanValue()) {
            queryOrg = manuOrg;
        } else {
            List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)manuOrg, (String)"10", (boolean)false);
            if (fromOrgs.isEmpty()) {
                return null;
            }
            queryOrg = (Long)fromOrgs.get(0);
        }
        QFilter filter = new QFilter("costtype.type", "=", (Object)"0");
        filter.and("bizstatus", "=", (Object)"1");
        filter.and("effectdate", "<=", (Object)new Date());
        filter.and("invaliddate", ">", (Object)new Date());
        if (OrgHelper.isOrgEnableMultiFactory((Long)queryOrg)) {
            boolean inventOrg = OrgUnitServiceHelper.checkOrgFunction((Long)manuOrg, (String)"05");
            if (inventOrg) {
                filter.and("storageorgunit", "=", (Object)manuOrg);
            } else {
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)manuOrg, (boolean)false);
                if (allToOrg.isEmpty()) {
                    return null;
                }
                filter.and("storageorgunit", "=", allToOrg.get(0));
            }
        } else {
            filter.and("calorg", "=", (Object)queryOrg);
        }
        DynamicObjectCollection costTypeObjs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costtype.id as costType", (QFilter[])new QFilter[]{filter});
        if (costTypeObjs.isEmpty()) {
            return null;
        }
        Set costTypeIds = costTypeObjs.stream().map(d -> d.getLong("costType")).collect(Collectors.toSet());
        logger.info("\u8ba1\u5212\u6210\u672c\u65e5\u5fd7\u81ea\u52a8\u540c\u6b65\uff0c\u6839\u636e\u751f\u4ea7\u7ec4\u7ec7\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b\uff0c\u751f\u4ea7\u7ec4\u7ec7==>{},\u6210\u672c\u7c7b\u578b==>{}", (Object)manuOrg, costTypeIds);
        QFilter costTypeFilter = new QFilter("id", "in", costTypeIds);
        costTypeFilter.and("enable", "=", (Object)"1");
        costTypeFilter.and("costtypeentry.costtypeattr", "=", (Object)"2");
        DynamicObjectCollection costTypes = QueryServiceHelper.query((String)"cad_costtype", (String)"id,costtypeentry.costtype.id as planCostId", (QFilter[])new QFilter[]{costTypeFilter});
        if (costTypes.isEmpty()) {
            return null;
        }
        for (DynamicObject costType : costTypes) {
            HashMap<String, Long> map = new HashMap<String, Long>(5);
            map.put("accountCostType", costType.getLong("id"));
            map.put("planCostType", costType.getLong("planCostId"));
            result.add(map);
        }
        planCostParam.setOrg(Long.valueOf(queryOrg));
        planCostParam.setCostTypeMap(result);
        return planCostParam;
    }
}

